/*
 * Decompiled with CFR 0.152.
 */
package com.o19s.es.ltr.feature.store;

import com.o19s.es.ltr.feature.FeatureSet;
import com.o19s.es.ltr.feature.LtrModel;
import com.o19s.es.ltr.feature.store.StoredLtrModel;
import com.o19s.es.ltr.ranker.LtrRanker;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.RamUsageEstimator;

public class CompiledLtrModel
implements LtrModel,
Accountable {
    private static final long BASE_RAM_USED = RamUsageEstimator.shallowSizeOfInstance(StoredLtrModel.class);
    private final String name;
    private final FeatureSet set;
    private final LtrRanker ranker;

    public CompiledLtrModel(String name, FeatureSet set, LtrRanker ranker) {
        this.name = name;
        this.set = set.optimize();
        this.ranker = ranker;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public LtrRanker ranker() {
        return this.ranker;
    }

    @Override
    public FeatureSet featureSet() {
        return this.set;
    }

    public long ramBytesUsed() {
        return BASE_RAM_USED + (long)(this.name.length() * 2) + (long)RamUsageEstimator.NUM_BYTES_ARRAY_HEADER + (this.set instanceof Accountable ? ((Accountable)this.set).ramBytesUsed() : (long)(this.set.size() * RamUsageEstimator.NUM_BYTES_OBJECT_HEADER)) + (this.ranker instanceof Accountable ? ((Accountable)this.ranker).ramBytesUsed() : (long)(this.set.size() * RamUsageEstimator.NUM_BYTES_OBJECT_HEADER));
    }
}

