/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.spec;

import javax.crypto.spec.PBEKeySpec;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.crypto.DigestAlgorithm;
import org.bouncycastle.jcajce.spec.PrfUtils;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class PBKDF2KeySpec
extends PBEKeySpec {
    private static final AlgorithmIdentifier defaultPRF = new AlgorithmIdentifier(PKCSObjectIdentifiers.id_hmacWithSHA1, DERNull.INSTANCE);
    private AlgorithmIdentifier prf;

    public PBKDF2KeySpec(char[] cArray, byte[] byArray, int n, int n2) {
        this(cArray, byArray, n, n2, defaultPRF);
    }

    public PBKDF2KeySpec(char[] cArray, byte[] byArray, int n, int n2, DigestAlgorithm digestAlgorithm) {
        this(cArray, byArray, n, n2, PrfUtils.getAlgorithmIdentifier(digestAlgorithm));
    }

    public PBKDF2KeySpec(char[] cArray, byte[] byArray, int n, int n2, AlgorithmIdentifier algorithmIdentifier) {
        super(cArray, byArray, n, n2);
        this.prf = algorithmIdentifier;
    }

    public boolean isDefaultPrf() {
        return defaultPRF.equals(this.prf);
    }

    public AlgorithmIdentifier getPrf() {
        return this.prf;
    }
}

