/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.util.dispose;

import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bouncycastle.crypto.util.dispose.Disposable;
import org.bouncycastle.util.Properties;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class DisposalDaemon
implements Runnable {
    private static final Logger LOG = Logger.getLogger(DisposalDaemon.class.getName());
    private static final ReferenceQueue<Disposable> referenceQueue = new ReferenceQueue();
    private static final Set<ReferenceWrapperWithDisposerRunnable> refs = ConcurrentHashMap.newKeySet();
    private static final ScheduledExecutorService cleanupExecutor;
    private static final DisposalDaemon disposalDaemon;
    private static final Thread disposalThread;
    private static final long cleanupDelayMillis;
    private static final String CLEANUP_DELAY_PROP = "org.bouncycastle.native.cleanup_delay";
    private static final String DISPOSAL_DAEMON_PRIORITY = "org.bouncycastle.native.cleanup_priority";

    private static void addShutdownHook() {
        try {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    ReferenceWrapperWithDisposerRunnable referenceWrapperWithDisposerRunnable = (ReferenceWrapperWithDisposerRunnable)referenceQueue.poll();
                    while (referenceWrapperWithDisposerRunnable != null) {
                        refs.remove(referenceWrapperWithDisposerRunnable);
                        referenceWrapperWithDisposerRunnable.dispose();
                        referenceWrapperWithDisposerRunnable = (ReferenceWrapperWithDisposerRunnable)referenceQueue.poll();
                    }
                }
            });
        }
        catch (Throwable throwable) {
            LOG.warning("adding shutdown hook: " + throwable.getMessage());
        }
    }

    public static void addDisposable(Disposable disposable) {
        ReferenceWrapperWithDisposerRunnable referenceWrapperWithDisposerRunnable = new ReferenceWrapperWithDisposerRunnable(disposable, referenceQueue);
        refs.add(referenceWrapperWithDisposerRunnable);
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    final ReferenceWrapperWithDisposerRunnable referenceWrapperWithDisposerRunnable = (ReferenceWrapperWithDisposerRunnable)referenceQueue.remove();
                    refs.remove(referenceWrapperWithDisposerRunnable);
                    if (cleanupExecutor == null) {
                        referenceWrapperWithDisposerRunnable.dispose();
                        continue;
                    }
                    cleanupExecutor.schedule(new Runnable(){

                        @Override
                        public void run() {
                            referenceWrapperWithDisposerRunnable.dispose();
                        }
                    }, cleanupDelayMillis, TimeUnit.MILLISECONDS);
                }
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                continue;
            }
            catch (Throwable throwable) {
                if (!LOG.isLoggable(Level.FINE)) continue;
                LOG.fine("exception in disposal thread: " + throwable.getMessage());
                continue;
            }
            break;
        }
    }

    static {
        disposalDaemon = new DisposalDaemon();
        String string = Properties.getPropertyValue(CLEANUP_DELAY_PROP, "0").trim();
        if (string.endsWith("ms")) {
            string = string.replace("ms", "").trim();
            cleanupDelayMillis = Long.parseLong(string);
        } else {
            cleanupDelayMillis = Long.parseLong(string) * 1000L;
        }
        cleanupExecutor = cleanupDelayMillis > 0L ? Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runnable) {
                Thread thread = new Thread(runnable, "BC Cleanup Executor");
                thread.setDaemon(true);
                return thread;
            }
        }) : null;
        String string2 = Properties.getPropertyValue(DISPOSAL_DAEMON_PRIORITY, "min").trim();
        disposalThread = new Thread((Runnable)disposalDaemon, "BC Disposal Daemon");
        disposalThread.setDaemon(true);
        if ("min".equals(string2)) {
            disposalThread.setPriority(1);
        } else if ("normal".equals(string2)) {
            disposalThread.setPriority(5);
        } else if ("high".equals(string2)) {
            disposalThread.setPriority(10);
        } else {
            throw new IllegalArgumentException("Unknown disposal daemon priority: " + string2);
        }
        disposalThread.start();
        DisposalDaemon.addShutdownHook();
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static class ReferenceWrapperWithDisposerRunnable
    extends PhantomReference<Disposable> {
        private final Runnable disposer;
        private final String label;

        public ReferenceWrapperWithDisposerRunnable(Disposable disposable, ReferenceQueue<? super Disposable> referenceQueue) {
            super(disposable, referenceQueue);
            this.disposer = disposable.getDisposeAction();
            this.label = disposable.toString();
        }

        public void dispose() {
            this.disposer.run();
        }

        public String toString() {
            return this.label;
        }
    }
}

