/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.internal.pqc.lms;

import java.util.HashMap;
import java.util.Map;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.crypto.internal.Digest;
import org.bouncycastle.crypto.internal.pqc.lms.DigestProvider;
import org.bouncycastle.crypto.internal.pqc.lms.LMOtsParameters;
import org.bouncycastle.crypto.internal.pqc.lms.LMSigParameters;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class LmsDigestUtil {
    private static Map<String, ASN1ObjectIdentifier> nameToOid = new HashMap<String, ASN1ObjectIdentifier>();
    private static Map<ASN1ObjectIdentifier, String> oidToName = new HashMap<ASN1ObjectIdentifier, String>();
    static DigestProvider digestProvider;

    public static void setProvider(DigestProvider digestProvider) {
        LmsDigestUtil.digestProvider = digestProvider;
    }

    static Digest getDigest(LMOtsParameters lMOtsParameters) {
        return LmsDigestUtil.createDigest(lMOtsParameters.getDigestOID(), lMOtsParameters.getN());
    }

    static Digest getDigest(LMSigParameters lMSigParameters) {
        return LmsDigestUtil.createDigest(lMSigParameters.getDigestOID(), lMSigParameters.getM());
    }

    private static Digest createDigest(ASN1ObjectIdentifier aSN1ObjectIdentifier, int n) {
        Digest digest = digestProvider.getDigest(aSN1ObjectIdentifier);
        if (aSN1ObjectIdentifier.equals(NISTObjectIdentifiers.id_shake256_len)) {
            return new WrapperDigest(digest, n);
        }
        if (n == 24) {
            return new WrapperDigest(digest, n);
        }
        return digest;
    }

    static {
        nameToOid.put("SHA-256", NISTObjectIdentifiers.id_sha256);
        nameToOid.put("SHA-512", NISTObjectIdentifiers.id_sha512);
        nameToOid.put("SHAKE128", NISTObjectIdentifiers.id_shake128);
        nameToOid.put("SHAKE256", NISTObjectIdentifiers.id_shake256);
        oidToName.put(NISTObjectIdentifiers.id_sha256, "SHA-256");
        oidToName.put(NISTObjectIdentifiers.id_sha512, "SHA-512");
        oidToName.put(NISTObjectIdentifiers.id_shake128, "SHAKE128");
        oidToName.put(NISTObjectIdentifiers.id_shake256, "SHAKE256");
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    static class WrapperDigest
    implements Digest {
        private final Digest dig;
        private final int length;

        WrapperDigest(Digest digest, int n) {
            this.dig = digest;
            this.length = n;
        }

        @Override
        public String getAlgorithmName() {
            return this.dig.getAlgorithmName() + "/" + this.length * 8;
        }

        @Override
        public int getDigestSize() {
            return this.length;
        }

        @Override
        public void update(byte by) {
            this.dig.update(by);
        }

        @Override
        public void update(byte[] byArray, int n, int n2) {
            this.dig.update(byArray, n, n2);
        }

        @Override
        public int doFinal(byte[] byArray, int n) {
            byte[] byArray2 = new byte[this.dig.getDigestSize()];
            this.dig.doFinal(byArray2, 0);
            System.arraycopy(byArray2, 0, byArray, n, this.length);
            return this.length;
        }

        @Override
        public void reset() {
            this.dig.reset();
        }

        @Override
        public int getByteLength() {
            return this.dig.getByteLength();
        }
    }
}

