/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.internal.pqc.lms;

import org.bouncycastle.crypto.internal.Digest;
import org.bouncycastle.crypto.internal.pqc.lms.LMOtsParameters;
import org.bouncycastle.crypto.internal.pqc.lms.LMSContext;
import org.bouncycastle.crypto.internal.pqc.lms.LMSigParameters;
import org.bouncycastle.crypto.internal.pqc.lms.LmsDigestUtil;
import org.bouncycastle.crypto.internal.pqc.lms.LmsUtils;
import org.bouncycastle.crypto.internal.pqc.lms.SeedDerive;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class LMOtsPrivateKey {
    private final LMOtsParameters parameter;
    private final byte[] I;
    private final int q;
    private final byte[] masterSecret;

    public LMOtsPrivateKey(LMOtsParameters lMOtsParameters, byte[] byArray, int n, byte[] byArray2) {
        this.parameter = lMOtsParameters;
        this.I = byArray;
        this.q = n;
        this.masterSecret = byArray2;
    }

    LMSContext getSignatureContext(LMSigParameters lMSigParameters, byte[][] byArray) {
        byte[] byArray2 = new byte[this.parameter.getN()];
        SeedDerive seedDerive = this.getDerivationFunction();
        seedDerive.setJ(-3);
        seedDerive.deriveSeed(byArray2, false);
        Digest digest = LmsDigestUtil.getDigest(this.parameter);
        LmsUtils.byteArray(this.getI(), digest);
        LmsUtils.u32str(this.getQ(), digest);
        LmsUtils.u16str((short)-32383, digest);
        LmsUtils.byteArray(byArray2, digest);
        return new LMSContext(this, lMSigParameters, digest, byArray2, byArray);
    }

    SeedDerive getDerivationFunction() {
        SeedDerive seedDerive = new SeedDerive(this.I, this.masterSecret, LmsDigestUtil.getDigest(this.parameter));
        seedDerive.setQ(this.q);
        return seedDerive;
    }

    public LMOtsParameters getParameter() {
        return this.parameter;
    }

    public byte[] getI() {
        return this.I;
    }

    public int getQ() {
        return this.q;
    }

    public byte[] getMasterSecret() {
        return this.masterSecret;
    }
}

