/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.processor;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.bytes.BytesArray;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.ingest.ConfigurationUtils;
import org.opensearch.neuralsearch.ml.MLCommonsClientAccessor;
import org.opensearch.neuralsearch.ml.dto.AgentExecutionDTO;
import org.opensearch.neuralsearch.ml.dto.AgentInfoDTO;
import org.opensearch.neuralsearch.query.AgenticSearchQueryBuilder;
import org.opensearch.neuralsearch.settings.NeuralSearchSettingsAccessor;
import org.opensearch.neuralsearch.stats.events.EventStatName;
import org.opensearch.neuralsearch.stats.events.EventStatsManager;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.search.pipeline.AbstractProcessor;
import org.opensearch.search.pipeline.PipelineProcessingContext;
import org.opensearch.search.pipeline.Processor;
import org.opensearch.search.pipeline.SearchRequestProcessor;

public class AgenticQueryTranslatorProcessor
extends AbstractProcessor
implements SearchRequestProcessor {
    @Generated
    private static final Logger log = LogManager.getLogger(AgenticQueryTranslatorProcessor.class);
    public static final String TYPE = "agentic_query_translator";
    private static final int MAX_AGENT_RESPONSE_SIZE = 10000;
    private static final int MAX_AGENT_ID_LENGTH = 100;
    private static final String AGENT_ID_PATTERN = "^[a-zA-Z0-9_-]+$";
    private final MLCommonsClientAccessor mlClient;
    private final String agentId;
    private final NamedXContentRegistry xContentRegistry;

    AgenticQueryTranslatorProcessor(String tag, String description, boolean ignoreFailure, MLCommonsClientAccessor mlClient, String agentId, NamedXContentRegistry xContentRegistry) {
        super(tag, description, ignoreFailure);
        this.mlClient = mlClient;
        this.agentId = agentId;
        this.xContentRegistry = xContentRegistry;
    }

    public void processRequestAsync(SearchRequest request, PipelineProcessingContext requestContext, ActionListener<SearchRequest> requestListener) {
        EventStatsManager.increment(EventStatName.AGENTIC_QUERY_TRANSLATOR_PROCESSOR_EXECUTIONS);
        SearchSourceBuilder sourceBuilder = request.source();
        if (sourceBuilder == null || sourceBuilder.query() == null) {
            requestListener.onResponse((Object)request);
            return;
        }
        QueryBuilder query = sourceBuilder.query();
        if (!(query instanceof AgenticSearchQueryBuilder)) {
            requestListener.onResponse((Object)request);
            return;
        }
        AgenticSearchQueryBuilder agenticQuery = (AgenticSearchQueryBuilder)query;
        if (this.hasOtherSearchFeatures(sourceBuilder)) {
            String errorMessage = String.format(Locale.ROOT, "Invalid usage with other search features like aggregation, sort, filters, collapse - Agent ID: [%s]", this.agentId);
            agenticQuery.setAgentFailureReason(errorMessage);
            requestListener.onFailure((Exception)new IllegalArgumentException("Agentic search blocked - " + errorMessage));
            return;
        }
        this.executeAgentAsync(agenticQuery, request, requestContext, requestListener);
    }

    private boolean hasOtherSearchFeatures(SearchSourceBuilder sourceBuilder) {
        return sourceBuilder.aggregations() != null || sourceBuilder.sorts() != null && !sourceBuilder.sorts().isEmpty() || sourceBuilder.highlighter() != null || sourceBuilder.postFilter() != null || sourceBuilder.suggest() != null || sourceBuilder.rescores() != null && !sourceBuilder.rescores().isEmpty() || sourceBuilder.collapse() != null;
    }

    private void executeAgentAsync(AgenticSearchQueryBuilder agenticQuery, SearchRequest request, PipelineProcessingContext requestContext, ActionListener<SearchRequest> requestListener) {
        this.mlClient.getAgentDetails(this.agentId, (ActionListener<AgentInfoDTO>)ActionListener.wrap(agentInfo -> this.mlClient.executeAgent(request, agenticQuery, this.agentId, (AgentInfoDTO)agentInfo, this.xContentRegistry, (ActionListener<AgentExecutionDTO>)ActionListener.wrap(agentResponse -> {
            try {
                String dslQuery = agentResponse.getDslQuery();
                String agentStepsSummary = agentResponse.getAgentStepsSummary();
                String memoryId = agentResponse.getMemoryId();
                if (dslQuery == null) {
                    String errorMessage = String.format(Locale.ROOT, "Null response from agent - Agent ID: [%s]", this.agentId);
                    agenticQuery.setAgentFailureReason(errorMessage);
                    throw new IllegalArgumentException("Agentic search failed - " + errorMessage);
                }
                if (dslQuery.length() > 10000) {
                    String errorMessage = String.format(Locale.ROOT, "Response size exceeded limit - Agent ID: [%s], Size: [%d]. Maximum allowed size is %d characters.", this.agentId, dslQuery.length(), 10000);
                    agenticQuery.setAgentFailureReason(errorMessage);
                    throw new IllegalArgumentException("Agentic search blocked - " + errorMessage);
                }
                if (agentStepsSummary != null && !agentStepsSummary.trim().isEmpty()) {
                    requestContext.setAttribute("agent_steps_summary", (Object)agentStepsSummary);
                }
                if (memoryId != null && !memoryId.trim().isEmpty()) {
                    requestContext.setAttribute("memory_id", (Object)memoryId);
                }
                requestContext.setAttribute("dsl_query", (Object)dslQuery);
                BytesArray bytes = new BytesArray(dslQuery);
                List originalExtBuilders = request.source() != null ? request.source().ext() : null;
                try (XContentParser parser = XContentType.JSON.xContent().createParser(this.xContentRegistry, null, (InputStream)bytes.streamInput());){
                    SearchSourceBuilder newSourceBuilder = SearchSourceBuilder.fromXContent((XContentParser)parser);
                    if (originalExtBuilders != null && !originalExtBuilders.isEmpty()) {
                        newSourceBuilder.ext(originalExtBuilders);
                    }
                    request.source(newSourceBuilder);
                }
                requestListener.onResponse((Object)request);
            }
            catch (IOException e) {
                String errorMessage = String.format(Locale.ROOT, "Parse error - Agent ID: [%s], Error: [%s]", this.agentId, e.getMessage());
                agenticQuery.setAgentFailureReason(errorMessage);
                requestListener.onFailure((Exception)new IOException("Agentic search failed - " + errorMessage, e));
            }
        }, e -> {
            String errorMessage = String.format(Locale.ROOT, "Agent execution error - Agent ID: [%s], Error: [%s]", this.agentId, e.getMessage());
            agenticQuery.setAgentFailureReason(errorMessage);
            requestListener.onFailure((Exception)new IllegalArgumentException("Agentic search failed - " + errorMessage, (Throwable)e));
        })), e -> {
            String errorMessage = String.format(Locale.ROOT, "Failed to get agent info - Agent ID: [%s], Error: [%s]", this.agentId, e.getMessage());
            agenticQuery.setAgentFailureReason(errorMessage);
            requestListener.onFailure((Exception)new IllegalArgumentException("Agentic search failed - " + errorMessage, (Throwable)e));
        }));
    }

    public SearchRequest processRequest(SearchRequest request) throws Exception {
        throw new UnsupportedOperationException("Use processRequestAsync for agentic search processor");
    }

    public String getType() {
        return TYPE;
    }

    public static class Factory
    implements Processor.Factory<SearchRequestProcessor> {
        private final MLCommonsClientAccessor mlClient;
        private final NamedXContentRegistry xContentRegistry;
        private final NeuralSearchSettingsAccessor settingsAccessor;

        public Factory(MLCommonsClientAccessor mlClient, NamedXContentRegistry xContentRegistry, NeuralSearchSettingsAccessor settingsAccessor) {
            this.mlClient = mlClient;
            this.xContentRegistry = xContentRegistry;
            this.settingsAccessor = settingsAccessor;
        }

        public AgenticQueryTranslatorProcessor create(Map<String, Processor.Factory<SearchRequestProcessor>> processorFactories, String tag, String description, boolean ignoreFailure, Map<String, Object> config, Processor.PipelineContext pipelineContext) throws IllegalArgumentException, IllegalStateException {
            String agentId = ConfigurationUtils.readStringProperty((String)AgenticQueryTranslatorProcessor.TYPE, (String)tag, config, (String)"agent_id");
            if (agentId == null || agentId.trim().isEmpty()) {
                throw new IllegalArgumentException("agent_id is required for agentic_query_translator processor");
            }
            if (agentId.length() > 100) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "agent_id exceeds maximum length of %d characters", 100));
            }
            if (!agentId.matches(AgenticQueryTranslatorProcessor.AGENT_ID_PATTERN)) {
                throw new IllegalArgumentException("agent_id must contain only alphanumeric characters, hyphens, and underscores");
            }
            return new AgenticQueryTranslatorProcessor(tag, description, ignoreFailure, this.mlClient, agentId, this.xContentRegistry);
        }
    }
}

