/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.bucket.terms;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.LongBitSet;
import org.apache.lucene.util.NumericUtils;
import org.apache.lucene.util.StringHelper;
import org.apache.lucene.util.automaton.Automata;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.ByteRunAutomaton;
import org.apache.lucene.util.automaton.CompiledAutomaton;
import org.apache.lucene.util.automaton.Operations;
import org.apache.lucene.util.automaton.RegExp;
import org.opensearch.OpenSearchParseException;
import org.opensearch.common.util.BitMixer;
import org.opensearch.core.ParseField;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentFragment;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.IndexSettings;
import org.opensearch.search.DocValueFormat;

public class IncludeExclude
implements Writeable,
ToXContentFragment {
    public static final ParseField INCLUDE_FIELD = new ParseField("include", new String[0]);
    public static final ParseField EXCLUDE_FIELD = new ParseField("exclude", new String[0]);
    public static final ParseField PARTITION_FIELD = new ParseField("partition", new String[0]);
    public static final ParseField NUM_PARTITIONS_FIELD = new ParseField("num_partitions", new String[0]);
    private static final int HASH_PARTITIONING_SEED = 31;
    private static final int DEFAULT_MAX_REGEX_LENGTH = 1000;
    private static final int MAX_PREFIXES = 1000;
    private final String include;
    private final String exclude;
    private final SortedSet<BytesRef> includeValues;
    private final SortedSet<BytesRef> excludeValues;
    private final int incZeroBasedPartition;
    private final int incNumPartitions;

    public static IncludeExclude merge(IncludeExclude include, IncludeExclude exclude) {
        String excludeMethod;
        if (include == null) {
            return exclude;
        }
        if (exclude == null) {
            return include;
        }
        if (include.isPartitionBased()) {
            throw new IllegalArgumentException("Cannot specify any excludes when using a partition-based include");
        }
        String includeMethod = include.isRegexBased() ? "regex" : "set";
        String string = excludeMethod = exclude.isRegexBased() ? "regex" : "set";
        if (!includeMethod.equals(excludeMethod)) {
            throw new IllegalArgumentException("Cannot mix a " + includeMethod + "-based include with a " + excludeMethod + "-based method");
        }
        if (include.isRegexBased()) {
            return new IncludeExclude(include.include, exclude.exclude);
        }
        return new IncludeExclude(include.includeValues, exclude.excludeValues);
    }

    public static IncludeExclude parseInclude(XContentParser parser) throws IOException {
        XContentParser.Token token = parser.currentToken();
        if (token == XContentParser.Token.VALUE_STRING) {
            return new IncludeExclude(parser.text(), null);
        }
        if (token == XContentParser.Token.START_ARRAY) {
            return new IncludeExclude(new TreeSet<BytesRef>(IncludeExclude.parseArrayToSet(parser)), null);
        }
        if (token == XContentParser.Token.START_OBJECT) {
            String currentFieldName = null;
            Integer partition = null;
            Integer numPartitions = null;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (NUM_PARTITIONS_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    numPartitions = parser.intValue();
                    continue;
                }
                if (PARTITION_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    partition = parser.intValue();
                    continue;
                }
                throw new OpenSearchParseException("Unknown parameter in Include/Exclude clause: " + currentFieldName, new Object[0]);
            }
            if (partition == null) {
                throw new IllegalArgumentException("Missing [" + PARTITION_FIELD.getPreferredName() + "] parameter for partition-based include");
            }
            if (numPartitions == null) {
                throw new IllegalArgumentException("Missing [" + NUM_PARTITIONS_FIELD.getPreferredName() + "] parameter for partition-based include");
            }
            return new IncludeExclude(partition, numPartitions);
        }
        throw new IllegalArgumentException("Unrecognized token for an include [" + String.valueOf(token) + "]");
    }

    public static IncludeExclude parseExclude(XContentParser parser) throws IOException {
        XContentParser.Token token = parser.currentToken();
        if (token == XContentParser.Token.VALUE_STRING) {
            return new IncludeExclude(null, parser.text());
        }
        if (token == XContentParser.Token.START_ARRAY) {
            return new IncludeExclude(null, new TreeSet<BytesRef>(IncludeExclude.parseArrayToSet(parser)));
        }
        throw new IllegalArgumentException("Unrecognized token for an exclude [" + String.valueOf(token) + "]");
    }

    public IncludeExclude(String include, String exclude) {
        this.include = include;
        this.exclude = exclude;
        this.includeValues = null;
        this.excludeValues = null;
        this.incZeroBasedPartition = 0;
        this.incNumPartitions = 0;
    }

    public IncludeExclude(SortedSet<BytesRef> includeValues, SortedSet<BytesRef> excludeValues) {
        if (includeValues == null && excludeValues == null) {
            throw new IllegalArgumentException();
        }
        this.include = null;
        this.exclude = null;
        this.incZeroBasedPartition = 0;
        this.incNumPartitions = 0;
        this.includeValues = includeValues;
        this.excludeValues = excludeValues;
    }

    public IncludeExclude(String[] includeValues, String[] excludeValues) {
        this(IncludeExclude.convertToBytesRefSet(includeValues), IncludeExclude.convertToBytesRefSet(excludeValues));
    }

    public IncludeExclude(double[] includeValues, double[] excludeValues) {
        this(IncludeExclude.convertToBytesRefSet(includeValues), IncludeExclude.convertToBytesRefSet(excludeValues));
    }

    public IncludeExclude(long[] includeValues, long[] excludeValues) {
        this(IncludeExclude.convertToBytesRefSet(includeValues), IncludeExclude.convertToBytesRefSet(excludeValues));
    }

    public IncludeExclude(int partition, int numPartitions) {
        if (partition < 0 || partition >= numPartitions) {
            throw new IllegalArgumentException("Partition must be >=0 and < numPartition which is " + numPartitions);
        }
        this.incZeroBasedPartition = partition;
        this.incNumPartitions = numPartitions;
        this.include = null;
        this.exclude = null;
        this.includeValues = null;
        this.excludeValues = null;
    }

    public IncludeExclude(StreamInput in) throws IOException {
        int i;
        int size;
        if (in.readBoolean()) {
            this.includeValues = null;
            this.excludeValues = null;
            this.incZeroBasedPartition = 0;
            this.incNumPartitions = 0;
            this.include = in.readOptionalString();
            this.exclude = in.readOptionalString();
            return;
        }
        this.include = null;
        this.exclude = null;
        if (in.readBoolean()) {
            size = in.readVInt();
            this.includeValues = new TreeSet<BytesRef>();
            for (i = 0; i < size; ++i) {
                this.includeValues.add(in.readBytesRef());
            }
        } else {
            this.includeValues = null;
        }
        if (in.readBoolean()) {
            size = in.readVInt();
            this.excludeValues = new TreeSet<BytesRef>();
            for (i = 0; i < size; ++i) {
                this.excludeValues.add(in.readBytesRef());
            }
        } else {
            this.excludeValues = null;
        }
        this.incNumPartitions = in.readVInt();
        this.incZeroBasedPartition = in.readVInt();
    }

    public void writeTo(StreamOutput out) throws IOException {
        boolean regexBased = this.isRegexBased();
        out.writeBoolean(regexBased);
        if (regexBased) {
            out.writeOptionalString(this.include);
            out.writeOptionalString(this.exclude);
        } else {
            boolean hasIncludes = this.includeValues != null;
            out.writeBoolean(hasIncludes);
            if (hasIncludes) {
                out.writeVInt(this.includeValues.size());
                for (BytesRef value : this.includeValues) {
                    out.writeBytesRef(value);
                }
            }
            boolean hasExcludes = this.excludeValues != null;
            out.writeBoolean(hasExcludes);
            if (hasExcludes) {
                out.writeVInt(this.excludeValues.size());
                for (BytesRef value : this.excludeValues) {
                    out.writeBytesRef(value);
                }
            }
            out.writeVInt(this.incNumPartitions);
            out.writeVInt(this.incZeroBasedPartition);
        }
    }

    private static SortedSet<BytesRef> convertToBytesRefSet(String[] values) {
        TreeSet<BytesRef> returnSet = null;
        if (values != null) {
            returnSet = new TreeSet<BytesRef>();
            for (String value : values) {
                returnSet.add(new BytesRef((CharSequence)value));
            }
        }
        return returnSet;
    }

    private static SortedSet<BytesRef> convertToBytesRefSet(double[] values) {
        TreeSet<BytesRef> returnSet = null;
        if (values != null) {
            returnSet = new TreeSet<BytesRef>();
            for (double value : values) {
                returnSet.add(new BytesRef((CharSequence)String.valueOf(value)));
            }
        }
        return returnSet;
    }

    private static SortedSet<BytesRef> convertToBytesRefSet(long[] values) {
        TreeSet<BytesRef> returnSet = null;
        if (values != null) {
            returnSet = new TreeSet<BytesRef>();
            for (long value : values) {
                returnSet.add(new BytesRef((CharSequence)String.valueOf(value)));
            }
        }
        return returnSet;
    }

    private static Set<BytesRef> parseArrayToSet(XContentParser parser) throws IOException {
        HashSet<BytesRef> set = new HashSet<BytesRef>();
        if (parser.currentToken() != XContentParser.Token.START_ARRAY) {
            throw new OpenSearchParseException("Missing start of array in include/exclude clause", new Object[0]);
        }
        while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
            if (!parser.currentToken().isValue()) {
                throw new OpenSearchParseException("Array elements in include/exclude clauses should be string values", new Object[0]);
            }
            set.add(new BytesRef((CharSequence)parser.text()));
        }
        return set;
    }

    public boolean isRegexBased() {
        return this.include != null || this.exclude != null;
    }

    public boolean isPartitionBased() {
        return this.incNumPartitions > 0;
    }

    private Automaton toAutomaton(int maxRegExLength) {
        Automaton a;
        if (this.include != null) {
            IncludeExclude.validateRegExpStringLength(this.include, maxRegExLength);
            a = new RegExp(this.include).toAutomaton();
        } else {
            a = this.includeValues != null ? Automata.makeStringUnion(this.includeValues) : Automata.makeAnyString();
        }
        if (this.exclude != null) {
            IncludeExclude.validateRegExpStringLength(this.exclude, maxRegExLength);
            Automaton excludeAutomaton = new RegExp(this.exclude).toAutomaton();
            a = Operations.minus((Automaton)a, (Automaton)excludeAutomaton, (int)10000);
        } else if (this.excludeValues != null) {
            a = Operations.minus((Automaton)a, (Automaton)Automata.makeStringUnion(this.excludeValues), (int)10000);
        }
        if (a.isDeterministic()) {
            return a;
        }
        return Operations.determinize((Automaton)a, (int)10000);
    }

    private static void validateRegExpStringLength(String source, int maxRegexLength) {
        if (maxRegexLength > 0 && source.length() > maxRegexLength) {
            throw new IllegalArgumentException("The length of regex [" + source.length() + "] used in the request has exceeded the allowed maximum of [" + maxRegexLength + "]. This maximum can be set by changing the [" + IndexSettings.MAX_REGEX_LENGTH_SETTING.getKey() + "] index level setting.");
        }
    }

    public StringFilter convertToStringFilter(DocValueFormat format) {
        return this.convertToStringFilter(format, 1000);
    }

    public StringFilter convertToStringFilter(DocValueFormat format, int maxRegexLength) {
        if (this.isRegexBased()) {
            return new AutomatonBackedStringFilter(this.toAutomaton(maxRegexLength));
        }
        if (this.isPartitionBased()) {
            return new PartitionedStringFilter();
        }
        return new TermListBackedStringFilter(IncludeExclude.parseForDocValues(this.includeValues, format), IncludeExclude.parseForDocValues(this.excludeValues, format));
    }

    private static SortedSet<BytesRef> parseForDocValues(SortedSet<BytesRef> endUserFormattedValues, DocValueFormat format) {
        SortedSet<BytesRef> result = endUserFormattedValues;
        if (endUserFormattedValues != null && format != DocValueFormat.RAW) {
            result = new TreeSet<BytesRef>();
            for (BytesRef formattedVal : endUserFormattedValues) {
                result.add(format.parseBytesRef(formattedVal.utf8ToString()));
            }
        }
        return result;
    }

    public OrdinalsFilter convertToOrdinalsFilter(DocValueFormat format) {
        return this.convertToOrdinalsFilter(format, 1000);
    }

    public OrdinalsFilter convertToOrdinalsFilter(DocValueFormat format, int maxRegexLength) {
        if (this.isRegexBased()) {
            PrefixBackedOrdinalsFilter prefixBackedOrdinalsFilter;
            if ((this.include == null || this.include.endsWith(".*")) && (this.exclude == null || this.exclude.endsWith(".*")) && (prefixBackedOrdinalsFilter = this.tryCreatePrefixOrdinalsFilter(maxRegexLength)) != null) {
                return prefixBackedOrdinalsFilter;
            }
            return new AutomatonBackedOrdinalsFilter(this.toAutomaton(maxRegexLength));
        }
        if (this.isPartitionBased()) {
            return new PartitionedOrdinalsFilter();
        }
        return new TermListBackedOrdinalsFilter(IncludeExclude.parseForDocValues(this.includeValues, format), IncludeExclude.parseForDocValues(this.excludeValues, format));
    }

    private static List<String> expandRegexp(RegExp regExp, int maxPrefixes) {
        switch (regExp.kind) {
            case REGEXP_UNION: {
                ArrayList<RegExp> alternatives = new ArrayList<RegExp>();
                while (regExp.exp1.kind == RegExp.Kind.REGEXP_UNION) {
                    alternatives.add(regExp.exp2);
                    regExp = regExp.exp1;
                }
                alternatives.add(regExp.exp2);
                alternatives.add(regExp.exp1);
                ArrayList<String> output = new ArrayList<String>();
                for (RegExp leaf : alternatives) {
                    List<String> leafExpansions = IncludeExclude.expandRegexp(leaf, maxPrefixes);
                    if (leafExpansions == null) {
                        return null;
                    }
                    if (output.size() + leafExpansions.size() > maxPrefixes) {
                        return null;
                    }
                    output.addAll(leafExpansions);
                }
                return output;
            }
            case REGEXP_CONCATENATION: {
                List<String> prefixes = IncludeExclude.expandRegexp(regExp.exp1, maxPrefixes);
                if (prefixes == null) {
                    return null;
                }
                List<String> suffixes = IncludeExclude.expandRegexp(regExp.exp2, maxPrefixes);
                if (suffixes == null) {
                    return null;
                }
                if (prefixes.size() * suffixes.size() > maxPrefixes) {
                    return null;
                }
                ArrayList<String> out = new ArrayList<String>();
                StringBuilder stringBuilder = new StringBuilder();
                for (String prefix : prefixes) {
                    for (String suffix : suffixes) {
                        stringBuilder.setLength(0);
                        stringBuilder.append(prefix).append(suffix);
                        out.add(stringBuilder.toString());
                    }
                }
                return out;
            }
            case REGEXP_CHAR: {
                return List.of(Character.toString(regExp.c));
            }
            case REGEXP_STRING: {
                return List.of(regExp.s);
            }
        }
        return null;
    }

    static SortedSet<BytesRef> extractPrefixes(String pattern, int maxRegexLength) {
        if (pattern == null) {
            return Collections.emptySortedSet();
        }
        TreeSet<BytesRef> prefixSet = null;
        IncludeExclude.validateRegExpStringLength(pattern, maxRegexLength);
        RegExp regExp = new RegExp(pattern);
        if (regExp.kind == RegExp.Kind.REGEXP_CONCATENATION && regExp.exp2.kind == RegExp.Kind.REGEXP_REPEAT) {
            List<String> prefixes;
            RegExp tail = regExp.exp2.exp1;
            if ((tail.kind == RegExp.Kind.REGEXP_ANYCHAR || tail.kind == RegExp.Kind.REGEXP_ANYSTRING) && (prefixes = IncludeExclude.expandRegexp(regExp.exp1, 1000)) != null) {
                prefixSet = new TreeSet<BytesRef>();
                for (String prefix : prefixes) {
                    prefixSet.add(new BytesRef((CharSequence)prefix));
                }
            }
        }
        return prefixSet;
    }

    private PrefixBackedOrdinalsFilter tryCreatePrefixOrdinalsFilter(int maxRegexLength) {
        SortedSet<BytesRef> includeSet = IncludeExclude.extractPrefixes(this.include, maxRegexLength);
        if (includeSet == null) {
            return null;
        }
        SortedSet<BytesRef> excludeSet = IncludeExclude.extractPrefixes(this.exclude, maxRegexLength);
        if (excludeSet == null) {
            return null;
        }
        return new PrefixBackedOrdinalsFilter(includeSet, excludeSet);
    }

    public LongFilter convertToLongFilter(DocValueFormat format) {
        if (this.isPartitionBased()) {
            return new PartitionedLongFilter();
        }
        int numValids = this.includeValues == null ? 0 : this.includeValues.size();
        int numInvalids = this.excludeValues == null ? 0 : this.excludeValues.size();
        SetBackedLongFilter result = new SetBackedLongFilter(numValids, numInvalids);
        if (this.includeValues != null) {
            for (BytesRef val : this.includeValues) {
                result.addAccept(format.parseLong(val.utf8ToString(), false, null));
            }
        }
        if (this.excludeValues != null) {
            for (BytesRef val : this.excludeValues) {
                result.addReject(format.parseLong(val.utf8ToString(), false, null));
            }
        }
        return result;
    }

    public LongFilter convertToDoubleFilter() {
        double dval;
        if (this.isPartitionBased()) {
            return new PartitionedLongFilter();
        }
        int numValids = this.includeValues == null ? 0 : this.includeValues.size();
        int numInvalids = this.excludeValues == null ? 0 : this.excludeValues.size();
        SetBackedLongFilter result = new SetBackedLongFilter(numValids, numInvalids);
        if (this.includeValues != null) {
            for (BytesRef val : this.includeValues) {
                dval = Double.parseDouble(val.utf8ToString());
                result.addAccept(NumericUtils.doubleToSortableLong((double)dval));
            }
        }
        if (this.excludeValues != null) {
            for (BytesRef val : this.excludeValues) {
                dval = Double.parseDouble(val.utf8ToString());
                result.addReject(NumericUtils.doubleToSortableLong((double)dval));
            }
        }
        return result;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.include != null) {
            builder.field(INCLUDE_FIELD.getPreferredName(), this.include);
        } else if (this.includeValues != null) {
            builder.startArray(INCLUDE_FIELD.getPreferredName());
            for (BytesRef value : this.includeValues) {
                builder.value(value.utf8ToString());
            }
            builder.endArray();
        } else if (this.isPartitionBased()) {
            builder.startObject(INCLUDE_FIELD.getPreferredName());
            builder.field(PARTITION_FIELD.getPreferredName(), this.incZeroBasedPartition);
            builder.field(NUM_PARTITIONS_FIELD.getPreferredName(), this.incNumPartitions);
            builder.endObject();
        }
        if (this.exclude != null) {
            builder.field(EXCLUDE_FIELD.getPreferredName(), this.exclude);
        } else if (this.excludeValues != null) {
            builder.startArray(EXCLUDE_FIELD.getPreferredName());
            for (BytesRef value : this.excludeValues) {
                builder.value(value.utf8ToString());
            }
            builder.endArray();
        }
        return builder;
    }

    public int hashCode() {
        return Objects.hash(this.include, this.exclude, this.includeValues, this.excludeValues, this.incZeroBasedPartition, this.incNumPartitions);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IncludeExclude other = (IncludeExclude)obj;
        return Objects.equals(this.include, other.include) && Objects.equals(this.exclude, other.exclude) && Objects.equals(this.includeValues, other.includeValues) && Objects.equals(this.excludeValues, other.excludeValues) && Objects.equals(this.incZeroBasedPartition, other.incZeroBasedPartition) && Objects.equals(this.incNumPartitions, other.incNumPartitions);
    }

    public static abstract class StringFilter
    extends Filter {
        public abstract boolean accept(BytesRef var1);
    }

    static class AutomatonBackedStringFilter
    extends StringFilter {
        private final ByteRunAutomaton runAutomaton;

        private AutomatonBackedStringFilter(Automaton automaton) {
            this.runAutomaton = new ByteRunAutomaton(automaton);
        }

        @Override
        public boolean accept(BytesRef value) {
            return this.runAutomaton.run(value.bytes, value.offset, value.length);
        }
    }

    class PartitionedStringFilter
    extends StringFilter {
        PartitionedStringFilter() {
        }

        @Override
        public boolean accept(BytesRef value) {
            return Math.floorMod(StringHelper.murmurhash3_x86_32((BytesRef)value, (int)31), IncludeExclude.this.incNumPartitions) == IncludeExclude.this.incZeroBasedPartition;
        }
    }

    static class TermListBackedStringFilter
    extends StringFilter {
        private final Set<BytesRef> valids;
        private final Set<BytesRef> invalids;

        TermListBackedStringFilter(Set<BytesRef> includeValues, Set<BytesRef> excludeValues) {
            this.valids = includeValues;
            this.invalids = excludeValues;
        }

        @Override
        public boolean accept(BytesRef value) {
            return !(this.valids != null && !this.valids.contains(value) || this.invalids != null && this.invalids.contains(value));
        }
    }

    public static abstract class OrdinalsFilter
    extends Filter {
        public abstract LongBitSet acceptedGlobalOrdinals(SortedSetDocValues var1) throws IOException;
    }

    static class PrefixBackedOrdinalsFilter
    extends OrdinalsFilter {
        private final SortedSet<BytesRef> includePrefixes;
        private final SortedSet<BytesRef> excludePrefixes;

        private PrefixBackedOrdinalsFilter(SortedSet<BytesRef> includePrefixes, SortedSet<BytesRef> excludePrefixes) {
            this.includePrefixes = includePrefixes;
            this.excludePrefixes = excludePrefixes;
        }

        private static BytesRef nextBytesRef(BytesRef bytesRef) {
            int pos;
            BytesRef next = BytesRef.deepCopyOf((BytesRef)bytesRef);
            for (pos = next.offset + next.length - 1; pos >= next.offset && next.bytes[pos] == -1; --pos) {
                next.bytes[pos] = 0;
            }
            if (pos < next.offset) {
                return null;
            }
            int n = pos;
            next.bytes[n] = (byte)(next.bytes[n] + 1);
            return next;
        }

        private static void process(SortedSetDocValues globalOrdinals, long length, SortedSet<BytesRef> prefixes, LongBiConsumer consumer) throws IOException {
            for (BytesRef prefix : prefixes) {
                BytesRef next;
                long startOrd = globalOrdinals.lookupTerm(prefix);
                if (startOrd < 0L) {
                    if ((startOrd = -1L - startOrd) >= length) continue;
                    BytesRef startTerm = globalOrdinals.lookupOrd(startOrd);
                    if (startTerm.length <= prefix.length || !Arrays.equals(startTerm.bytes, startTerm.offset, startTerm.offset + prefix.length, prefix.bytes, prefix.offset, prefix.offset + prefix.length)) {
                        continue;
                    }
                } else if (startOrd >= length) continue;
                if ((next = PrefixBackedOrdinalsFilter.nextBytesRef(prefix)) == null) {
                    consumer.accept(startOrd, length);
                    continue;
                }
                long endOrd = globalOrdinals.lookupTerm(next);
                if (endOrd < 0L) {
                    endOrd = -1L - endOrd;
                }
                if (startOrd >= endOrd) continue;
                consumer.accept(startOrd, endOrd);
            }
        }

        @Override
        public LongBitSet acceptedGlobalOrdinals(SortedSetDocValues globalOrdinals) throws IOException {
            LongBitSet accept = new LongBitSet(globalOrdinals.getValueCount());
            if (!this.includePrefixes.isEmpty()) {
                PrefixBackedOrdinalsFilter.process(globalOrdinals, accept.length(), this.includePrefixes, (arg_0, arg_1) -> ((LongBitSet)accept).set(arg_0, arg_1));
            } else if (accept.length() > 0L) {
                accept.set(0L, accept.length());
            }
            PrefixBackedOrdinalsFilter.process(globalOrdinals, accept.length(), this.excludePrefixes, (arg_0, arg_1) -> ((LongBitSet)accept).clear(arg_0, arg_1));
            return accept;
        }

        private static interface LongBiConsumer {
            public void accept(long var1, long var3);
        }
    }

    static class AutomatonBackedOrdinalsFilter
    extends OrdinalsFilter {
        private final CompiledAutomaton compiled;

        private AutomatonBackedOrdinalsFilter(Automaton automaton) {
            this.compiled = new CompiledAutomaton(automaton);
        }

        @Override
        public LongBitSet acceptedGlobalOrdinals(SortedSetDocValues globalOrdinals) throws IOException {
            LongBitSet acceptedGlobalOrdinals = new LongBitSet(globalOrdinals.getValueCount());
            DocValuesTerms globalTerms = new DocValuesTerms(globalOrdinals);
            TermsEnum globalTermsEnum = this.compiled.getTermsEnum((Terms)globalTerms);
            BytesRef term = globalTermsEnum.next();
            while (term != null) {
                acceptedGlobalOrdinals.set(globalTermsEnum.ord());
                term = globalTermsEnum.next();
            }
            return acceptedGlobalOrdinals;
        }
    }

    class PartitionedOrdinalsFilter
    extends OrdinalsFilter {
        PartitionedOrdinalsFilter() {
        }

        @Override
        public LongBitSet acceptedGlobalOrdinals(SortedSetDocValues globalOrdinals) throws IOException {
            long numOrds = globalOrdinals.getValueCount();
            LongBitSet acceptedGlobalOrdinals = new LongBitSet(numOrds);
            TermsEnum termEnum = globalOrdinals.termsEnum();
            BytesRef term = termEnum.next();
            while (term != null) {
                if (Math.floorMod(StringHelper.murmurhash3_x86_32((BytesRef)term, (int)31), IncludeExclude.this.incNumPartitions) == IncludeExclude.this.incZeroBasedPartition) {
                    acceptedGlobalOrdinals.set(termEnum.ord());
                }
                term = termEnum.next();
            }
            return acceptedGlobalOrdinals;
        }
    }

    static class TermListBackedOrdinalsFilter
    extends OrdinalsFilter {
        private final SortedSet<BytesRef> includeValues;
        private final SortedSet<BytesRef> excludeValues;

        TermListBackedOrdinalsFilter(SortedSet<BytesRef> includeValues, SortedSet<BytesRef> excludeValues) {
            this.includeValues = includeValues;
            this.excludeValues = excludeValues;
        }

        @Override
        public LongBitSet acceptedGlobalOrdinals(SortedSetDocValues globalOrdinals) throws IOException {
            long ord;
            LongBitSet acceptedGlobalOrdinals = new LongBitSet(globalOrdinals.getValueCount());
            if (this.includeValues != null) {
                for (BytesRef term : this.includeValues) {
                    ord = globalOrdinals.lookupTerm(term);
                    if (ord < 0L) continue;
                    acceptedGlobalOrdinals.set(ord);
                }
            } else if (acceptedGlobalOrdinals.length() > 0L) {
                acceptedGlobalOrdinals.set(0L, acceptedGlobalOrdinals.length());
            }
            if (this.excludeValues != null) {
                for (BytesRef term : this.excludeValues) {
                    ord = globalOrdinals.lookupTerm(term);
                    if (ord < 0L) continue;
                    acceptedGlobalOrdinals.clear(ord);
                }
            }
            return acceptedGlobalOrdinals;
        }
    }

    public class PartitionedLongFilter
    extends LongFilter {
        @Override
        public boolean accept(long value) {
            long hashCode = BitMixer.mix64((long)value);
            return Math.floorMod(hashCode, IncludeExclude.this.incNumPartitions) == IncludeExclude.this.incZeroBasedPartition;
        }
    }

    public static class SetBackedLongFilter
    extends LongFilter {
        private Set<Long> valids;
        private Set<Long> invalids;

        private SetBackedLongFilter(int numValids, int numInvalids) {
            if (numValids > 0) {
                this.valids = new HashSet<Long>(numValids);
            }
            if (numInvalids > 0) {
                this.invalids = new HashSet<Long>(numInvalids);
            }
        }

        @Override
        public boolean accept(long value) {
            return !(this.valids != null && !this.valids.contains(value) || this.invalids != null && this.invalids.contains(value));
        }

        private void addAccept(long val) {
            this.valids.add(val);
        }

        private void addReject(long val) {
            this.invalids.add(val);
        }
    }

    private static class DocValuesTerms
    extends Terms {
        private final SortedSetDocValues values;

        DocValuesTerms(SortedSetDocValues values) {
            this.values = values;
        }

        public TermsEnum iterator() throws IOException {
            return this.values.termsEnum();
        }

        public long size() throws IOException {
            return -1L;
        }

        public long getSumTotalTermFreq() throws IOException {
            return -1L;
        }

        public long getSumDocFreq() throws IOException {
            return -1L;
        }

        public int getDocCount() throws IOException {
            return -1;
        }

        public boolean hasFreqs() {
            return false;
        }

        public boolean hasOffsets() {
            return false;
        }

        public boolean hasPositions() {
            return false;
        }

        public boolean hasPayloads() {
            return false;
        }
    }

    public static abstract class LongFilter
    extends Filter {
        public abstract boolean accept(long var1);
    }

    public static abstract class Filter {
    }
}

