/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.codec.customcodecs;

import com.intel.qat.QatZipper;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.codecs.FilterCodec;
import org.apache.lucene.codecs.StoredFieldsFormat;
import org.apache.lucene.codecs.lucene103.Lucene103Codec;
import org.opensearch.index.codec.customcodecs.Lucene103QatStoredFieldsFormat;
import org.opensearch.index.codec.customcodecs.backward_codecs.lucene99.Lucene99QatCodec;

public abstract class Lucene103QatCodec
extends FilterCodec {
    public static final Mode DEFAULT_COMPRESSION_MODE = Mode.QAT_LZ4;
    private final StoredFieldsFormat storedFieldsFormat;

    public Lucene103QatCodec(Mode mode) {
        this(mode, Lucene99QatCodec.DEFAULT_COMPRESSION_LEVEL);
    }

    public Lucene103QatCodec(Mode mode, int compressionLevel) {
        super(mode.getCodec(), (Codec)new Lucene103Codec());
        this.storedFieldsFormat = new Lucene103QatStoredFieldsFormat(mode, compressionLevel);
    }

    public Lucene103QatCodec(Mode mode, int compressionLevel, Supplier<QatZipper.Mode> supplier) {
        super(mode.getCodec(), (Codec)new Lucene103Codec());
        this.storedFieldsFormat = new Lucene103QatStoredFieldsFormat(mode, compressionLevel, supplier);
    }

    public Lucene103QatCodec(Mode mode, Supplier<Codec> defaultCodecSupplier, int compressionLevel) {
        super(mode.getCodec(), defaultCodecSupplier.get());
        this.storedFieldsFormat = new Lucene103QatStoredFieldsFormat(mode, compressionLevel);
    }

    public Lucene103QatCodec(Mode mode, int compressionLevel, Supplier<QatZipper.Mode> supplier, Supplier<Codec> defaultCodecSupplier) {
        super(mode.getCodec(), defaultCodecSupplier.get());
        this.storedFieldsFormat = new Lucene103QatStoredFieldsFormat(mode, compressionLevel, supplier);
    }

    public StoredFieldsFormat storedFieldsFormat() {
        return this.storedFieldsFormat;
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    public static enum Mode {
        QAT_LZ4("QATLZ4103", Set.of("qat_lz4")),
        QAT_DEFLATE("QATDEFLATE103", Set.of("qat_deflate")),
        QAT_ZSTD("QATZSTD103", Set.of("qat_zstd"));

        private final String codec;
        private final Set<String> aliases;

        private Mode(String codec, Set<String> aliases) {
            this.codec = codec;
            this.aliases = aliases;
        }

        public String getCodec() {
            return this.codec;
        }

        public Set<String> getAliases() {
            return this.aliases;
        }
    }
}

