/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.timeseries.ratelimit;

import java.time.Clock;
import java.time.Duration;
import java.util.List;
import java.util.Random;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ad.ratelimit.ADColdEntityWorker;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.timeseries.AnalysisType;
import org.opensearch.timeseries.NodeStateManager;
import org.opensearch.timeseries.breaker.CircuitBreakerService;
import org.opensearch.timeseries.ratelimit.QueuedRequest;
import org.opensearch.timeseries.ratelimit.RateLimitedRequestWorker;

public abstract class ScheduledWorker<RequestType extends QueuedRequest, TransformedRequestType extends QueuedRequest>
extends RateLimitedRequestWorker<RequestType> {
    private static final Logger LOG = LogManager.getLogger(ADColdEntityWorker.class);
    protected volatile int batchSize;
    private final RateLimitedRequestWorker<TransformedRequestType> targetQueue;
    private boolean scheduled;
    protected volatile int expectedExecutionTimeInMilliSecsPerRequest;

    public ScheduledWorker(String workerName, long heapSizeInBytes, int singleRequestSizeInBytes, Setting<Float> maxHeapPercentForQueueSetting, ClusterService clusterService, Random random, CircuitBreakerService adCircuitBreakerService, ThreadPool threadPool, String threadPoolName, Settings settings, float maxQueuedTaskRatio, Clock clock, float mediumSegmentPruneRatio, float lowSegmentPruneRatio, int maintenanceFreqConstant, RateLimitedRequestWorker<TransformedRequestType> targetQueue, Duration stateTtl, NodeStateManager nodeStateManager, AnalysisType context) {
        super(workerName, heapSizeInBytes, singleRequestSizeInBytes, maxHeapPercentForQueueSetting, clusterService, random, adCircuitBreakerService, threadPool, threadPoolName, settings, maxQueuedTaskRatio, clock, mediumSegmentPruneRatio, lowSegmentPruneRatio, maintenanceFreqConstant, stateTtl, nodeStateManager, context);
        this.targetQueue = targetQueue;
        this.scheduled = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pullRequests() {
        int pulledRequestSize = 0;
        int filteredRequestSize = 0;
        try {
            List requests = this.getRequests(this.batchSize);
            if (requests == null || requests.isEmpty()) {
                return;
            }
            pulledRequestSize = requests.size();
            List<TransformedRequestType> filteredRequests = this.transformRequests(requests);
            if (!filteredRequests.isEmpty()) {
                this.targetQueue.putAll(filteredRequests);
                filteredRequestSize = filteredRequests.size();
            }
        }
        catch (Exception e) {
            LOG.error("Error enqueuing cold entity requests", (Throwable)e);
        }
        finally {
            if (pulledRequestSize < this.batchSize) {
                this.scheduled = false;
            } else {
                this.scheduled = true;
                if (filteredRequestSize == 0) {
                    this.pullRequests();
                } else {
                    this.schedulePulling(this.getScheduleDelay(filteredRequestSize));
                }
            }
        }
    }

    private synchronized void schedulePulling(TimeValue delay) {
        try {
            this.threadPool.schedule(this::pullRequests, delay, this.threadPoolName);
        }
        catch (Exception e) {
            LOG.error("Fail to schedule cold entity pulling", (Throwable)e);
        }
    }

    @Override
    protected void triggerProcess() {
        if (!this.scheduled) {
            this.pullRequests();
        }
    }

    private TimeValue getScheduleDelay(int requestSize) {
        return TimeValue.timeValueMillis((long)(requestSize * this.expectedExecutionTimeInMilliSecsPerRequest));
    }

    protected abstract List<TransformedRequestType> transformRequests(List<RequestType> var1);
}

