/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.materialproviders.model;

import java.util.Objects;

public class KmsPublicKeyDiscoveryInput {
    private final String recipientKmsIdentifier;

    protected KmsPublicKeyDiscoveryInput(BuilderImpl builder) {
        this.recipientKmsIdentifier = builder.recipientKmsIdentifier();
    }

    public String recipientKmsIdentifier() {
        return this.recipientKmsIdentifier;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected String recipientKmsIdentifier;

        protected BuilderImpl() {
        }

        protected BuilderImpl(KmsPublicKeyDiscoveryInput model) {
            this.recipientKmsIdentifier = model.recipientKmsIdentifier();
        }

        @Override
        public Builder recipientKmsIdentifier(String recipientKmsIdentifier) {
            this.recipientKmsIdentifier = recipientKmsIdentifier;
            return this;
        }

        @Override
        public String recipientKmsIdentifier() {
            return this.recipientKmsIdentifier;
        }

        @Override
        public KmsPublicKeyDiscoveryInput build() {
            if (Objects.isNull(this.recipientKmsIdentifier())) {
                throw new IllegalArgumentException("Missing value for required field `recipientKmsIdentifier`");
            }
            return new KmsPublicKeyDiscoveryInput(this);
        }
    }

    public static interface Builder {
        public Builder recipientKmsIdentifier(String var1);

        public String recipientKmsIdentifier();

        public KmsPublicKeyDiscoveryInput build();
    }
}

