/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.plugin.insights.core.service;

import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.admin.cluster.state.ClusterStateRequest;
import org.opensearch.action.support.IndicesOptions;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.lifecycle.AbstractLifecycleComponent;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.util.concurrent.FutureUtils;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.plugin.insights.core.exporter.LocalIndexExporter;
import org.opensearch.plugin.insights.core.exporter.QueryInsightsExporter;
import org.opensearch.plugin.insights.core.exporter.QueryInsightsExporterFactory;
import org.opensearch.plugin.insights.core.exporter.SinkType;
import org.opensearch.plugin.insights.core.metrics.OperationalMetric;
import org.opensearch.plugin.insights.core.metrics.OperationalMetricsCounter;
import org.opensearch.plugin.insights.core.reader.QueryInsightsReader;
import org.opensearch.plugin.insights.core.reader.QueryInsightsReaderFactory;
import org.opensearch.plugin.insights.core.service.TopQueriesService;
import org.opensearch.plugin.insights.core.service.categorizer.QueryShapeGenerator;
import org.opensearch.plugin.insights.core.service.categorizer.SearchQueryCategorizer;
import org.opensearch.plugin.insights.core.utils.IndexDiscoveryHelper;
import org.opensearch.plugin.insights.rules.model.GroupingType;
import org.opensearch.plugin.insights.rules.model.MetricType;
import org.opensearch.plugin.insights.rules.model.SearchQueryRecord;
import org.opensearch.plugin.insights.rules.model.healthStats.QueryInsightsHealthStats;
import org.opensearch.plugin.insights.rules.model.healthStats.TopQueriesHealthStats;
import org.opensearch.plugin.insights.settings.QueryInsightsSettings;
import org.opensearch.telemetry.metrics.MetricsRegistry;
import org.opensearch.threadpool.Scheduler;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.client.Client;

public class QueryInsightsService
extends AbstractLifecycleComponent {
    public static final String QUERY_INSIGHTS_INDEX_TAG_NAME = "query_insights_feature_space";
    private static final Logger logger = LogManager.getLogger(QueryInsightsService.class);
    private final ClusterService clusterService;
    private final ThreadPool threadPool;
    private final Map<MetricType, TopQueriesService> topQueriesServices;
    private final Map<MetricType, Boolean> enableCollect;
    private final LinkedBlockingQueue<SearchQueryRecord> queryRecordsQueue;
    protected volatile List<Scheduler.Cancellable> scheduledFutures;
    protected volatile ScheduledFuture deleteIndicesScheduledFuture;
    final QueryInsightsExporterFactory queryInsightsExporterFactory;
    final QueryInsightsReaderFactory queryInsightsReaderFactory;
    private GroupingType groupingType;
    private volatile boolean searchQueryMetricsEnabled;
    private final SearchQueryCategorizer searchQueryCategorizer;
    private final NamedXContentRegistry namedXContentRegistry;
    private QueryShapeGenerator queryShapeGenerator;
    private final Client client;
    SinkType sinkType;

    @Inject
    public QueryInsightsService(ClusterService clusterService, ThreadPool threadPool, Client client, MetricsRegistry metricsRegistry, NamedXContentRegistry namedXContentRegistry, QueryInsightsExporterFactory queryInsightsExporterFactory, QueryInsightsReaderFactory queryInsightsReaderFactory) {
        this.clusterService = clusterService;
        this.enableCollect = new HashMap<MetricType, Boolean>();
        this.queryRecordsQueue = new LinkedBlockingQueue(1000);
        this.threadPool = threadPool;
        this.queryInsightsExporterFactory = queryInsightsExporterFactory;
        this.queryInsightsReaderFactory = queryInsightsReaderFactory;
        this.namedXContentRegistry = namedXContentRegistry;
        this.client = client;
        this.topQueriesServices = new HashMap<MetricType, TopQueriesService>();
        for (MetricType metricType : MetricType.allMetricTypes()) {
            this.enableCollect.put(metricType, false);
            this.topQueriesServices.put(metricType, new TopQueriesService(client, metricType, threadPool, this.queryInsightsExporterFactory, this.queryInsightsReaderFactory));
        }
        clusterService.getClusterSettings().addSettingsUpdateConsumer(QueryInsightsSettings.TOP_N_EXPORTER_TYPE, v -> this.setExporterAndReaderType(SinkType.parse(v)), this::validateExporterType);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(QueryInsightsSettings.TOP_N_EXPORTER_DELETE_AFTER, this::setExporterDeleteAfterAndDelete, this::validateExporterDeleteAfter);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(QueryInsightsSettings.TOP_N_EXPORTER_TEMPLATE_PRIORITY, this::setTemplatePriority, this::validateTemplatePriority);
        this.setExporterDeleteAfterAndDelete((Integer)clusterService.getClusterSettings().get(QueryInsightsSettings.TOP_N_EXPORTER_DELETE_AFTER));
        this.setExporterAndReaderType(SinkType.parse((String)clusterService.getClusterSettings().get(QueryInsightsSettings.TOP_N_EXPORTER_TYPE)));
        this.setTemplatePriority((Long)clusterService.getClusterSettings().get(QueryInsightsSettings.TOP_N_EXPORTER_TEMPLATE_PRIORITY));
        this.searchQueryCategorizer = SearchQueryCategorizer.getInstance(metricsRegistry);
        this.enableSearchQueryMetricsFeature(false);
        this.groupingType = QueryInsightsSettings.DEFAULT_GROUPING_TYPE;
    }

    public boolean addRecord(SearchQueryRecord record) {
        boolean shouldAdd;
        boolean bl = shouldAdd = this.isSearchQueryMetricsFeatureEnabled() || this.isGroupingEnabled();
        if (!shouldAdd) {
            for (Map.Entry<MetricType, TopQueriesService> entry : this.topQueriesServices.entrySet()) {
                List<SearchQueryRecord> currentSnapshot;
                if (!this.enableCollect.get(entry.getKey()).booleanValue() || (currentSnapshot = entry.getValue().getTopQueriesCurrentSnapshot()).size() >= entry.getValue().getTopNSize() && SearchQueryRecord.compare(record, currentSnapshot.get(0), entry.getKey()) <= 0) continue;
                shouldAdd = true;
                break;
            }
        }
        if (shouldAdd) {
            return this.queryRecordsQueue.offer(record);
        }
        return false;
    }

    public void drainRecords() {
        ArrayList<SearchQueryRecord> records = new ArrayList<SearchQueryRecord>();
        this.queryRecordsQueue.drainTo(records);
        records.sort(Comparator.comparingLong(SearchQueryRecord::getTimestamp));
        for (MetricType metricType : MetricType.allMetricTypes()) {
            if (!this.enableCollect.get(metricType).booleanValue()) continue;
            this.topQueriesServices.get(metricType).consumeRecords(records);
        }
        if (this.searchQueryMetricsEnabled) {
            try {
                this.searchQueryCategorizer.consumeRecords(records);
            }
            catch (Exception e) {
                OperationalMetricsCounter.getInstance().incrementCounter(OperationalMetric.QUERY_CATEGORIZE_EXCEPTIONS);
                logger.error("Error while trying to categorize the queries.", (Throwable)e);
            }
        }
    }

    public TopQueriesService getTopQueriesService(MetricType metricType) {
        return this.topQueriesServices.get(metricType);
    }

    public void enableCollection(MetricType metricType, boolean enable) {
        this.enableCollect.put(metricType, enable);
        this.topQueriesServices.get(metricType).setEnabled(enable);
        if (!enable && !this.isAnyFeatureEnabled()) {
            this.queryRecordsQueue.clear();
        }
    }

    public void validateGrouping(String groupingTypeSetting) {
        GroupingType.getGroupingTypeFromSettingAndValidate(groupingTypeSetting);
    }

    public void setGrouping(String groupingTypeSetting) {
        GroupingType oldGroupingType = this.groupingType;
        GroupingType newGroupingType = GroupingType.getGroupingTypeFromSettingAndValidate(groupingTypeSetting);
        if (oldGroupingType != newGroupingType) {
            this.groupingType = newGroupingType;
            for (MetricType metricType : MetricType.allMetricTypes()) {
                this.topQueriesServices.get(metricType).setGrouping(newGroupingType);
            }
        }
    }

    public void setMaximumGroups(int maxGroups) {
        for (MetricType metricType : MetricType.allMetricTypes()) {
            this.topQueriesServices.get(metricType).setMaxGroups(maxGroups);
        }
    }

    public void validateMaximumGroups(int maxGroups) {
        if (maxGroups < 0 || maxGroups > 10000) {
            throw new IllegalArgumentException("Max groups setting should be between 0 and 10000, was (" + maxGroups + ")");
        }
    }

    public GroupingType getGrouping() {
        return this.groupingType;
    }

    public boolean isCollectionEnabled(MetricType metricType) {
        return this.enableCollect.get(metricType);
    }

    public boolean isAnyFeatureEnabled() {
        return this.isTopNFeatureEnabled() || this.isSearchQueryMetricsFeatureEnabled();
    }

    public boolean isTopNFeatureEnabled() {
        for (MetricType t : MetricType.allMetricTypes()) {
            if (!this.isCollectionEnabled(t)) continue;
            return true;
        }
        return false;
    }

    public boolean isSearchQueryMetricsFeatureEnabled() {
        return this.searchQueryMetricsEnabled;
    }

    public boolean isGroupingEnabled() {
        return this.groupingType != GroupingType.NONE && this.isTopNFeatureEnabled();
    }

    public void enableSearchQueryMetricsFeature(boolean enable) {
        this.searchQueryMetricsEnabled = enable;
    }

    public void validateWindowSize(MetricType type, TimeValue windowSize) {
        if (this.topQueriesServices.containsKey(type)) {
            this.topQueriesServices.get(type).validateWindowSize(windowSize);
        }
    }

    public void setWindowSize(MetricType type, TimeValue windowSize) {
        if (this.topQueriesServices.containsKey(type)) {
            this.topQueriesServices.get(type).setWindowSize(windowSize);
        }
    }

    public void validateTopNSize(MetricType type, int topNSize) {
        if (this.topQueriesServices.containsKey(type)) {
            this.topQueriesServices.get(type).validateTopNSize(topNSize);
        }
    }

    public void setTopNSize(MetricType type, int topNSize) {
        if (this.topQueriesServices.containsKey(type)) {
            this.topQueriesServices.get(type).setTopNSize(topNSize);
        }
    }

    public void setExporterAndReaderType(SinkType sinkType) {
        QueryInsightsExporter currentExporter = this.queryInsightsExporterFactory.getExporter("top_queries_exporter");
        QueryInsightsReader currentReader = this.queryInsightsReaderFactory.getReader("top_queries_reader");
        if (this.sinkType == SinkType.LOCAL_INDEX && currentExporter != null) {
            this.deleteAllTopNIndices(this.client, (LocalIndexExporter)currentExporter);
        }
        if (currentExporter != null) {
            try {
                this.queryInsightsExporterFactory.closeExporter(currentExporter);
            }
            catch (IOException e) {
                OperationalMetricsCounter.getInstance().incrementCounter(OperationalMetric.EXPORTER_FAIL_TO_CLOSE_EXCEPTION);
                logger.error("Fail to close the current exporter when updating exporter and reader, error: ", (Throwable)e);
            }
        }
        if (currentReader != null) {
            try {
                this.queryInsightsReaderFactory.closeReader(currentReader);
            }
            catch (IOException e) {
                OperationalMetricsCounter.getInstance().incrementCounter(OperationalMetric.READER_FAIL_TO_CLOSE_EXCEPTION);
                logger.error("Fail to close the current reader when updating exporter and reader, error: ", (Throwable)e);
            }
        }
        if (sinkType == SinkType.LOCAL_INDEX) {
            this.queryInsightsExporterFactory.createLocalIndexExporter("top_queries_exporter", "'top_queries-'yyyy.MM.dd", "mappings/top-queries-record.json");
            this.queryInsightsReaderFactory.createLocalIndexReader("top_queries_reader", "'top_queries-'yyyy.MM.dd", this.namedXContentRegistry);
        } else if (sinkType == SinkType.DEBUG) {
            this.queryInsightsExporterFactory.createDebugExporter("top_queries_exporter");
        }
        this.sinkType = sinkType;
    }

    public void setExporterDeleteAfterAndDelete(int deleteAfter) {
        QueryInsightsExporter topQueriesExporter = this.queryInsightsExporterFactory.getExporter("top_queries_exporter");
        if (topQueriesExporter != null && topQueriesExporter.getClass() == LocalIndexExporter.class) {
            ((LocalIndexExporter)topQueriesExporter).setDeleteAfter(deleteAfter);
            this.deleteExpiredTopNIndices();
        }
    }

    void validateExporterDeleteAfter(int deleteAfter) {
        if (deleteAfter < 1 || deleteAfter > 180) {
            OperationalMetricsCounter.getInstance().incrementCounter(OperationalMetric.INVALID_EXPORTER_TYPE_FAILURES);
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Invalid exporter delete_after_days setting [%d], value should be an integer between %d and %d.", deleteAfter, 1, 180));
        }
    }

    public SearchQueryCategorizer getSearchQueryCategorizer() {
        return this.searchQueryCategorizer;
    }

    public void validateExporterType(String exporterType) {
        this.queryInsightsExporterFactory.validateExporterType(exporterType);
    }

    public void setTemplatePriority(long templatePriority) {
        logger.info("Setting query insights index template priority to [{}]", (Object)templatePriority);
        QueryInsightsExporter topQueriesExporter = this.queryInsightsExporterFactory.getExporter("top_queries_exporter");
        if (topQueriesExporter != null && topQueriesExporter.getClass() == LocalIndexExporter.class) {
            logger.debug("Updating query insights index template priority for top queries exporter to [{}]", (Object)templatePriority);
            this.queryInsightsExporterFactory.updateExporter(topQueriesExporter, "'top_queries-'yyyy.MM.dd", templatePriority);
        }
    }

    public void validateTemplatePriority(long templatePriority) {
        if (templatePriority < 0L) {
            OperationalMetricsCounter.getInstance().incrementCounter(OperationalMetric.INVALID_EXPORTER_TYPE_FAILURES);
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Invalid template priority setting [%d], value should be a non-negative long.", templatePriority));
        }
    }

    static long getInitialDelay(Instant now) {
        Instant startOfNextDay = now.truncatedTo(ChronoUnit.DAYS).plus(1L, ChronoUnit.DAYS);
        return Duration.between(now, startOfNextDay).toMillis();
    }

    protected void doStart() {
        if (this.isAnyFeatureEnabled()) {
            this.scheduledFutures = new ArrayList<Scheduler.Cancellable>();
            this.scheduledFutures.add(this.threadPool.scheduleWithFixedDelay(this::drainRecords, QueryInsightsSettings.QUERY_RECORD_QUEUE_DRAIN_INTERVAL, "query_insights_executor"));
            if (this.threadPool.scheduler() != null) {
                this.deleteIndicesScheduledFuture = this.threadPool.scheduler().scheduleWithFixedDelay(() -> {
                    try {
                        if (this.clusterService.isStateInitialised() && this.clusterService.state().getNodes() != null && this.clusterService.state().getNodes().isLocalNodeElectedClusterManager()) {
                            this.deleteExpiredTopNIndices();
                        }
                    }
                    catch (Exception e) {
                        logger.error("Error occurred while deleting expired indices:", (Throwable)e);
                    }
                }, QueryInsightsService.getInitialDelay(Instant.now()) + Duration.ofMinutes(5L).toMillis(), Duration.ofDays(1L).toMillis(), TimeUnit.MILLISECONDS);
            } else {
                logger.error("Unable to schedule Query Insights delete job. threadPool.scheduler() is null");
            }
        }
    }

    protected void doStop() {
        if (this.scheduledFutures != null) {
            for (Scheduler.Cancellable cancellable : this.scheduledFutures) {
                if (cancellable == null) continue;
                cancellable.cancel();
            }
        }
        FutureUtils.cancel((Future)this.deleteIndicesScheduledFuture);
    }

    protected void doClose() throws IOException {
        for (TopQueriesService topQueriesService : this.topQueriesServices.values()) {
            topQueriesService.close();
        }
        this.queryInsightsExporterFactory.closeAllExporters();
        this.queryInsightsReaderFactory.closeAllReaders();
    }

    public QueryInsightsHealthStats getHealthStats() {
        Map<MetricType, TopQueriesHealthStats> topQueriesHealthStatsMap = this.topQueriesServices.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((TopQueriesService)entry.getValue()).getHealthStats()));
        Map<String, Long> fieldTypeCacheStats = Optional.ofNullable(this.queryShapeGenerator).map(QueryShapeGenerator::getFieldTypeCacheStats).orElse(Collections.emptyMap());
        return new QueryInsightsHealthStats(this.threadPool.info("query_insights_executor"), this.queryRecordsQueue.size(), topQueriesHealthStatsMap, fieldTypeCacheStats);
    }

    void deleteExpiredTopNIndices() {
        QueryInsightsExporter topQueriesExporter = this.queryInsightsExporterFactory.getExporter("top_queries_exporter");
        if (topQueriesExporter != null && topQueriesExporter.getClass() == LocalIndexExporter.class) {
            LocalIndexExporter localIndexExporter = (LocalIndexExporter)topQueriesExporter;
            this.threadPool.executor("query_insights_executor").execute(() -> {
                ClusterStateRequest clusterStateRequest = IndexDiscoveryHelper.createClusterStateRequest(IndicesOptions.strictExpand());
                this.client.admin().cluster().state(clusterStateRequest, ActionListener.wrap(clusterStateResponse -> {
                    Map indexMetadataMap = clusterStateResponse.getState().metadata().indices();
                    long startOfTodayUtcMillis = LocalDateTime.now(ZoneOffset.UTC).truncatedTo(ChronoUnit.DAYS).toInstant(ZoneOffset.UTC).toEpochMilli();
                    long expirationMillisLong = startOfTodayUtcMillis - TimeUnit.DAYS.toMillis(((LocalIndexExporter)topQueriesExporter).getDeleteAfter());
                    for (Map.Entry entry : indexMetadataMap.entrySet()) {
                        String indexName = (String)entry.getKey();
                        if (!TopQueriesService.isTopQueriesIndex(indexName, (IndexMetadata)entry.getValue()) || ((IndexMetadata)entry.getValue()).getCreationDate() >= expirationMillisLong) continue;
                        localIndexExporter.deleteSingleIndex(indexName, this.client);
                    }
                }, exception -> logger.error("Error while deleting expired top_queries-* indices: ", (Throwable)exception)));
            });
        }
    }

    void deleteAllTopNIndices(Client client, LocalIndexExporter localIndexExporter) {
        ClusterStateRequest clusterStateRequest = IndexDiscoveryHelper.createClusterStateRequest(IndicesOptions.strictExpand());
        client.admin().cluster().state(clusterStateRequest, ActionListener.wrap(clusterStateResponse -> clusterStateResponse.getState().metadata().indices().entrySet().stream().filter(entry -> TopQueriesService.isTopQueriesIndex((String)entry.getKey(), (IndexMetadata)entry.getValue())).forEach(entry -> localIndexExporter.deleteSingleIndex((String)entry.getKey(), client)), exception -> logger.error("Error while deleting expired top_queries-* indices: ", (Throwable)exception)));
    }

    public void setQueryShapeGenerator(QueryShapeGenerator queryShapeGenerator) {
        this.queryShapeGenerator = queryShapeGenerator;
    }
}

