/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.threatIntel.sacommons.monitor;

import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opensearch.commons.alerting.model.Alert;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.securityanalytics.model.threatintel.BaseEntity;
import org.opensearch.securityanalytics.model.threatintel.ThreatIntelAlert;
import org.opensearch.securityanalytics.util.XContentUtils;

public class ThreatIntelAlertDto
extends BaseEntity {
    public static final String ALERT_ID_FIELD = "id";
    public static final String SCHEMA_VERSION_FIELD = "schema_version";
    public static final String SEQ_NO_FIELD = "seq_no";
    public static final String PRIMARY_TERM_FIELD = "primary_term";
    public static final String ALERT_VERSION_FIELD = "version";
    public static final String USER_FIELD = "user";
    public static final String TRIGGER_NAME_FIELD = "trigger_id";
    public static final String TRIGGER_ID_FIELD = "trigger_name";
    public static final String STATE_FIELD = "state";
    public static final String START_TIME_FIELD = "start_time";
    public static final String END_TIME_FIELD = "end_time";
    public static final String LAST_UPDATED_TIME_FIELD = "last_updated_time";
    public static final String ACKNOWLEDGED_TIME_FIELD = "acknowledged_time";
    public static final String ERROR_MESSAGE_FIELD = "error_message";
    public static final String SEVERITY_FIELD = "severity";
    public static final String ACTION_EXECUTION_RESULTS_FIELD = "action_execution_results";
    public static final String IOC_VALUE_FIELD = "ioc_value";
    public static final String IOC_TYPE_FIELD = "ioc_type";
    public static final String FINDING_IDS_FIELD = "finding_ids";
    public static final String NO_ID = "";
    public static final long NO_VERSION = 1L;
    public static final long NO_SCHEMA_VERSION = 0L;
    private final String id;
    private final long version;
    private final long schemaVersion;
    private final long seqNo;
    private final long primaryTerm;
    private final User user;
    private final String triggerName;
    private final String triggerId;
    private final Alert.State state;
    private final Instant startTime;
    private final Instant endTime;
    private final Instant acknowledgedTime;
    private final Instant lastUpdatedTime;
    private final String errorMessage;
    private final String severity;
    private final String iocValue;
    private final String iocType;
    private List<String> findingIds;

    public ThreatIntelAlertDto(String id, long version, long schemaVersion, long seqNo, long primaryTerm, User user, String triggerId, String triggerName, Alert.State state, Instant startTime, Instant endTime, Instant lastUpdatedTime, Instant acknowledgedTime, String errorMessage, String severity, String iocValue, String iocType, List<String> findingIds) {
        this.id = id != null ? id : NO_ID;
        this.version = version != 0L ? version : 1L;
        this.schemaVersion = schemaVersion;
        this.seqNo = seqNo;
        this.primaryTerm = primaryTerm;
        this.user = user;
        this.triggerId = triggerId;
        this.triggerName = triggerName;
        this.state = state;
        this.startTime = startTime;
        this.endTime = endTime;
        this.acknowledgedTime = acknowledgedTime;
        this.errorMessage = errorMessage;
        this.severity = severity;
        this.iocValue = iocValue;
        this.iocType = iocType;
        this.lastUpdatedTime = lastUpdatedTime;
        this.findingIds = findingIds;
    }

    public ThreatIntelAlertDto(StreamInput sin) throws IOException {
        this.id = sin.readString();
        this.version = sin.readLong();
        this.schemaVersion = sin.readLong();
        this.seqNo = sin.readLong();
        this.primaryTerm = sin.readLong();
        this.user = sin.readBoolean() ? new User(sin) : null;
        this.triggerId = sin.readString();
        this.triggerName = sin.readString();
        this.state = (Alert.State)sin.readEnum(Alert.State.class);
        this.startTime = sin.readInstant();
        this.endTime = sin.readOptionalInstant();
        this.acknowledgedTime = sin.readOptionalInstant();
        this.errorMessage = sin.readOptionalString();
        this.severity = sin.readString();
        this.lastUpdatedTime = sin.readOptionalInstant();
        this.iocType = sin.readString();
        this.iocValue = sin.readString();
        this.findingIds = sin.readStringList();
    }

    public ThreatIntelAlertDto(ThreatIntelAlert alert, long seqNo, long primaryTerm) {
        this.id = alert.getId();
        this.version = alert.getVersion();
        this.schemaVersion = alert.getSchemaVersion();
        this.user = alert.getUser();
        this.triggerId = alert.getTriggerId();
        this.triggerName = alert.getTriggerName();
        this.state = alert.getState();
        this.startTime = alert.getStartTime();
        this.endTime = alert.getEndTime();
        this.acknowledgedTime = alert.getAcknowledgedTime();
        this.errorMessage = alert.getErrorMessage();
        this.severity = alert.getSeverity();
        this.iocValue = alert.getIocValue();
        this.iocType = alert.getIocType();
        this.lastUpdatedTime = alert.getLastUpdatedTime();
        this.findingIds = alert.getFindingIds();
        this.seqNo = seqNo;
        this.primaryTerm = primaryTerm;
    }

    public boolean isAcknowledged() {
        return this.state == Alert.State.ACKNOWLEDGED;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.id);
        out.writeLong(this.version);
        out.writeLong(this.schemaVersion);
        out.writeLong(this.seqNo);
        out.writeLong(this.primaryTerm);
        out.writeBoolean(this.user != null);
        if (this.user != null) {
            this.user.writeTo(out);
        }
        out.writeString(this.triggerId);
        out.writeString(this.triggerName);
        out.writeEnum((Enum)this.state);
        out.writeInstant(this.startTime);
        out.writeOptionalInstant(this.endTime);
        out.writeOptionalInstant(this.acknowledgedTime);
        out.writeOptionalString(this.errorMessage);
        out.writeString(this.severity);
        out.writeOptionalInstant(this.lastUpdatedTime);
        out.writeString(this.iocType);
        out.writeString(this.iocValue);
        out.writeStringCollection(this.findingIds);
    }

    public static ThreatIntelAlertDto parse(XContentParser xcp, long version) throws IOException {
        String id = NO_ID;
        long schemaVersion = 0L;
        long seqNo = -2L;
        long primaryTerm = 0L;
        User user = null;
        String triggerId = null;
        String triggerName = null;
        Alert.State state = null;
        Instant startTime = null;
        String severity = null;
        Instant endTime = null;
        Instant acknowledgedTime = null;
        Instant lastUpdatedTime = null;
        String errorMessage = null;
        String iocValue = null;
        String iocType = null;
        ArrayList<String> findingIds = new ArrayList<String>();
        block40: while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = xcp.currentName();
            xcp.nextToken();
            switch (fieldName) {
                case "user": {
                    user = xcp.currentToken() == XContentParser.Token.VALUE_NULL ? null : User.parse((XContentParser)xcp);
                    continue block40;
                }
                case "id": {
                    id = xcp.text();
                    continue block40;
                }
                case "ioc_value": {
                    iocValue = xcp.textOrNull();
                    continue block40;
                }
                case "ioc_type": {
                    iocType = xcp.textOrNull();
                    continue block40;
                }
                case "version": {
                    version = xcp.longValue();
                    continue block40;
                }
                case "schema_version": {
                    schemaVersion = xcp.intValue();
                    continue block40;
                }
                case "seq_no": {
                    seqNo = xcp.longValue();
                    continue block40;
                }
                case "primary_term": {
                    primaryTerm = xcp.longValue();
                    continue block40;
                }
                case "trigger_name": {
                    triggerId = xcp.text();
                    continue block40;
                }
                case "trigger_id": {
                    triggerName = xcp.text();
                    continue block40;
                }
                case "state": {
                    state = Alert.State.valueOf((String)xcp.text());
                    continue block40;
                }
                case "error_message": {
                    errorMessage = xcp.textOrNull();
                    continue block40;
                }
                case "severity": {
                    severity = xcp.text();
                    continue block40;
                }
                case "start_time": {
                    startTime = XContentUtils.getInstant(xcp);
                    continue block40;
                }
                case "end_time": {
                    endTime = XContentUtils.getInstant(xcp);
                    continue block40;
                }
                case "acknowledged_time": {
                    acknowledgedTime = XContentUtils.getInstant(xcp);
                    continue block40;
                }
                case "last_updated_time": {
                    lastUpdatedTime = XContentUtils.getInstant(xcp);
                    continue block40;
                }
                case "finding_ids": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
                    while (xcp.nextToken() != XContentParser.Token.END_ARRAY) {
                        findingIds.add(xcp.text());
                    }
                    break;
                }
            }
            xcp.skipChildren();
        }
        return new ThreatIntelAlertDto(id, version, schemaVersion, seqNo, primaryTerm, user, triggerId, triggerName, state, startTime, endTime, acknowledgedTime, lastUpdatedTime, errorMessage, severity, iocValue, iocType, findingIds);
    }

    public static Alert readFrom(StreamInput sin) throws IOException {
        return new Alert(sin);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return this.createXContentBuilder(builder, true);
    }

    @Override
    public String getId() {
        return this.id;
    }

    public XContentBuilder toXContentWithUser(XContentBuilder builder) throws IOException {
        return this.createXContentBuilder(builder, false);
    }

    private XContentBuilder createXContentBuilder(XContentBuilder builder, boolean secure) throws IOException {
        builder.startObject().field(ALERT_ID_FIELD, this.id).field(ALERT_VERSION_FIELD, this.version).field(SCHEMA_VERSION_FIELD, this.schemaVersion).field(SEQ_NO_FIELD, this.seqNo).field(PRIMARY_TERM_FIELD, this.primaryTerm).field(TRIGGER_NAME_FIELD, this.triggerName).field(TRIGGER_ID_FIELD, this.triggerName).field(STATE_FIELD, (Object)this.state).field(ERROR_MESSAGE_FIELD, this.errorMessage).field(IOC_VALUE_FIELD, this.iocValue).field(IOC_TYPE_FIELD, this.iocType).field(SEVERITY_FIELD, this.severity).field(FINDING_IDS_FIELD, (Object)this.findingIds.toArray(new String[0]));
        XContentUtils.buildInstantAsField(builder, this.acknowledgedTime, ACKNOWLEDGED_TIME_FIELD);
        XContentUtils.buildInstantAsField(builder, this.lastUpdatedTime, LAST_UPDATED_TIME_FIELD);
        XContentUtils.buildInstantAsField(builder, this.startTime, START_TIME_FIELD);
        XContentUtils.buildInstantAsField(builder, this.endTime, END_TIME_FIELD);
        if (!secure) {
            if (this.user == null) {
                builder.nullField(USER_FIELD);
            } else {
                builder.field(USER_FIELD, (ToXContent)this.user);
            }
        }
        return builder.endObject();
    }

    public Map<String, Object> asTemplateArg() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(ACKNOWLEDGED_TIME_FIELD, this.acknowledgedTime != null ? Long.valueOf(this.acknowledgedTime.toEpochMilli()) : null);
        map.put(ALERT_ID_FIELD, this.id);
        map.put(ALERT_VERSION_FIELD, this.version);
        map.put(END_TIME_FIELD, this.endTime != null ? Long.valueOf(this.endTime.toEpochMilli()) : null);
        map.put(ERROR_MESSAGE_FIELD, this.errorMessage);
        map.put(SEVERITY_FIELD, this.severity);
        map.put(START_TIME_FIELD, this.startTime.toEpochMilli());
        map.put(STATE_FIELD, this.state.toString());
        map.put(TRIGGER_ID_FIELD, this.triggerId);
        map.put(TRIGGER_NAME_FIELD, this.triggerName);
        map.put(FINDING_IDS_FIELD, this.findingIds);
        map.put(LAST_UPDATED_TIME_FIELD, this.lastUpdatedTime);
        map.put(IOC_TYPE_FIELD, this.iocType);
        map.put(IOC_VALUE_FIELD, this.iocValue);
        return map;
    }

    public long getVersion() {
        return this.version;
    }

    public long getSchemaVersion() {
        return this.schemaVersion;
    }

    public User getUser() {
        return this.user;
    }

    public String getTriggerName() {
        return this.triggerName;
    }

    public Alert.State getState() {
        return this.state;
    }

    public Instant getStartTime() {
        return this.startTime;
    }

    public Instant getEndTime() {
        return this.endTime;
    }

    public Instant getAcknowledgedTime() {
        return this.acknowledgedTime;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getSeverity() {
        return this.severity;
    }

    public String getTriggerId() {
        return this.triggerId;
    }

    public Instant getLastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public String getIocValue() {
        return this.iocValue;
    }

    public String getIocType() {
        return this.iocType;
    }

    public List<String> getFindingIds() {
        return this.findingIds;
    }

    public long getSeqNo() {
        return this.seqNo;
    }

    public long getPrimaryTerm() {
        return this.primaryTerm;
    }
}

