/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.rules.backend;

import java.util.Locale;
import org.apache.commons.lang3.NotImplementedException;
import org.opensearch.search.aggregations.AggregationBuilder;
import org.opensearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.opensearch.search.aggregations.metrics.AvgAggregationBuilder;
import org.opensearch.search.aggregations.metrics.MaxAggregationBuilder;
import org.opensearch.search.aggregations.metrics.MedianAbsoluteDeviationAggregationBuilder;
import org.opensearch.search.aggregations.metrics.MinAggregationBuilder;
import org.opensearch.search.aggregations.metrics.SumAggregationBuilder;
import org.opensearch.search.aggregations.metrics.ValueCountAggregationBuilder;

public final class AggregationBuilders {
    public static AggregationBuilder getAggregationBuilderByFunction(String aggregationFunction, String name) {
        return switch (aggregationFunction.toLowerCase(Locale.ROOT)) {
            case "avg" -> new AvgAggregationBuilder(name).field(name);
            case "max" -> new MaxAggregationBuilder(name).field(name);
            case "median_absolute_deviation" -> new MedianAbsoluteDeviationAggregationBuilder(name).field(name);
            case "min" -> new MinAggregationBuilder(name).field(name);
            case "sum" -> new SumAggregationBuilder(name).field(name);
            case "terms" -> new TermsAggregationBuilder(name).field(name);
            case "count" -> new ValueCountAggregationBuilder(name.replace(".", "_")).field(name);
            default -> throw new NotImplementedException(String.format(Locale.getDefault(), "Aggregation %s not supported by the backend", aggregationFunction));
        };
    }
}

