/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.spark.execution.statement;

import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.sql.spark.asyncquery.model.AsyncQueryRequestContext;
import org.opensearch.sql.spark.execution.statement.StatementId;
import org.opensearch.sql.spark.execution.statement.StatementModel;
import org.opensearch.sql.spark.execution.statement.StatementState;
import org.opensearch.sql.spark.execution.statestore.StatementStorageService;
import org.opensearch.sql.spark.rest.model.LangType;

public class Statement {
    private static final Logger LOG = LogManager.getLogger();
    private final String sessionId;
    private final String accountId;
    private final String applicationId;
    private final String jobId;
    private final StatementId statementId;
    private final LangType langType;
    private final String datasourceName;
    private final String query;
    private final String queryId;
    private final AsyncQueryRequestContext asyncQueryRequestContext;
    private final StatementStorageService statementStorageService;
    private StatementModel statementModel;

    public void open() {
        this.statementModel = StatementModel.submitStatement(this.sessionId, this.accountId, this.applicationId, this.jobId, this.statementId, this.langType, this.datasourceName, this.query, this.queryId);
        this.statementModel = this.statementStorageService.createStatement(this.statementModel, this.asyncQueryRequestContext);
    }

    public void cancel() {
        StatementState statementState = this.statementModel.getStatementState();
        if (statementState.equals((Object)StatementState.SUCCESS) || statementState.equals((Object)StatementState.FAILED) || statementState.equals((Object)StatementState.TIMEOUT) || statementState.equals((Object)StatementState.CANCELLED)) {
            String errorMsg = String.format("can't cancel statement in %s state. statement: %s.", statementState.getState(), this.statementId);
            LOG.error(errorMsg);
            throw new IllegalStateException(errorMsg);
        }
        this.statementModel = this.statementStorageService.updateStatementState(this.statementModel, StatementState.CANCELLED, this.asyncQueryRequestContext);
    }

    public StatementState getStatementState() {
        return this.statementModel.getStatementState();
    }

    @Generated
    Statement(String sessionId, String accountId, String applicationId, String jobId, StatementId statementId, LangType langType, String datasourceName, String query, String queryId, AsyncQueryRequestContext asyncQueryRequestContext, StatementStorageService statementStorageService, StatementModel statementModel) {
        this.sessionId = sessionId;
        this.accountId = accountId;
        this.applicationId = applicationId;
        this.jobId = jobId;
        this.statementId = statementId;
        this.langType = langType;
        this.datasourceName = datasourceName;
        this.query = query;
        this.queryId = queryId;
        this.asyncQueryRequestContext = asyncQueryRequestContext;
        this.statementStorageService = statementStorageService;
        this.statementModel = statementModel;
    }

    @Generated
    public static StatementBuilder builder() {
        return new StatementBuilder();
    }

    @Generated
    public String getSessionId() {
        return this.sessionId;
    }

    @Generated
    public String getAccountId() {
        return this.accountId;
    }

    @Generated
    public String getApplicationId() {
        return this.applicationId;
    }

    @Generated
    public String getJobId() {
        return this.jobId;
    }

    @Generated
    public StatementId getStatementId() {
        return this.statementId;
    }

    @Generated
    public LangType getLangType() {
        return this.langType;
    }

    @Generated
    public String getDatasourceName() {
        return this.datasourceName;
    }

    @Generated
    public String getQuery() {
        return this.query;
    }

    @Generated
    public String getQueryId() {
        return this.queryId;
    }

    @Generated
    public AsyncQueryRequestContext getAsyncQueryRequestContext() {
        return this.asyncQueryRequestContext;
    }

    @Generated
    public StatementStorageService getStatementStorageService() {
        return this.statementStorageService;
    }

    @Generated
    public StatementModel getStatementModel() {
        return this.statementModel;
    }

    @Generated
    public void setStatementModel(StatementModel statementModel) {
        this.statementModel = statementModel;
    }

    @Generated
    public static class StatementBuilder {
        @Generated
        private String sessionId;
        @Generated
        private String accountId;
        @Generated
        private String applicationId;
        @Generated
        private String jobId;
        @Generated
        private StatementId statementId;
        @Generated
        private LangType langType;
        @Generated
        private String datasourceName;
        @Generated
        private String query;
        @Generated
        private String queryId;
        @Generated
        private AsyncQueryRequestContext asyncQueryRequestContext;
        @Generated
        private StatementStorageService statementStorageService;
        @Generated
        private StatementModel statementModel;

        @Generated
        StatementBuilder() {
        }

        @Generated
        public StatementBuilder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        @Generated
        public StatementBuilder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        @Generated
        public StatementBuilder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        @Generated
        public StatementBuilder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        @Generated
        public StatementBuilder statementId(StatementId statementId) {
            this.statementId = statementId;
            return this;
        }

        @Generated
        public StatementBuilder langType(LangType langType) {
            this.langType = langType;
            return this;
        }

        @Generated
        public StatementBuilder datasourceName(String datasourceName) {
            this.datasourceName = datasourceName;
            return this;
        }

        @Generated
        public StatementBuilder query(String query) {
            this.query = query;
            return this;
        }

        @Generated
        public StatementBuilder queryId(String queryId) {
            this.queryId = queryId;
            return this;
        }

        @Generated
        public StatementBuilder asyncQueryRequestContext(AsyncQueryRequestContext asyncQueryRequestContext) {
            this.asyncQueryRequestContext = asyncQueryRequestContext;
            return this;
        }

        @Generated
        public StatementBuilder statementStorageService(StatementStorageService statementStorageService) {
            this.statementStorageService = statementStorageService;
            return this;
        }

        @Generated
        public StatementBuilder statementModel(StatementModel statementModel) {
            this.statementModel = statementModel;
            return this;
        }

        @Generated
        public Statement build() {
            return new Statement(this.sessionId, this.accountId, this.applicationId, this.jobId, this.statementId, this.langType, this.datasourceName, this.query, this.queryId, this.asyncQueryRequestContext, this.statementStorageService, this.statementModel);
        }

        @Generated
        public String toString() {
            return "Statement.StatementBuilder(sessionId=" + this.sessionId + ", accountId=" + this.accountId + ", applicationId=" + this.applicationId + ", jobId=" + this.jobId + ", statementId=" + String.valueOf(this.statementId) + ", langType=" + String.valueOf((Object)this.langType) + ", datasourceName=" + this.datasourceName + ", query=" + this.query + ", queryId=" + this.queryId + ", asyncQueryRequestContext=" + String.valueOf(this.asyncQueryRequestContext) + ", statementStorageService=" + String.valueOf(this.statementStorageService) + ", statementModel=" + String.valueOf(this.statementModel) + ")";
        }
    }
}

