/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.spark.dispatcher;

import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.json.JSONObject;
import org.opensearch.sql.datasource.model.DataSourceMetadata;
import org.opensearch.sql.spark.asyncquery.model.AsyncQueryJobMetadata;
import org.opensearch.sql.spark.asyncquery.model.AsyncQueryRequestContext;
import org.opensearch.sql.spark.asyncquery.model.QueryState;
import org.opensearch.sql.spark.dispatcher.AsyncQueryHandler;
import org.opensearch.sql.spark.dispatcher.model.DispatchQueryContext;
import org.opensearch.sql.spark.dispatcher.model.DispatchQueryRequest;
import org.opensearch.sql.spark.dispatcher.model.DispatchQueryResponse;
import org.opensearch.sql.spark.dispatcher.model.JobType;
import org.opensearch.sql.spark.execution.session.CreateSessionRequest;
import org.opensearch.sql.spark.execution.session.Session;
import org.opensearch.sql.spark.execution.session.SessionManager;
import org.opensearch.sql.spark.execution.statement.QueryRequest;
import org.opensearch.sql.spark.execution.statement.Statement;
import org.opensearch.sql.spark.execution.statement.StatementId;
import org.opensearch.sql.spark.execution.statement.StatementState;
import org.opensearch.sql.spark.leasemanager.LeaseManager;
import org.opensearch.sql.spark.leasemanager.model.LeaseRequest;
import org.opensearch.sql.spark.metrics.EmrMetrics;
import org.opensearch.sql.spark.metrics.MetricsService;
import org.opensearch.sql.spark.parameter.SparkSubmitParametersBuilderProvider;
import org.opensearch.sql.spark.response.JobExecutionResponseReader;

public class InteractiveQueryHandler
extends AsyncQueryHandler {
    private final SessionManager sessionManager;
    private final JobExecutionResponseReader jobExecutionResponseReader;
    private final LeaseManager leaseManager;
    private final MetricsService metricsService;
    protected final SparkSubmitParametersBuilderProvider sparkSubmitParametersBuilderProvider;

    @Override
    protected JSONObject getResponseFromResultIndex(AsyncQueryJobMetadata asyncQueryJobMetadata, AsyncQueryRequestContext asyncQueryRequestContext) {
        String queryId = asyncQueryJobMetadata.getQueryId();
        return this.jobExecutionResponseReader.getResultWithQueryId(queryId, asyncQueryJobMetadata.getResultIndex(), asyncQueryRequestContext);
    }

    @Override
    protected JSONObject getResponseFromExecutor(AsyncQueryJobMetadata asyncQueryJobMetadata, AsyncQueryRequestContext asyncQueryRequestContext) {
        JSONObject result = new JSONObject();
        String queryId = asyncQueryJobMetadata.getQueryId();
        Statement statement = this.getStatementByQueryId(asyncQueryJobMetadata.getSessionId(), queryId, asyncQueryJobMetadata.getDatasourceName(), asyncQueryRequestContext);
        StatementState statementState = statement.getStatementState();
        result.put("status", (Object)statementState.getState());
        result.put("error", (Object)Optional.of(statement.getStatementModel().getError()).orElse(""));
        return result;
    }

    @Override
    public String cancelJob(AsyncQueryJobMetadata asyncQueryJobMetadata, AsyncQueryRequestContext asyncQueryRequestContext) {
        String queryId = asyncQueryJobMetadata.getQueryId();
        this.getStatementByQueryId(asyncQueryJobMetadata.getSessionId(), queryId, asyncQueryJobMetadata.getDatasourceName(), asyncQueryRequestContext).cancel();
        return queryId;
    }

    @Override
    public DispatchQueryResponse submit(DispatchQueryRequest dispatchQueryRequest, DispatchQueryContext context) {
        Optional<Session> existingSession;
        Session session = null;
        String clusterName = dispatchQueryRequest.getClusterName();
        Map<String, String> tags = context.getTags();
        DataSourceMetadata dataSourceMetadata = context.getDataSourceMetadata();
        this.leaseManager.borrow(new LeaseRequest(JobType.INTERACTIVE, dispatchQueryRequest.getDatasource()));
        if (dispatchQueryRequest.getSessionId() != null && (existingSession = this.sessionManager.getSession(dispatchQueryRequest.getSessionId(), dispatchQueryRequest.getDatasource())).isPresent()) {
            session = existingSession.get();
        }
        if (session == null || !session.isOperationalForDataSource(dispatchQueryRequest.getDatasource())) {
            tags.put("type", JobType.INTERACTIVE.getText());
            session = this.sessionManager.createSession(new CreateSessionRequest(clusterName, dispatchQueryRequest.getAccountId(), dispatchQueryRequest.getApplicationId(), dispatchQueryRequest.getExecutionRoleARN(), this.sparkSubmitParametersBuilderProvider.getSparkSubmitParametersBuilder().className("org.apache.spark.sql.FlintREPL").clusterName(clusterName).dataSource(dataSourceMetadata, dispatchQueryRequest, context.getAsyncQueryRequestContext()).acceptModifier(dispatchQueryRequest.getSparkSubmitParameterModifier()).acceptComposers(dispatchQueryRequest, context.getAsyncQueryRequestContext()), tags, dataSourceMetadata.getResultIndex(), dataSourceMetadata.getName()), context.getAsyncQueryRequestContext());
            this.metricsService.incrementNumericalMetric(EmrMetrics.EMR_INTERACTIVE_QUERY_JOBS_CREATION_COUNT);
        }
        session.submit(new QueryRequest(context.getQueryId(), dispatchQueryRequest.getLangType(), dispatchQueryRequest.getQuery()), context.getAsyncQueryRequestContext());
        return DispatchQueryResponse.builder().queryId(context.getQueryId()).jobId(session.getSessionModel().getJobId()).resultIndex(dataSourceMetadata.getResultIndex()).sessionId(session.getSessionId()).datasourceName(dataSourceMetadata.getName()).jobType(JobType.INTERACTIVE).status(QueryState.WAITING).build();
    }

    private Statement getStatementByQueryId(String sessionId, String queryId, String datasourceName, AsyncQueryRequestContext asyncQueryRequestContext) {
        Optional<Session> session = this.sessionManager.getSession(sessionId, datasourceName);
        if (session.isPresent()) {
            StatementId statementId = new StatementId(queryId);
            Optional<Statement> statement = session.get().get(statementId, asyncQueryRequestContext);
            if (statement.isPresent()) {
                return statement.get();
            }
            throw new IllegalArgumentException("no statement found. " + String.valueOf(statementId));
        }
        throw new IllegalArgumentException("no session found. " + sessionId);
    }

    @Generated
    public InteractiveQueryHandler(SessionManager sessionManager, JobExecutionResponseReader jobExecutionResponseReader, LeaseManager leaseManager, MetricsService metricsService, SparkSubmitParametersBuilderProvider sparkSubmitParametersBuilderProvider) {
        this.sessionManager = sessionManager;
        this.jobExecutionResponseReader = jobExecutionResponseReader;
        this.leaseManager = leaseManager;
        this.metricsService = metricsService;
        this.sparkSubmitParametersBuilderProvider = sparkSubmitParametersBuilderProvider;
    }
}

