/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.spark.asyncquery.model;

import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;

public enum QueryState {
    WAITING("waiting"),
    RUNNING("running"),
    SUCCESS("success"),
    FAILED("failed"),
    TIMEOUT("timeout"),
    CANCELLED("cancelled");

    private final String state;
    private static final Map<String, QueryState> STATES;

    private QueryState(String state) {
        this.state = state;
    }

    public static QueryState fromString(String key) {
        for (QueryState ss : QueryState.values()) {
            if (!ss.getState().toLowerCase(Locale.ROOT).equals(key)) continue;
            return ss;
        }
        throw new IllegalArgumentException("Invalid query state: " + key);
    }

    @Generated
    public String getState() {
        return this.state;
    }

    static {
        STATES = Arrays.stream(QueryState.values()).collect(Collectors.toMap(t -> t.name().toLowerCase(), t -> t));
    }
}

