/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.ppl.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.antlr.v4.runtime.ParserRuleContext;
import org.opensearch.sql.ast.expression.Argument;
import org.opensearch.sql.ast.expression.DataType;
import org.opensearch.sql.ast.expression.Literal;
import org.opensearch.sql.ast.tree.Join;
import org.opensearch.sql.common.setting.Settings;
import org.opensearch.sql.common.utils.StringUtils;
import org.opensearch.sql.exception.SemanticCheckException;
import org.opensearch.sql.ppl.antlr.parser.OpenSearchPPLParser;

public class ArgumentFactory {
    public static List<Argument> getArgumentList(OpenSearchPPLParser.FieldsCommandContext ctx) {
        return Collections.singletonList(ctx.fieldsCommandBody().MINUS() != null ? new Argument("exclude", new Literal(true, DataType.BOOLEAN)) : new Argument("exclude", new Literal(false, DataType.BOOLEAN)));
    }

    public static List<Argument> getArgumentList(OpenSearchPPLParser.StatsCommandContext ctx, Settings settings) {
        OpenSearchPPLParser.StatsArgsContext ctx1 = ctx.statsArgs();
        OpenSearchPPLParser.DedupSplitArgContext ctx2 = ctx.dedupSplitArg();
        Argument[] argumentArray = new Argument[4];
        argumentArray[0] = ctx1.partitionsArg() != null && !ctx1.partitionsArg().isEmpty() ? new Argument("partitions", ArgumentFactory.getArgumentValue(ctx1.partitionsArg((int)0).partitions)) : new Argument("partitions", Literal.ONE);
        argumentArray[1] = ctx1.allnumArg() != null && !ctx1.allnumArg().isEmpty() ? new Argument("allnum", ArgumentFactory.getArgumentValue(ctx1.allnumArg((int)0).allnum)) : new Argument("allnum", Literal.FALSE);
        Argument argument = argumentArray[2] = ctx1.delimArg() != null && !ctx1.delimArg().isEmpty() ? new Argument("delim", ArgumentFactory.getArgumentValue(ctx1.delimArg((int)0).delim)) : new Argument("delim", new Literal(" ", DataType.STRING));
        argumentArray[3] = ctx1.bucketNullableArg() != null && !ctx1.bucketNullableArg().isEmpty() ? new Argument("bucket_nullable", ArgumentFactory.getArgumentValue(ctx1.bucketNullableArg((int)0).bucket_nullable)) : new Argument("bucket_nullable", ArgumentFactory.legacyPreferred(settings) ? Literal.TRUE : Literal.FALSE);
        ArrayList<Argument> list = new ArrayList<Argument>(Arrays.asList(argumentArray));
        if (ctx2 != null) {
            list.add(new Argument("dedupsplit", ArgumentFactory.getArgumentValue(ctx2.dedupsplit)));
        } else {
            list.add(new Argument("dedupsplit", Literal.FALSE));
        }
        return list;
    }

    private static boolean legacyPreferred(Settings settings) {
        return settings == null || settings.getSettingValue(Settings.Key.PPL_SYNTAX_LEGACY_PREFERRED) == null || Boolean.TRUE.equals(settings.getSettingValue(Settings.Key.PPL_SYNTAX_LEGACY_PREFERRED));
    }

    public static List<Argument> getArgumentList(OpenSearchPPLParser.DedupCommandContext ctx) {
        return Arrays.asList(ctx.number != null ? new Argument("number", ArgumentFactory.getArgumentValue(ctx.number)) : new Argument("number", new Literal(1, DataType.INTEGER)), ctx.keepempty != null ? new Argument("keepempty", ArgumentFactory.getArgumentValue(ctx.keepempty)) : new Argument("keepempty", new Literal(false, DataType.BOOLEAN)), ctx.consecutive != null ? new Argument("consecutive", ArgumentFactory.getArgumentValue(ctx.consecutive)) : new Argument("consecutive", new Literal(false, DataType.BOOLEAN)));
    }

    public static List<Argument> getArgumentList(OpenSearchPPLParser.SortFieldContext ctx) {
        Argument[] argumentArray = new Argument[2];
        Argument argument = argumentArray[0] = ctx.MINUS() != null ? new Argument("asc", new Literal(false, DataType.BOOLEAN)) : new Argument("asc", new Literal(true, DataType.BOOLEAN));
        argumentArray[1] = ctx.sortFieldExpression().AUTO() != null ? new Argument("type", new Literal("auto", DataType.STRING)) : (ctx.sortFieldExpression().IP() != null ? new Argument("type", new Literal("ip", DataType.STRING)) : (ctx.sortFieldExpression().NUM() != null ? new Argument("type", new Literal("num", DataType.STRING)) : (ctx.sortFieldExpression().STR() != null ? new Argument("type", new Literal("str", DataType.STRING)) : new Argument("type", new Literal(null, DataType.NULL)))));
        return Arrays.asList(argumentArray);
    }

    public static List<Argument> getArgumentList(OpenSearchPPLParser.TopCommandContext ctx) {
        return Arrays.asList(ctx.number != null ? new Argument("noOfResults", ArgumentFactory.getArgumentValue(ctx.number)) : new Argument("noOfResults", new Literal(10, DataType.INTEGER)), ctx.countfield != null ? new Argument("countField", ArgumentFactory.getArgumentValue(ctx.countfield)) : new Argument("countField", new Literal("count", DataType.STRING)), ctx.showcount != null ? new Argument("showCount", ArgumentFactory.getArgumentValue(ctx.showcount)) : new Argument("showCount", new Literal(true, DataType.BOOLEAN)));
    }

    public static List<Argument> getArgumentList(OpenSearchPPLParser.RareCommandContext ctx) {
        return Arrays.asList(ctx.number != null ? new Argument("noOfResults", ArgumentFactory.getArgumentValue(ctx.number)) : new Argument("noOfResults", new Literal(10, DataType.INTEGER)), ctx.countfield != null ? new Argument("countField", ArgumentFactory.getArgumentValue(ctx.countfield)) : new Argument("countField", new Literal("count", DataType.STRING)), ctx.showcount != null ? new Argument("showCount", ArgumentFactory.getArgumentValue(ctx.showcount)) : new Argument("showCount", new Literal(true, DataType.BOOLEAN)));
    }

    private static Literal getArgumentValue(ParserRuleContext ctx) {
        if (ctx instanceof OpenSearchPPLParser.IntegerLiteralContext) {
            return new Literal(Integer.parseInt(ctx.getText()), DataType.INTEGER);
        }
        if (ctx instanceof OpenSearchPPLParser.DecimalLiteralContext) {
            return new Literal(Double.parseDouble(ctx.getText()), DataType.DOUBLE);
        }
        if (ctx instanceof OpenSearchPPLParser.BooleanLiteralContext) {
            return new Literal(Boolean.valueOf(ctx.getText()), DataType.BOOLEAN);
        }
        return new Literal(StringUtils.unquoteText(ctx.getText()), DataType.STRING);
    }

    public static Argument getArgumentValue(OpenSearchPPLParser.JoinTypeContext ctx) {
        Join.JoinType type = ArgumentFactory.getJoinType(ctx);
        return new Argument("type", new Literal(type.name(), DataType.STRING));
    }

    public static Join.JoinType getJoinType(OpenSearchPPLParser.SqlLikeJoinTypeContext ctx) {
        if (ctx == null) {
            return Join.JoinType.INNER;
        }
        if (ctx.INNER() != null) {
            return Join.JoinType.INNER;
        }
        if (ctx.SEMI() != null) {
            return Join.JoinType.SEMI;
        }
        if (ctx.ANTI() != null) {
            return Join.JoinType.ANTI;
        }
        if (ctx.LEFT() != null) {
            return Join.JoinType.LEFT;
        }
        if (ctx.RIGHT() != null) {
            return Join.JoinType.RIGHT;
        }
        if (ctx.CROSS() != null) {
            return Join.JoinType.CROSS;
        }
        if (ctx.FULL() != null) {
            return Join.JoinType.FULL;
        }
        if (ctx.OUTER() != null) {
            return Join.JoinType.LEFT;
        }
        throw new SemanticCheckException(String.format("Unsupported join type %s", ctx.getText()));
    }

    public static Join.JoinType getJoinType(OpenSearchPPLParser.JoinTypeContext ctx) {
        if (ctx == null) {
            return Join.JoinType.INNER;
        }
        if (ctx.INNER() != null) {
            return Join.JoinType.INNER;
        }
        if (ctx.SEMI() != null) {
            return Join.JoinType.SEMI;
        }
        if (ctx.ANTI() != null) {
            return Join.JoinType.ANTI;
        }
        if (ctx.LEFT() != null) {
            return Join.JoinType.LEFT;
        }
        if (ctx.RIGHT() != null) {
            return Join.JoinType.RIGHT;
        }
        if (ctx.CROSS() != null) {
            return Join.JoinType.CROSS;
        }
        if (ctx.FULL() != null) {
            return Join.JoinType.FULL;
        }
        if (ctx.OUTER() != null) {
            return Join.JoinType.LEFT;
        }
        throw new SemanticCheckException(String.format("Unsupported join type %s", ctx.getText()));
    }

    public static Join.JoinType getJoinType(Argument.ArgumentMap argumentMap) {
        Join.JoinType joinType;
        String type = argumentMap.get("type").toString();
        if (type.equalsIgnoreCase(Join.JoinType.INNER.name())) {
            joinType = Join.JoinType.INNER;
        } else if (type.equalsIgnoreCase(Join.JoinType.SEMI.name())) {
            joinType = Join.JoinType.SEMI;
        } else if (type.equalsIgnoreCase(Join.JoinType.ANTI.name())) {
            joinType = Join.JoinType.ANTI;
        } else if (type.equalsIgnoreCase(Join.JoinType.LEFT.name())) {
            joinType = Join.JoinType.LEFT;
        } else if (type.equalsIgnoreCase(Join.JoinType.RIGHT.name())) {
            joinType = Join.JoinType.RIGHT;
        } else if (type.equalsIgnoreCase(Join.JoinType.CROSS.name())) {
            joinType = Join.JoinType.CROSS;
        } else if (type.equalsIgnoreCase(Join.JoinType.FULL.name())) {
            joinType = Join.JoinType.FULL;
        } else if (type.equalsIgnoreCase("OUTER")) {
            joinType = Join.JoinType.LEFT;
        } else {
            throw new SemanticCheckException(String.format("Supported join type %s", type));
        }
        return joinType;
    }
}

