/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.ppl;

import lombok.Generated;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeVisitor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.sql.ast.statement.Statement;
import org.opensearch.sql.common.response.ResponseListener;
import org.opensearch.sql.common.setting.Settings;
import org.opensearch.sql.common.utils.QueryContext;
import org.opensearch.sql.executor.ExecutionEngine;
import org.opensearch.sql.executor.QueryManager;
import org.opensearch.sql.executor.QueryType;
import org.opensearch.sql.executor.execution.AbstractPlan;
import org.opensearch.sql.executor.execution.QueryPlanFactory;
import org.opensearch.sql.ppl.antlr.PPLSyntaxParser;
import org.opensearch.sql.ppl.domain.PPLQueryRequest;
import org.opensearch.sql.ppl.parser.AstBuilder;
import org.opensearch.sql.ppl.parser.AstStatementBuilder;
import org.opensearch.sql.ppl.utils.PPLQueryDataAnonymizer;

public class PPLService {
    @Generated
    private static final Logger log = LogManager.getLogger(PPLService.class);
    private final PPLSyntaxParser parser;
    private final QueryManager queryManager;
    private final QueryPlanFactory queryExecutionFactory;
    private final Settings settings;
    private final QueryType PPL_QUERY = QueryType.PPL;
    private final PPLQueryDataAnonymizer anonymizer;

    public PPLService(PPLSyntaxParser parser, QueryManager queryManager, QueryPlanFactory queryExecutionFactory, Settings settings) {
        this.parser = parser;
        this.queryManager = queryManager;
        this.queryExecutionFactory = queryExecutionFactory;
        this.settings = settings;
        this.anonymizer = new PPLQueryDataAnonymizer(settings);
    }

    public void execute(PPLQueryRequest request, ResponseListener<ExecutionEngine.QueryResponse> queryListener, ResponseListener<ExecutionEngine.ExplainResponse> explainListener) {
        try {
            this.queryManager.submit(this.plan(request, queryListener, explainListener));
        }
        catch (Exception e) {
            queryListener.onFailure(e);
        }
    }

    public void explain(PPLQueryRequest request, ResponseListener<ExecutionEngine.ExplainResponse> listener) {
        try {
            this.queryManager.submit(this.plan(request, QueryPlanFactory.NO_CONSUMER_RESPONSE_LISTENER, listener));
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    private AbstractPlan plan(PPLQueryRequest request, ResponseListener<ExecutionEngine.QueryResponse> queryListener, ResponseListener<ExecutionEngine.ExplainResponse> explainListener) {
        ParseTree cst = this.parser.parse(request.getRequest());
        Statement statement = (Statement)cst.accept((ParseTreeVisitor)new AstStatementBuilder(new AstBuilder(request.getRequest(), this.settings), AstStatementBuilder.StatementBuilderContext.builder().isExplain(request.isExplainRequest()).format(request.getFormat()).build()));
        log.info("[{}] Incoming request {}", (Object)QueryContext.getRequestId(), (Object)this.anonymizer.anonymizeStatement(statement));
        return this.queryExecutionFactory.create(statement, queryListener, explainListener);
    }
}

