/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.util;

import java.math.BigDecimal;
import java.util.Optional;
import lombok.Generated;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.commons.lang3.tuple.Pair;

public final class OpenSearchRelOptUtil {
    public static Optional<Pair<Integer, Boolean>> getOrderEquivalentInputInfo(RexNode expr) {
        switch (expr.getKind()) {
            case INPUT_REF: {
                RexInputRef inputRef = (RexInputRef)expr;
                return Optional.of(Pair.of((Object)inputRef.getIndex(), (Object)false));
            }
            case PLUS_PREFIX: {
                return OpenSearchRelOptUtil.getOrderEquivalentInputInfo((RexNode)((RexCall)expr).getOperands().get(0));
            }
            case MINUS_PREFIX: {
                return OpenSearchRelOptUtil.getOrderEquivalentInputInfo((RexNode)((RexCall)expr).getOperands().get(0)).map(inputInfo -> Pair.of((Object)((Integer)inputInfo.getLeft()), (Object)((Boolean)inputInfo.getRight() == false ? 1 : 0)));
            }
            case PLUS: 
            case MINUS: {
                RexNode operand0 = (RexNode)((RexCall)expr).getOperands().get(0);
                RexNode operand1 = (RexNode)((RexCall)expr).getOperands().get(1);
                boolean operand0Lit = operand0.isA(SqlKind.LITERAL);
                boolean operand1Lit = operand1.isA(SqlKind.LITERAL);
                if (operand0Lit == operand1Lit) {
                    return Optional.empty();
                }
                RexNode variable = operand0Lit ? operand1 : operand0;
                boolean flipped = expr.getKind() == SqlKind.MINUS && operand0Lit;
                return OpenSearchRelOptUtil.getOrderEquivalentInputInfo(variable).map(inputInfo -> Pair.of((Object)((Integer)inputInfo.getLeft()), (Object)(flipped != (Boolean)inputInfo.getRight() ? 1 : 0)));
            }
            case TIMES: {
                RexNode variable;
                RexNode operand0 = (RexNode)((RexCall)expr).getOperands().get(0);
                RexNode operand1 = (RexNode)((RexCall)expr).getOperands().get(1);
                RexNode lit = operand0.isA(SqlKind.LITERAL) ? operand0 : (operand1.isA(SqlKind.LITERAL) ? operand1 : null);
                RexNode rexNode = variable = lit == operand0 ? operand1 : operand0;
                if (lit == null) {
                    return Optional.empty();
                }
                BigDecimal k = (BigDecimal)((RexLiteral)lit).getValueAs(BigDecimal.class);
                if (k == null || k.signum() == 0) {
                    return Optional.empty();
                }
                boolean flipped = k.signum() < 0;
                return OpenSearchRelOptUtil.getOrderEquivalentInputInfo(variable).map(inputInfo -> Pair.of((Object)((Integer)inputInfo.getLeft()), (Object)(flipped != (Boolean)inputInfo.getRight() ? 1 : 0)));
            }
            case CAST: 
            case SAFE_CAST: {
                RexNode child = (RexNode)((RexCall)expr).getOperands().get(0);
                if (!OpenSearchRelOptUtil.isOrderPreservingCast(child.getType(), expr.getType())) {
                    return Optional.empty();
                }
                return OpenSearchRelOptUtil.getOrderEquivalentInputInfo(child);
            }
        }
        return Optional.empty();
    }

    private static boolean isOrderPreservingCast(RelDataType src, RelDataType dst) {
        SqlTypeName srcType = src.getSqlTypeName();
        SqlTypeName dstType = dst.getSqlTypeName();
        if (SqlTypeUtil.isIntType((RelDataType)src) && SqlTypeUtil.isApproximateNumeric((RelDataType)dst)) {
            int intBits = switch (srcType) {
                case SqlTypeName.TINYINT -> 8;
                case SqlTypeName.SMALLINT -> 16;
                case SqlTypeName.INTEGER -> 32;
                case SqlTypeName.BIGINT -> 64;
                default -> 0;
            };
            int floatBits = switch (dstType) {
                case SqlTypeName.FLOAT -> 24;
                case SqlTypeName.DOUBLE -> 53;
                default -> 0;
            };
            return intBits > 0 && floatBits > 0 && intBits <= floatBits;
        }
        if (SqlTypeUtil.isExactNumeric((RelDataType)src) && SqlTypeUtil.isExactNumeric((RelDataType)dst)) {
            int srcPrec = src.getPrecision();
            int dstPrec = dst.getPrecision();
            return dstPrec >= srcPrec;
        }
        if (SqlTypeUtil.isCharacter((RelDataType)src) && SqlTypeUtil.isCharacter((RelDataType)dst)) {
            int srcLength = src.getPrecision();
            int dstLength = dst.getPrecision();
            return dstLength >= srcLength || dstLength == -1;
        }
        if (srcType == SqlTypeName.DATE && (dstType == SqlTypeName.TIMESTAMP || dstType == SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE)) {
            return true;
        }
        if (srcType == SqlTypeName.TIME && (dstType == SqlTypeName.TIMESTAMP || dstType == SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE)) {
            return true;
        }
        if (srcType == dstType) {
            return dst.getPrecision() >= src.getPrecision() && dst.getScale() >= src.getScale();
        }
        return false;
    }

    @Generated
    private OpenSearchRelOptUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

