/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.storage.scan;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import lombok.Generated;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.commons.lang3.tuple.Pair;
import org.opensearch.search.aggregations.AggregationBuilder;
import org.opensearch.search.aggregations.AggregationBuilders;
import org.opensearch.search.aggregations.AggregatorFactories;
import org.opensearch.search.aggregations.BucketOrder;
import org.opensearch.search.aggregations.bucket.composite.CompositeAggregationBuilder;
import org.opensearch.search.aggregations.bucket.composite.CompositeValuesSourceBuilder;
import org.opensearch.search.aggregations.bucket.missing.MissingOrder;
import org.opensearch.search.aggregations.bucket.terms.MultiTermsAggregationBuilder;
import org.opensearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.opensearch.search.aggregations.support.ValuesSourceAggregationBuilder;
import org.opensearch.search.sort.SortOrder;
import org.opensearch.sql.opensearch.data.type.OpenSearchDataType;
import org.opensearch.sql.opensearch.request.OpenSearchRequestBuilder;
import org.opensearch.sql.opensearch.response.agg.OpenSearchAggregationResponseParser;
import org.opensearch.sql.opensearch.storage.scan.OSRequestBuilderAction;

class AggPushDownAction
implements OSRequestBuilderAction {
    private Pair<List<AggregationBuilder>, OpenSearchAggregationResponseParser> aggregationBuilder;
    private final Map<String, OpenSearchDataType> extendedTypeMapping;
    private final long scriptCount;
    private List<String> bucketNames;

    public AggPushDownAction(Pair<List<AggregationBuilder>, OpenSearchAggregationResponseParser> aggregationBuilder, Map<String, OpenSearchDataType> extendedTypeMapping, List<String> bucketNames) {
        this.aggregationBuilder = aggregationBuilder;
        this.extendedTypeMapping = extendedTypeMapping;
        this.scriptCount = ((List)aggregationBuilder.getLeft()).stream().filter(this::isScriptAggBuilder).count();
        this.bucketNames = bucketNames;
    }

    private boolean isScriptAggBuilder(AggregationBuilder aggBuilder) {
        ValuesSourceAggregationBuilder valueSourceAgg;
        return aggBuilder instanceof ValuesSourceAggregationBuilder && (valueSourceAgg = (ValuesSourceAggregationBuilder)aggBuilder).script() != null;
    }

    @Override
    public void apply(OpenSearchRequestBuilder requestBuilder) {
        requestBuilder.pushDownAggregation(this.aggregationBuilder);
        requestBuilder.pushTypeMapping(this.extendedTypeMapping);
    }

    public void pushDownSortIntoAggBucket(List<RelFieldCollation> collations, List<String> fieldNames) {
        if (((List)this.aggregationBuilder.getLeft()).isEmpty()) {
            return;
        }
        AggregationBuilder builder = (AggregationBuilder)((List)this.aggregationBuilder.getLeft()).getFirst();
        ArrayList selected = new ArrayList(collations.size());
        if (builder instanceof CompositeAggregationBuilder) {
            CompositeAggregationBuilder compositeAggBuilder = (CompositeAggregationBuilder)builder;
            List buckets = compositeAggBuilder.sources();
            ArrayList newBuckets = new ArrayList(buckets.size());
            ArrayList<String> newBucketNames = new ArrayList<String>(buckets.size());
            collations.forEach(collation -> {
                SortOrder order;
                String bucketName = (String)fieldNames.get(collation.getFieldIndex());
                CompositeValuesSourceBuilder bucket = (CompositeValuesSourceBuilder)buckets.get(this.bucketNames.indexOf(bucketName));
                RelFieldCollation.Direction direction = collation.getDirection();
                RelFieldCollation.NullDirection nullDirection = collation.nullDirection;
                SortOrder sortOrder = order = RelFieldCollation.Direction.DESCENDING.equals((Object)direction) ? SortOrder.DESC : SortOrder.ASC;
                if (bucket.missingBucket()) {
                    MissingOrder missingOrder = switch (nullDirection) {
                        case RelFieldCollation.NullDirection.FIRST -> MissingOrder.FIRST;
                        case RelFieldCollation.NullDirection.LAST -> MissingOrder.LAST;
                        default -> MissingOrder.DEFAULT;
                    };
                    bucket.missingOrder(missingOrder);
                }
                newBuckets.add(bucket.order(order));
                newBucketNames.add(bucketName);
                selected.add(bucketName);
            });
            IntStream.range(0, buckets.size()).mapToObj(fieldNames::get).filter(name -> !selected.contains(name)).forEach(name -> {
                newBuckets.add((CompositeValuesSourceBuilder)buckets.get(this.bucketNames.indexOf(name)));
                newBucketNames.add((String)name);
            });
            AggregatorFactories.Builder newAggBuilder = new AggregatorFactories.Builder();
            compositeAggBuilder.getSubAggregations().forEach(arg_0 -> ((AggregatorFactories.Builder)newAggBuilder).addAggregator(arg_0));
            this.aggregationBuilder = Pair.of(Collections.singletonList(((CompositeAggregationBuilder)AggregationBuilders.composite((String)"composite_buckets", newBuckets).subAggregations(newAggBuilder)).size(compositeAggBuilder.size())), (Object)((OpenSearchAggregationResponseParser)this.aggregationBuilder.getRight()));
            this.bucketNames = newBucketNames;
        }
        if (builder instanceof TermsAggregationBuilder) {
            TermsAggregationBuilder termsAggBuilder = (TermsAggregationBuilder)builder;
            termsAggBuilder.order(BucketOrder.key((!collations.getFirst().getDirection().isDescending() ? 1 : 0) != 0));
        }
    }

    public boolean pushDownLimitIntoBucketSize(Integer size) {
        if (((List)this.aggregationBuilder.getLeft()).isEmpty()) {
            return false;
        }
        AggregationBuilder builder = (AggregationBuilder)((List)this.aggregationBuilder.getLeft()).getFirst();
        if (builder instanceof CompositeAggregationBuilder) {
            CompositeAggregationBuilder compositeAggBuilder = (CompositeAggregationBuilder)builder;
            if (size < compositeAggBuilder.size()) {
                compositeAggBuilder.size(size.intValue());
                return true;
            }
            return false;
        }
        if (builder instanceof TermsAggregationBuilder) {
            TermsAggregationBuilder termsAggBuilder = (TermsAggregationBuilder)builder;
            if (size < termsAggBuilder.size()) {
                termsAggBuilder.size(size.intValue());
                return true;
            }
            return false;
        }
        if (builder instanceof MultiTermsAggregationBuilder) {
            MultiTermsAggregationBuilder multiTermsAggBuilder = (MultiTermsAggregationBuilder)builder;
            if (size < multiTermsAggBuilder.size()) {
                multiTermsAggBuilder.size(size.intValue());
                return true;
            }
            return false;
        }
        if (builder instanceof ValuesSourceAggregationBuilder.LeafOnly) {
            return true;
        }
        throw new OpenSearchRequestBuilder.PushDownUnSupportedException("Unknown aggregation builder " + builder.getClass().getSimpleName());
    }

    @Generated
    public long getScriptCount() {
        return this.scriptCount;
    }
}

