/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.request;

import java.math.BigDecimal;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import lombok.Generated;
import org.apache.calcite.DataContext;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUnknownAs;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.calcite.runtime.Hook;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSyntax;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.ArraySqlType;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.NlsString;
import org.apache.calcite.util.RangeSets;
import org.apache.calcite.util.Sarg;
import org.opensearch.index.mapper.DateFieldMapper;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.index.query.RangeQueryBuilder;
import org.opensearch.index.query.ScriptQueryBuilder;
import org.opensearch.script.Script;
import org.opensearch.sql.calcite.plan.OpenSearchConstants;
import org.opensearch.sql.calcite.type.ExprIPType;
import org.opensearch.sql.calcite.type.ExprSqlType;
import org.opensearch.sql.calcite.utils.OpenSearchTypeFactory;
import org.opensearch.sql.calcite.utils.UserDefinedFunctionUtils;
import org.opensearch.sql.data.model.ExprIpValue;
import org.opensearch.sql.data.model.ExprTimestampValue;
import org.opensearch.sql.data.type.ExprCoreType;
import org.opensearch.sql.data.type.ExprType;
import org.opensearch.sql.opensearch.data.type.OpenSearchDataType;
import org.opensearch.sql.opensearch.data.type.OpenSearchTextType;
import org.opensearch.sql.opensearch.storage.script.CalciteScriptEngine;
import org.opensearch.sql.opensearch.storage.script.CompoundedScriptEngine;
import org.opensearch.sql.opensearch.storage.script.StringUtils;
import org.opensearch.sql.opensearch.storage.script.filter.lucene.relevance.MatchBoolPrefixQuery;
import org.opensearch.sql.opensearch.storage.script.filter.lucene.relevance.MatchPhrasePrefixQuery;
import org.opensearch.sql.opensearch.storage.script.filter.lucene.relevance.MatchPhraseQuery;
import org.opensearch.sql.opensearch.storage.script.filter.lucene.relevance.MatchQuery;
import org.opensearch.sql.opensearch.storage.script.filter.lucene.relevance.MultiMatchQuery;
import org.opensearch.sql.opensearch.storage.script.filter.lucene.relevance.QueryStringQuery;
import org.opensearch.sql.opensearch.storage.script.filter.lucene.relevance.SimpleQueryStringQuery;
import org.opensearch.sql.opensearch.storage.serde.RelJsonSerializer;
import org.opensearch.sql.opensearch.storage.serde.SerializationWrapper;
import shaded.com.google.common.base.Preconditions;
import shaded.com.google.common.collect.BoundType;
import shaded.com.google.common.collect.Range;

public class PredicateAnalyzer {
    private PredicateAnalyzer() {
    }

    public static QueryBuilder analyze(RexNode expression, List<String> schema, Map<String, ExprType> fieldTypes) throws ExpressionNotAnalyzableException {
        return PredicateAnalyzer.analyze(expression, schema, fieldTypes, null, null);
    }

    public static QueryBuilder analyze(RexNode expression, List<String> schema, Map<String, ExprType> fieldTypes, RelDataType rowType, RelOptCluster cluster) throws ExpressionNotAnalyzableException {
        return PredicateAnalyzer.analyzeExpression(expression, schema, fieldTypes, rowType, cluster).builder();
    }

    public static QueryExpression analyzeExpression(RexNode expression, List<String> schema, Map<String, ExprType> fieldTypes, RelDataType rowType, RelOptCluster cluster) throws ExpressionNotAnalyzableException {
        Objects.requireNonNull(expression, "expression");
        return PredicateAnalyzer.analyzeExpression(expression, schema, fieldTypes, rowType, cluster, new Visitor(schema, fieldTypes, rowType, cluster));
    }

    public static QueryExpression analyzeExpression(RexNode expression, List<String> schema, Map<String, ExprType> fieldTypes, RelDataType rowType, RelOptCluster cluster, Visitor visitor) throws ExpressionNotAnalyzableException {
        Objects.requireNonNull(expression, "expression");
        try {
            QueryExpression queryExpression = (QueryExpression)expression.accept((RexVisitor)visitor);
            return queryExpression;
        }
        catch (Throwable e) {
            if (e instanceof CalciteScriptEngine.UnsupportedScriptException) {
                throw new ExpressionNotAnalyzableException("Can't convert " + String.valueOf(expression), e);
            }
            try {
                return new ScriptQueryExpression(expression, rowType, fieldTypes, cluster);
            }
            catch (Throwable e2) {
                throw new ExpressionNotAnalyzableException("Can't convert " + String.valueOf(expression), e2);
            }
        }
    }

    private static String timestampValueForPushDown(String value) {
        ExprTimestampValue exprTimestampValue = new ExprTimestampValue(value);
        return DateFieldMapper.getDefaultDateTimeFormatter().format((TemporalAccessor)exprTimestampValue.timestampValue());
    }

    private static String ipValueForPushDown(String value) {
        ExprIpValue exprIpValue = new ExprIpValue(value);
        return exprIpValue.value();
    }

    private static RangeQueryBuilder addFormatIfNecessary(LiteralExpression literal, RangeQueryBuilder rangeQueryBuilder) {
        if (literal.value() instanceof GregorianCalendar) {
            rangeQueryBuilder.format("date_time");
        }
        return rangeQueryBuilder;
    }

    public static Object sargPointValue(Object point) {
        if (point instanceof NlsString) {
            return ((NlsString)point).getValue();
        }
        if (point instanceof BigDecimal) {
            return ((BigDecimal)point).doubleValue();
        }
        return point;
    }

    private static void checkForIncompatibleDateTimeOperands(RexCall call) {
        RelDataType op1 = ((RexNode)call.getOperands().get(0)).getType();
        RelDataType op2 = ((RexNode)call.getOperands().get(1)).getType();
        if (SqlTypeFamily.DATETIME.contains(op1) && !SqlTypeFamily.DATETIME.contains(op2) || SqlTypeFamily.DATETIME.contains(op2) && !SqlTypeFamily.DATETIME.contains(op1) || SqlTypeFamily.DATE.contains(op1) && !SqlTypeFamily.DATE.contains(op2) || SqlTypeFamily.DATE.contains(op2) && !SqlTypeFamily.DATE.contains(op1) || SqlTypeFamily.TIMESTAMP.contains(op1) && !SqlTypeFamily.TIMESTAMP.contains(op2) || SqlTypeFamily.TIMESTAMP.contains(op2) && !SqlTypeFamily.TIMESTAMP.contains(op1) || SqlTypeFamily.TIME.contains(op1) && !SqlTypeFamily.TIME.contains(op2) || SqlTypeFamily.TIME.contains(op2) && !SqlTypeFamily.TIME.contains(op1)) {
            throw new PredicateAnalyzerException("Cannot handle " + String.valueOf(call.getKind()) + " expression for _id field, " + String.valueOf(call));
        }
    }

    private static void checkForNestedFieldOperands(RexCall call) throws PredicateAnalyzerException {
        boolean conditionContainsNestedField = call.getOperands().stream().map(RexNode::getType).anyMatch(type -> type instanceof ArraySqlType);
        if (conditionContainsNestedField) {
            throw new PredicateAnalyzerException(String.format(Locale.ROOT, "OpenSearch DSL does not handle %s on nested fields correctly", call.getKind()));
        }
    }

    public static abstract class QueryExpression
    implements Expression {
        private int scriptCount;

        protected void accumulateScriptCount(int count) {
            this.scriptCount += count;
        }

        public abstract QueryBuilder builder();

        public abstract List<RexNode> getAnalyzedNodes();

        public abstract void updateAnalyzedNodes(RexNode var1);

        public abstract List<RexNode> getUnAnalyzableNodes();

        public boolean isPartial() {
            return false;
        }

        QueryExpression not() {
            throw new PredicateAnalyzerException("not cannot be applied to " + String.valueOf(this.getClass()));
        }

        QueryExpression exists() {
            throw new PredicateAnalyzerException("SqlOperatorImpl ['exists'] cannot be applied to " + String.valueOf(this.getClass()));
        }

        QueryExpression notExists() {
            throw new PredicateAnalyzerException("SqlOperatorImpl ['notExists'] cannot be applied to " + String.valueOf(this.getClass()));
        }

        QueryExpression contains(LiteralExpression literal) {
            throw new PredicateAnalyzerException("SqlOperatorImpl ['contains'] cannot be applied to " + String.valueOf(this.getClass()));
        }

        QueryExpression between(Range<?> literal, boolean isTimeStamp) {
            throw new PredicateAnalyzerException("between cannot be applied to " + String.valueOf(this.getClass()));
        }

        QueryExpression like(LiteralExpression literal) {
            throw new PredicateAnalyzerException("SqlOperatorImpl ['like'] cannot be applied to " + String.valueOf(this.getClass()));
        }

        QueryExpression notLike(LiteralExpression literal) {
            throw new PredicateAnalyzerException("SqlOperatorImpl ['notLike'] cannot be applied to " + String.valueOf(this.getClass()));
        }

        QueryExpression equals(LiteralExpression literal) {
            throw new PredicateAnalyzerException("SqlOperatorImpl ['='] cannot be applied to " + String.valueOf(this.getClass()));
        }

        QueryExpression equals(Object point, boolean isTimeStamp) {
            throw new PredicateAnalyzerException("equals cannot be applied to " + String.valueOf(this.getClass()));
        }

        QueryExpression notEquals(LiteralExpression literal) {
            throw new PredicateAnalyzerException("SqlOperatorImpl ['not'] cannot be applied to " + String.valueOf(this.getClass()));
        }

        QueryExpression gt(LiteralExpression literal) {
            throw new PredicateAnalyzerException("SqlOperatorImpl ['>'] cannot be applied to " + String.valueOf(this.getClass()));
        }

        QueryExpression gte(LiteralExpression literal) {
            throw new PredicateAnalyzerException("SqlOperatorImpl ['>='] cannot be applied to " + String.valueOf(this.getClass()));
        }

        QueryExpression lt(LiteralExpression literal) {
            throw new PredicateAnalyzerException("SqlOperatorImpl ['<'] cannot be applied to " + String.valueOf(this.getClass()));
        }

        QueryExpression lte(LiteralExpression literal) {
            throw new PredicateAnalyzerException("SqlOperatorImpl ['<='] cannot be applied to " + String.valueOf(this.getClass()));
        }

        QueryExpression match(String query, Map<String, String> optionalArguments) {
            throw new PredicateAnalyzerException("Match cannot be applied to " + String.valueOf(this.getClass()));
        }

        QueryExpression matchPhrase(String query, Map<String, String> optionalArguments) {
            throw new PredicateAnalyzerException("MatchPhrase cannot be applied to " + String.valueOf(this.getClass()));
        }

        QueryExpression matchBoolPrefix(String query, Map<String, String> optionalArguments) {
            throw new PredicateAnalyzerException("MatchBoolPrefix cannot be applied to " + String.valueOf(this.getClass()));
        }

        QueryExpression matchPhrasePrefix(String query, Map<String, String> optionalArguments) {
            throw new PredicateAnalyzerException("MatchPhrasePrefix cannot be applied to " + String.valueOf(this.getClass()));
        }

        QueryExpression simpleQueryString(RexCall fieldsRexCall, String query, Map<String, String> optionalArguments) {
            throw new PredicateAnalyzerException("SimpleQueryString cannot be applied to " + String.valueOf(this.getClass()));
        }

        QueryExpression queryString(RexCall fieldsRexCall, String query, Map<String, String> optionalArguments) {
            throw new PredicateAnalyzerException("QueryString cannot be applied to " + String.valueOf(this.getClass()));
        }

        QueryExpression multiMatch(RexCall fieldsRexCall, String query, Map<String, String> optionalArguments) {
            throw new PredicateAnalyzerException("MultiMatch cannot be applied to " + String.valueOf(this.getClass()));
        }

        QueryExpression isTrue() {
            throw new PredicateAnalyzerException("isTrue cannot be applied to " + String.valueOf(this.getClass()));
        }

        QueryExpression in(LiteralExpression literal) {
            throw new PredicateAnalyzerException("in cannot be applied to " + String.valueOf(this.getClass()));
        }

        QueryExpression notIn(LiteralExpression literal) {
            throw new PredicateAnalyzerException("notIn cannot be applied to " + String.valueOf(this.getClass()));
        }

        static QueryExpression create(TerminalExpression expression) {
            if (expression instanceof CastExpression) {
                expression = CastExpression.unpack(expression);
            }
            if (expression instanceof NamedFieldExpression) {
                return new SimpleQueryExpression((NamedFieldExpression)expression);
            }
            String message = String.format(Locale.ROOT, "Unsupported expression: [%s]", expression);
            throw new PredicateAnalyzerException(message);
        }

        @Generated
        public int getScriptCount() {
            return this.scriptCount;
        }
    }

    static class Visitor
    extends RexVisitorImpl<Expression> {
        List<String> schema;
        Map<String, ExprType> fieldTypes;
        RelDataType rowType;
        RelOptCluster cluster;
        private static final Map<String, SingleFieldRelevanceFunctionHandler> SINGLE_FIELD_RELEVANCE_FUNCTION_HANDLERS = Map.of("match", (f, q, o) -> QueryExpression.create(f).match(q, o), "match_phrase", (f, q, o) -> QueryExpression.create(f).matchPhrase(q, o), "match_bool_prefix", (f, q, o) -> QueryExpression.create(f).matchBoolPrefix(q, o), "match_phrase_prefix", (f, q, o) -> QueryExpression.create(f).matchPhrasePrefix(q, o));
        private static final Map<String, MultiFieldsRelevanceFunctionHandler> MULTI_FIELDS_RELEVANCE_FUNCTION_HANDLERS = Map.of("simple_query_string", (c, q, o) -> QueryExpression.create(new NamedFieldExpression()).simpleQueryString(c, q, o), "query_string", (c, q, o) -> QueryExpression.create(new NamedFieldExpression()).queryString(c, q, o), "multi_match", (c, q, o) -> QueryExpression.create(new NamedFieldExpression()).multiMatch(c, q, o));

        Visitor(List<String> schema, Map<String, ExprType> fieldTypes, RelDataType rowType, RelOptCluster cluster) {
            super(true);
            this.schema = schema;
            this.fieldTypes = fieldTypes;
            this.rowType = rowType;
            this.cluster = cluster;
        }

        public Expression visitInputRef(RexInputRef inputRef) {
            return new NamedFieldExpression(inputRef, this.schema, this.fieldTypes);
        }

        public Expression visitLiteral(RexLiteral literal) {
            return new LiteralExpression(literal);
        }

        private static boolean supportedRexCall(RexCall call) {
            SqlSyntax syntax = call.getOperator().getSyntax();
            switch (syntax) {
                case BINARY: {
                    switch (call.getKind()) {
                        case CONTAINS: 
                        case AND: 
                        case OR: 
                        case LIKE: 
                        case EQUALS: 
                        case NOT_EQUALS: 
                        case GREATER_THAN: 
                        case GREATER_THAN_OR_EQUAL: 
                        case LESS_THAN: 
                        case LESS_THAN_OR_EQUAL: {
                            return true;
                        }
                    }
                    return false;
                }
                case SPECIAL: {
                    switch (call.getKind()) {
                        case LIKE: 
                        case CAST: 
                        case ITEM: 
                        case OTHER_FUNCTION: {
                            return true;
                        }
                    }
                    return false;
                }
                case FUNCTION: {
                    return true;
                }
                case POSTFIX: {
                    switch (call.getKind()) {
                        case IS_TRUE: 
                        case IS_NOT_NULL: 
                        case IS_NULL: {
                            return true;
                        }
                    }
                    return false;
                }
                case PREFIX: {
                    switch (call.getKind()) {
                        case NOT: {
                            return true;
                        }
                    }
                    return false;
                }
                case INTERNAL: {
                    switch (call.getKind()) {
                        case SEARCH: {
                            return true;
                        }
                    }
                    return false;
                }
            }
            return false;
        }

        static boolean isSearchWithPoints(RexCall search) {
            RexLiteral literal = (RexLiteral)search.getOperands().get(1);
            Sarg sarg = Objects.requireNonNull((Sarg)literal.getValueAs(Sarg.class), "Sarg");
            return sarg.isPoints();
        }

        static boolean isSearchWithComplementedPoints(RexCall search) {
            RexLiteral literal = (RexLiteral)search.getOperands().get(1);
            Sarg sarg = Objects.requireNonNull((Sarg)literal.getValueAs(Sarg.class), "Sarg");
            return sarg.isComplementedPoints();
        }

        static RexUnknownAs getNullAsForSearch(RexCall search) {
            RexLiteral literal = (RexLiteral)search.getOperands().get(1);
            Sarg sarg = Objects.requireNonNull((Sarg)literal.getValueAs(Sarg.class), "Sarg");
            return sarg.nullAs;
        }

        public Expression visitCall(RexCall call) {
            SqlSyntax syntax = call.getOperator().getSyntax();
            if (!Visitor.supportedRexCall(call)) {
                String message = String.format(Locale.ROOT, "Unsupported call: [%s]", call);
                throw new PredicateAnalyzerException(message);
            }
            switch (syntax) {
                case BINARY: 
                case INTERNAL: {
                    return this.binary(call);
                }
                case POSTFIX: {
                    return this.postfix(call);
                }
                case PREFIX: {
                    return this.prefix(call);
                }
                case SPECIAL: {
                    return switch (call.getKind()) {
                        case SqlKind.CAST -> this.toCastExpression(call);
                        case SqlKind.CONTAINS -> this.binary(call);
                        case SqlKind.LIKE -> this.like(call);
                        default -> {
                            String message = String.format(Locale.ROOT, "Unsupported call: [%s]", call);
                            throw new PredicateAnalyzerException(message);
                        }
                    };
                }
                case FUNCTION: {
                    String functionName = call.getOperator().getName().toLowerCase(Locale.ROOT);
                    if (functionName.equalsIgnoreCase(UserDefinedFunctionUtils.IP_FUNCTION_NAME)) {
                        return this.visitIpFunction(call);
                    }
                    if (!UserDefinedFunctionUtils.SINGLE_FIELD_RELEVANCE_FUNCTION_SET.contains(functionName) && !UserDefinedFunctionUtils.MULTI_FIELDS_RELEVANCE_FUNCTION_SET.contains(functionName)) break;
                    return this.visitRelevanceFunc(call);
                }
            }
            String message = String.format(Locale.ROOT, "Unsupported syntax [%s] for call: [%s]", syntax, call);
            throw new PredicateAnalyzerException(message);
        }

        private QueryExpression visitRelevanceFunc(RexCall call) {
            String funcName = call.getOperator().getName().toLowerCase(Locale.ROOT);
            List ops = call.getOperands();
            if (UserDefinedFunctionUtils.SINGLE_FIELD_RELEVANCE_FUNCTION_SET.contains(funcName) && ops.size() < 2) {
                throw new PredicateAnalyzerException("Single field relevance query function should at least have 2 operands (field and query)");
            }
            if (UserDefinedFunctionUtils.MULTI_FIELDS_RELEVANCE_FUNCTION_SET.contains(funcName) && ops.size() < 1) {
                throw new PredicateAnalyzerException("Multi field relevance query function should at least have 1 operand (query)");
            }
            if (UserDefinedFunctionUtils.SINGLE_FIELD_RELEVANCE_FUNCTION_SET.contains(funcName)) {
                List fieldQueryOperands = this.visitList(List.of(AliasPair.from((RexNode)((RexNode)ops.get((int)0)), (String)funcName).value, AliasPair.from((RexNode)((RexNode)ops.get((int)1)), (String)funcName).value));
                NamedFieldExpression namedFieldExpression = (NamedFieldExpression)fieldQueryOperands.get(0);
                String queryLiteralOperand = ((LiteralExpression)fieldQueryOperands.get(1)).stringValue();
                Map<String, String> optionalArguments = this.parseRelevanceFunctionOptionalArguments(ops, funcName);
                return SINGLE_FIELD_RELEVANCE_FUNCTION_HANDLERS.get(funcName).apply(namedFieldExpression, queryLiteralOperand, optionalArguments);
            }
            if (UserDefinedFunctionUtils.MULTI_FIELDS_RELEVANCE_FUNCTION_SET.contains(funcName)) {
                Map<String, String> optionalArguments;
                String queryLiteralOperand;
                RexCall fieldsRexCall = null;
                AliasPair firstPair = AliasPair.from((RexNode)ops.get(0), funcName);
                String firstKey = (String)((RexLiteral)firstPair.alias).getValueAs(String.class);
                if ("fields".equals(firstKey)) {
                    fieldsRexCall = (RexCall)firstPair.value;
                    queryLiteralOperand = ((LiteralExpression)this.visitList(List.of(AliasPair.from((RexNode)((RexNode)ops.get((int)1)), (String)funcName).value)).get(0)).stringValue();
                    optionalArguments = this.parseRelevanceFunctionOptionalArguments(ops, funcName, 2);
                } else if ("query".equals(firstKey)) {
                    queryLiteralOperand = ((LiteralExpression)this.visitList(List.of(firstPair.value)).get(0)).stringValue();
                    optionalArguments = this.parseRelevanceFunctionOptionalArguments(ops, funcName, 1);
                } else {
                    throw new PredicateAnalyzerException(String.format(Locale.ROOT, "Invalid first parameter for function [%s]: expected 'fields' or 'query', got '%s'", funcName, firstKey));
                }
                return MULTI_FIELDS_RELEVANCE_FUNCTION_HANDLERS.get(funcName).apply(fieldsRexCall, queryLiteralOperand, optionalArguments);
            }
            throw new PredicateAnalyzerException(String.format(Locale.ROOT, "Unsupported search relevance function: [%s]", funcName));
        }

        private LiteralExpression visitIpFunction(RexCall call) {
            return new LiteralExpression((RexLiteral)call.getOperands().getFirst());
        }

        private Map<String, String> parseRelevanceFunctionOptionalArguments(List<RexNode> operands, String funcName) {
            return this.parseRelevanceFunctionOptionalArguments(operands, funcName, 2);
        }

        private Map<String, String> parseRelevanceFunctionOptionalArguments(List<RexNode> operands, String funcName, int startIndex) {
            HashMap<String, String> optionalArguments = new HashMap<String, String>();
            for (int i = startIndex; i < operands.size(); ++i) {
                AliasPair aliasPair = AliasPair.from(operands.get(i), funcName);
                String key = (String)((RexLiteral)aliasPair.alias).getValueAs(String.class);
                if (optionalArguments.containsKey(key)) {
                    throw new PredicateAnalyzerException(String.format(Locale.ROOT, "Parameter '%s' can only be specified once for function [%s].", key, funcName));
                }
                optionalArguments.put(key, (String)((RexLiteral)aliasPair.value).getValueAs(String.class));
            }
            return optionalArguments;
        }

        private static RexCall expectCall(RexNode node, SqlOperator op, String funcName) {
            RexCall call;
            if (!(node instanceof RexCall) || (call = (RexCall)node).getOperator() != op) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "Expect [%s] RexCall but get [%s] for function [%s]", op.getName(), node.toString(), funcName));
            }
            return call;
        }

        private QueryExpression prefix(RexCall call) {
            Preconditions.checkArgument((call.getKind() == SqlKind.NOT ? 1 : 0) != 0, (String)"Expected %s got %s", (Object)SqlKind.NOT, (Object)call.getKind());
            if (call.getOperands().size() != 1) {
                String message = String.format(Locale.ROOT, "Unsupported NOT operator: [%s]", call);
                throw new PredicateAnalyzerException(message);
            }
            QueryExpression expr = (QueryExpression)((RexNode)call.getOperands().get(0)).accept((RexVisitor)this);
            return expr.not();
        }

        private QueryExpression postfix(RexCall call) {
            Preconditions.checkArgument((call.getKind() == SqlKind.IS_TRUE || call.getKind() == SqlKind.IS_NULL || call.getKind() == SqlKind.IS_NOT_NULL ? 1 : 0) != 0);
            if (call.getOperands().size() != 1) {
                String message = String.format(Locale.ROOT, "Unsupported operator: [%s]", call);
                throw new PredicateAnalyzerException(message);
            }
            if (call.getKind() == SqlKind.IS_TRUE) {
                Expression qe = (Expression)((RexNode)call.getOperands().get(0)).accept((RexVisitor)this);
                return ((QueryExpression)qe).isTrue();
            }
            PredicateAnalyzer.checkForNestedFieldOperands(call);
            Expression a = (Expression)((RexNode)call.getOperands().get(0)).accept((RexVisitor)this);
            Visitor.isColumn(a, (RexNode)call, "_id", true);
            Visitor.isColumn(a, (RexNode)call, "_index", true);
            QueryExpression operand = QueryExpression.create((TerminalExpression)a);
            return call.getKind() == SqlKind.IS_NOT_NULL ? operand.exists() : operand.notExists();
        }

        private QueryExpression binary(RexCall call) {
            if (call.getKind() == SqlKind.AND || call.getKind() == SqlKind.OR) {
                return this.andOr(call);
            }
            PredicateAnalyzer.checkForIncompatibleDateTimeOperands(call);
            Preconditions.checkState((call.getOperands().size() == 2 ? 1 : 0) != 0);
            Expression a = (Expression)((RexNode)call.getOperands().get(0)).accept((RexVisitor)this);
            Expression b = (Expression)((RexNode)call.getOperands().get(1)).accept((RexVisitor)this);
            SwapResult pair = Visitor.swap(a, b);
            boolean swapped = pair.isSwapped();
            if (Visitor.isColumn(pair.getKey(), (RexNode)call, "_id", false) || Visitor.isColumn(pair.getKey(), (RexNode)call, "_index", false) || Visitor.isColumn(pair.getKey(), (RexNode)call, "_uid", false)) {
                switch (call.getKind()) {
                    case EQUALS: 
                    case NOT_EQUALS: {
                        break;
                    }
                    default: {
                        throw new PredicateAnalyzerException("Cannot handle " + String.valueOf(call.getKind()) + " expression for _id field, " + String.valueOf(call));
                    }
                }
            }
            switch (call.getKind()) {
                case CONTAINS: {
                    return QueryExpression.create(pair.getKey()).contains(pair.getValue());
                }
                case EQUALS: {
                    return QueryExpression.create(pair.getKey()).equals(pair.getValue());
                }
                case NOT_EQUALS: {
                    return QueryExpression.create(pair.getKey()).notEquals(pair.getValue());
                }
                case GREATER_THAN: {
                    if (swapped) {
                        return QueryExpression.create(pair.getKey()).lt(pair.getValue());
                    }
                    return QueryExpression.create(pair.getKey()).gt(pair.getValue());
                }
                case GREATER_THAN_OR_EQUAL: {
                    if (swapped) {
                        return QueryExpression.create(pair.getKey()).lte(pair.getValue());
                    }
                    return QueryExpression.create(pair.getKey()).gte(pair.getValue());
                }
                case LESS_THAN: {
                    if (swapped) {
                        return QueryExpression.create(pair.getKey()).gt(pair.getValue());
                    }
                    return QueryExpression.create(pair.getKey()).lt(pair.getValue());
                }
                case LESS_THAN_OR_EQUAL: {
                    if (swapped) {
                        return QueryExpression.create(pair.getKey()).gte(pair.getValue());
                    }
                    return QueryExpression.create(pair.getKey()).lte(pair.getValue());
                }
                case SEARCH: {
                    QueryExpression expression = Visitor.constructQueryExpressionForSearch(call, pair);
                    RexUnknownAs nullAs = Visitor.getNullAsForSearch(call);
                    QueryExpression finalExpression = switch (nullAs) {
                        default -> throw new MatchException(null, null);
                        case RexUnknownAs.FALSE -> CompoundQueryExpression.and(false, expression, QueryExpression.create(pair.getKey()).exists());
                        case RexUnknownAs.TRUE -> CompoundQueryExpression.or(expression, QueryExpression.create(pair.getKey()).notExists());
                        case RexUnknownAs.UNKNOWN -> expression;
                    };
                    finalExpression.updateAnalyzedNodes((RexNode)call);
                    return finalExpression;
                }
            }
            String message = String.format(Locale.ROOT, "Unable to handle call: [%s]", call);
            throw new PredicateAnalyzerException(message);
        }

        private QueryExpression like(RexCall call) {
            Preconditions.checkState((call.getOperands().size() == 3 ? 1 : 0) != 0);
            Expression a = (Expression)((RexNode)call.getOperands().get(0)).accept((RexVisitor)this);
            Expression b = (Expression)((RexNode)call.getOperands().get(1)).accept((RexVisitor)this);
            SwapResult pair = Visitor.swap(a, b);
            return QueryExpression.create(pair.getKey()).like(pair.getValue());
        }

        private static QueryExpression constructQueryExpressionForSearch(RexCall call, SwapResult pair) {
            NamedFieldExpression namedField;
            if (Visitor.isSearchWithComplementedPoints(call)) {
                return QueryExpression.create(pair.getKey()).notIn(pair.getValue());
            }
            if (Visitor.isSearchWithPoints(call)) {
                return QueryExpression.create(pair.getKey()).in(pair.getValue());
            }
            Sarg sarg = (Sarg)pair.getValue().literal.getValueAs(Sarg.class);
            Set rangeSet = Objects.requireNonNull(sarg).rangeSet.asRanges();
            TerminalExpression terminalExpression = pair.getKey();
            boolean isTimeStamp = terminalExpression instanceof NamedFieldExpression && (namedField = (NamedFieldExpression)terminalExpression).isTimeStampType();
            List<QueryExpression> queryExpressions = rangeSet.stream().map(range -> RangeSets.isPoint((Range)range) ? QueryExpression.create(pair.getKey()).equals(PredicateAnalyzer.sargPointValue(range.lowerEndpoint()), isTimeStamp) : QueryExpression.create(pair.getKey()).between((Range<?>)range, isTimeStamp)).toList();
            if (queryExpressions.size() == 1) {
                return queryExpressions.getFirst();
            }
            return CompoundQueryExpression.or(queryExpressions.toArray(new QueryExpression[0]));
        }

        private boolean containIsEmptyFunction(RexCall call) {
            return call.getKind() == SqlKind.OR && call.getOperands().stream().anyMatch(o -> o.getKind() == SqlKind.IS_NULL) && call.getOperands().stream().anyMatch(o -> o.getKind() == SqlKind.OTHER && ((RexCall)o).getOperator().equals((Object)SqlStdOperatorTable.IS_EMPTY));
        }

        private QueryExpression andOr(RexCall call) {
            if (this.containIsEmptyFunction(call)) {
                throw new PredicateAnalyzerException("DSL will evaluate both branches of OR with isNUll, prevent push-down to avoid NPE");
            }
            QueryExpression[] expressions = new QueryExpression[call.getOperands().size()];
            PredicateAnalyzerException firstError = null;
            boolean partial = false;
            int failedCount = 0;
            for (int i = 0; i < call.getOperands().size(); ++i) {
                RexNode operand = (RexNode)call.getOperands().get(i);
                try {
                    Expression expr = this.tryAnalyzeOperand(operand);
                    if (!(expr instanceof QueryExpression)) continue;
                    expressions[i] = (QueryExpression)expr;
                    partial |= expressions[i].isPartial();
                    continue;
                }
                catch (PredicateAnalyzerException e) {
                    if (firstError == null) {
                        firstError = e;
                    }
                    partial = true;
                    ++failedCount;
                    expressions[i] = new UnAnalyzableQueryExpression(operand);
                }
            }
            switch (call.getKind()) {
                case OR: {
                    if (partial) {
                        if (firstError != null) {
                            throw firstError;
                        }
                        String message = String.format(Locale.ROOT, "Unable to handle call: [%s]", call);
                        throw new PredicateAnalyzerException(message);
                    }
                    return CompoundQueryExpression.or(expressions);
                }
                case AND: {
                    if (failedCount == call.getOperands().size()) {
                        throw new PredicateAnalyzerException("All expressions in AND failed to analyze: " + String.valueOf(call));
                    }
                    return CompoundQueryExpression.and(partial, expressions);
                }
            }
            String message = String.format(Locale.ROOT, "Unable to handle call: [%s]", call);
            throw new PredicateAnalyzerException(message);
        }

        public Expression tryAnalyzeOperand(RexNode node) {
            try {
                Expression expr = (Expression)node.accept((RexVisitor)this);
                if (expr instanceof NamedFieldExpression) {
                    return expr;
                }
                QueryExpression qe = (QueryExpression)expr;
                if (!qe.isPartial()) {
                    qe.updateAnalyzedNodes(node);
                }
                return qe;
            }
            catch (PredicateAnalyzerException firstFailed) {
                try {
                    ScriptQueryExpression qe = new ScriptQueryExpression(node, this.rowType, this.fieldTypes, this.cluster);
                    if (!qe.isPartial()) {
                        ((QueryExpression)qe).updateAnalyzedNodes(node);
                    }
                    return qe;
                }
                catch (CalciteScriptEngine.UnsupportedScriptException secondFailed) {
                    throw new PredicateAnalyzerException(secondFailed);
                }
            }
        }

        private static SwapResult swap(Expression left, Expression right) {
            TerminalExpression terminal;
            LiteralExpression literal = Visitor.expressAsLiteral(left);
            boolean swapped = false;
            if (literal != null) {
                swapped = true;
                terminal = (TerminalExpression)right;
            } else {
                literal = Visitor.expressAsLiteral(right);
                terminal = (TerminalExpression)left;
            }
            if (literal == null || terminal == null) {
                String message = String.format(Locale.ROOT, "Unexpected combination of expressions [left: %s] [right: %s]", left, right);
                throw new PredicateAnalyzerException(message);
            }
            if (CastExpression.isCastExpression(terminal)) {
                terminal = CastExpression.unpack(terminal);
            }
            return new SwapResult(swapped, terminal, literal);
        }

        private CastExpression toCastExpression(RexCall call) {
            TerminalExpression argument = (TerminalExpression)((RexNode)call.getOperands().get(0)).accept((RexVisitor)this);
            return new CastExpression(call.getType(), argument);
        }

        private static NamedFieldExpression toNamedField(RexLiteral literal) {
            return new NamedFieldExpression(literal);
        }

        private static LiteralExpression expressAsLiteral(Expression exp) {
            if (exp instanceof LiteralExpression) {
                return (LiteralExpression)exp;
            }
            return null;
        }

        private static boolean isColumn(Expression exp, RexNode node, String columnName, boolean throwException) {
            if (!(exp instanceof NamedFieldExpression)) {
                return false;
            }
            NamedFieldExpression termExp = (NamedFieldExpression)exp;
            if (columnName.equals(termExp.getRootName())) {
                if (throwException) {
                    throw new PredicateAnalyzerException("Cannot handle _id field in " + String.valueOf(node));
                }
                return true;
            }
            return false;
        }

        private static class AliasPair {
            final RexNode value;
            final RexNode alias;

            static AliasPair from(RexNode node, String funcName) {
                RexCall mapCall = Visitor.expectCall(node, (SqlOperator)SqlStdOperatorTable.MAP_VALUE_CONSTRUCTOR, funcName);
                return new AliasPair((RexNode)mapCall.getOperands().get(1), (RexNode)mapCall.getOperands().get(0));
            }

            private AliasPair(RexNode value, RexNode alias) {
                this.value = value;
                this.alias = alias;
            }
        }

        @FunctionalInterface
        private static interface SingleFieldRelevanceFunctionHandler {
            public QueryExpression apply(NamedFieldExpression var1, String var2, Map<String, String> var3);
        }

        @FunctionalInterface
        private static interface MultiFieldsRelevanceFunctionHandler {
            public QueryExpression apply(RexCall var1, String var2, Map<String, String> var3);
        }

        private static class SwapResult {
            final boolean swapped;
            final TerminalExpression terminal;
            final LiteralExpression literal;

            SwapResult(boolean swapped, TerminalExpression terminal, LiteralExpression literal) {
                this.swapped = swapped;
                this.terminal = terminal;
                this.literal = literal;
            }

            TerminalExpression getKey() {
                return this.terminal;
            }

            LiteralExpression getValue() {
                return this.literal;
            }

            boolean isSwapped() {
                return this.swapped;
            }
        }
    }

    public static class ExpressionNotAnalyzableException
    extends Exception {
        ExpressionNotAnalyzableException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static class ScriptQueryExpression
    extends QueryExpression {
        private RexNode analyzedNode;
        private final Supplier<String> codeGenerator;

        public ScriptQueryExpression(RexNode rexNode, RelDataType rowType, Map<String, ExprType> fieldTypes, RelOptCluster cluster) {
            if (rexNode instanceof RexCall && (rexNode.getKind().equals((Object)SqlKind.IS_NULL) || rexNode.getKind().equals((Object)SqlKind.IS_NOT_NULL))) {
                PredicateAnalyzer.checkForNestedFieldOperands((RexCall)rexNode);
            }
            this.accumulateScriptCount(1);
            RelJsonSerializer serializer = new RelJsonSerializer(cluster);
            this.codeGenerator = () -> SerializationWrapper.wrapWithLangType(CompoundedScriptEngine.ScriptEngineType.CALCITE, serializer.serialize(rexNode, rowType, fieldTypes));
        }

        @Override
        public QueryBuilder builder() {
            return new ScriptQueryBuilder(this.getScript());
        }

        public Script getScript() {
            long currentTime = (Long)Hook.CURRENT_TIME.get((Object)-1L);
            if (currentTime < 0L) {
                throw new CalciteScriptEngine.UnsupportedScriptException("ScriptQueryExpression requires a valid current time from hook, but it is not set");
            }
            return new Script(Script.DEFAULT_SCRIPT_TYPE, "opensearch_compounded_script", this.codeGenerator.get(), Collections.emptyMap(), Map.of(DataContext.Variable.UTC_TIMESTAMP.camelName, currentTime));
        }

        @Override
        public List<RexNode> getAnalyzedNodes() {
            return this.analyzedNode == null ? List.of() : List.of(this.analyzedNode);
        }

        @Override
        public void updateAnalyzedNodes(RexNode rexNode) {
            this.analyzedNode = rexNode;
        }

        @Override
        public List<RexNode> getUnAnalyzableNodes() {
            return List.of();
        }
    }

    static final class LiteralExpression
    implements TerminalExpression {
        final RexLiteral literal;

        LiteralExpression(RexLiteral literal) {
            this.literal = literal;
        }

        Object value() {
            if (this.isSarg()) {
                return this.sargValue();
            }
            if (this.isIntegral()) {
                return this.longValue();
            }
            if (this.isFractional()) {
                return this.doubleValue();
            }
            if (this.isBoolean()) {
                return this.booleanValue();
            }
            if (this.isTimestamp()) {
                return PredicateAnalyzer.timestampValueForPushDown(RexLiteral.stringValue((RexNode)this.literal));
            }
            if (this.isString()) {
                return RexLiteral.stringValue((RexNode)this.literal);
            }
            if (this.isIp()) {
                return PredicateAnalyzer.ipValueForPushDown(RexLiteral.stringValue((RexNode)this.literal));
            }
            return this.rawValue();
        }

        boolean isIntegral() {
            return SqlTypeName.INT_TYPES.contains(this.literal.getType().getSqlTypeName());
        }

        boolean isFractional() {
            return SqlTypeName.FRACTIONAL_TYPES.contains(this.literal.getType().getSqlTypeName());
        }

        boolean isDecimal() {
            return SqlTypeName.DECIMAL == this.literal.getType().getSqlTypeName();
        }

        boolean isBoolean() {
            return SqlTypeName.BOOLEAN_TYPES.contains(this.literal.getType().getSqlTypeName());
        }

        public boolean isString() {
            return SqlTypeName.CHAR_TYPES.contains(this.literal.getType().getSqlTypeName());
        }

        public boolean isSarg() {
            return SqlTypeName.SARG.getName().equalsIgnoreCase(this.literal.getTypeName().getName());
        }

        public boolean isTimestamp() {
            RelDataType relDataType = this.literal.getType();
            if (relDataType instanceof ExprSqlType) {
                ExprSqlType exprSqlType = (ExprSqlType)relDataType;
                return exprSqlType.getUdt() == OpenSearchTypeFactory.ExprUDT.EXPR_TIMESTAMP;
            }
            return false;
        }

        public boolean isIp() {
            return this.literal.getType() instanceof ExprIPType;
        }

        long longValue() {
            return ((Number)((Object)this.literal.getValue())).longValue();
        }

        double doubleValue() {
            return ((Number)((Object)this.literal.getValue())).doubleValue();
        }

        boolean booleanValue() {
            return RexLiteral.booleanValue((RexNode)this.literal);
        }

        String stringValue() {
            return RexLiteral.stringValue((RexNode)this.literal);
        }

        List<Object> sargValue() {
            Sarg sarg = Objects.requireNonNull((Sarg)this.literal.getValueAs(Sarg.class), "Sarg");
            ArrayList<Object> values = new ArrayList<Object>();
            if (sarg.isPoints()) {
                Set ranges = sarg.rangeSet.asRanges();
                ranges.forEach(range -> values.add(PredicateAnalyzer.sargPointValue(range.lowerEndpoint())));
            } else if (sarg.isComplementedPoints()) {
                Set ranges = sarg.negate().rangeSet.asRanges();
                ranges.forEach(range -> values.add(PredicateAnalyzer.sargPointValue(range.lowerEndpoint())));
            }
            return values;
        }

        Object rawValue() {
            return this.literal.getValue();
        }
    }

    public static final class PredicateAnalyzerException
    extends RuntimeException {
        PredicateAnalyzerException(String message) {
            super(message);
        }

        PredicateAnalyzerException(Throwable cause) {
            super(cause);
        }
    }

    public static final class NamedFieldExpression
    implements TerminalExpression {
        private final String name;
        private final ExprType type;

        public NamedFieldExpression(int refIndex, List<String> schema, Map<String, ExprType> filedTypes) {
            this.name = refIndex >= schema.size() ? null : schema.get(refIndex);
            this.type = filedTypes.get(this.name);
        }

        public NamedFieldExpression(String name, ExprType type) {
            this.name = name;
            this.type = type;
        }

        private NamedFieldExpression() {
            this.name = null;
            this.type = null;
        }

        private NamedFieldExpression(RexInputRef ref, List<String> schema, Map<String, ExprType> filedTypes) {
            this.name = ref == null || ref.getIndex() >= schema.size() ? null : schema.get(ref.getIndex());
            this.type = filedTypes.get(this.name);
        }

        private NamedFieldExpression(RexLiteral literal) {
            this.name = literal == null ? null : RexLiteral.stringValue((RexNode)literal);
            this.type = null;
        }

        public String getRootName() {
            return this.name;
        }

        ExprType getExprType() {
            return this.type;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        boolean isTimeStampType() {
            ExprType exprType;
            if (this.type == null) return false;
            ExprType exprType2 = this.type.getOriginalExprType();
            if (exprType2 instanceof OpenSearchDataType) {
                OpenSearchDataType osType = (OpenSearchDataType)exprType2;
                exprType = osType.getExprCoreType();
            } else {
                exprType = this.type.getOriginalExprType();
            }
            if (!ExprCoreType.TIMESTAMP.equals(exprType)) return false;
            return true;
        }

        boolean isTextType() {
            return this.type != null && this.type.getOriginalExprType() instanceof OpenSearchTextType;
        }

        boolean isMetaField() {
            return OpenSearchConstants.METADATAFIELD_TYPE_MAP.containsKey(this.getRootName());
        }

        String getReference() {
            return this.getRootName();
        }

        public String getReferenceForTermQuery() {
            return OpenSearchTextType.toKeywordSubField(this.getRootName(), this.type);
        }
    }

    static final class CastExpression
    implements TerminalExpression {
        private final RelDataType type;
        private final TerminalExpression argument;

        private CastExpression(RelDataType type, TerminalExpression argument) {
            this.type = type;
            this.argument = argument;
        }

        public boolean isCastFromLiteral() {
            return this.argument instanceof LiteralExpression;
        }

        static TerminalExpression unpack(TerminalExpression exp) {
            if (!(exp instanceof CastExpression)) {
                return exp;
            }
            return ((CastExpression)exp).argument;
        }

        static boolean isCastExpression(Expression exp) {
            return exp instanceof CastExpression;
        }
    }

    static interface TerminalExpression
    extends Expression {
    }

    static class SimpleQueryExpression
    extends QueryExpression {
        private RexNode analyzedRexNode;
        private final NamedFieldExpression rel;
        private QueryBuilder builder;

        private String getFieldReference() {
            return this.rel.getReference();
        }

        private String getFieldReferenceForTermQuery() {
            String reference = this.rel.getReferenceForTermQuery();
            if (reference == null) {
                throw new PredicateAnalyzerException("Field reference for term query cannot be null for " + this.rel.getRootName());
            }
            return reference;
        }

        private SimpleQueryExpression(NamedFieldExpression rel) {
            this.rel = rel;
        }

        public SimpleQueryExpression(QueryBuilder builder) {
            this.builder = builder;
            this.rel = null;
        }

        @Override
        public QueryBuilder builder() {
            if (this.builder == null) {
                throw new IllegalStateException("Builder was not initialized");
            }
            return this.builder;
        }

        @Override
        public List<RexNode> getUnAnalyzableNodes() {
            return List.of();
        }

        @Override
        public List<RexNode> getAnalyzedNodes() {
            return this.analyzedRexNode == null ? List.of() : List.of(this.analyzedRexNode);
        }

        @Override
        public void updateAnalyzedNodes(RexNode rexNode) {
            this.analyzedRexNode = rexNode;
        }

        @Override
        public QueryExpression not() {
            this.builder = QueryBuilders.boolQuery().mustNot(this.builder());
            return this;
        }

        @Override
        public QueryExpression exists() {
            this.builder = QueryBuilders.existsQuery((String)this.getFieldReference());
            return this;
        }

        @Override
        public QueryExpression notExists() {
            this.builder = QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.existsQuery((String)this.getFieldReference()));
            return this;
        }

        @Override
        public QueryExpression like(LiteralExpression literal) {
            boolean isKeywordField;
            String fieldName = this.getFieldReference();
            String keywordField = OpenSearchTextType.toKeywordSubField(fieldName, this.rel.getExprType());
            boolean bl = isKeywordField = keywordField != null;
            if (isKeywordField) {
                this.builder = QueryBuilders.wildcardQuery((String)keywordField, (String)StringUtils.convertSqlWildcardToLuceneSafe(literal.stringValue())).caseInsensitive(true);
                return this;
            }
            throw new UnsupportedOperationException("Like query is not supported for text field");
        }

        @Override
        public QueryExpression contains(LiteralExpression literal) {
            this.builder = QueryBuilders.matchQuery((String)this.getFieldReference(), (Object)literal.value());
            return this;
        }

        @Override
        public QueryExpression notLike(LiteralExpression literal) {
            this.builder = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.existsQuery((String)this.getFieldReference())).mustNot((QueryBuilder)QueryBuilders.regexpQuery((String)this.getFieldReference(), (String)literal.stringValue()));
            return this;
        }

        @Override
        public QueryExpression equals(LiteralExpression literal) {
            Object value = literal.value();
            this.builder = value instanceof GregorianCalendar ? QueryBuilders.boolQuery().must((QueryBuilder)PredicateAnalyzer.addFormatIfNecessary(literal, QueryBuilders.rangeQuery((String)this.getFieldReference()).gte(value))).must((QueryBuilder)PredicateAnalyzer.addFormatIfNecessary(literal, QueryBuilders.rangeQuery((String)this.getFieldReference()).lte(value))) : QueryBuilders.termQuery((String)this.getFieldReferenceForTermQuery(), (Object)value);
            return this;
        }

        @Override
        public QueryExpression notEquals(LiteralExpression literal) {
            Object value = literal.value();
            this.builder = value instanceof GregorianCalendar ? QueryBuilders.boolQuery().should((QueryBuilder)PredicateAnalyzer.addFormatIfNecessary(literal, QueryBuilders.rangeQuery((String)this.getFieldReference()).gt(value))).should((QueryBuilder)PredicateAnalyzer.addFormatIfNecessary(literal, QueryBuilders.rangeQuery((String)this.getFieldReference()).lt(value))) : QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.existsQuery((String)this.getFieldReference())).mustNot((QueryBuilder)QueryBuilders.termQuery((String)this.getFieldReferenceForTermQuery(), (Object)value));
            return this;
        }

        @Override
        public QueryExpression gt(LiteralExpression literal) {
            Object value = literal.value();
            this.builder = PredicateAnalyzer.addFormatIfNecessary(literal, QueryBuilders.rangeQuery((String)this.getFieldReference()).gt(value));
            return this;
        }

        @Override
        public QueryExpression gte(LiteralExpression literal) {
            Object value = literal.value();
            this.builder = PredicateAnalyzer.addFormatIfNecessary(literal, QueryBuilders.rangeQuery((String)this.getFieldReference()).gte(value));
            return this;
        }

        @Override
        public QueryExpression lt(LiteralExpression literal) {
            Object value = literal.value();
            this.builder = PredicateAnalyzer.addFormatIfNecessary(literal, QueryBuilders.rangeQuery((String)this.getFieldReference()).lt(value));
            return this;
        }

        @Override
        public QueryExpression lte(LiteralExpression literal) {
            Object value = literal.value();
            this.builder = PredicateAnalyzer.addFormatIfNecessary(literal, QueryBuilders.rangeQuery((String)this.getFieldReference()).lte(value));
            return this;
        }

        @Override
        public QueryExpression match(String query, Map<String, String> optionalArguments) {
            this.builder = new MatchQuery().build(this.getFieldReference(), query, (Map)optionalArguments);
            return this;
        }

        @Override
        public QueryExpression matchPhrase(String query, Map<String, String> optionalArguments) {
            this.builder = new MatchPhraseQuery().build(this.getFieldReference(), query, (Map)optionalArguments);
            return this;
        }

        @Override
        public QueryExpression matchBoolPrefix(String query, Map<String, String> optionalArguments) {
            this.builder = new MatchBoolPrefixQuery().build(this.getFieldReference(), query, (Map)optionalArguments);
            return this;
        }

        @Override
        public QueryExpression matchPhrasePrefix(String query, Map<String, String> optionalArguments) {
            this.builder = new MatchPhrasePrefixQuery().build(this.getFieldReference(), query, (Map)optionalArguments);
            return this;
        }

        @Override
        public QueryExpression simpleQueryString(RexCall fieldsRexCall, String query, Map<String, String> optionalArguments) {
            this.builder = new SimpleQueryStringQuery().build(fieldsRexCall, query, (Map)optionalArguments);
            return this;
        }

        @Override
        public QueryExpression queryString(RexCall fieldsRexCall, String query, Map<String, String> optionalArguments) {
            this.builder = new QueryStringQuery().build(fieldsRexCall, query, (Map)optionalArguments);
            return this;
        }

        @Override
        public QueryExpression multiMatch(RexCall fieldsRexCall, String query, Map<String, String> optionalArguments) {
            this.builder = new MultiMatchQuery().build(fieldsRexCall, query, (Map)optionalArguments);
            return this;
        }

        @Override
        public QueryExpression isTrue() {
            return this;
        }

        @Override
        public QueryExpression in(LiteralExpression literal) {
            Collection collection = (Collection)literal.value();
            this.builder = QueryBuilders.termsQuery((String)this.getFieldReferenceForTermQuery(), (Collection)collection);
            return this;
        }

        @Override
        public QueryExpression notIn(LiteralExpression literal) {
            Collection collection = (Collection)literal.value();
            this.builder = QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.termsQuery((String)this.getFieldReferenceForTermQuery(), (Collection)collection));
            return this;
        }

        @Override
        public QueryExpression equals(Object point, boolean isTimeStamp) {
            this.builder = QueryBuilders.termQuery((String)this.getFieldReferenceForTermQuery(), (Object)this.convertEndpointValue(point, isTimeStamp));
            return this;
        }

        @Override
        public QueryExpression between(Range<?> range, boolean isTimeStamp) {
            Object lowerBound = range.hasLowerBound() ? this.convertEndpointValue(range.lowerEndpoint(), isTimeStamp) : null;
            Object upperBound = range.hasUpperBound() ? this.convertEndpointValue(range.upperEndpoint(), isTimeStamp) : null;
            RangeQueryBuilder rangeQueryBuilder = QueryBuilders.rangeQuery((String)this.getFieldReference());
            rangeQueryBuilder = range.lowerBoundType() == BoundType.CLOSED ? rangeQueryBuilder.gte(lowerBound) : rangeQueryBuilder.gt(lowerBound);
            rangeQueryBuilder = range.upperBoundType() == BoundType.CLOSED ? rangeQueryBuilder.lte(upperBound) : rangeQueryBuilder.lt(upperBound);
            this.builder = rangeQueryBuilder;
            return this;
        }

        private Object convertEndpointValue(Object value, boolean isTimeStamp) {
            value = PredicateAnalyzer.sargPointValue(value);
            return isTimeStamp ? PredicateAnalyzer.timestampValueForPushDown(value.toString()) : value;
        }
    }

    public static class CompoundQueryExpression
    extends QueryExpression {
        private final boolean partial;
        private final BoolQueryBuilder builder;
        private List<RexNode> analyzedNodes = new ArrayList<RexNode>();
        private final List<RexNode> unAnalyzableNodes = new ArrayList<RexNode>();

        public static CompoundQueryExpression or(QueryExpression ... expressions) {
            CompoundQueryExpression bqe = new CompoundQueryExpression(false);
            for (QueryExpression expression : expressions) {
                bqe.builder.should(expression.builder());
                bqe.accumulateScriptCount(expression.getScriptCount());
            }
            return bqe;
        }

        public static CompoundQueryExpression and(boolean partial, QueryExpression ... expressions) {
            CompoundQueryExpression bqe = new CompoundQueryExpression(partial);
            for (QueryExpression expression : expressions) {
                bqe.analyzedNodes.addAll(expression.getAnalyzedNodes());
                bqe.unAnalyzableNodes.addAll(expression.getUnAnalyzableNodes());
                if (expression instanceof UnAnalyzableQueryExpression) continue;
                bqe.builder.must(expression.builder());
                bqe.accumulateScriptCount(expression.getScriptCount());
            }
            return bqe;
        }

        private CompoundQueryExpression(boolean partial) {
            this(partial, QueryBuilders.boolQuery());
        }

        private CompoundQueryExpression(boolean partial, BoolQueryBuilder builder) {
            this.partial = partial;
            this.builder = Objects.requireNonNull(builder, "builder");
        }

        @Override
        public boolean isPartial() {
            return this.partial;
        }

        @Override
        public QueryBuilder builder() {
            return this.builder;
        }

        @Override
        public void updateAnalyzedNodes(RexNode rexNode) {
            this.analyzedNodes = List.of(rexNode);
        }

        @Override
        public QueryExpression not() {
            return new CompoundQueryExpression(this.partial, QueryBuilders.boolQuery().mustNot(this.builder()));
        }

        @Override
        @Generated
        public List<RexNode> getAnalyzedNodes() {
            return this.analyzedNodes;
        }

        @Override
        @Generated
        public List<RexNode> getUnAnalyzableNodes() {
            return this.unAnalyzableNodes;
        }
    }

    static class UnAnalyzableQueryExpression
    extends QueryExpression {
        final RexNode unAnalyzableRexNode;

        public UnAnalyzableQueryExpression(RexNode rexNode) {
            this.unAnalyzableRexNode = Objects.requireNonNull(rexNode, "rexNode");
        }

        @Override
        public QueryBuilder builder() {
            return null;
        }

        @Override
        public List<RexNode> getUnAnalyzableNodes() {
            return List.of(this.unAnalyzableRexNode);
        }

        @Override
        public List<RexNode> getAnalyzedNodes() {
            return List.of();
        }

        @Override
        public void updateAnalyzedNodes(RexNode rexNode) {
            throw new IllegalStateException("UnAnalyzableQueryExpression does not support unAnalyzableNodes");
        }

        @Generated
        public RexNode getUnAnalyzableRexNode() {
            return this.unAnalyzableRexNode;
        }
    }

    static interface Expression {
    }
}

