/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.request;

import java.io.IOException;
import java.util.Arrays;
import java.util.function.Consumer;
import java.util.function.Function;
import lombok.Generated;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.search.SearchScrollRequest;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.sql.opensearch.data.value.OpenSearchExprValueFactory;
import org.opensearch.sql.opensearch.response.OpenSearchResponse;

public interface OpenSearchRequest
extends Writeable {
    public static final TimeValue DEFAULT_QUERY_TIMEOUT = TimeValue.timeValueMinutes((long)1L);

    public OpenSearchResponse search(Function<SearchRequest, SearchResponse> var1, Function<SearchScrollRequest, SearchResponse> var2);

    public void clean(Consumer<String> var1);

    public void forceClean(Consumer<String> var1);

    public OpenSearchExprValueFactory getExprValueFactory();

    public boolean hasAnotherBatch();

    public static class IndexName
    implements Writeable {
        private static final String COMMA = ",";
        private final String[] indexNames;

        public IndexName(StreamInput si) throws IOException {
            this.indexNames = si.readStringArray();
        }

        public IndexName(String indexName) {
            this.indexNames = indexName.split(COMMA);
        }

        public String[] getIndexNames() {
            return this.indexNames;
        }

        public String toString() {
            return String.join((CharSequence)COMMA, this.indexNames);
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeStringArray(this.indexNames);
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof IndexName)) {
                return false;
            }
            IndexName other = (IndexName)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return Arrays.deepEquals(this.getIndexNames(), other.getIndexNames());
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof IndexName;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + Arrays.deepHashCode(this.getIndexNames());
            return result;
        }
    }
}

