/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.legacy.rewriter.subquery;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLExistsExpr;
import com.alibaba.druid.sql.ast.expr.SQLInSubQueryExpr;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLJoinTableSource;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import org.opensearch.sql.legacy.rewriter.subquery.NestedQueryContext;

public class RewriterContext {
    private final Deque<SQLTableSource> tableStack = new ArrayDeque<SQLTableSource>();
    private final Deque<SQLExpr> conditionStack = new ArrayDeque<SQLExpr>();
    private final List<SQLInSubQueryExpr> sqlInSubQueryExprs = new ArrayList<SQLInSubQueryExpr>();
    private final List<SQLExistsExpr> sqlExistsExprs = new ArrayList<SQLExistsExpr>();
    private final NestedQueryContext nestedQueryDetector = new NestedQueryContext();

    public SQLTableSource popJoin() {
        return this.tableStack.pop();
    }

    public SQLExpr popWhere() {
        return this.conditionStack.pop();
    }

    public void addWhere(SQLExpr expr) {
        this.conditionStack.push(expr);
    }

    public void addJoin(SQLTableSource right, SQLJoinTableSource.JoinType joinType, SQLBinaryOpExpr condition) {
        SQLTableSource left = this.tableStack.pop();
        SQLJoinTableSource joinTableSource = new SQLJoinTableSource();
        joinTableSource.setLeft(left);
        joinTableSource.setRight(right);
        joinTableSource.setJoinType(joinType);
        joinTableSource.setCondition((SQLExpr)condition);
        this.tableStack.push((SQLTableSource)joinTableSource);
    }

    public void addJoin(SQLTableSource right, SQLJoinTableSource.JoinType joinType) {
        this.addJoin(right, joinType, null);
    }

    public void addTable(SQLTableSource table) {
        this.tableStack.push(table);
        this.nestedQueryDetector.add(table);
    }

    public boolean isNestedQuery(SQLExprTableSource table) {
        return this.nestedQueryDetector.isNested(table);
    }

    public void setInSubQuery(SQLInSubQueryExpr expr) {
        this.sqlInSubQueryExprs.add(expr);
    }

    public void setExistsSubQuery(SQLExistsExpr expr) {
        this.sqlExistsExprs.add(expr);
    }

    public List<SQLInSubQueryExpr> getSqlInSubQueryExprs() {
        return this.sqlInSubQueryExprs;
    }

    public List<SQLExistsExpr> getSqlExistsExprs() {
        return this.sqlExistsExprs;
    }
}

