/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.legacy.pit;

import java.util.Optional;
import java.util.concurrent.ExecutionException;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchSecurityException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.search.CreatePitAction;
import org.opensearch.action.search.CreatePitRequest;
import org.opensearch.action.search.CreatePitResponse;
import org.opensearch.action.search.DeletePitAction;
import org.opensearch.action.search.DeletePitRequest;
import org.opensearch.action.search.DeletePitResponse;
import org.opensearch.common.action.ActionFuture;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.sql.common.setting.Settings;
import org.opensearch.sql.legacy.esdomain.LocalClusterState;
import org.opensearch.sql.legacy.pit.PointInTimeHandler;
import org.opensearch.transport.client.Client;

public class PointInTimeHandlerImpl
implements PointInTimeHandler {
    private final Client client;
    private String[] indices;
    private final Optional<TimeValue> customKeepAlive;
    private String pitId;
    private static final Logger LOG = LogManager.getLogger();

    public PointInTimeHandlerImpl(Client client, String[] indices) {
        this.client = client;
        this.indices = indices;
        this.customKeepAlive = Optional.empty();
    }

    public PointInTimeHandlerImpl(Client client, String[] indices, TimeValue customKeepAlive) {
        this.client = client;
        this.indices = indices;
        this.customKeepAlive = Optional.ofNullable(customKeepAlive);
    }

    public PointInTimeHandlerImpl(Client client, String pitId) {
        this.client = client;
        this.pitId = pitId;
        this.customKeepAlive = Optional.empty();
    }

    @Override
    public void create() {
        TimeValue keepAlive = this.getEffectiveKeepAlive();
        LOG.info("Creating PIT with keepalive: {} ({}ms)", (Object)keepAlive, (Object)keepAlive.getMillis());
        CreatePitRequest createPitRequest = new CreatePitRequest(keepAlive, Boolean.valueOf(false), this.indices);
        ActionFuture execute = this.client.execute((ActionType)CreatePitAction.INSTANCE, (ActionRequest)createPitRequest);
        try {
            CreatePitResponse pitResponse = (CreatePitResponse)execute.get();
            this.pitId = pitResponse.getId();
            LOG.info("Created Point In Time {} with keepalive {} successfully.", (Object)this.pitId, (Object)keepAlive);
        }
        catch (OpenSearchSecurityException e) {
            throw e;
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException("Error occurred while creating PIT.", e);
        }
    }

    @Override
    public void delete() {
        DeletePitRequest deletePitRequest = new DeletePitRequest(new String[]{this.pitId});
        ActionFuture execute = this.client.execute((ActionType)DeletePitAction.INSTANCE, (ActionRequest)deletePitRequest);
        try {
            DeletePitResponse deletePitResponse = (DeletePitResponse)execute.get();
            LOG.info("Delete Point In Time {} status: {}", (Object)this.pitId, (Object)deletePitResponse.status().getStatus());
        }
        catch (OpenSearchSecurityException e) {
            throw e;
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException("Error occurred while deleting PIT.", e);
        }
    }

    private TimeValue getEffectiveKeepAlive() {
        if (this.customKeepAlive.isPresent()) {
            LOG.info("Using custom PIT keepalive from JOIN_TIME_OUT hint: {} ({}ms)", (Object)this.customKeepAlive.get(), (Object)this.customKeepAlive.get().getMillis());
            return this.customKeepAlive.get();
        }
        TimeValue defaultKeepAlive = (TimeValue)LocalClusterState.state().getSettingValue(Settings.Key.SQL_CURSOR_KEEP_ALIVE);
        LOG.info("Using default PIT keepalive: {} ({}ms)", (Object)defaultKeepAlive, (Object)defaultKeepAlive.getMillis());
        return defaultKeepAlive;
    }

    @Override
    @Generated
    public String getPitId() {
        return this.pitId;
    }

    @Generated
    public void setPitId(String pitId) {
        this.pitId = pitId;
    }
}

