/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.expression.parse;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import shaded.com.google.common.collect.ImmutableList;

public class RegexCommonUtils {
    private static final Pattern NAMED_GROUP_PATTERN = Pattern.compile("\\(\\?<([a-zA-Z][a-zA-Z0-9]*)>");
    private static final int MAX_CACHE_SIZE = 1000;
    private static final Map<String, Pattern> patternCache = Collections.synchronizedMap(new LinkedHashMap<String, Pattern>(1001, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, Pattern> eldest) {
            return this.size() > 1000;
        }
    });

    public static Pattern getCompiledPattern(String regex) {
        Pattern pattern = patternCache.get(regex);
        if (pattern == null) {
            pattern = Pattern.compile(regex);
            patternCache.put(regex, pattern);
        }
        return pattern;
    }

    public static List<String> getNamedGroupCandidates(String pattern) {
        ImmutableList.Builder namedGroups = ImmutableList.builder();
        Matcher m = NAMED_GROUP_PATTERN.matcher(pattern);
        while (m.find()) {
            namedGroups.add((Object)m.group(1));
        }
        return namedGroups.build();
    }

    public static boolean matchesPartial(String text, String patternStr) {
        if (text == null || patternStr == null) {
            return false;
        }
        Pattern pattern = RegexCommonUtils.getCompiledPattern(patternStr);
        return pattern.matcher(text).find();
    }

    public static String extractNamedGroup(String text, Pattern pattern, String groupName) {
        if (text == null || pattern == null || groupName == null) {
            return null;
        }
        Matcher matcher = pattern.matcher(text);
        if (matcher.matches()) {
            try {
                return matcher.group(groupName);
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
        return null;
    }
}

