/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.ast.tree;

import java.util.List;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.opensearch.sql.ast.AbstractNodeVisitor;
import org.opensearch.sql.ast.dsl.AstDSL;
import org.opensearch.sql.ast.tree.Eval;
import org.opensearch.sql.ast.tree.UnresolvedPlan;
import shaded.com.google.common.collect.ImmutableList;

public class SPath
extends UnresolvedPlan {
    private UnresolvedPlan child;
    private final String inField;
    private final @Nullable String outField;
    private final String path;

    @Override
    public UnresolvedPlan attach(UnresolvedPlan child) {
        this.child = child;
        return this;
    }

    public List<UnresolvedPlan> getChild() {
        return this.child == null ? ImmutableList.of() : ImmutableList.of((Object)this.child);
    }

    @Override
    public <T, C> T accept(AbstractNodeVisitor<T, C> nodeVisitor, C context) {
        return nodeVisitor.visitSpath(this, context);
    }

    public Eval rewriteAsEval() {
        String outField = this.outField;
        if (outField == null) {
            outField = this.path;
        }
        return AstDSL.eval(this.child, AstDSL.let(AstDSL.field(outField), AstDSL.function("json_extract", AstDSL.field(this.inField), AstDSL.stringLiteral(this.path))));
    }

    @Override
    @Generated
    public String toString() {
        return "SPath(child=" + String.valueOf(this.getChild()) + ", inField=" + this.inField + ", outField=" + this.outField + ", path=" + this.path + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SPath)) {
            return false;
        }
        SPath other = (SPath)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<UnresolvedPlan> this$child = this.getChild();
        List<UnresolvedPlan> other$child = other.getChild();
        if (this$child == null ? other$child != null : !((Object)this$child).equals(other$child)) {
            return false;
        }
        String this$inField = this.inField;
        String other$inField = other.inField;
        if (this$inField == null ? other$inField != null : !this$inField.equals(other$inField)) {
            return false;
        }
        String this$outField = this.outField;
        String other$outField = other.outField;
        if (this$outField == null ? other$outField != null : !this$outField.equals(other$outField)) {
            return false;
        }
        String this$path = this.path;
        String other$path = other.path;
        return !(this$path == null ? other$path != null : !this$path.equals(other$path));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SPath;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<UnresolvedPlan> $child = this.getChild();
        result = result * 59 + ($child == null ? 43 : ((Object)$child).hashCode());
        String $inField = this.inField;
        result = result * 59 + ($inField == null ? 43 : $inField.hashCode());
        String $outField = this.outField;
        result = result * 59 + ($outField == null ? 43 : $outField.hashCode());
        String $path = this.path;
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        return result;
    }

    @Generated
    public SPath(String inField, @Nullable String outField, String path) {
        this.inField = inField;
        this.outField = outField;
        this.path = path;
    }

    @Generated
    public SPath(UnresolvedPlan child, String inField, @Nullable String outField, String path) {
        this.child = child;
        this.inField = inField;
        this.outField = outField;
        this.path = path;
    }
}

