/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.fips;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.bouncycastle.crypto.fips.FipsSHS;
import org.bouncycastle.crypto.internal.Xof;
import org.bouncycastle.crypto.internal.params.AsymmetricKeyParameter;
import org.bouncycastle.math.ec.rfc8032.Ed448;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.io.Streams;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
final class Ed448PublicKeyParameters
extends AsymmetricKeyParameter {
    public static final int KEY_SIZE = 57;
    private final byte[] data = new byte[57];
    private final Ed448 ed448 = new Ed448(){

        @Override
        protected Xof createXof() {
            return (Xof)FipsSHS.createDigest(FipsSHS.Algorithm.SHAKE256);
        }
    };

    public Ed448PublicKeyParameters(byte[] byArray) {
        this(Ed448PublicKeyParameters.validate(byArray), 0);
    }

    public Ed448PublicKeyParameters(byte[] byArray, int n) {
        super(false);
        System.arraycopy(byArray, n, this.data, 0, 57);
    }

    public Ed448PublicKeyParameters(InputStream inputStream) throws IOException {
        super(false);
        if (57 != Streams.readFully(inputStream, this.data)) {
            throw new EOFException("EOF encountered in middle of Ed448 public key");
        }
    }

    public void encode(byte[] byArray, int n) {
        System.arraycopy(this.data, 0, byArray, n, 57);
    }

    public byte[] getEncoded() {
        return Arrays.clone(this.data);
    }

    public boolean verify(int n, byte[] byArray, byte[] byArray2, int n2, int n3, byte[] byArray3, int n4) {
        switch (n) {
            case 0: {
                return this.ed448.verify(byArray3, n4, this.data, 0, byArray, byArray2, n2, n3);
            }
            case 1: {
                if (64 != n3) {
                    throw new IllegalArgumentException("msgLen");
                }
                return this.ed448.verifyPrehash(byArray3, n4, this.data, 0, byArray, byArray2, n2);
            }
        }
        throw new IllegalArgumentException("algorithm");
    }

    private static byte[] validate(byte[] byArray) {
        if (byArray.length != 57) {
            throw new IllegalArgumentException("'buf' must have length 57");
        }
        return byArray;
    }
}

