/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.searchrelevance.model;

import java.io.IOException;
import java.util.List;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.searchrelevance.model.QuerySetEntry;

public class QuerySet
implements ToXContentObject {
    public static final String ID = "id";
    public static final String NAME = "name";
    public static final String DESCRIPTION = "description";
    public static final String TIME_STAMP = "timestamp";
    public static final String SAMPLING = "sampling";
    public static final String QUERY_SET_QUERIES = "querySetQueries";
    private final String id;
    private final String name;
    private final String description;
    private final String sampling;
    private final String timestamp;
    private final List<QuerySetEntry> querySetQueries;

    public QuerySet(String id, String name, String description, String timestamp, String sampling, List<QuerySetEntry> querySetQueries) {
        this.id = id;
        this.description = description;
        this.name = name;
        this.sampling = sampling;
        this.timestamp = timestamp;
        this.querySetQueries = querySetQueries;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        XContentBuilder xContentBuilder = builder.startObject();
        xContentBuilder.field(ID, this.id);
        xContentBuilder.field(NAME, this.name == null ? "" : this.name.trim());
        xContentBuilder.field(DESCRIPTION, this.description == null ? "" : this.description.trim());
        xContentBuilder.field(SAMPLING, this.sampling == null ? "" : this.sampling.trim());
        xContentBuilder.field(TIME_STAMP, this.timestamp.trim());
        xContentBuilder.startArray(QUERY_SET_QUERIES);
        for (QuerySetEntry entry : this.querySetQueries) {
            entry.toXContent(xContentBuilder, params);
        }
        xContentBuilder.endArray();
        return xContentBuilder.endObject();
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String sampling() {
        return this.sampling;
    }

    public String timestamp() {
        return this.timestamp;
    }

    public List<QuerySetEntry> querySetQueries() {
        return this.querySetQueries;
    }

    public static class Builder {
        private String id;
        private String name = "";
        private String description = "";
        private String sampling = "";
        private String timestamp = "";
        private List<QuerySetEntry> querySetQueries;

        private Builder() {
        }

        private Builder(QuerySet t) {
            this.id = t.id;
            this.name = t.name;
            this.description = t.description;
            this.sampling = t.sampling;
            this.timestamp = t.timestamp;
            this.querySetQueries = t.querySetQueries;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder sampling(String sampling) {
            this.sampling = sampling;
            return this;
        }

        public Builder timestamp(String timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Builder querySetQueries(List<QuerySetEntry> querySetQueries) {
            this.querySetQueries = querySetQueries;
            return this;
        }

        public QuerySet build() {
            return new QuerySet(this.id, this.name, this.description, this.timestamp, this.sampling, this.querySetQueries);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static Builder builder(QuerySet t) {
            return new Builder(t);
        }
    }
}

