/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.searchrelevance.judgments;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.common.inject.Inject;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.searchrelevance.exception.SearchRelevanceException;
import org.opensearch.searchrelevance.judgments.BaseJudgmentsProcessor;
import org.opensearch.searchrelevance.model.JudgmentType;
import org.opensearch.searchrelevance.stats.events.EventStatName;
import org.opensearch.searchrelevance.stats.events.EventStatsManager;
import org.opensearch.transport.client.Client;

public class ImportJudgmentsProcessor
implements BaseJudgmentsProcessor {
    private static final Logger LOGGER = LogManager.getLogger(ImportJudgmentsProcessor.class);
    private final Client client;

    @Inject
    public ImportJudgmentsProcessor(Client client) {
        this.client = client;
    }

    @Override
    public JudgmentType getJudgmentType() {
        return JudgmentType.IMPORT_JUDGMENT;
    }

    @Override
    public void generateJudgmentRating(Map<String, Object> metadata, ActionListener<List<Map<String, Object>>> listener) {
        EventStatsManager.increment(EventStatName.IMPORT_JUDGMENT_RATING_GENERATIONS);
        List sourceJudgementRatings = (List)metadata.get("judgmentRatings");
        metadata.remove("judgmentRatings");
        ArrayList formattedRatings = new ArrayList();
        for (Map queryJudgment : sourceJudgementRatings) {
            String queryText = queryJudgment.get("query").toString();
            Object ratingData = queryJudgment.get("ratings");
            if (!(ratingData instanceof List)) {
                listener.onFailure((Exception)((Object)new SearchRelevanceException("queryText " + queryText + " must have a list of rating data.", RestStatus.BAD_REQUEST)));
                return;
            }
            List ratingsList = (List)ratingData;
            ArrayList<Map<String, String>> docIdRatings = new ArrayList<Map<String, String>>();
            for (Map ratingInfo : ratingsList) {
                String docId = (String)ratingInfo.get("docId");
                Object ratingObj = ratingInfo.get("rating");
                if (docId == null || docId.isEmpty()) {
                    listener.onFailure((Exception)((Object)new SearchRelevanceException("docId for queryText " + queryText + " must not be null or empty", RestStatus.BAD_REQUEST)));
                    return;
                }
                if (ratingObj == null) {
                    listener.onFailure((Exception)((Object)new SearchRelevanceException("rating for queryText " + queryText + " must not be null", RestStatus.BAD_REQUEST)));
                    return;
                }
                String rating = String.valueOf(ratingObj);
                try {
                    Float.parseFloat(rating);
                }
                catch (NumberFormatException e) {
                    listener.onFailure((Exception)((Object)new SearchRelevanceException("rating '" + rating + "' for queryText " + queryText + " must be a valid float", RestStatus.BAD_REQUEST)));
                    return;
                }
                docIdRatings.add(Map.of("docId", docId, "rating", rating));
            }
            HashMap<String, Object> queryRatings = new HashMap<String, Object>();
            queryRatings.put("query", queryText);
            queryRatings.put("ratings", docIdRatings);
            formattedRatings.add(queryRatings);
        }
        listener.onResponse(formattedRatings);
    }
}

