/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.plugin.insights.rules.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.Version;
import org.opensearch.core.common.Strings;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.tasks.resourcetracker.TaskResourceInfo;
import org.opensearch.core.tasks.resourcetracker.TaskResourceUsage;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.MediaTypeRegistry;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.plugin.insights.rules.model.AggregationType;
import org.opensearch.plugin.insights.rules.model.Attribute;
import org.opensearch.plugin.insights.rules.model.Measurement;
import org.opensearch.plugin.insights.rules.model.MetricType;
import org.opensearch.search.builder.SearchSourceBuilder;
import reactor.util.annotation.NonNull;

public class SearchQueryRecord
implements ToXContentObject,
Writeable {
    private static final Logger log = LogManager.getLogger(SearchQueryRecord.class);
    private final long timestamp;
    private final Map<MetricType, Measurement> measurements;
    private final Map<Attribute, Object> attributes;
    private final String id;
    public static final String TIMESTAMP = "timestamp";
    public static final String LATENCY = "latency";
    public static final String CPU = "cpu";
    public static final String MEMORY = "memory";
    public static final String SEARCH_TYPE = "search_type";
    public static final String SOURCE = "source";
    public static final String TOTAL_SHARDS = "total_shards";
    public static final String INDICES = "indices";
    public static final String PHASE_LATENCY_MAP = "phase_latency_map";
    public static final String NODE_ID = "node_id";
    public static final String TASK_RESOURCE_USAGES = "task_resource_usages";
    public static final String LABELS = "labels";
    public static final String GROUP_BY = "group_by";
    public static final String ID = "id";
    public static final String IS_CANCELLED = "is_cancelled";
    public static final String TOP_N_QUERY = "top_n_query";
    public static final String WLM_GROUP_ID = "wlm_group_id";
    public static final Map<String, Boolean> DEFAULT_TOP_N_QUERY_MAP = Collections.unmodifiableMap(Arrays.stream(MetricType.values()).collect(Collectors.toMap(MetricType::toString, metric -> Boolean.FALSE)));
    public static final String QUERY_GROUP_HASHCODE = "query_group_hashcode";
    public static final String MEASUREMENTS = "measurements";
    private String groupingId;
    public static final Attribute[] VERBOSE_ONLY_FIELDS = new Attribute[]{Attribute.TASK_RESOURCE_USAGES, Attribute.SOURCE, Attribute.PHASE_LATENCY_MAP};

    public SearchQueryRecord(StreamInput in) throws IOException, ClassCastException {
        this.timestamp = in.readLong();
        this.id = in.readString();
        if (in.getVersion().onOrAfter(Version.V_2_17_0)) {
            this.measurements = new LinkedHashMap<MetricType, Measurement>();
            in.readOrderedMap(MetricType::readFromStream, Measurement::readFromStream).forEach((metricType, measurement) -> this.measurements.put((MetricType)metricType, (Measurement)measurement));
            this.groupingId = null;
        } else {
            this.measurements = new HashMap<MetricType, Measurement>();
            in.readMap(MetricType::readFromStream, StreamInput::readGenericValue).forEach((metricType, o) -> {
                try {
                    this.measurements.put((MetricType)metricType, new Measurement(metricType.parseValue(o)));
                }
                catch (ClassCastException e) {
                    throw new ClassCastException("Error parsing value for metric type: " + String.valueOf(metricType));
                }
            });
        }
        this.attributes = Attribute.readAttributeMap(in);
    }

    public SearchQueryRecord(long timestamp, Map<MetricType, Measurement> measurements, Map<Attribute, Object> attributes) {
        this(timestamp, measurements, attributes, UUID.randomUUID().toString());
    }

    public SearchQueryRecord(long timestamp, Map<MetricType, Measurement> measurements, Map<Attribute, Object> attributes, String id) {
        if (measurements == null) {
            throw new IllegalArgumentException("Measurements cannot be null");
        }
        this.measurements = measurements;
        this.attributes = attributes;
        this.timestamp = timestamp;
        this.id = id;
    }

    public SearchQueryRecord(SearchQueryRecord other) {
        this.measurements = new HashMap<MetricType, Measurement>(other.measurements);
        this.attributes = new HashMap<Attribute, Object>(other.attributes);
        this.timestamp = other.timestamp;
        this.id = other.id;
        this.groupingId = other.groupingId;
    }

    public static SearchQueryRecord fromXContent(XContentParser parser) throws IOException {
        long timestamp = 0L;
        HashMap<MetricType, Measurement> measurements = new HashMap<MetricType, Measurement>();
        HashMap<Attribute, Object> attributes = new HashMap<Attribute, Object>();
        String id = null;
        parser.nextToken();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            try {
                switch (fieldName) {
                    case "timestamp": {
                        timestamp = parser.longValue();
                        break;
                    }
                    case "id": {
                        id = parser.text();
                        break;
                    }
                    case "latency": 
                    case "cpu": 
                    case "memory": {
                        MetricType metric = MetricType.fromString(fieldName);
                        measurements.put(metric, Measurement.fromXContent(parser));
                        break;
                    }
                    case "search_type": {
                        attributes.put(Attribute.SEARCH_TYPE, parser.text());
                        break;
                    }
                    case "group_by": {
                        attributes.put(Attribute.GROUP_BY, parser.text());
                        break;
                    }
                    case "query_group_hashcode": {
                        attributes.put(Attribute.QUERY_GROUP_HASHCODE, parser.text());
                        break;
                    }
                    case "source": {
                        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                        attributes.put(Attribute.SOURCE, SearchSourceBuilder.fromXContent((XContentParser)parser, (boolean)false));
                        break;
                    }
                    case "total_shards": {
                        attributes.put(Attribute.TOTAL_SHARDS, parser.intValue());
                        break;
                    }
                    case "indices": {
                        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                        ArrayList<String> indices = new ArrayList<String>();
                        while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                            indices.add(parser.text());
                        }
                        attributes.put(Attribute.INDICES, indices.toArray());
                        break;
                    }
                    case "phase_latency_map": {
                        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                        HashMap<String, Long> phaseLatencyMap = new HashMap<String, Long>();
                        while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                            String phase = parser.currentName();
                            parser.nextToken();
                            phaseLatencyMap.put(phase, parser.longValue());
                        }
                        attributes.put(Attribute.PHASE_LATENCY_MAP, phaseLatencyMap);
                        break;
                    }
                    case "node_id": {
                        attributes.put(Attribute.NODE_ID, parser.text());
                        break;
                    }
                    case "is_cancelled": {
                        attributes.put(Attribute.IS_CANCELLED, parser.booleanValue());
                        break;
                    }
                    case "wlm_group_id": {
                        attributes.put(Attribute.WLM_GROUP_ID, parser.text());
                        break;
                    }
                    case "task_resource_usages": {
                        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                        ArrayList<TaskResourceInfo> tasksResourceUsages = new ArrayList<TaskResourceInfo>();
                        while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                            String action = "";
                            long taskId = 0L;
                            long parentTaskId = 0L;
                            String nodeId = "";
                            TaskResourceUsage taskRU = new TaskResourceUsage(0L, 0L);
                            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                            while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                                String usageFields = parser.currentName();
                                parser.nextToken();
                                switch (usageFields) {
                                    case "action": {
                                        action = parser.text();
                                        break;
                                    }
                                    case "taskId": {
                                        taskId = parser.longValue();
                                        break;
                                    }
                                    case "parentTaskId": {
                                        parentTaskId = parser.longValue();
                                        break;
                                    }
                                    case "nodeId": {
                                        nodeId = parser.text();
                                        break;
                                    }
                                    case "taskResourceUsage": {
                                        taskRU = TaskResourceUsage.fromXContent((XContentParser)parser);
                                        break;
                                    }
                                }
                            }
                            TaskResourceInfo resourceInfo = new TaskResourceInfo(action, taskId, parentTaskId, nodeId, taskRU);
                            tasksResourceUsages.add(resourceInfo);
                        }
                        attributes.put(Attribute.TASK_RESOURCE_USAGES, tasksResourceUsages);
                        break;
                    }
                    case "labels": {
                        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                        HashMap<String, String> labels = new HashMap<String, String>();
                        while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                            parser.nextToken();
                            labels.put("X-Opaque-Id", parser.text());
                        }
                        attributes.put(Attribute.LABELS, labels);
                        break;
                    }
                    case "top_n_query": {
                        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                        HashMap<String, Boolean> metricTypeMap = new HashMap<String, Boolean>();
                        while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                            String metricName = parser.currentName();
                            parser.nextToken();
                            metricTypeMap.put(metricName, parser.booleanValue());
                        }
                        attributes.put(Attribute.TOP_N_QUERY, metricTypeMap);
                        break;
                    }
                }
            }
            catch (Exception e) {
                log.error("Error when parsing through search hit", (Throwable)e);
            }
        }
        return new SearchQueryRecord(timestamp, measurements, attributes, id);
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getId() {
        return this.id;
    }

    public Number getMeasurement(MetricType name) {
        if (!this.measurements.containsKey(name)) {
            return null;
        }
        return this.measurements.get(name).getMeasurement();
    }

    public void addMeasurement(MetricType metricType, Number numberToAdd) {
        if (!this.measurements.containsKey(metricType)) {
            this.measurements.put(metricType, new Measurement(numberToAdd));
            return;
        }
        this.measurements.get(metricType).addMeasurement(numberToAdd);
    }

    public void setMeasurementAggregation(MetricType name, AggregationType aggregationType) {
        if (!this.measurements.containsKey(name)) {
            return;
        }
        this.measurements.get(name).setAggregationType(aggregationType);
    }

    public Map<MetricType, Measurement> getMeasurements() {
        return this.measurements;
    }

    public Map<Attribute, Object> getAttributes() {
        return this.attributes;
    }

    public void addAttribute(Attribute attribute, Object value) {
        this.attributes.put(attribute, value);
    }

    public void setTopNTrue(@NonNull MetricType metricType) {
        HashMap<String, Boolean> topNMap = (HashMap<String, Boolean>)this.attributes.get((Object)Attribute.TOP_N_QUERY);
        if (topNMap == null) {
            topNMap = new HashMap<String, Boolean>(DEFAULT_TOP_N_QUERY_MAP);
            topNMap.put(metricType.toString(), true);
            this.attributes.put(Attribute.TOP_N_QUERY, topNMap);
        } else {
            topNMap.put(metricType.toString(), true);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(TIMESTAMP, this.timestamp);
        builder.field(ID, this.id);
        for (Map.Entry<Attribute, Object> entry : this.attributes.entrySet()) {
            if (entry.getKey() == Attribute.TOP_N_QUERY) continue;
            builder.field(entry.getKey().toString(), entry.getValue());
        }
        builder.startObject(MEASUREMENTS);
        for (Map.Entry<Enum, Object> entry : this.measurements.entrySet()) {
            builder.field(((MetricType)entry.getKey()).toString());
            ((Measurement)entry.getValue()).toXContent(builder, params);
        }
        builder.endObject();
        return builder.endObject();
    }

    public XContentBuilder toXContentForExport(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(TIMESTAMP, this.timestamp);
        builder.field(ID, this.id);
        for (Map.Entry<Attribute, Object> entry : this.attributes.entrySet()) {
            builder.field(entry.getKey().toString(), entry.getValue());
        }
        builder.startObject(MEASUREMENTS);
        for (Map.Entry<Enum, Object> entry : this.measurements.entrySet()) {
            builder.field(((MetricType)entry.getKey()).toString());
            ((Measurement)entry.getValue()).toXContent(builder, params);
        }
        builder.endObject();
        return builder.endObject();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeLong(this.timestamp);
        out.writeString(this.id);
        if (out.getVersion().onOrAfter(Version.V_2_17_0)) {
            out.writeMap(this.measurements, (stream, metricType) -> MetricType.writeTo(out, metricType), (stream, measurement) -> measurement.writeTo(out));
        } else {
            out.writeMap(this.measurements, (stream, metricType) -> MetricType.writeTo(out, metricType), StreamOutput::writeGenericValue);
        }
        out.writeMap(this.attributes, (stream, attribute) -> Attribute.writeTo(out, attribute), (stream, attributeValue) -> Attribute.writeValueTo(out, attributeValue));
    }

    public static int compare(SearchQueryRecord a, SearchQueryRecord b, MetricType metricType) {
        return metricType.compare(a.getMeasurement(metricType), b.getMeasurement(metricType));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SearchQueryRecord)) {
            return false;
        }
        SearchQueryRecord other = (SearchQueryRecord)o;
        return this.timestamp == other.getTimestamp() && this.measurements.equals(other.getMeasurements()) && this.attributes.size() == other.getAttributes().size();
    }

    public int hashCode() {
        return Objects.hash(this.timestamp, this.measurements, this.attributes);
    }

    public String toString() {
        return Strings.toString((MediaType)MediaTypeRegistry.JSON, (ToXContent)this);
    }

    public void setGroupingId(String groupingId) {
        this.groupingId = groupingId;
    }

    public String getGroupingId() {
        return this.groupingId;
    }

    public boolean isCancelled() {
        return (Boolean)this.attributes.getOrDefault((Object)Attribute.IS_CANCELLED, false);
    }

    public SearchQueryRecord copyAndSimplifyRecord() {
        SearchQueryRecord simplifiedRecord = new SearchQueryRecord(this);
        for (Attribute attribute : VERBOSE_ONLY_FIELDS) {
            simplifiedRecord.getAttributes().remove((Object)attribute);
        }
        return simplifiedRecord;
    }
}

