/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.util;

import java.io.IOException;
import org.bouncycastle.crypto.UpdateOutputStream;
import org.bouncycastle.crypto.fips.FipsOutputXOFCalculator;
import org.bouncycastle.crypto.fips.FipsSHS;
import org.bouncycastle.crypto.fips.FipsXOFOperatorFactory;
import org.bouncycastle.util.Arrays;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class Fingerprint {
    private static char[] encodingTable = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private final byte[] fingerprint;

    public Fingerprint(byte[] byArray) {
        this(byArray, 160);
    }

    public Fingerprint(byte[] byArray, int n) {
        this.fingerprint = Fingerprint.calculateFingerprint(byArray, n);
    }

    public byte[] getFingerprint() {
        return Arrays.clone(this.fingerprint);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i != this.fingerprint.length; ++i) {
            if (i > 0) {
                stringBuilder.append(":");
            }
            stringBuilder.append(encodingTable[this.fingerprint[i] >>> 4 & 0xF]);
            stringBuilder.append(encodingTable[this.fingerprint[i] & 0xF]);
        }
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Fingerprint) {
            return Arrays.areEqual(((Fingerprint)object).fingerprint, this.fingerprint);
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.fingerprint);
    }

    public static byte[] calculateFingerprint(byte[] byArray) {
        return Fingerprint.calculateFingerprint(byArray, 160);
    }

    public static byte[] calculateFingerprint(byte[] byArray, int n) {
        if (n % 8 != 0) {
            throw new IllegalArgumentException("bitLength must be a multiple of 8");
        }
        FipsSHS.XOFOperatorFactory<FipsSHS.Parameters> xOFOperatorFactory = new FipsSHS.XOFOperatorFactory<FipsSHS.Parameters>();
        FipsOutputXOFCalculator<FipsSHS.Parameters> fipsOutputXOFCalculator = ((FipsXOFOperatorFactory)xOFOperatorFactory).createOutputXOFCalculator(FipsSHS.SHAKE256);
        try {
            UpdateOutputStream updateOutputStream = fipsOutputXOFCalculator.getFunctionStream();
            updateOutputStream.write(byArray);
            updateOutputStream.close();
            return fipsOutputXOFCalculator.getFunctionOutput(n / 8);
        }
        catch (IOException iOException) {
            throw new IllegalStateException("finger print calculation failed");
        }
    }
}

