/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.internal.io;

import java.io.IOException;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.UpdateOutputStream;
import org.bouncycastle.crypto.internal.Xof;
import org.bouncycastle.crypto.internal.io.Utils;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class XofOutputStream
extends UpdateOutputStream {
    private final String algorithmName;
    private final boolean isApprovedMode;
    protected Xof digest;

    public XofOutputStream(Xof xof) {
        this.algorithmName = xof.getAlgorithmName();
        this.isApprovedMode = CryptoServicesRegistrar.isInApprovedOnlyMode();
        this.digest = xof;
    }

    @Override
    public void write(int n) throws IOException {
        Utils.approvedModeCheck(this.isApprovedMode, this.algorithmName);
        this.digest.update((byte)n);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        Utils.approvedModeCheck(this.isApprovedMode, this.algorithmName);
        this.digest.update(byArray, n, n2);
    }

    public final int getOutput(byte[] byArray, int n, int n2) {
        Utils.approvedModeCheck(this.isApprovedMode, this.algorithmName);
        return this.digest.doOutput(byArray, n, n2);
    }

    public final int getFinalOutput(byte[] byArray, int n, int n2) {
        Utils.approvedModeCheck(this.isApprovedMode, this.algorithmName);
        return this.digest.doFinal(byArray, n, n2);
    }

    public void reset() {
        Utils.approvedModeCheck(this.isApprovedMode, this.algorithmName);
        this.digest.reset();
    }
}

