/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.fips;

import java.util.HashMap;
import java.util.Map;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.EntropySource;
import org.bouncycastle.crypto.fips.DRBGUtils;
import org.bouncycastle.crypto.fips.FipsAlgorithm;
import org.bouncycastle.crypto.fips.FipsStatus;
import org.bouncycastle.crypto.fips.FipsUnapprovedOperationError;
import org.bouncycastle.crypto.fips.SP80090DRBG;
import org.bouncycastle.crypto.fips.VariantInternalKatTest;
import org.bouncycastle.crypto.internal.BlockCipher;
import org.bouncycastle.crypto.internal.params.KeyParameter;
import org.bouncycastle.crypto.internal.params.KeyParameterImpl;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Properties;
import org.bouncycastle.util.encoders.Hex;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class CTRSP800DRBG
implements SP80090DRBG {
    private static final long TDEA_RESEED_MAX = 0x80000000L;
    private static final long AES_RESEED_MAX = 0x800000000000L;
    private static final int TDEA_MAX_BITS_REQUEST = 4096;
    private static final int AES_MAX_BITS_REQUEST = 262144;
    private static final Map<String, byte[][]> kats = new HashMap<String, byte[][]>();
    private static final Map<String, byte[][]> reseedKats = new HashMap<String, byte[][]>();
    private static final Map<String, byte[][]> reseedValues = new HashMap<String, byte[][]>();
    private EntropySource _entropySource;
    private BlockCipher _engine;
    private int _keySizeInBits;
    private int _seedLength;
    private boolean _isTDEA = false;
    private int _securityStrength;
    private WorkingBuffer workingBuf = new WorkingBuffer();
    private long _reseedCounter = 0L;
    private byte[] _personalizationString;
    private static final byte[] K_BITS;

    public CTRSP800DRBG(BlockCipher blockCipher, int n, int n2, EntropySource entropySource, byte[] byArray, byte[] byArray2) {
        this._engine = blockCipher;
        this._keySizeInBits = n;
        this._seedLength = n + blockCipher.getBlockSize() * 8;
        this._isTDEA = this.isTDEA(blockCipher);
        if (!FipsStatus.isBooting() && this._isTDEA && CryptoServicesRegistrar.isInApprovedOnlyMode() && !Properties.isOverrideSet("org.bouncycastle.tripledes.allow_drbg")) {
            throw new FipsUnapprovedOperationError("Triple-DES CTRDRBG disallowed");
        }
        this.init(n2, entropySource, byArray, byArray2);
    }

    private void init(int n, EntropySource entropySource, byte[] byArray, byte[] byArray2) {
        if (n > 256) {
            throw new IllegalArgumentException("Requested security strength is not supported by the derivation function");
        }
        if (this.getMaxSecurityStrength(this._engine, this._keySizeInBits) < n) {
            throw new IllegalArgumentException("Requested security strength is not supported by the derivation function");
        }
        if (entropySource.entropySize() < n) {
            throw new IllegalArgumentException("Not enough entropy for security strength required");
        }
        this._entropySource = entropySource;
        this._securityStrength = n;
        this.CTR_DRBG_Instantiate_algorithm(byArray, byArray2);
    }

    private void CTR_DRBG_Instantiate_algorithm(byte[] byArray, byte[] byArray2) {
        this._personalizationString = Arrays.clone(byArray);
        byte[] byArray3 = this.getEntropy();
        byte[] byArray4 = Arrays.concatenate(byArray3, byArray2, byArray);
        Arrays.fill(byArray3, (byte)0);
        byte[] byArray5 = this.Block_Cipher_df(byArray4, this._seedLength);
        Arrays.fill(byArray4, (byte)0);
        int n = this._engine.getBlockSize();
        WorkingBuffer.access$102(this.workingBuf, new byte[this.getExpandedKeySizeInBytes()]);
        WorkingBuffer.access$202(this.workingBuf, new byte[n]);
        this.expandKey(this.workingBuf._Key);
        this.CTR_DRBG_Update(byArray5);
        Arrays.fill(byArray5, (byte)0);
        this._reseedCounter = 1L;
    }

    private void CTR_DRBG_Update(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length];
        byte[] byArray3 = new byte[this._engine.getBlockSize()];
        int n = 0;
        int n2 = this._engine.getBlockSize();
        this._engine.init(true, new KeyParameterImpl(this.workingBuf._Key));
        while (n * n2 < byArray.length) {
            this.addOneTo(this.workingBuf._V);
            this._engine.processBlock(this.workingBuf._V, 0, byArray3, 0);
            int n3 = byArray2.length - n * n2 > n2 ? n2 : byArray2.length - n * n2;
            System.arraycopy(byArray3, 0, byArray2, n * n2, n3);
            ++n;
        }
        Arrays.fill(byArray3, (byte)0);
        this.XOR(byArray2, byArray, byArray2, 0);
        System.arraycopy(byArray2, 0, this.workingBuf._Key, 0, this.getKeySizeInBytes());
        System.arraycopy(byArray2, this.getKeySizeInBytes(), this.workingBuf._V, 0, this.workingBuf._V.length);
        Arrays.fill(byArray2, (byte)0);
        this.expandKey(this.workingBuf._Key);
    }

    private void CTR_DRBG_Reseed_algorithm(byte[] byArray) {
        byte[] byArray2 = this.getEntropy();
        byte[] byArray3 = Arrays.concatenate(byArray2, byArray);
        Arrays.fill(byArray2, (byte)0);
        byte[] byArray4 = this.Block_Cipher_df(byArray3, this._seedLength);
        Arrays.fill(byArray3, (byte)0);
        this.CTR_DRBG_Update(byArray4);
        Arrays.fill(byArray4, (byte)0);
        this._reseedCounter = 1L;
    }

    private void XOR(byte[] byArray, byte[] byArray2, byte[] byArray3, int n) {
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (byte)(byArray2[i] ^ byArray3[i + n]);
        }
    }

    private void addOneTo(byte[] byArray) {
        int n = 1;
        for (int i = 1; i <= byArray.length; ++i) {
            int n2 = (byArray[byArray.length - i] & 0xFF) + n;
            n = n2 > 255 ? 1 : 0;
            byArray[byArray.length - i] = (byte)n2;
        }
    }

    private byte[] Block_Cipher_df(byte[] byArray, int n) {
        int n2 = this._engine.getBlockSize();
        int n3 = byArray.length;
        int n4 = n / 8;
        int n5 = 8 + n3 + 1;
        int n6 = (n5 + n2 - 1) / n2 * n2;
        byte[] byArray2 = new byte[n6];
        this.copyIntToByteArray(byArray2, n3, 0);
        this.copyIntToByteArray(byArray2, n4, 4);
        System.arraycopy(byArray, 0, byArray2, 8, n3);
        byArray2[8 + n3] = -128;
        byte[] byArray3 = new byte[this.getKeySizeInBytes() + n2];
        byte[] byArray4 = new byte[n2];
        byte[] byArray5 = new byte[n2];
        int n7 = 0;
        byte[] byArray6 = new byte[this.getExpandedKeySizeInBytes()];
        System.arraycopy(K_BITS, 0, byArray6, 0, this.getKeySizeInBytes());
        this.expandKey(byArray6);
        KeyParameterImpl keyParameterImpl = new KeyParameterImpl(byArray6);
        while (n7 * n2 * 8 < this._keySizeInBits + n2 * 8) {
            this.copyIntToByteArray(byArray5, n7, 0);
            this.BCC(byArray4, keyParameterImpl, byArray5, byArray2);
            int n8 = byArray3.length - n7 * n2 > n2 ? n2 : byArray3.length - n7 * n2;
            System.arraycopy(byArray4, 0, byArray3, n7 * n2, n8);
            ++n7;
        }
        Arrays.fill(byArray2, (byte)0);
        Arrays.fill(byArray4, (byte)0);
        Arrays.fill(byArray5, (byte)0);
        byte[] byArray7 = new byte[n2];
        System.arraycopy(byArray3, 0, byArray6, 0, this.getKeySizeInBytes());
        System.arraycopy(byArray3, this.getKeySizeInBytes(), byArray7, 0, byArray7.length);
        Arrays.fill(byArray3, (byte)0);
        this.expandKey(byArray6);
        byArray3 = new byte[n / 2];
        n7 = 0;
        this._engine.init(true, new KeyParameterImpl(byArray6));
        while (n7 * n2 < byArray3.length) {
            this._engine.processBlock(byArray7, 0, byArray7, 0);
            int n9 = byArray3.length - n7 * n2 > n2 ? n2 : byArray3.length - n7 * n2;
            System.arraycopy(byArray7, 0, byArray3, n7 * n2, n9);
            ++n7;
        }
        Arrays.fill(byArray7, (byte)0);
        Arrays.fill(byArray6, (byte)0);
        return byArray3;
    }

    private void BCC(byte[] byArray, KeyParameter keyParameter, byte[] byArray2, byte[] byArray3) {
        int n = this._engine.getBlockSize();
        byte[] byArray4 = new byte[n];
        int n2 = byArray3.length / n;
        byte[] byArray5 = new byte[n];
        this._engine.init(true, keyParameter);
        this._engine.processBlock(byArray2, 0, byArray4, 0);
        for (int i = 0; i < n2; ++i) {
            this.XOR(byArray5, byArray4, byArray3, i * n);
            this._engine.processBlock(byArray5, 0, byArray4, 0);
        }
        System.arraycopy(byArray4, 0, byArray, 0, byArray.length);
    }

    private void copyIntToByteArray(byte[] byArray, int n, int n2) {
        byArray[n2 + 0] = (byte)(n >> 24);
        byArray[n2 + 1] = (byte)(n >> 16);
        byArray[n2 + 2] = (byte)(n >> 8);
        byArray[n2 + 3] = (byte)n;
    }

    @Override
    public int getBlockSize() {
        return this.workingBuf._V.length * 8;
    }

    @Override
    public int getSecurityStrength() {
        return this._securityStrength;
    }

    @Override
    public byte[] getPersonalizationString() {
        return Arrays.clone(this._personalizationString);
    }

    @Override
    public int generate(byte[] byArray, byte[] byArray2, boolean bl) {
        byte[] byArray3;
        if (bl) {
            this.CTR_DRBG_Reseed_algorithm(byArray2);
            byArray2 = null;
        }
        if (this._isTDEA) {
            if (this._reseedCounter > 0x80000000L) {
                return -1;
            }
            if (DRBGUtils.isTooLarge(byArray, 512)) {
                throw new IllegalArgumentException("Number of bits per request limited to 4096");
            }
        } else {
            if (this._reseedCounter > 0x800000000000L) {
                return -1;
            }
            if (DRBGUtils.isTooLarge(byArray, 32768)) {
                throw new IllegalArgumentException("Number of bits per request limited to 262144");
            }
        }
        if (byArray2 != null) {
            byArray3 = this.Block_Cipher_df(byArray2, this._seedLength);
            this.CTR_DRBG_Update(byArray3);
        } else {
            byArray3 = new byte[this._seedLength];
        }
        byte[] byArray4 = new byte[this.workingBuf._V.length];
        this._engine.init(true, new KeyParameterImpl(this.workingBuf._Key));
        for (int i = 0; i <= byArray.length / byArray4.length; ++i) {
            int n;
            int n2 = n = byArray.length - i * byArray4.length > byArray4.length ? byArray4.length : byArray.length - i * this.workingBuf._V.length;
            if (n == 0) continue;
            this.addOneTo(this.workingBuf._V);
            this._engine.processBlock(this.workingBuf._V, 0, byArray4, 0);
            System.arraycopy(byArray4, 0, byArray, i * byArray4.length, n);
        }
        this.CTR_DRBG_Update(byArray3);
        Arrays.fill(byArray3, (byte)0);
        ++this._reseedCounter;
        return byArray.length * 8;
    }

    @Override
    public void reseed(byte[] byArray) {
        this.CTR_DRBG_Reseed_algorithm(byArray);
    }

    private byte[] getEntropy() {
        byte[] byArray = this._entropySource.getEntropy();
        if (byArray == null || byArray.length < (this._securityStrength + 7) / 8) {
            throw new IllegalStateException("Insufficient entropy provided by entropy source");
        }
        return byArray;
    }

    @Override
    public VariantInternalKatTest createSelfTest(FipsAlgorithm fipsAlgorithm) {
        return new VariantInternalKatTest(fipsAlgorithm){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            void evaluate() throws Exception {
                byte[] byArray = CTRSP800DRBG.this.workingBuf._Key;
                byte[] byArray2 = CTRSP800DRBG.this.workingBuf._V;
                byte[] byArray3 = CTRSP800DRBG.this._personalizationString;
                long l = CTRSP800DRBG.this._reseedCounter;
                EntropySource entropySource = CTRSP800DRBG.this._entropySource;
                try {
                    int n;
                    byte[] byArray4;
                    byte[] byArray5;
                    block16: {
                        block15: {
                            block14: {
                                byArray5 = Hex.decode("404142434445464748494A4B4C4D4E4F505152535455565758595A5B5C5D5E5F606162636465666768696A6B6C6D6E6F70717273747576");
                                byArray4 = Hex.decode("2021222324");
                                n = CTRSP800DRBG.this.getMaxSecurityStrength(CTRSP800DRBG.this._engine, CTRSP800DRBG.this._keySizeInBits);
                                byte[][] byArray6 = (byte[][])kats.get(this.algorithm.getName());
                                CTRSP800DRBG.this.init(CTRSP800DRBG.this._securityStrength, new DRBGUtils.KATEntropyProvider().get(n), byArray5, byArray4);
                                byte[] byArray7 = new byte[byArray6[0].length];
                                CTRSP800DRBG.this.generate(byArray7, null, true);
                                if (!Arrays.areEqual(byArray6[0], byArray7)) {
                                    this.fail("DRBG Block 1 KAT failure");
                                }
                                byArray7 = new byte[byArray6[1].length];
                                CTRSP800DRBG.this.generate(byArray7, null, true);
                                if (!Arrays.areEqual(byArray6[1], byArray7)) {
                                    this.fail("DRBG Block 2 KAT failure");
                                }
                                try {
                                    CTRSP800DRBG.this.init(CTRSP800DRBG.this._securityStrength, new DRBGUtils.LyingEntropySource(n), byArray5, byArray4);
                                    this.fail("DRBG LyingEntropySource not detected in init");
                                }
                                catch (IllegalStateException illegalStateException) {
                                    if (illegalStateException.getMessage().equals("Insufficient entropy provided by entropy source")) break block14;
                                    this.fail("DRBG self test failed init entropy check");
                                }
                            }
                            try {
                                CTRSP800DRBG.this.init(CTRSP800DRBG.this._securityStrength, new DRBGUtils.LyingEntropySource(20), byArray5, byArray4);
                                this.fail("DRBG insufficient EntropySource not detected");
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                if (illegalArgumentException.getMessage().equals("Not enough entropy for security strength required")) break block15;
                                this.fail("DRBG self test failed init entropy check");
                            }
                        }
                        try {
                            CTRSP800DRBG.this._entropySource = new DRBGUtils.LyingEntropySource(n);
                            CTRSP800DRBG.this.reseed(null);
                            this.fail("DRBG LyingEntropySource not detected in reseed");
                        }
                        catch (IllegalStateException illegalStateException) {
                            if (illegalStateException.getMessage().equals("Insufficient entropy provided by entropy source")) break block16;
                            this.fail("DRBG self test failed reseed entropy check");
                        }
                    }
                    try {
                        CTRSP800DRBG.this.init(n + 1, new DRBGUtils.KATEntropyProvider().get(n), byArray5, byArray4);
                        this.fail("DRBG successful initialise with too high security strength");
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        if (!illegalArgumentException.getMessage().equals("Requested security strength is not supported by the derivation function")) {
                            this.fail("DRBG self test failed init security strength check");
                        }
                    }
                }
                finally {
                    WorkingBuffer.access$102(CTRSP800DRBG.this.workingBuf, byArray);
                    WorkingBuffer.access$202(CTRSP800DRBG.this.workingBuf, byArray2);
                    CTRSP800DRBG.access$402(CTRSP800DRBG.this, byArray3);
                    CTRSP800DRBG.this._reseedCounter = l;
                    CTRSP800DRBG.this._entropySource = entropySource;
                }
            }
        };
    }

    @Override
    public VariantInternalKatTest createReseedSelfTest(FipsAlgorithm fipsAlgorithm) {
        return new VariantInternalKatTest(fipsAlgorithm){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            void evaluate() throws Exception {
                byte[] byArray = CTRSP800DRBG.this.workingBuf._Key;
                byte[] byArray2 = CTRSP800DRBG.this.workingBuf._V;
                byte[] byArray3 = CTRSP800DRBG.this._personalizationString;
                long l = CTRSP800DRBG.this._reseedCounter;
                EntropySource entropySource = CTRSP800DRBG.this._entropySource;
                try {
                    byte[] byArray4 = Hex.decode("404142434445464748494A4B4C4D4E4F505152535455565758595A5B5C5D5E5F606162636465666768696A6B6C6D6E6F70717273747576");
                    int n = CTRSP800DRBG.this.getMaxSecurityStrength(CTRSP800DRBG.this._engine, CTRSP800DRBG.this._keySizeInBits);
                    byte[][] byArray5 = (byte[][])reseedKats.get(this.algorithm.getName());
                    byte[][] byArray6 = (byte[][])reseedValues.get(this.algorithm.getName());
                    byte[] byArray7 = byArray6[0];
                    WorkingBuffer.access$102(CTRSP800DRBG.this.workingBuf, new byte[CTRSP800DRBG.this.getExpandedKeySizeInBytes()]);
                    System.arraycopy(byArray7, 0, CTRSP800DRBG.this.workingBuf._Key, 0, byArray7.length);
                    CTRSP800DRBG.this.expandKey(CTRSP800DRBG.this.workingBuf._Key);
                    WorkingBuffer.access$202(CTRSP800DRBG.this.workingBuf, Arrays.clone(byArray6[1]));
                    CTRSP800DRBG.this._entropySource = new DRBGUtils.KATEntropyProvider().get(n);
                    CTRSP800DRBG.this.reseed(byArray4);
                    if (CTRSP800DRBG.this._reseedCounter != 1L) {
                        this.fail("DRBG reseedCounter failed to reset");
                    }
                    byArray7 = new byte[byArray5[0].length];
                    CTRSP800DRBG.this.generate(byArray7, null, false);
                    if (!Arrays.areEqual(byArray5[0], byArray7)) {
                        this.fail("DRBG Block 1 reseed KAT failure");
                    }
                    byArray7 = new byte[byArray5[1].length];
                    CTRSP800DRBG.this.generate(byArray7, null, false);
                    if (!Arrays.areEqual(byArray5[1], byArray7)) {
                        this.fail("DRBG Block 2 reseed KAT failure");
                    }
                    try {
                        CTRSP800DRBG.this._entropySource = new DRBGUtils.LyingEntropySource(n);
                        CTRSP800DRBG.this.reseed(null);
                        this.fail("DRBG LyingEntropySource not detected");
                    }
                    catch (IllegalStateException illegalStateException) {
                        if (!illegalStateException.getMessage().equals("Insufficient entropy provided by entropy source")) {
                            this.fail("DRBG self test failed reseed entropy check");
                        }
                    }
                }
                finally {
                    WorkingBuffer.access$102(CTRSP800DRBG.this.workingBuf, byArray);
                    WorkingBuffer.access$202(CTRSP800DRBG.this.workingBuf, byArray2);
                    CTRSP800DRBG.access$402(CTRSP800DRBG.this, byArray3);
                    CTRSP800DRBG.this._reseedCounter = l;
                    CTRSP800DRBG.this._entropySource = entropySource;
                }
            }
        };
    }

    private boolean isTDEA(BlockCipher blockCipher) {
        return blockCipher.getAlgorithmName().equals("DESede") || blockCipher.getAlgorithmName().equals("TDEA");
    }

    private int getMaxSecurityStrength(BlockCipher blockCipher, int n) {
        if (this.isTDEA(blockCipher) && n == 168) {
            return 112;
        }
        if (blockCipher.getAlgorithmName().equals("AES")) {
            return n;
        }
        return -1;
    }

    private void expandKey(byte[] byArray) {
        if (this._isTDEA) {
            byte[] byArray2 = new byte[24];
            this.padKey(byArray, 0, byArray2, 0);
            this.padKey(byArray, 7, byArray2, 8);
            this.padKey(byArray, 14, byArray2, 16);
            System.arraycopy(byArray2, 0, byArray, 0, 24);
            Arrays.fill(byArray2, (byte)0);
        }
    }

    private int getExpandedKeySizeInBytes() {
        return this._isTDEA ? 24 : this.getKeySizeInBytes();
    }

    private int getKeySizeInBytes() {
        return (this._keySizeInBits + 7) / 8;
    }

    private void padKey(byte[] byArray, int n, byte[] byArray2, int n2) {
        byArray2[n2 + 0] = (byte)(byArray[n + 0] & 0xFE);
        byArray2[n2 + 1] = (byte)(byArray[n + 0] << 7 | (byArray[n + 1] & 0xFC) >>> 1);
        byArray2[n2 + 2] = (byte)(byArray[n + 1] << 6 | (byArray[n + 2] & 0xF8) >>> 2);
        byArray2[n2 + 3] = (byte)(byArray[n + 2] << 5 | (byArray[n + 3] & 0xF0) >>> 3);
        byArray2[n2 + 4] = (byte)(byArray[n + 3] << 4 | (byArray[n + 4] & 0xE0) >>> 4);
        byArray2[n2 + 5] = (byte)(byArray[n + 4] << 3 | (byArray[n + 5] & 0xC0) >>> 5);
        byArray2[n2 + 6] = (byte)(byArray[n + 5] << 2 | (byArray[n + 6] & 0x80) >>> 6);
        byArray2[n2 + 7] = (byte)(byArray[n + 6] << 1);
        for (int i = n2; i <= n2 + 7; ++i) {
            byte by = byArray2[i];
            byArray2[i] = (byte)(by & 0xFE | (by >> 1 ^ by >> 2 ^ by >> 3 ^ by >> 4 ^ by >> 5 ^ by >> 6 ^ by >> 7 ^ 1) & 1);
        }
    }

    static /* synthetic */ byte[] access$402(CTRSP800DRBG cTRSP800DRBG, byte[] byArray) {
        cTRSP800DRBG._personalizationString = byArray;
        return byArray;
    }

    static {
        kats.put("TRIPLEDES", new byte[][]{Hex.decode("09b2711937c5fc9fdf6f7e070625b41f74916ddb93b9f7a7c90091f86cdf2003a052e8d17bc37d86"), Hex.decode("b5c3c811e17247830be34f9461bf991401edbe99bc0dd6668b5d3f2501d2659bf99da71e38979e75")});
        kats.put("AES-128", new byte[][]{Hex.decode("314069e227a6e4c59c402ac0f9189f921ef19673d16b3fd401ded2f3b8b1d19a1c3b11f948ba8e2a"), Hex.decode("36ccfd81909865e88091079bbd408e9943dd3bedf8e7521e43cd639fed11f482bb17a794ed0265f1")});
        kats.put("AES-192", new byte[][]{Hex.decode("7ee353634fb8bd87bd4a2b292db7a049615bb8ae6a887efb8e81af7124453dac21949cfb51dd065f"), Hex.decode("8861d7165d9983a987e4ac39b9013ae41377f2134e5c7b57d6f8a3653e0ee616f0ddc9e11d85a8fd")});
        kats.put("AES-256", new byte[][]{Hex.decode("f5771b72bb3c3ceeea5d4327159f7bcf5d3aed67adaa039528b3d5f846961700734ac1aa5d401709"), Hex.decode("a6b09617644ea00b797ce09060d23682b89a09c293fb5fac71ba77943421a7559557bd957bce64c9")});
        reseedValues.put("TRIPLEDES", new byte[][]{Hex.decode("0102030405060708090a0b0c0d0e0f101112131415"), Hex.decode("0807060504030201")});
        reseedValues.put("AES-128", new byte[][]{Hex.decode("0102030405060708090a0b0c0d0e0f10"), Hex.decode("100f0e0d0c0b0a090807060504030201")});
        reseedValues.put("AES-192", new byte[][]{Hex.decode("0102030405060708090a0b0c0d0e0f101112131415161718"), Hex.decode("100f0e0d0c0b0a090807060504030201")});
        reseedValues.put("AES-256", new byte[][]{Hex.decode("0102030405060708090a0b0c0d0e0f100102030405060708090a0b0c0d0e0f10"), Hex.decode("100f0e0d0c0b0a090807060504030201")});
        reseedKats.put("TRIPLEDES", new byte[][]{Hex.decode("48ce7cefb4ec0f4a5a3b50c09a309675a9827404e01e0adff50a6d8d895d0308f6fffaf5e8159a8a"), Hex.decode("19d8a900cf51f131070cbbf22a7028edb42d79c836feb0a270e6703bf7d64ffa7bab66922bc7597b")});
        reseedKats.put("AES-128", new byte[][]{Hex.decode("af649344a18257a1448aca5e7014c784cf01618ac354a4dd9b63b83f10fd4d31eff645b737619fd7"), Hex.decode("c63ff00c3f966108d53270633a945b87fd11d8344946589f1533617323895593229d060c0b25f53e")});
        reseedKats.put("AES-192", new byte[][]{Hex.decode("544c683bd1538f349b62135813dc752ee329244ec83e037039dc35beb12a28ea505cdb81ec4bd61e"), Hex.decode("58dda13ba129e5ea009c8d0dac7cc5c998b84d52f759acfffa9bdd08d7cdbedc185114e270679e99")});
        reseedKats.put("AES-256", new byte[][]{Hex.decode("e20e7e3e5fc4876ac58b412c20b0cd173e0c934762f32d558f84c7a533efcee1b1571253afe18551"), Hex.decode("bae2554712e8143be922d97125c7b88fd768dd7c359fc1fe413f6ba5cb83892fe4a407c8aec04762")});
        K_BITS = Hex.decode("000102030405060708090A0B0C0D0E0F101112131415161718191A1B1C1D1E1F");
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static class WorkingBuffer {
        private byte[] _Key;
        private byte[] _V;

        private WorkingBuffer() {
        }

        protected void finalize() throws Throwable {
            try {
                Arrays.fill(this._Key, (byte)0);
                Arrays.fill(this._V, (byte)0);
            }
            finally {
                super.finalize();
            }
        }

        static /* synthetic */ byte[] access$102(WorkingBuffer workingBuffer, byte[] byArray) {
            workingBuffer._Key = byArray;
            return byArray;
        }

        static /* synthetic */ byte[] access$202(WorkingBuffer workingBuffer, byte[] byArray) {
            workingBuffer._V = byArray;
            return byArray;
        }
    }
}

