/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.action.memorycontainer.memory;

import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.json.JsonXContent;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.ml.action.memorycontainer.memory.FactSearchResult;
import org.opensearch.ml.common.FunctionName;
import org.opensearch.ml.common.dataset.MLInputDataset;
import org.opensearch.ml.common.dataset.remote.RemoteInferenceInputDataSet;
import org.opensearch.ml.common.input.MLInput;
import org.opensearch.ml.common.memorycontainer.MemoryConfiguration;
import org.opensearch.ml.common.memorycontainer.MemoryDecision;
import org.opensearch.ml.common.memorycontainer.MemoryDecisionRequest;
import org.opensearch.ml.common.memorycontainer.MemoryStrategy;
import org.opensearch.ml.common.memorycontainer.MemoryStrategyType;
import org.opensearch.ml.common.output.MLOutput;
import org.opensearch.ml.common.output.model.ModelTensor;
import org.opensearch.ml.common.output.model.ModelTensorOutput;
import org.opensearch.ml.common.output.model.ModelTensors;
import org.opensearch.ml.common.transport.MLTaskResponse;
import org.opensearch.ml.common.transport.memorycontainer.memory.MessageInput;
import org.opensearch.ml.common.transport.prediction.MLPredictionTaskAction;
import org.opensearch.ml.common.transport.prediction.MLPredictionTaskRequest;
import org.opensearch.ml.common.utils.StringUtils;
import org.opensearch.ml.engine.processor.MLProcessorType;
import org.opensearch.ml.engine.processor.ProcessorChain;
import org.opensearch.ml.helper.MemoryContainerHelper;
import org.opensearch.transport.client.Client;

public class MemoryProcessingService {
    @Generated
    private static final Logger log = LogManager.getLogger(MemoryProcessingService.class);
    private final Client client;
    private final NamedXContentRegistry xContentRegistry;
    private final ProcessorChain extractJsonProcessorChain;
    private final MemoryContainerHelper memoryContainerHelper;

    public MemoryProcessingService(Client client, NamedXContentRegistry xContentRegistry, MemoryContainerHelper memoryContainerHelper) {
        this.client = client;
        this.xContentRegistry = xContentRegistry;
        ArrayList<Map<String, String>> processorConfigs = new ArrayList<Map<String, String>>();
        processorConfigs.add(Map.of("type", MLProcessorType.EXTRACT_JSON.getValue(), "extract_type", "object"));
        this.extractJsonProcessorChain = new ProcessorChain(processorConfigs);
        this.memoryContainerHelper = memoryContainerHelper;
    }

    public void runMemoryStrategy(MemoryStrategy strategy, List<MessageInput> messages, MemoryConfiguration memoryConfig, ActionListener<List<String>> listener) {
        MemoryStrategyType type = strategy.getType();
        if (type == MemoryStrategyType.SEMANTIC || type == MemoryStrategyType.USER_PREFERENCE || type == MemoryStrategyType.SUMMARY) {
            this.extractFactsFromConversation(messages, strategy, memoryConfig, listener);
        } else {
            log.error("Unsupported memory strategy type: {}", (Object)type);
            listener.onFailure((Exception)new IllegalArgumentException("Unsupported memory strategy type: " + String.valueOf(type)));
        }
    }

    public void extractFactsFromConversation(List<MessageInput> messages, MemoryStrategy strategy, MemoryConfiguration memoryConfig, ActionListener<List<String>> listener) {
        String llmModelId = this.getEffectiveLlmId(strategy, memoryConfig);
        if (llmModelId == null) {
            log.debug("No LLM model configured for fact extraction, skipping");
            listener.onResponse(new ArrayList());
            return;
        }
        boolean isOverride = strategy != null && strategy.getStrategyConfig() != null && strategy.getStrategyConfig().containsKey("llm_id");
        log.debug("Extracting long-term memory facts using LLM model: {} (strategy: {}, source: {})", (Object)llmModelId, strategy != null ? strategy.getType() : "unknown", (Object)(isOverride ? "strategy-override" : "container-config"));
        HashMap<String, Object> stringParameters = new HashMap<String, Object>();
        MemoryStrategyType type = strategy.getType();
        String defaultPrompt = type == MemoryStrategyType.USER_PREFERENCE ? "<ROLE>You are a USER PREFERENCE EXTRACTOR, not a chat assistant. Your only job is to output JSON facts. Do not answer questions, make suggestions, ask follow-ups, or perform actions.</ROLE>\n\n<SCOPE>\n\u2022 Extract preferences only from USER messages. Assistant messages are context only.\n\u2022 Explicit: user states a preference (\"I prefer/like/dislike ...\"; \"always/never/usually ...\"; \"set X to Y\"; \"run X when Y\").\n\u2022 Implicit: infer only with strong signals: repeated choices (>=2) or clear habitual language. Do not infer from a single one-off.\n</SCOPE>\n\n<EXTRACT>\n\u2022 Specific, actionable, likely long-term preferences (likes/dislikes/choices/settings). Ignore non-preferences.\n</EXTRACT>\n\n<STYLE & RULES>\n\u2022 One sentence per preference; merge related details; no duplicates; preserve user wording and numbers; avoid relative time; keep each fact < 350 chars.\n\u2022 Format: \"Preference sentence. Context: <why/how>. Categories: cat1,cat2\"\n</STYLE & RULES>\n\n<OUTPUT>\nReturn ONLY one minified JSON object exactly as {\"facts\":[\"Preference sentence. Context: <why/how>. Categories: cat1,cat2\"]}. If none, return {\"facts\":[]}. The first character MUST be '{' and the last MUST be '}'. No preambles, explanations, code fences, XML, or other text.\n</OUTPUT>" : (type == MemoryStrategyType.SUMMARY ? "<system_prompt><description>You will be given a text block and a list of summaries you previously generated when available.</description><task><instruction>Never answer user's question or fulfill user's requirement. You are a summary generator, not a helpful assistant.</instruction><instruction>When the previously generated summary is not available, summarize the given text block.</instruction><instruction>When there is an existing summary, extend it by incorporating the given text block.</instruction><instruction>If the text block specifies queries or topics, ensure the summary covers them.</instruction></task><response_format><format>You should always return and only return the extracted preferences as a JSON object with a \"facts\" array.</format><example>{ \"facts\": [\"The system shows a list of Elasticsearch/OpenSearch indices with their health status, document count, and size information\", \"5 indices shown have 'red' health status, 8 of them in 'yellow', and 13 of them are in 'green' health status\", \"The doc is a log from a web application, dated from 2020-01-01T00:00:00 to 2020-01-31T23:59:59\"]}</example></response_format></system_prompt>" : "<ROLE>You are a universal semantic fact extraction agent. Write FULL-SENTENCE, self-contained facts suitable for long-term memory.</ROLE>\n\n<SCOPE>\n\u2022 Include facts from USER messages.\n\u2022 Also include ASSISTANT-authored statements that are clearly presented as conclusions/results/validated findings (e.g., root cause, quantified impact, confirmed fix).\n\u2022 Ignore ASSISTANT questions, hypotheses, tentative language, brainstorming, instructions, or tool prompts unless explicitly confirmed as outcomes.\n</SCOPE>\n\n<STYLE & RULES>\n\u2022 One sentence per fact; merge closely related details (metrics, entities, causes, scope) into the same sentence.\n\u2022 Do NOT start with \"User\" or pronouns.\n\u2022 Prefer absolute over relative time; if only relative (e.g., \"yesterday\"), omit it rather than guessing.\n\u2022 Preserve terminology, names, numbers, and units; avoid duplicates and chit-chat.\n\u2022 No speculation or hedging unless those words appear verbatim in the source.\n</STYLE & RULES>\n\n<OUTPUT>\nReturn ONLY a single JSON object on one line, minified exactly as {\"facts\":[\"...\"]} (array of strings only; no other keys). No code fences, no newlines/tabs, and no spaces after commas or colons. If no meaningful facts, return {\"facts\":[]}.\n</OUTPUT>");
        if (strategy.getStrategyConfig() == null || strategy.getStrategyConfig().isEmpty()) {
            stringParameters.put("system_prompt", defaultPrompt);
        } else {
            Object customPrompt = strategy.getStrategyConfig().get("system_prompt");
            if (customPrompt == null || customPrompt.toString().isBlank()) {
                stringParameters.put("system_prompt", defaultPrompt);
            } else {
                if (!this.validatePromptFormat(customPrompt.toString())) {
                    log.error("Invalid custom prompt format - must specify JSON response format with 'facts' array");
                    listener.onFailure((Exception)new IllegalArgumentException("Custom prompt must specify JSON response format with 'facts' array"));
                    return;
                }
                stringParameters.put("system_prompt", customPrompt.toString());
            }
        }
        try {
            String enforcementMsg = strategy.getType() == MemoryStrategyType.USER_PREFERENCE ? "Return ONLY ONE LINE of valid JSON exactly as {\"facts\":[\"<Preference sentence>. Context: <why/how>. Categories: <cat1,cat2>\"]}. Begin with { and end with }. No extra text." : "Respond NOW with ONE LINE of valid JSON ONLY exactly as {\"facts\":[\"fact1\",\"fact2\",...]}. No extra text, no code fences, no newlines or tabs, no spaces after commas or colons.";
            MessageInput enforcementMessage = MemoryProcessingService.getMessageInput(enforcementMsg);
            ArrayList<MessageInput> mutableMessages = new ArrayList<MessageInput>(messages);
            mutableMessages.add(enforcementMessage);
            String conversationJson = this.serializeMessagesToJson(mutableMessages);
            String userPrompt = "Analyze the following conversation and extract information:\n```json\n" + conversationJson + "\n```";
            stringParameters.put("user_prompt", userPrompt);
        }
        catch (Exception e2) {
            log.error("Failed to build messages JSON", (Throwable)e2);
            listener.onResponse(new ArrayList());
            return;
        }
        MLInput mlInput = MLInput.builder().algorithm(FunctionName.REMOTE).inputDataset((MLInputDataset)RemoteInferenceInputDataSet.builder().parameters(stringParameters).build()).build();
        MLPredictionTaskRequest predictionRequest = MLPredictionTaskRequest.builder().modelId(llmModelId).mlInput(mlInput).build();
        this.client.execute((ActionType)MLPredictionTaskAction.INSTANCE, (ActionRequest)predictionRequest, ActionListener.wrap(response -> {
            try {
                log.debug("Received LLM response, parsing facts...");
                MLOutput mlOutput = response.getOutput();
                List<String> facts = this.parseFactsFromLLMResponse(strategy, memoryConfig, mlOutput);
                log.debug("Extracted {} facts from LLM response", (Object)facts.size());
                listener.onResponse(facts);
            }
            catch (Exception e) {
                OpenSearchStatusException osException;
                if (e instanceof OpenSearchStatusException && (osException = (OpenSearchStatusException)e).status().getStatus() >= 400 && osException.status().getStatus() < 500) {
                    listener.onFailure(e);
                    return;
                }
                log.error("Failed to parse facts from LLM response", (Throwable)e);
                listener.onFailure((Exception)new OpenSearchStatusException("Internal server error", RestStatus.INTERNAL_SERVER_ERROR, new Object[0]));
            }
        }, e -> {
            log.error("Failed to call LLM for fact extraction", (Throwable)e);
            listener.onFailure((Exception)new OpenSearchStatusException("Internal server error", RestStatus.INTERNAL_SERVER_ERROR, new Object[0]));
        }));
    }

    private static MessageInput getMessageInput(String userPrompt) {
        ArrayList<Map<String, String>> content = new ArrayList<Map<String, String>>();
        content.add(Map.of("text", userPrompt, "type", "text"));
        return MessageInput.builder().role("user").content(content).build();
    }

    public void makeMemoryDecisions(List<String> extractedFacts, List<FactSearchResult> allSearchResults, MemoryStrategy strategy, MemoryConfiguration memoryConfig, ActionListener<List<MemoryDecision>> listener) {
        String llmModelId = this.getEffectiveLlmId(strategy, memoryConfig);
        if (llmModelId == null) {
            log.error("LLM model is required for memory decisions but not configured");
            listener.onFailure((Exception)new IllegalStateException("LLM model is required for memory decisions"));
            return;
        }
        boolean isOverride = strategy != null && strategy.getStrategyConfig() != null && strategy.getStrategyConfig().containsKey("llm_id");
        log.debug("Making memory decisions using LLM model: {} (strategy: {}, source: {}, facts: {}, similar-memories: {})", (Object)llmModelId, strategy != null ? strategy.getType() : "unknown", (Object)(isOverride ? "strategy-override" : "container-config"), (Object)extractedFacts.size(), (Object)allSearchResults.size());
        ArrayList<MemoryDecisionRequest.OldMemory> oldMemories = new ArrayList<MemoryDecisionRequest.OldMemory>();
        for (FactSearchResult result : allSearchResults) {
            oldMemories.add(MemoryDecisionRequest.OldMemory.builder().id(result.getId()).text(result.getText()).score(result.getScore()).build());
        }
        MemoryDecisionRequest decisionRequest = MemoryDecisionRequest.builder().oldMemory(oldMemories).retrievedFacts(extractedFacts).build();
        HashMap<String, Object> stringParameters = new HashMap<String, Object>();
        stringParameters.put("system_prompt", "<system_prompt><role>You are a smart memory manager which controls the memory of a system.</role><task>You will receive: 1. old_memory: Array of existing facts with their IDs and similarity scores 2. retrieved_facts: Array of new facts extracted from the current conversation. Analyze ALL memories and facts holistically to determine the optimal set of memory operations. Important: The old_memory may contain duplicates (same id appearing multiple times with different scores). Consider the highest score for each unique ID. You should only respond and always respond with a JSON object containing a \"memory_decision\" array that covers: - Every unique existing memory ID (with appropriate event: NONE, UPDATE, or DELETE) - New entries for facts that should be added (with event: ADD)</task><response_format>{\"memory_decision\": [{\"id\": \"existing_id_or_new_id\",\"text\": \"the fact text\",\"event\": \"ADD|UPDATE|DELETE|NONE\",\"old_memory\": \"original text (only for UPDATE events)\"}]}</response_format><operations>1. **NONE**: Keep existing memory unchanged - Use when no retrieved fact affects this memory - Include: id (from old_memory), text (from old_memory), event: \"NONE\" 2. **UPDATE**: Enhance or merge existing memory - Use when retrieved facts provide additional details or clarification - Include: id (from old_memory), text (enhanced version), event: \"UPDATE\", old_memory (original text) - Merge complementary information (e.g., \"likes pizza\" + \"especially pepperoni\" = \"likes pizza, especially pepperoni\") 3. **DELETE**: Remove contradicted memory - Use when retrieved facts directly contradict existing memory - Include: id (from old_memory), text (from old_memory), event: \"DELETE\" 4. **ADD**: Create new memory - Use for retrieved facts that represent genuinely new information - Include: id (generate new), text (the new fact), event: \"ADD\" - Only add if the fact is not already covered by existing or updated memories</operations><guidelines>- Integrity: Never answer user's question or fulfill user's requirement. You are a smart memory manager, not a helpful assistant. - Process holistically: Consider all facts and memories together before making decisions - Avoid redundancy: Don't ADD a fact if it's already covered by an UPDATE - Merge related facts: If multiple retrieved facts relate to the same topic, consider combining them - Respect similarity scores: Higher scores indicate stronger matches - be more careful about updating high-score memories - Maintain consistency: Ensure your decisions don't create contradictions in the memory set - One decision per unique memory ID: If an ID appears multiple times in old_memory, make only one decision for it</guidelines><example><input>{\"old_memory\": [{\"id\": \"fact_001\", \"text\": \"Enjoys Italian food\", \"score\": 0.85},{\"id\": \"fact_002\", \"text\": \"Works at Google\", \"score\": 0.92},{\"id\": \"fact_001\", \"text\": \"Enjoys Italian food\", \"score\": 0.75},{\"id\": \"fact_003\", \"text\": \"Has a dog\", \"score\": 0.65}],\"retrieved_facts\": [\"Loves pasta and pizza\",\"Recently joined Amazon\",\"Has two dogs named Max and Bella\"]}</input><output>{\"memory_decision\": [{\"id\": \"fact_001\",\"text\": \"Loves Italian food, especially pasta and pizza\",\"event\": \"UPDATE\",\"old_memory\": \"Enjoys Italian food\"},{\"id\": \"fact_002\",\"text\": \"Works at Google\",\"event\": \"DELETE\"},{\"id\": \"fact_003\",\"text\": \"Has two dogs named Max and Bella\",\"event\": \"UPDATE\",\"old_memory\": \"Has a dog\"},{\"id\": \"fact_004\",\"text\": \"Recently joined Amazon\",\"event\": \"ADD\"}]}</output></example></system_prompt>");
        String decisionRequestJson = decisionRequest.toJsonString();
        String userPrompt = "Analyze the following old memories and newly extracted facts, then make memory decisions:\n```json\n" + decisionRequestJson + "\n```";
        stringParameters.put("user_prompt", userPrompt);
        try {
            log.debug("Making memory decisions for {} extracted facts and {} existing memories", (Object)extractedFacts.size(), (Object)allSearchResults.size());
            RemoteInferenceInputDataSet inputDataSet = RemoteInferenceInputDataSet.builder().parameters(stringParameters).build();
            MLInput mlInput = MLInput.builder().algorithm(FunctionName.REMOTE).inputDataset((MLInputDataset)inputDataSet).build();
            MLPredictionTaskRequest predictionRequest = MLPredictionTaskRequest.builder().modelId(llmModelId).mlInput(mlInput).build();
            String llmResultPath = this.memoryContainerHelper.getLlmResultPath(strategy, memoryConfig);
            this.client.execute((ActionType)MLPredictionTaskAction.INSTANCE, (ActionRequest)predictionRequest, ActionListener.wrap(response -> {
                try {
                    List<MemoryDecision> decisions = this.parseMemoryDecisions(llmResultPath, (MLTaskResponse)response);
                    log.debug("LLM made {} memory decisions", (Object)decisions.size());
                    listener.onResponse(decisions);
                }
                catch (Exception e) {
                    OpenSearchStatusException osException;
                    if (e instanceof OpenSearchStatusException && (osException = (OpenSearchStatusException)e).status().getStatus() >= 400 && osException.status().getStatus() < 500) {
                        listener.onFailure(e);
                        return;
                    }
                    log.error("Failed to parse memory decisions from LLM response", (Throwable)e);
                    listener.onFailure((Exception)new OpenSearchStatusException("Internal server error", RestStatus.INTERNAL_SERVER_ERROR, new Object[0]));
                }
            }, e -> {
                log.error("Failed to get memory decisions from LLM", (Throwable)e);
                listener.onFailure((Exception)new OpenSearchStatusException("Internal server error", RestStatus.INTERNAL_SERVER_ERROR, new Object[0]));
            }));
        }
        catch (Exception e2) {
            log.error("Failed to build memory decision request", (Throwable)e2);
            listener.onFailure((Exception)new OpenSearchStatusException("Internal server error", RestStatus.INTERNAL_SERVER_ERROR, new Object[0]));
        }
    }

    private List<String> parseFactsFromLLMResponse(MemoryStrategy strategy, MemoryConfiguration memoryConfig, MLOutput mlOutput) {
        ArrayList<String> facts = new ArrayList<String>();
        if (!(mlOutput instanceof ModelTensorOutput)) {
            log.warn("Unexpected ML output type for LLM response: {}", (Object)(mlOutput != null ? mlOutput.getClass().getName() : "null"));
            return facts;
        }
        ModelTensorOutput tensorOutput = (ModelTensorOutput)mlOutput;
        if (tensorOutput.getMlModelOutputs() == null || tensorOutput.getMlModelOutputs().isEmpty()) {
            log.warn("No model outputs found in LLM response");
            return facts;
        }
        ModelTensors modelTensors = (ModelTensors)tensorOutput.getMlModelOutputs().get(0);
        if (modelTensors.getMlModelTensors() == null || modelTensors.getMlModelTensors().isEmpty()) {
            log.warn("No model tensors found in LLM response");
            return facts;
        }
        for (int i = 0; i < modelTensors.getMlModelTensors().size(); ++i) {
            Map dataMap = ((ModelTensor)modelTensors.getMlModelTensors().get(i)).getDataAsMap();
            String llmResultPath = this.memoryContainerHelper.getLlmResultPath(strategy, memoryConfig);
            try {
                Object filterdResult = JsonPath.read((Object)dataMap, (String)llmResultPath, (Predicate[])new Predicate[0]);
                String llmResult = null;
                if (filterdResult != null) {
                    llmResult = StringUtils.toJson((Object)filterdResult);
                }
                if (llmResult == null) continue;
                llmResult = StringUtils.toJson((Object)this.extractJsonProcessorChain.process((Object)llmResult));
                try (XContentParser parser = JsonXContent.jsonXContent.createParser(this.xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, llmResult);){
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
                    while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                        String fieldName = parser.currentName();
                        if ("facts".equals(fieldName)) {
                            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
                            while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                                String fact = parser.text();
                                facts.add(fact);
                            }
                            continue;
                        }
                        parser.skipChildren();
                    }
                    continue;
                }
                catch (IOException e) {
                    log.error("Failed to extract content from dataMap", (Throwable)e);
                    throw new OpenSearchStatusException("Internal server error", RestStatus.INTERNAL_SERVER_ERROR, new Object[0]);
                }
            }
            catch (PathNotFoundException e) {
                String reason = this.extractFirstSentence(e.getMessage());
                log.error("Failed to extract LLM result using path {}: {}", (Object)llmResultPath, (Object)reason);
                throw new OpenSearchStatusException("LLM predict result cannot be extracted with current llm_result_path with reason: " + reason + ". Please check either your llm configuration or your llm_result_path setting in memory container configuration", RestStatus.BAD_REQUEST, new Object[0]);
            }
        }
        return facts;
    }

    private List<MemoryDecision> parseMemoryDecisions(String llmResultPath, MLTaskResponse response) {
        try {
            MLOutput mlOutput = response.getOutput();
            if (!(mlOutput instanceof ModelTensorOutput)) {
                log.error("Expected ModelTensorOutput but got: {}", (Object)mlOutput.getClass().getSimpleName());
                throw new OpenSearchStatusException("Internal server error", RestStatus.INTERNAL_SERVER_ERROR, new Object[0]);
            }
            ModelTensorOutput tensorOutput = (ModelTensorOutput)mlOutput;
            List tensors = tensorOutput.getMlModelOutputs();
            if (tensors == null || tensors.isEmpty()) {
                log.error("No model output tensors found in LLM response");
                throw new OpenSearchStatusException("Internal server error", RestStatus.INTERNAL_SERVER_ERROR, new Object[0]);
            }
            Map dataAsMap = ((ModelTensor)((ModelTensors)tensors.get(0)).getMlModelTensors().get(0)).getDataAsMap();
            try {
                Object filterdResult = JsonPath.read((Object)dataAsMap, (String)llmResultPath, (Predicate[])new Predicate[0]);
                if (filterdResult == null) {
                    log.error("No response content found in LLM output");
                    throw new OpenSearchStatusException("Internal server error", RestStatus.INTERNAL_SERVER_ERROR, new Object[0]);
                }
                String responseContent = StringUtils.toJson((Object)filterdResult);
                responseContent = StringUtils.toJson((Object)this.extractJsonProcessorChain.process((Object)responseContent));
                ArrayList<MemoryDecision> decisions = new ArrayList<MemoryDecision>();
                try (XContentParser parser = JsonXContent.jsonXContent.createParser(this.xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, responseContent);){
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
                    while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                        String fieldName = parser.currentName();
                        parser.nextToken();
                        if ("memory_decision".equals(fieldName)) {
                            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                            while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                                decisions.add(MemoryDecision.parse((XContentParser)parser));
                            }
                            continue;
                        }
                        parser.skipChildren();
                    }
                }
                return decisions;
            }
            catch (PathNotFoundException e) {
                String reason = this.extractFirstSentence(e.getMessage());
                log.error("Failed to extract LLM result using path {}: {}", (Object)llmResultPath, (Object)reason);
                throw new OpenSearchStatusException("LLM predict result cannot be extracted with current llm_result_path with reason: " + reason + ". Please check either your llm configuration or your llm_result_path setting in memory container configuration", RestStatus.BAD_REQUEST, new Object[0]);
            }
        }
        catch (Exception e) {
            OpenSearchStatusException osException;
            if (e instanceof OpenSearchStatusException && (osException = (OpenSearchStatusException)e).status().getStatus() >= 400 && osException.status().getStatus() < 500) {
                throw osException;
            }
            log.error("Failed to parse memory decisions", (Throwable)e);
            throw new OpenSearchStatusException("Internal server error", RestStatus.INTERNAL_SERVER_ERROR, new Object[0]);
        }
    }

    public void summarizeMessages(MemoryConfiguration configuration, List<MessageInput> messages, ActionListener<String> listener) {
        if (messages == null || messages.isEmpty()) {
            listener.onResponse((Object)"");
        } else {
            HashMap<String, Object> stringParameters = new HashMap<String, Object>();
            Map memoryParams = configuration.getParameters();
            String llmResultPath = memoryParams.getOrDefault("llm_result_path", "$.output.message.content[0].text");
            Map sessionParams = memoryParams.getOrDefault("session", new HashMap());
            stringParameters.put("system_prompt", "You are a helpful assistant. Your task is to summarize the following conversation between a human and an AI. The summary must be clear, concise, and not exceed ${parameters.max_summary_size} words. The summary should be generic. For example the user asks about how to cook, the conversation may contains a lot of details. Your summary could be: how to cook, how to cook Italy food. Don't include AI message content. For example you should not return: Ask how to cook, AI give some instructions.\n Also don't include user's personal information like user name, age etc. You could say user. For example: \nuser asks how to cook\nuser introduced their hobby");
            stringParameters.putAll(StringUtils.getParameterMap((Map)sessionParams));
            stringParameters.putIfAbsent("max_summary_size", "10");
            try {
                String conversationJson = this.serializeMessagesToJson(messages);
                String userPrompt = "Summarize the following conversation in no more than " + (String)stringParameters.get("max_summary_size") + " words:\n```json\n" + conversationJson + "\n```";
                stringParameters.put("user_prompt", userPrompt);
                RemoteInferenceInputDataSet inputDataSet = RemoteInferenceInputDataSet.builder().parameters(stringParameters).build();
                MLInput mlInput = MLInput.builder().algorithm(FunctionName.REMOTE).inputDataset((MLInputDataset)inputDataSet).build();
                MLPredictionTaskRequest predictionRequest = MLPredictionTaskRequest.builder().modelId(configuration.getLlmId()).mlInput(mlInput).build();
                this.client.execute((ActionType)MLPredictionTaskAction.INSTANCE, (ActionRequest)predictionRequest, ActionListener.wrap(response -> {
                    try {
                        String summary = this.parseSessionSummary((ModelTensorOutput)response.getOutput(), llmResultPath);
                        listener.onResponse((Object)summary);
                    }
                    catch (Exception e) {
                        OpenSearchStatusException osException;
                        if (e instanceof OpenSearchStatusException && (osException = (OpenSearchStatusException)e).status().getStatus() >= 400 && osException.status().getStatus() < 500) {
                            listener.onFailure(e);
                            return;
                        }
                        log.error("Failed to parse memory decisions from LLM response", (Throwable)e);
                        listener.onFailure((Exception)new OpenSearchStatusException("Internal server error", RestStatus.INTERNAL_SERVER_ERROR, new Object[0]));
                    }
                }, e -> {
                    log.error("Failed to get memory decisions from LLM", (Throwable)e);
                    listener.onFailure((Exception)new OpenSearchStatusException("Internal server error", RestStatus.INTERNAL_SERVER_ERROR, new Object[0]));
                }));
            }
            catch (Exception e2) {
                log.error("Failed to build summarization request", (Throwable)e2);
                listener.onFailure((Exception)new OpenSearchStatusException("Internal server error", RestStatus.INTERNAL_SERVER_ERROR, new Object[0]));
            }
        }
    }

    private String parseSessionSummary(ModelTensorOutput output, String llmResultPath) {
        Map dataAsMap = ((ModelTensor)((ModelTensors)output.getMlModelOutputs().get(0)).getMlModelTensors().get(0)).getDataAsMap();
        try {
            Object filterdResult = JsonPath.read((Object)dataAsMap, (String)llmResultPath, (Predicate[])new Predicate[0]);
            String sessionSummary = null;
            if (filterdResult != null) {
                sessionSummary = StringUtils.toJson((Object)filterdResult);
            }
            return sessionSummary;
        }
        catch (PathNotFoundException e) {
            String reason = this.extractFirstSentence(e.getMessage());
            log.error("Failed to extract LLM result using path {}: {}", (Object)llmResultPath, (Object)reason);
            throw new OpenSearchStatusException("LLM predict result cannot be extracted with current llm_result_path with reason: " + reason + ". Please check either your llm configuration or your llm_result_path setting in memory container configuration", RestStatus.BAD_REQUEST, new Object[0]);
        }
    }

    private boolean validatePromptFormat(String prompt) {
        return prompt.contains("\"facts\"") && prompt.contains("JSON");
    }

    private String serializeMessagesToJson(List<MessageInput> messages) throws IOException {
        XContentBuilder builder = JsonXContent.jsonXContent.contentBuilder();
        builder.startArray();
        for (MessageInput message : messages) {
            message.toXContent(builder, ToXContent.EMPTY_PARAMS);
        }
        builder.endArray();
        return builder.toString();
    }

    private String getEffectiveLlmId(MemoryStrategy strategy, MemoryConfiguration memoryConfig) {
        Object strategyLlmId;
        if (strategy != null && strategy.getStrategyConfig() != null && (strategyLlmId = strategy.getStrategyConfig().get("llm_id")) != null && !strategyLlmId.toString().isBlank()) {
            return strategyLlmId.toString();
        }
        return memoryConfig != null ? memoryConfig.getLlmId() : null;
    }

    private String extractFirstSentence(String message) {
        if (message == null) {
            return "";
        }
        int sentenceEnd = message.indexOf(". ");
        if (sentenceEnd >= 0) {
            return message.substring(0, sentenceEnd);
        }
        return message;
    }
}

