/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.startree.filter.provider;

import java.util.ArrayList;
import java.util.List;
import org.opensearch.index.mapper.MappedFieldType;
import org.opensearch.index.mapper.NumberFieldMapper;
import org.opensearch.search.startree.filter.DimensionFilter;
import org.opensearch.search.startree.filter.ExactMatchDimFilter;
import org.opensearch.search.startree.filter.MatchNoneFilter;
import org.opensearch.search.startree.filter.RangeMatchDimFilter;
import org.opensearch.search.startree.filter.provider.NumericMapper;
import org.opensearch.search.startree.filter.provider.StarTreeRangeQuery;

abstract class NumericNonDecimalMapper
extends NumericMapper {
    NumericNonDecimalMapper() {
    }

    @Override
    public DimensionFilter getExactMatchFilter(MappedFieldType mappedFieldType, List<Object> rawValues) {
        NumberFieldMapper.NumberFieldType numberFieldType = (NumberFieldMapper.NumberFieldType)mappedFieldType;
        ArrayList<Object> convertedValues = new ArrayList<Object>(rawValues.size());
        for (Object rawValue : rawValues) {
            convertedValues.add(numberFieldType.numberType().parse(rawValue, true).longValue());
        }
        return new ExactMatchDimFilter(mappedFieldType.name(), convertedValues);
    }

    @Override
    public DimensionFilter getRangeMatchFilter(MappedFieldType mappedFieldType, StarTreeRangeQuery rangeQuery) {
        boolean upperTermHasDecimalPart;
        NumberFieldMapper.NumberFieldType numberFieldType = (NumberFieldMapper.NumberFieldType)mappedFieldType;
        Long parsedLow = rangeQuery.from() == null ? this.defaultMinimum().longValue() : numberFieldType.numberType().parse(rangeQuery.from(), true).longValue();
        Long parsedHigh = rangeQuery.to() == null ? this.defaultMaximum().longValue() : numberFieldType.numberType().parse(rangeQuery.to(), true).longValue();
        boolean lowerTermHasDecimalPart = NumberFieldMapper.NumberType.hasDecimalPart(parsedLow);
        if (!lowerTermHasDecimalPart && !rangeQuery.includeLower() || lowerTermHasDecimalPart && NumberFieldMapper.NumberType.signum(parsedLow) > 0.0) {
            if (parsedLow.equals(this.defaultMaximum())) {
                return new MatchNoneFilter();
            }
            parsedLow = parsedLow + 1L;
        }
        if (!(upperTermHasDecimalPart = NumberFieldMapper.NumberType.hasDecimalPart(parsedHigh)) && !rangeQuery.includeUpper() || upperTermHasDecimalPart && NumberFieldMapper.NumberType.signum(parsedHigh) < 0.0) {
            if (parsedHigh.equals(this.defaultMinimum())) {
                return new MatchNoneFilter();
            }
            parsedHigh = parsedHigh - 1L;
        }
        return new RangeMatchDimFilter(mappedFieldType.name(), parsedLow, parsedHigh, true, true);
    }

    abstract Long defaultMinimum();

    abstract Long defaultMaximum();
}

