/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.mapper;

import java.io.IOException;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import org.apache.lucene.document.LongField;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.document.SortedNumericDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.IndexOrDocValuesQuery;
import org.apache.lucene.search.IndexSortSortedNumericDocValuesRangeQuery;
import org.apache.lucene.search.Query;
import org.opensearch.OpenSearchParseException;
import org.opensearch.Version;
import org.opensearch.common.Explicit;
import org.opensearch.common.Nullable;
import org.opensearch.common.TriFunction;
import org.opensearch.common.geo.ShapeRelation;
import org.opensearch.common.logging.DeprecationLogger;
import org.opensearch.common.lucene.BytesRefs;
import org.opensearch.common.time.DateFormatter;
import org.opensearch.common.time.DateFormatters;
import org.opensearch.common.time.DateMathParser;
import org.opensearch.common.time.DateUtils;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.util.FeatureFlags;
import org.opensearch.common.util.LocaleUtils;
import org.opensearch.common.xcontent.support.XContentMapValues;
import org.opensearch.index.IndexSortConfig;
import org.opensearch.index.compositeindex.datacube.DimensionType;
import org.opensearch.index.fielddata.IndexFieldData;
import org.opensearch.index.fielddata.IndexNumericFieldData;
import org.opensearch.index.fielddata.plain.SortedNumericIndexFieldData;
import org.opensearch.index.mapper.DataStreamFieldMapper;
import org.opensearch.index.mapper.DerivedFieldGenerator;
import org.opensearch.index.mapper.FieldMapper;
import org.opensearch.index.mapper.MappedFieldType;
import org.opensearch.index.mapper.Mapper;
import org.opensearch.index.mapper.NumericPointEncoder;
import org.opensearch.index.mapper.ParametrizedFieldMapper;
import org.opensearch.index.mapper.ParseContext;
import org.opensearch.index.mapper.SortedNumericDocValuesFetcher;
import org.opensearch.index.mapper.SourceValueFetcher;
import org.opensearch.index.mapper.StoredFieldFetcher;
import org.opensearch.index.mapper.TextSearchInfo;
import org.opensearch.index.mapper.ValueFetcher;
import org.opensearch.index.query.DateRangeIncludingNowQuery;
import org.opensearch.index.query.QueryRewriteContext;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.search.DocValueFormat;
import org.opensearch.search.approximate.ApproximatePointRangeQuery;
import org.opensearch.search.approximate.ApproximateScoreQuery;
import org.opensearch.search.lookup.SearchLookup;

public final class DateFieldMapper
extends ParametrizedFieldMapper {
    private static final DeprecationLogger DEPRECATION_LOGGER = DeprecationLogger.getLogger(DateFieldMapper.class);
    public static final String CONTENT_TYPE = "date";
    public static final String DATE_NANOS_CONTENT_TYPE = "date_nanos";
    @Deprecated
    public static final DateFormatter LEGACY_DEFAULT_DATE_TIME_FORMATTER = DateFormatter.forPattern("strict_date_optional_time||epoch_millis");
    public static final DateFormatter DEFAULT_DATE_TIME_FORMATTER = DateFormatter.forPattern("strict_date_time_no_millis||strict_date_optional_time||epoch_millis", "strict_date_optional_time");
    public static final ParametrizedFieldMapper.TypeParser MILLIS_PARSER = new ParametrizedFieldMapper.TypeParser((n, c) -> {
        boolean ignoreMalformedByDefault = (Boolean)IGNORE_MALFORMED_SETTING.get(c.getSettings());
        return new Builder((String)n, Resolution.MILLISECONDS, c.getDateFormatter(), ignoreMalformedByDefault, c.indexVersionCreated());
    });
    public static final ParametrizedFieldMapper.TypeParser NANOS_PARSER = new ParametrizedFieldMapper.TypeParser((n, c) -> {
        boolean ignoreMalformedByDefault = (Boolean)IGNORE_MALFORMED_SETTING.get(c.getSettings());
        return new Builder((String)n, Resolution.NANOSECONDS, c.getDateFormatter(), ignoreMalformedByDefault, c.indexVersionCreated());
    });
    private final boolean store;
    private final boolean indexed;
    private final boolean hasDocValues;
    private final boolean skiplist;
    private final boolean isSkiplistConfigured;
    private final Locale locale;
    private final String format;
    private final String printFormat;
    private final Explicit<Boolean> ignoreMalformed;
    private final Long nullValue;
    private final String nullValueAsString;
    private final Resolution resolution;
    private final boolean ignoreMalformedByDefault;
    private final Version indexCreatedVersion;

    public static DateFormatter getDefaultDateTimeFormatter() {
        return FeatureFlags.isEnabled(FeatureFlags.DATETIME_FORMATTER_CACHING_SETTING) ? DEFAULT_DATE_TIME_FORMATTER : LEGACY_DEFAULT_DATE_TIME_FORMATTER;
    }

    private static DateFieldMapper toType(FieldMapper in) {
        return (DateFieldMapper)in;
    }

    @Override
    protected void canDeriveSourceInternal() {
        this.checkStoredAndDocValuesForDerivedSource();
    }

    @Override
    protected DerivedFieldGenerator derivedFieldGenerator() {
        return new DerivedFieldGenerator(this.mappedFieldType, new SortedNumericDocValuesFetcher(this.mappedFieldType, this.simpleName()){

            @Override
            public Object convert(Object value) {
                Long val = (Long)value;
                if (val == null) {
                    return null;
                }
                return DateFieldMapper.this.fieldType().dateTimeFormatter().format(DateFieldMapper.this.resolution.toInstant(val).atZone(ZoneOffset.UTC));
            }
        }, new StoredFieldFetcher(this.mappedFieldType, this.simpleName()));
    }

    private DateFieldMapper(String simpleName, MappedFieldType mappedFieldType, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo, Long nullValue, Resolution resolution, Builder builder) {
        super(simpleName, mappedFieldType, multiFields, copyTo);
        this.store = builder.store.getValue();
        this.indexed = builder.index.getValue();
        this.hasDocValues = builder.docValues.getValue();
        this.skiplist = builder.skiplist.getValue();
        this.isSkiplistConfigured = builder.skiplist.isConfigured();
        this.locale = builder.locale.getValue();
        this.format = builder.format.getValue();
        this.printFormat = builder.printFormat.getValue();
        this.ignoreMalformed = builder.ignoreMalformed.getValue();
        this.nullValueAsString = builder.nullValue.getValue();
        this.nullValue = nullValue;
        this.resolution = resolution;
        this.ignoreMalformedByDefault = (Boolean)builder.ignoreMalformed.getDefaultValue().value();
        this.indexCreatedVersion = builder.indexCreatedVersion;
    }

    @Override
    public ParametrizedFieldMapper.Builder getMergeBuilder() {
        return new Builder(this.simpleName(), this.resolution, null, this.ignoreMalformedByDefault, this.indexCreatedVersion).init(this);
    }

    @Override
    public DateFieldType fieldType() {
        return (DateFieldType)super.fieldType();
    }

    @Override
    protected String contentType() {
        return this.fieldType().resolution.type();
    }

    @Override
    protected DateFieldMapper clone() {
        return (DateFieldMapper)super.clone();
    }

    @Override
    protected void parseCreateField(ParseContext context) throws IOException {
        long timestamp;
        Object dateAsObject;
        Object dateAsString = context.externalValueSet() ? ((dateAsObject = context.externalValue()) == null ? null : dateAsObject.toString()) : context.parser().textOrNull();
        if (dateAsString == null) {
            if (this.nullValue == null) {
                return;
            }
            timestamp = this.nullValue;
        } else {
            try {
                timestamp = this.fieldType().parse((String)dateAsString);
            }
            catch (ArithmeticException | IllegalArgumentException | DateTimeException | OpenSearchParseException e) {
                if (((Boolean)this.ignoreMalformed().value()).booleanValue()) {
                    context.addIgnoredField(this.mappedFieldType.name());
                    return;
                }
                throw e;
            }
        }
        if (this.indexed) {
            context.doc().add((IndexableField)new LongPoint(this.fieldType().name(), new long[]{timestamp}));
        }
        if (this.hasDocValues) {
            if (this.skiplist || this.isSkiplistDefaultEnabled(context.indexSettings().getIndexSortConfig(), this.fieldType().name())) {
                context.doc().add((IndexableField)SortedNumericDocValuesField.indexedField((String)this.fieldType().name(), (long)timestamp));
            } else {
                context.doc().add((IndexableField)new SortedNumericDocValuesField(this.fieldType().name(), timestamp));
            }
        } else if (this.store || this.indexed) {
            this.createFieldNamesField(context);
        }
        if (this.store) {
            context.doc().add((IndexableField)new StoredField(this.fieldType().name(), timestamp));
        }
    }

    boolean isSkiplistDefaultEnabled(IndexSortConfig indexSortConfig, String fieldName) {
        if (this.indexCreatedVersion.onOrAfter(Version.V_3_3_0) && !this.isSkiplistConfigured) {
            if (indexSortConfig.hasPrimarySortOnField(fieldName)) {
                return true;
            }
            if (DataStreamFieldMapper.Defaults.TIMESTAMP_FIELD.getName().equals(fieldName)) {
                return true;
            }
        }
        return false;
    }

    public Long getNullValue() {
        return this.nullValue;
    }

    public boolean skiplist() {
        return this.skiplist;
    }

    @Override
    protected Explicit<Boolean> ignoreMalformed() {
        return this.ignoreMalformed;
    }

    public static class Builder
    extends ParametrizedFieldMapper.Builder {
        private final ParametrizedFieldMapper.Parameter<Boolean> index = ParametrizedFieldMapper.Parameter.indexParam(m -> DateFieldMapper.toType((FieldMapper)m).indexed, true);
        private final ParametrizedFieldMapper.Parameter<Boolean> docValues = ParametrizedFieldMapper.Parameter.docValuesParam(m -> DateFieldMapper.toType((FieldMapper)m).hasDocValues, true);
        private final ParametrizedFieldMapper.Parameter<Boolean> store = ParametrizedFieldMapper.Parameter.storeParam(m -> DateFieldMapper.toType((FieldMapper)m).store, false);
        private final ParametrizedFieldMapper.Parameter<Boolean> skiplist = new ParametrizedFieldMapper.Parameter<Boolean>("skip_list", false, () -> false, (n, c, o) -> XContentMapValues.nodeBooleanValue(o), m -> DateFieldMapper.toType((FieldMapper)m).skiplist);
        private final ParametrizedFieldMapper.Parameter<Float> boost = ParametrizedFieldMapper.Parameter.boostParam();
        private final ParametrizedFieldMapper.Parameter<Map<String, String>> meta = ParametrizedFieldMapper.Parameter.metaParam();
        private final ParametrizedFieldMapper.Parameter<String> format = ParametrizedFieldMapper.Parameter.stringParam("format", false, m -> DateFieldMapper.toType((FieldMapper)m).format, DateFieldMapper.getDefaultDateTimeFormatter().pattern());
        private final ParametrizedFieldMapper.Parameter<String> printFormat = ParametrizedFieldMapper.Parameter.stringParam("print_format", false, m -> DateFieldMapper.toType((FieldMapper)m).printFormat, DateFieldMapper.getDefaultDateTimeFormatter().printPattern()).acceptsNull();
        private final ParametrizedFieldMapper.Parameter<Locale> locale = new ParametrizedFieldMapper.Parameter<Locale>("locale", false, () -> Locale.ROOT, (n, c, o) -> LocaleUtils.parse(o.toString()), m -> DateFieldMapper.toType((FieldMapper)m).locale);
        private final ParametrizedFieldMapper.Parameter<String> nullValue = ParametrizedFieldMapper.Parameter.stringParam("null_value", false, m -> DateFieldMapper.toType((FieldMapper)m).nullValueAsString, null).acceptsNull();
        private final ParametrizedFieldMapper.Parameter<Explicit<Boolean>> ignoreMalformed;
        private final Resolution resolution;
        private final Version indexCreatedVersion;

        public Builder(String name, Resolution resolution, DateFormatter dateFormatter, boolean ignoreMalformedByDefault, Version indexCreatedVersion) {
            super(name);
            this.resolution = resolution;
            this.indexCreatedVersion = indexCreatedVersion;
            this.ignoreMalformed = ParametrizedFieldMapper.Parameter.explicitBoolParam("ignore_malformed", true, m -> DateFieldMapper.toType((FieldMapper)m).ignoreMalformed, ignoreMalformedByDefault);
            if (dateFormatter != null) {
                this.format.setValue(dateFormatter.pattern());
                this.printFormat.setValue(dateFormatter.printPattern());
                this.locale.setValue(dateFormatter.locale());
            }
        }

        private DateFormatter buildFormatter() {
            try {
                if (this.format.isConfigured() && !this.printFormat.isConfigured()) {
                    return DateFormatter.forPattern(this.format.getValue(), null, !this.format.isConfigured()).withLocale(this.locale.getValue());
                }
                return DateFormatter.forPattern(this.format.getValue(), this.printFormat.getValue(), !this.format.isConfigured()).withLocale(this.locale.getValue());
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Error parsing [format] on field [" + this.name() + "]: " + e.getMessage(), e);
            }
        }

        @Override
        protected List<ParametrizedFieldMapper.Parameter<?>> getParameters() {
            return Arrays.asList(this.index, this.docValues, this.store, this.skiplist, this.format, this.printFormat, this.locale, this.nullValue, this.ignoreMalformed, this.boost, this.meta);
        }

        private Long parseNullValue(DateFieldType fieldType) {
            if (this.nullValue.getValue() == null) {
                return null;
            }
            try {
                return fieldType.parse(this.nullValue.getValue());
            }
            catch (Exception e) {
                DEPRECATION_LOGGER.deprecate("date_mapper_null_field", "Error parsing [" + this.nullValue.getValue() + "] as date in [null_value] on field [" + this.name() + "]); [null_value] will be ignored", new Object[0]);
                return null;
            }
        }

        @Override
        public DateFieldMapper build(Mapper.BuilderContext context) {
            DateFieldType ft = new DateFieldType(this.buildFullName(context), this.index.getValue(), this.store.getValue(), this.docValues.getValue(), this.buildFormatter(), this.resolution, this.nullValue.getValue(), this.meta.getValue());
            ft.setBoost(this.boost.getValue().floatValue());
            Long nullTimestamp = this.parseNullValue(ft);
            return new DateFieldMapper(this.name, ft, this.multiFieldsBuilder.build(this, context), this.copyTo.build(), nullTimestamp, this.resolution, this);
        }

        @Override
        public Optional<DimensionType> getSupportedDataCubeDimensionType() {
            return Optional.of(DimensionType.DATE);
        }
    }

    public static enum Resolution {
        MILLISECONDS("date", IndexNumericFieldData.NumericType.DATE){

            @Override
            public long convert(Instant instant) {
                return this.clampToValidRange(instant).toEpochMilli();
            }

            @Override
            public Instant toInstant(long value) {
                return Instant.ofEpochMilli(value);
            }

            @Override
            public Instant clampToValidRange(Instant instant) {
                return DateUtils.clampToMillisRange(instant);
            }

            @Override
            public long parsePointAsMillis(byte[] value) {
                return LongPoint.decodeDimension((byte[])value, (int)0);
            }

            @Override
            protected Query distanceFeatureQuery(String field, float boost, long origin, TimeValue pivot) {
                return LongField.newDistanceFeatureQuery((String)field, (float)boost, (long)origin, (long)pivot.getMillis());
            }
        }
        ,
        NANOSECONDS("date_nanos", IndexNumericFieldData.NumericType.DATE_NANOSECONDS){

            @Override
            public long convert(Instant instant) {
                return DateUtils.toLong(instant);
            }

            @Override
            public Instant toInstant(long value) {
                return DateUtils.toInstant(value);
            }

            @Override
            public Instant clampToValidRange(Instant instant) {
                return DateUtils.clampToNanosRange(instant);
            }

            @Override
            public long parsePointAsMillis(byte[] value) {
                return DateUtils.toMilliSeconds(LongPoint.decodeDimension((byte[])value, (int)0));
            }

            @Override
            protected Query distanceFeatureQuery(String field, float boost, long origin, TimeValue pivot) {
                return LongField.newDistanceFeatureQuery((String)field, (float)boost, (long)origin, (long)pivot.getNanos());
            }
        };

        private final String type;
        private final IndexNumericFieldData.NumericType numericType;

        private Resolution(String type, IndexNumericFieldData.NumericType numericType) {
            this.type = type;
            this.numericType = numericType;
        }

        public String type() {
            return this.type;
        }

        IndexNumericFieldData.NumericType numericType() {
            return this.numericType;
        }

        public abstract long convert(Instant var1);

        public abstract Instant toInstant(long var1);

        public abstract Instant clampToValidRange(Instant var1);

        public abstract long parsePointAsMillis(byte[] var1);

        public static Resolution ofOrdinal(int ord) {
            for (Resolution resolution : Resolution.values()) {
                if (ord != resolution.ordinal()) continue;
                return resolution;
            }
            throw new IllegalArgumentException("unknown resolution ordinal [" + ord + "]");
        }

        protected abstract Query distanceFeatureQuery(String var1, float var2, long var3, TimeValue var5);
    }

    public static final class DateFieldType
    extends MappedFieldType
    implements NumericPointEncoder {
        protected final DateFormatter dateTimeFormatter;
        protected final DateMathParser dateMathParser;
        protected final Resolution resolution;
        protected final String nullValue;

        public DateFieldType(String name, boolean isSearchable, boolean isStored, boolean hasDocValues, DateFormatter dateTimeFormatter, Resolution resolution, String nullValue, Map<String, String> meta) {
            super(name, isSearchable, isStored, hasDocValues, TextSearchInfo.SIMPLE_MATCH_ONLY, meta);
            this.dateTimeFormatter = dateTimeFormatter;
            this.dateMathParser = dateTimeFormatter.toDateMathParser();
            this.resolution = resolution;
            this.nullValue = nullValue;
        }

        public DateFieldType(String name) {
            this(name, true, false, true, DateFieldMapper.getDefaultDateTimeFormatter(), Resolution.MILLISECONDS, null, Collections.emptyMap());
        }

        public DateFieldType(String name, DateFormatter dateFormatter) {
            this(name, true, false, true, dateFormatter, Resolution.MILLISECONDS, null, Collections.emptyMap());
        }

        public DateFieldType(String name, Resolution resolution) {
            this(name, true, false, true, DateFieldMapper.getDefaultDateTimeFormatter(), resolution, null, Collections.emptyMap());
        }

        public DateFieldType(String name, Resolution resolution, DateFormatter dateFormatter) {
            this(name, true, false, true, dateFormatter, resolution, null, Collections.emptyMap());
        }

        @Override
        public String typeName() {
            return this.resolution.type();
        }

        public DateFormatter dateTimeFormatter() {
            return this.dateTimeFormatter;
        }

        public Resolution resolution() {
            return this.resolution;
        }

        protected DateMathParser dateMathParser() {
            return this.dateMathParser;
        }

        public long parse(String value) {
            return this.resolution.convert(DateFormatters.from(this.dateTimeFormatter().parse(value), this.dateTimeFormatter().locale()).toInstant());
        }

        public long convertNanosToMillis(long nanoSecondsSinceEpoch) {
            if (this.resolution.numericType.equals((Object)IndexNumericFieldData.NumericType.DATE_NANOSECONDS)) {
                return DateUtils.toMilliSeconds(nanoSecondsSinceEpoch);
            }
            return nanoSecondsSinceEpoch;
        }

        public long convertRoundedMillisToNanos(long milliSecondsSinceEpoch) {
            if (this.resolution.numericType.equals((Object)IndexNumericFieldData.NumericType.DATE_NANOSECONDS)) {
                return DateUtils.toNanoSeconds(milliSecondsSinceEpoch);
            }
            return milliSecondsSinceEpoch;
        }

        @Override
        public ValueFetcher valueFetcher(QueryShardContext context, SearchLookup searchLookup, String format) {
            DateFormatter defaultFormatter = this.dateTimeFormatter();
            final DateFormatter formatter = format != null ? DateFormatter.forPattern(format).withLocale(defaultFormatter.locale()) : defaultFormatter;
            return new SourceValueFetcher(this, this.name(), context, this.nullValue){
                final /* synthetic */ DateFieldType this$0;
                {
                    this.this$0 = this$0;
                    super(fieldName, context, nullValue);
                }

                @Override
                public String parseSourceValue(Object value) {
                    String date = value.toString();
                    long timestamp = this.this$0.parse(date);
                    ZonedDateTime dateTime = this.this$0.resolution().toInstant(timestamp).atZone(ZoneOffset.UTC);
                    return formatter.format(dateTime);
                }
            };
        }

        @Override
        public Query termQuery(Object value, @Nullable QueryShardContext context) {
            Query query = this.rangeQuery(value, value, true, true, ShapeRelation.INTERSECTS, null, null, context);
            if (this.boost() != 1.0f) {
                query = new BoostQuery(query, this.boost());
            }
            return query;
        }

        @Override
        public Query rangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, ShapeRelation relation, @Nullable ZoneId timeZone, @Nullable DateMathParser forcedDateParser, QueryShardContext context) {
            this.failIfNotIndexedAndNoDocValues();
            if (relation == ShapeRelation.DISJOINT) {
                throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] does not support DISJOINT ranges");
            }
            DateMathParser parser = forcedDateParser == null ? this.dateMathParser : forcedDateParser;
            return DateFieldType.dateRangeQuery(lowerTerm, upperTerm, includeLower, includeUpper, timeZone, parser, context, this.resolution, (TriFunction<Long, Long, boolean[], Query>)((TriFunction)(l, u, nowUsed) -> {
                Query query;
                Query dvQuery;
                Query query2 = dvQuery = this.hasDocValues() ? SortedNumericDocValuesField.newSlowRangeQuery((String)this.name(), (long)l, (long)u) : null;
                if (!this.isSearchable()) {
                    if (context.indexSortedOnField(this.name())) {
                        dvQuery = new IndexSortSortedNumericDocValuesRangeQuery(this.name(), l.longValue(), u.longValue(), dvQuery);
                    }
                    return nowUsed[0] ? new DateRangeIncludingNowQuery(dvQuery) : dvQuery;
                }
                Query pointRangeQuery = LongPoint.newRangeQuery((String)this.name(), (long)l, (long)u);
                if (dvQuery != null) {
                    query = new IndexOrDocValuesQuery(pointRangeQuery, dvQuery);
                    if (context.indexSortedOnField(this.name())) {
                        query = new IndexSortSortedNumericDocValuesRangeQuery(this.name(), l.longValue(), u.longValue(), query);
                    }
                } else {
                    query = pointRangeQuery;
                }
                ApproximatePointRangeQuery approxQuery = new ApproximatePointRangeQuery(this.name(), LongPoint.pack((long[])new long[]{l.longValue()}).bytes, LongPoint.pack((long[])new long[]{u.longValue()}).bytes, new long[]{l}.length, ApproximatePointRangeQuery.LONG_FORMAT);
                return nowUsed[0] ? new ApproximateScoreQuery(new DateRangeIncludingNowQuery(query), approxQuery) : new ApproximateScoreQuery(query, approxQuery);
            }));
        }

        public static Query dateRangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, @Nullable ZoneId timeZone, DateMathParser parser, QueryShardContext context, Resolution resolution, TriFunction<Long, Long, boolean[], Query> builder) {
            long u;
            long l;
            boolean[] nowUsed = new boolean[1];
            LongSupplier nowSupplier = () -> {
                nowUsed[0] = true;
                return context.nowInMillis();
            };
            if (lowerTerm == null) {
                l = Long.MIN_VALUE;
            } else {
                l = DateFieldType.parseToLong(lowerTerm, !includeLower, timeZone, parser, nowSupplier, resolution);
                if (!includeLower) {
                    ++l;
                }
            }
            if (upperTerm == null) {
                u = Long.MAX_VALUE;
            } else {
                u = DateFieldType.parseToLong(upperTerm, includeUpper, timeZone, parser, nowSupplier, resolution);
                if (!includeUpper) {
                    --u;
                }
            }
            return (Query)builder.apply((Object)l, (Object)u, (Object)nowUsed);
        }

        public long parseToLong(Object value, boolean roundUp, @Nullable ZoneId zone, DateMathParser dateParser, LongSupplier now) {
            dateParser = dateParser == null ? this.dateMathParser() : dateParser;
            return DateFieldType.parseToLong(value, roundUp, zone, dateParser, now, this.resolution);
        }

        public static long parseToLong(Object value, boolean roundUp, @Nullable ZoneId zone, DateMathParser dateParser, LongSupplier now, Resolution resolution) {
            return resolution.convert(dateParser.parse(BytesRefs.toString(value), now, roundUp, zone));
        }

        @Override
        public byte[] encodePoint(Number value) {
            byte[] point = new byte[8];
            LongPoint.encodeDimension((long)value.longValue(), (byte[])point, (int)0);
            return point;
        }

        @Override
        public byte[] encodePoint(Object value, boolean roundUp) {
            long timestamp = this.parseToLong(value, false, null, null, null);
            if (roundUp) {
                if (timestamp < Long.MAX_VALUE) {
                    ++timestamp;
                }
            } else if (timestamp > Long.MIN_VALUE) {
                --timestamp;
            }
            return this.encodePoint(timestamp);
        }

        @Override
        public Query distanceFeatureQuery(Object origin, String pivot, float boost, QueryShardContext context) {
            this.failIfNotIndexedAndNoDocValues();
            long originLong = this.parseToLong(origin, true, null, null, context::nowInMillis);
            TimeValue pivotTime = TimeValue.parseTimeValue((String)pivot, (String)"distance_feature.pivot");
            return this.resolution.distanceFeatureQuery(this.name(), boost, originLong, pivotTime);
        }

        @Override
        public MappedFieldType.Relation isFieldWithinQuery(IndexReader reader, Object from, Object to, boolean includeLower, boolean includeUpper, ZoneId timeZone, DateMathParser dateParser, QueryRewriteContext context) throws IOException {
            if (!this.isSearchable() && this.hasDocValues()) {
                return MappedFieldType.Relation.INTERSECTS;
            }
            if (dateParser == null) {
                dateParser = this.dateMathParser;
            }
            long fromInclusive = Long.MIN_VALUE;
            if (from != null) {
                fromInclusive = DateFieldType.parseToLong(from, !includeLower, timeZone, dateParser, context::nowInMillis, this.resolution);
                if (!includeLower) {
                    if (fromInclusive == Long.MAX_VALUE) {
                        return MappedFieldType.Relation.DISJOINT;
                    }
                    ++fromInclusive;
                }
            }
            long toInclusive = Long.MAX_VALUE;
            if (to != null) {
                toInclusive = DateFieldType.parseToLong(to, includeUpper, timeZone, dateParser, context::nowInMillis, this.resolution);
                if (!includeUpper) {
                    if (toInclusive == Long.MIN_VALUE) {
                        return MappedFieldType.Relation.DISJOINT;
                    }
                    --toInclusive;
                }
            }
            if (PointValues.size((IndexReader)reader, (String)this.name()) == 0L) {
                return MappedFieldType.Relation.DISJOINT;
            }
            long minValue = LongPoint.decodeDimension((byte[])PointValues.getMinPackedValue((IndexReader)reader, (String)this.name()), (int)0);
            long maxValue = LongPoint.decodeDimension((byte[])PointValues.getMaxPackedValue((IndexReader)reader, (String)this.name()), (int)0);
            if (minValue >= fromInclusive && maxValue <= toInclusive) {
                return MappedFieldType.Relation.WITHIN;
            }
            if (maxValue < fromInclusive || minValue > toInclusive) {
                return MappedFieldType.Relation.DISJOINT;
            }
            return MappedFieldType.Relation.INTERSECTS;
        }

        @Override
        public Function<byte[], Number> pointReaderIfPossible() {
            if (this.isSearchable()) {
                return this.resolution()::parsePointAsMillis;
            }
            return null;
        }

        @Override
        public IndexFieldData.Builder fielddataBuilder(String fullyQualifiedIndexName, Supplier<SearchLookup> searchLookup) {
            this.failIfNoDocValues();
            return new SortedNumericIndexFieldData.Builder(this.name(), this.resolution.numericType());
        }

        @Override
        public Object valueForDisplay(Object value) {
            Long val = (Long)value;
            if (val == null) {
                return null;
            }
            return this.dateTimeFormatter().format(this.resolution.toInstant(val).atZone(ZoneOffset.UTC));
        }

        @Override
        public DocValueFormat docValueFormat(@Nullable String format, ZoneId timeZone) {
            DateFormatter dateTimeFormatter = this.dateTimeFormatter;
            if (format != null) {
                dateTimeFormatter = DateFormatter.forPattern(format).withLocale(dateTimeFormatter.locale());
            }
            if (timeZone == null) {
                timeZone = ZoneOffset.UTC;
            }
            return new DocValueFormat.DateTime(dateTimeFormatter, timeZone, Resolution.MILLISECONDS);
        }
    }
}

