/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.security.InvalidAlgorithmParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import org.bouncycastle.crypto.Parameters;
import org.bouncycastle.crypto.ParametersWithIV;
import org.bouncycastle.jcajce.provider.ParametersCreator;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class IvParametersCreator<T extends ParametersWithIV>
implements ParametersCreator {
    private final ParametersWithIV baseParameters;

    IvParametersCreator(ParametersWithIV parametersWithIV) {
        this.baseParameters = parametersWithIV;
    }

    public Parameters createParameters(boolean bl, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        if (algorithmParameterSpec instanceof IvParameterSpec) {
            return this.baseParameters.withIV(((IvParameterSpec)algorithmParameterSpec).getIV());
        }
        if (bl && this.baseParameters.getAlgorithm().requiresAlgorithmParameters()) {
            return this.baseParameters.withIV(secureRandom);
        }
        return this.baseParameters;
    }
}

