/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.fips;

import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.PasswordBasedDeriver;
import org.bouncycastle.crypto.PasswordConverter;
import org.bouncycastle.crypto.fips.FipsAlgorithm;
import org.bouncycastle.crypto.fips.FipsDigestAlgorithm;
import org.bouncycastle.crypto.fips.FipsParameters;
import org.bouncycastle.crypto.fips.FipsPasswordBasedDeriverFactory;
import org.bouncycastle.crypto.fips.FipsSHS;
import org.bouncycastle.crypto.fips.FipsUnapprovedOperationError;
import org.bouncycastle.crypto.fips.PKCS5S2ParametersGenerator;
import org.bouncycastle.crypto.fips.SelfTestExecutor;
import org.bouncycastle.crypto.internal.PBEParametersGenerator;
import org.bouncycastle.crypto.internal.test.BasicKatTest;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Strings;
import org.bouncycastle.util.encoders.Hex;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class FipsPBKD {
    private static final FipsAlgorithm ALGORITHM_PBKDF2 = new FipsAlgorithm("PBKDF2");
    public static final ParametersBuilder PBKDF2;

    private FipsPBKD() {
    }

    static {
        Parameters parameters = new ParametersBuilder().using(FipsSHS.Algorithm.SHA256_HMAC, Strings.toByteArray("Legion of the Bouncy Castle")).withIterationCount(2048).withSalt(Hex.decode("0102030405060708090a0b0c0e0d0e0f"));
        PKCS5S2ParametersGenerator<Parameters> pKCS5S2ParametersGenerator = new PKCS5S2ParametersGenerator<Parameters>(parameters, FipsSHS.createHMac(FipsSHS.Algorithm.SHA256_HMAC));
        SelfTestExecutor.validate(ALGORITHM_PBKDF2, pKCS5S2ParametersGenerator, new PbkdfTest(parameters, Hex.decode("fb18073c0bc900343ad8280821938255")));
        PBKDF2 = new ParametersBuilder();
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static class PbkdfTest<T extends PBEParametersGenerator<Parameters>>
    implements BasicKatTest<T> {
        private final Parameters params;
        private final byte[] kat;

        PbkdfTest(Parameters parameters, byte[] byArray) {
            this.params = parameters;
            this.kat = byArray;
        }

        @Override
        public boolean hasTestPassed(T t) {
            ((PBEParametersGenerator)t).init(this.params.password, this.params.salt, this.params.iterationCount);
            byte[] byArray = t.deriveKey(PasswordBasedDeriver.KeyType.CIPHER, 16);
            return Arrays.areEqual(byArray, this.kat);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static class DeriverFactory
    extends FipsPasswordBasedDeriverFactory<Parameters> {
        @Override
        public PasswordBasedDeriver<Parameters> createDeriver(final Parameters parameters) {
            final PKCS5S2ParametersGenerator<Parameters> pKCS5S2ParametersGenerator = new PKCS5S2ParametersGenerator<Parameters>(parameters, FipsSHS.createHMac(parameters.getPRF()));
            pKCS5S2ParametersGenerator.init(parameters.getPassword(), parameters.getSalt(), parameters.getIterationCount());
            return new PasswordBasedDeriver<Parameters>(){

                @Override
                public Parameters getParameters() {
                    return parameters;
                }

                @Override
                public byte[] deriveKey(PasswordBasedDeriver.KeyType keyType, int n) {
                    return pKCS5S2ParametersGenerator.deriveKey(keyType, n);
                }

                @Override
                public byte[][] deriveKeyAndIV(PasswordBasedDeriver.KeyType keyType, int n, int n2) {
                    return pKCS5S2ParametersGenerator.deriveKeyAndIV(keyType, n, n2);
                }
            };
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static final class Parameters
    extends FipsParameters {
        private final FipsDigestAlgorithm digestAlgorithm;
        private final PasswordConverter converter;
        private final byte[] password;
        private final byte[] salt;
        private final int iterationCount;

        private Parameters(FipsDigestAlgorithm fipsDigestAlgorithm, PasswordConverter passwordConverter, byte[] byArray, int n, byte[] byArray2) {
            super(ALGORITHM_PBKDF2);
            this.digestAlgorithm = fipsDigestAlgorithm;
            this.converter = passwordConverter;
            this.password = byArray;
            this.iterationCount = n;
            this.salt = byArray2;
            if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
                if (byArray2.length < 16) {
                    throw new FipsUnapprovedOperationError("salt must be at least 128 bits");
                }
                if (byArray.length < 14) {
                    throw new FipsUnapprovedOperationError("password must be at least 112 bits");
                }
            }
        }

        private Parameters(FipsDigestAlgorithm fipsDigestAlgorithm, PasswordConverter passwordConverter, char[] cArray) {
            this(fipsDigestAlgorithm, passwordConverter, passwordConverter.convert(cArray), 1024, new byte[20]);
        }

        public Parameters withSalt(byte[] byArray) {
            return new Parameters(this.digestAlgorithm, this.converter, this.getPassword(), this.iterationCount, Arrays.clone(byArray));
        }

        public Parameters withIterationCount(int n) {
            return new Parameters(this.digestAlgorithm, this.converter, this.getPassword(), n, this.salt);
        }

        synchronized byte[] getPassword() {
            return Arrays.clone(this.password);
        }

        public FipsDigestAlgorithm getPRF() {
            return this.digestAlgorithm;
        }

        public byte[] getSalt() {
            return Arrays.clone(this.salt);
        }

        public int getIterationCount() {
            return this.iterationCount;
        }

        public PasswordConverter getConverter() {
            return this.converter;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() {
            Parameters parameters = this;
            synchronized (parameters) {
                Arrays.fill(this.password, (byte)0);
            }
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static final class ParametersBuilder
    extends FipsParameters {
        ParametersBuilder() {
            super(ALGORITHM_PBKDF2);
        }

        public Parameters using(byte[] byArray) {
            return this.using(FipsSHS.Algorithm.SHA1_HMAC, byArray);
        }

        public Parameters using(FipsDigestAlgorithm fipsDigestAlgorithm, byte[] byArray) {
            return new Parameters(fipsDigestAlgorithm, null, Arrays.clone(byArray), 1024, new byte[20]);
        }

        public Parameters using(PasswordConverter passwordConverter, char[] cArray) {
            return new Parameters(FipsSHS.Algorithm.SHA1_HMAC, passwordConverter, cArray);
        }

        public Parameters using(FipsDigestAlgorithm fipsDigestAlgorithm, PasswordConverter passwordConverter, char[] cArray) {
            return new Parameters(fipsDigestAlgorithm, passwordConverter, passwordConverter.convert(cArray), 1024, new byte[20]);
        }
    }
}

