/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.fips;

import java.math.BigInteger;
import org.bouncycastle.crypto.IllegalKeyException;
import org.bouncycastle.crypto.internal.BasicAgreement;
import org.bouncycastle.crypto.internal.CipherParameters;
import org.bouncycastle.crypto.internal.params.EcDomainParameters;
import org.bouncycastle.crypto.internal.params.EcMqvPrivateParameters;
import org.bouncycastle.crypto.internal.params.EcMqvPublicParameters;
import org.bouncycastle.crypto.internal.params.EcPrivateKeyParameters;
import org.bouncycastle.crypto.internal.params.EcPublicKeyParameters;
import org.bouncycastle.math.ec.ECAlgorithms;
import org.bouncycastle.math.ec.ECConstants;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECPoint;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class EcMqvBasicAgreement
implements BasicAgreement {
    EcMqvPrivateParameters privParams;

    EcMqvBasicAgreement() {
    }

    @Override
    public void init(CipherParameters cipherParameters) {
        this.privParams = (EcMqvPrivateParameters)cipherParameters;
    }

    @Override
    public int getFieldSize() {
        return (this.privParams.getStaticPrivateKey().getParameters().getCurve().getFieldSize() + 7) / 8;
    }

    @Override
    public BigInteger calculateAgreement(CipherParameters cipherParameters) {
        EcMqvPublicParameters ecMqvPublicParameters = (EcMqvPublicParameters)cipherParameters;
        EcPrivateKeyParameters ecPrivateKeyParameters = this.privParams.getStaticPrivateKey();
        EcDomainParameters ecDomainParameters = ecPrivateKeyParameters.getParameters();
        if (!ecDomainParameters.equals(ecMqvPublicParameters.getStaticPublicKey().getParameters())) {
            throw new IllegalKeyException("ECMQV public key components have wrong domain parameters");
        }
        ECPoint eCPoint = this.calculateMqvAgreement(ecDomainParameters, ecPrivateKeyParameters, this.privParams.getEphemeralPrivateKey(), this.privParams.getEphemeralPublicKey(), ecMqvPublicParameters.getStaticPublicKey(), ecMqvPublicParameters.getEphemeralPublicKey()).normalize();
        if (eCPoint.isInfinity()) {
            throw new IllegalStateException("Infinity is not a valid agreement value for MQV");
        }
        return eCPoint.getAffineXCoord().toBigInteger();
    }

    private ECPoint calculateMqvAgreement(EcDomainParameters ecDomainParameters, EcPrivateKeyParameters ecPrivateKeyParameters, EcPrivateKeyParameters ecPrivateKeyParameters2, EcPublicKeyParameters ecPublicKeyParameters, EcPublicKeyParameters ecPublicKeyParameters2, EcPublicKeyParameters ecPublicKeyParameters3) {
        BigInteger bigInteger = ecDomainParameters.getN();
        int n = (bigInteger.bitLength() + 1) / 2;
        BigInteger bigInteger2 = ECConstants.ONE.shiftLeft(n);
        ECCurve eCCurve = ecDomainParameters.getCurve();
        ECPoint eCPoint = ECAlgorithms.cleanPoint(eCCurve, ecPublicKeyParameters.getQ());
        ECPoint eCPoint2 = ECAlgorithms.cleanPoint(eCCurve, ecPublicKeyParameters2.getQ());
        ECPoint eCPoint3 = ECAlgorithms.cleanPoint(eCCurve, ecPublicKeyParameters3.getQ());
        BigInteger bigInteger3 = eCPoint.getAffineXCoord().toBigInteger();
        BigInteger bigInteger4 = bigInteger3.mod(bigInteger2);
        BigInteger bigInteger5 = bigInteger4.setBit(n);
        BigInteger bigInteger6 = ecPrivateKeyParameters.getD().multiply(bigInteger5).add(ecPrivateKeyParameters2.getD()).mod(bigInteger);
        BigInteger bigInteger7 = eCPoint3.getAffineXCoord().toBigInteger();
        BigInteger bigInteger8 = bigInteger7.mod(bigInteger2);
        BigInteger bigInteger9 = bigInteger8.setBit(n);
        BigInteger bigInteger10 = ecDomainParameters.getH().multiply(bigInteger6).mod(bigInteger);
        return ECAlgorithms.sumOfTwoMultiplies(eCPoint2, bigInteger9.multiply(bigInteger10).mod(bigInteger), eCPoint3, bigInteger10);
    }
}

