/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.storage.scan;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.AbstractRelNode;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rel.logical.LogicalFilter;
import org.apache.calcite.rel.logical.LogicalSort;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.search.aggregations.AggregationBuilder;
import org.opensearch.search.aggregations.bucket.histogram.AutoDateHistogramAggregationBuilder;
import org.opensearch.search.aggregations.metrics.ValueCountAggregationBuilder;
import org.opensearch.sql.calcite.utils.OpenSearchTypeFactory;
import org.opensearch.sql.common.setting.Settings;
import org.opensearch.sql.data.type.ExprCoreType;
import org.opensearch.sql.data.type.ExprType;
import org.opensearch.sql.opensearch.data.type.OpenSearchDataType;
import org.opensearch.sql.opensearch.data.type.OpenSearchTextType;
import org.opensearch.sql.opensearch.planner.physical.EnumerableIndexScanRule;
import org.opensearch.sql.opensearch.planner.physical.OpenSearchIndexRules;
import org.opensearch.sql.opensearch.request.AggregateAnalyzer;
import org.opensearch.sql.opensearch.request.PredicateAnalyzer;
import org.opensearch.sql.opensearch.response.agg.OpenSearchAggregationResponseParser;
import org.opensearch.sql.opensearch.storage.OpenSearchIndex;
import org.opensearch.sql.opensearch.storage.scan.AbstractAction;
import org.opensearch.sql.opensearch.storage.scan.AbstractCalciteIndexScan;
import org.opensearch.sql.opensearch.storage.scan.AggPushDownAction;
import org.opensearch.sql.opensearch.storage.scan.AggregationBuilderAction;
import org.opensearch.sql.opensearch.storage.scan.FilterDigest;
import org.opensearch.sql.opensearch.storage.scan.LimitDigest;
import org.opensearch.sql.opensearch.storage.scan.PushDownContext;
import org.opensearch.sql.opensearch.storage.scan.PushDownType;
import shaded.com.google.common.collect.ImmutableList;

public class CalciteLogicalIndexScan
extends AbstractCalciteIndexScan {
    private static final Logger LOG = LogManager.getLogger(CalciteLogicalIndexScan.class);

    public CalciteLogicalIndexScan(RelOptCluster cluster, RelOptTable table, OpenSearchIndex osIndex) {
        this(cluster, cluster.traitSetOf((RelTrait)Convention.NONE), (List<RelHint>)ImmutableList.of(), table, osIndex, table.getRowType(), new PushDownContext(osIndex));
    }

    protected CalciteLogicalIndexScan(RelOptCluster cluster, RelTraitSet traitSet, List<RelHint> hints, RelOptTable table, OpenSearchIndex osIndex, RelDataType schema, PushDownContext pushDownContext) {
        super(cluster, traitSet, hints, table, osIndex, schema, pushDownContext);
    }

    @Override
    protected AbstractCalciteIndexScan buildScan(RelOptCluster cluster, RelTraitSet traitSet, List<RelHint> hints, RelOptTable table, OpenSearchIndex osIndex, RelDataType schema, PushDownContext pushDownContext) {
        return new CalciteLogicalIndexScan(cluster, traitSet, hints, table, osIndex, schema, pushDownContext);
    }

    public CalciteLogicalIndexScan copyWithNewSchema(RelDataType schema) {
        return new CalciteLogicalIndexScan(this.getCluster(), this.traitSet, (List<RelHint>)this.hints, this.table, this.osIndex, schema, this.pushDownContext.clone());
    }

    public void register(RelOptPlanner planner) {
        super.register(planner);
        planner.addRule(EnumerableIndexScanRule.DEFAULT_CONFIG.toRule());
        if (((Boolean)this.osIndex.getSettings().getSettingValue(Settings.Key.CALCITE_PUSHDOWN_ENABLED)).booleanValue()) {
            for (RelOptRule rule : OpenSearchIndexRules.OPEN_SEARCH_INDEX_SCAN_RULES) {
                planner.addRule(rule);
            }
        } else {
            planner.addRule((RelOptRule)OpenSearchIndexRules.RELEVANCE_FUNCTION_PUSHDOWN);
        }
    }

    public AbstractRelNode pushDownFilter(Filter filter) {
        try {
            RelDataType rowType = filter.getRowType();
            CalciteLogicalIndexScan newScan = this.copyWithNewSchema(filter.getRowType());
            List schema = this.getRowType().getFieldNames();
            Map<String, ExprType> fieldTypes = this.osIndex.getFieldTypes().entrySet().stream().filter(entry -> schema.contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            PredicateAnalyzer.QueryExpression queryExpression = PredicateAnalyzer.analyzeExpression(filter.getCondition(), schema, fieldTypes, rowType, this.getCluster());
            newScan.pushDownContext.add(queryExpression.getScriptCount() > 0 ? PushDownType.SCRIPT : PushDownType.FILTER, new FilterDigest(queryExpression.getScriptCount(), queryExpression.isPartial() ? CalciteLogicalIndexScan.constructCondition(queryExpression.getAnalyzedNodes(), this.getCluster().getRexBuilder()) : filter.getCondition()), requestBuilder -> requestBuilder.pushDownFilter(queryExpression.builder()));
            if (queryExpression.isPartial()) {
                List<RexNode> conditions = queryExpression.getUnAnalyzableNodes();
                RexNode newCondition = CalciteLogicalIndexScan.constructCondition(conditions, this.getCluster().getRexBuilder());
                return filter.copy(filter.getTraitSet(), (RelNode)newScan, newCondition);
            }
            return newScan;
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Cannot pushdown the filter condition.", (Throwable)e);
            }
            return null;
        }
    }

    private static RexNode constructCondition(List<RexNode> conditions, RexBuilder rexBuilder) {
        return conditions.size() > 1 ? rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, conditions) : conditions.get(0);
    }

    public CalciteLogicalIndexScan pushDownCollapse(Project finalOutput, String fieldName) {
        ExprType fieldType = this.osIndex.getFieldTypes().get(fieldName);
        if (fieldType == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Cannot pushdown the dedup '{}' due to it is not a index field", (Object)fieldName);
            }
            return null;
        }
        ExprType originalExprType = fieldType.getOriginalExprType();
        String originalFieldName = originalExprType.getOriginalPath().orElse(fieldName);
        if (!(ExprCoreType.numberTypes().contains(originalExprType) || originalExprType.legacyTypeName().equals("KEYWORD") || originalExprType.legacyTypeName().equals("TEXT"))) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Cannot pushdown the dedup '{}' due to only keyword and number type are accepted, but its type is {}", (Object)originalFieldName, (Object)originalExprType.legacyTypeName());
            }
            return null;
        }
        String field = OpenSearchTextType.toKeywordSubField(originalFieldName, fieldType);
        if (field == null) {
            LOG.debug("Cannot pushdown the dedup due to no keyword subfield for {}.", (Object)fieldName);
            return null;
        }
        CalciteLogicalIndexScan newScan = this.copyWithNewSchema(finalOutput.getRowType());
        newScan.pushDownContext.add(PushDownType.COLLAPSE, fieldName, requestBuilder -> requestBuilder.pushDownCollapse(field));
        return newScan;
    }

    public CalciteLogicalIndexScan pushDownProject(List<Integer> selectedColumns) {
        AbstractAction<AggPushDownAction> action;
        RelDataTypeFactory.FieldInfoBuilder builder = this.getCluster().getTypeFactory().builder();
        List fieldList = this.getRowType().getFieldList();
        for (int project : selectedColumns) {
            builder.add((RelDataTypeField)fieldList.get(project));
        }
        RelDataType newSchema = builder.build();
        if (this.getPushDownContext().containsDigest(newSchema.getFieldNames())) {
            return null;
        }
        RelTraitSet traitSetWithReIndexedCollations = this.reIndexCollations(selectedColumns);
        CalciteLogicalIndexScan newScan = new CalciteLogicalIndexScan(this.getCluster(), traitSetWithReIndexedCollations, (List<RelHint>)this.hints, this.table, this.osIndex, newSchema, this.pushDownContext.clone());
        if (this.pushDownContext.isAggregatePushed()) {
            action = aggAction -> {};
        } else {
            Map<String, String> aliasMapping = this.osIndex.getAliasMapping();
            List<String> projectedFields = newSchema.getFieldNames().stream().map(fieldName -> aliasMapping.getOrDefault(fieldName, (String)fieldName)).toList();
            action = requestBuilder -> requestBuilder.pushDownProjectStream(projectedFields.stream());
        }
        newScan.pushDownContext.add(PushDownType.PROJECT, newSchema.getFieldNames(), action);
        return newScan;
    }

    private RelTraitSet reIndexCollations(List<Integer> selectedColumns) {
        RelTraitSet newTraitSet;
        RelCollation relCollation = this.getTraitSet().getCollation();
        if (!Objects.isNull(relCollation) && !relCollation.getFieldCollations().isEmpty()) {
            List newCollations = relCollation.getFieldCollations().stream().filter(collation -> selectedColumns.contains(collation.getFieldIndex())).map(collation -> collation.withFieldIndex(selectedColumns.indexOf(collation.getFieldIndex()))).collect(Collectors.toList());
            newTraitSet = this.getTraitSet().plus((RelTrait)RelCollations.of(newCollations));
        } else {
            newTraitSet = this.getTraitSet();
        }
        return newTraitSet;
    }

    public AbstractRelNode pushDownAggregate(Aggregate aggregate, Project project) {
        try {
            Object e;
            CalciteLogicalIndexScan newScan = new CalciteLogicalIndexScan(this.getCluster(), this.traitSet, (List<RelHint>)this.hints, this.table, this.osIndex, aggregate.getRowType(), this.pushDownContext.cloneWithoutSort());
            Map<String, ExprType> fieldTypes = this.osIndex.getFieldTypes();
            List outputFields = aggregate.getRowType().getFieldNames();
            Pair<List<AggregationBuilder>, OpenSearchAggregationResponseParser> aggregationBuilder = AggregateAnalyzer.analyze(aggregate, project, this.getRowType(), fieldTypes, outputFields, this.getCluster());
            Map<String, OpenSearchDataType> extendedTypeMapping = aggregate.getRowType().getFieldList().stream().collect(Collectors.toMap(RelDataTypeField::getName, field -> OpenSearchDataType.of(OpenSearchTypeFactory.convertRelDataTypeToExprType(field.getType()))));
            AggPushDownAction action = new AggPushDownAction(aggregationBuilder, extendedTypeMapping, outputFields.subList(0, aggregate.getGroupSet().cardinality()));
            newScan.pushDownContext.add(PushDownType.AGGREGATION, aggregate, action);
            if (((List)aggregationBuilder.getLeft()).size() == 1 && (e = ((List)aggregationBuilder.getLeft()).getFirst()) instanceof AutoDateHistogramAggregationBuilder) {
                AutoDateHistogramAggregationBuilder autoDateHistogram = (AutoDateHistogramAggregationBuilder)e;
                RexBuilder rexBuilder = this.getCluster().getRexBuilder();
                AggregationBuilder aggregationBuilders = (AggregationBuilder)autoDateHistogram.getSubAggregations().stream().toList().getFirst();
                RexNode condition = aggregationBuilders instanceof ValueCountAggregationBuilder ? rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexNode[]{rexBuilder.makeInputRef((RelNode)newScan, 1), rexBuilder.makeLiteral((Object)0, rexBuilder.getTypeFactory().createSqlType(SqlTypeName.INTEGER))}) : rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NOT_NULL, new RexNode[]{rexBuilder.makeInputRef((RelNode)newScan, 1)});
                return LogicalFilter.create((RelNode)newScan, (RexNode)condition);
            }
            return newScan;
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Cannot pushdown the aggregate {}", (Object)aggregate, (Object)e);
            }
            return null;
        }
    }

    public AbstractRelNode pushDownLimit(LogicalSort sort, Integer limit, Integer offset) {
        try {
            if (this.pushDownContext.isAggregatePushed()) {
                boolean updated = this.pushDownContext.getAggPushDownAction().pushDownLimitIntoBucketSize(limit + offset);
                if (!updated && offset > 0) {
                    return null;
                }
                CalciteLogicalIndexScan newScan = this.copyWithNewSchema(this.getRowType());
                AggregationBuilderAction action = updated ? aggAction -> aggAction.pushDownLimitIntoBucketSize(limit + offset) : aggAction -> {};
                newScan.pushDownContext.add(PushDownType.LIMIT, new LimitDigest(limit, offset), action);
                return offset > 0 ? sort.copy(sort.getTraitSet(), List.of(newScan)) : newScan;
            }
            CalciteLogicalIndexScan newScan = this.copyWithNewSchema(this.getRowType());
            newScan.pushDownContext.add(PushDownType.LIMIT, new LimitDigest(limit, offset), requestBuilder -> requestBuilder.pushDownLimit(limit, offset));
            return newScan;
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Cannot pushdown limit {} with offset {}", (Object)limit, (Object)offset, (Object)e);
            }
            return null;
        }
    }
}

