/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.response.agg;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.opensearch.search.aggregations.Aggregation;
import org.opensearch.search.aggregations.Aggregations;
import org.opensearch.sql.common.utils.StringUtils;
import org.opensearch.sql.opensearch.response.agg.MetricParser;

public class MetricParserHelper {
    private final Map<String, MetricParser> metricParserMap;
    private final List<String> countAggNameList;

    public MetricParserHelper(List<MetricParser> metricParserList) {
        this.metricParserMap = metricParserList.stream().collect(Collectors.toMap(MetricParser::getName, m -> m));
        this.countAggNameList = List.of();
    }

    public MetricParserHelper(List<MetricParser> metricParserList, List<String> countAggNameList) {
        this.metricParserMap = metricParserList.stream().collect(Collectors.toMap(MetricParser::getName, m -> m));
        this.countAggNameList = countAggNameList;
    }

    public Map<String, Object> parse(Aggregations aggregations) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        for (Aggregation aggregation : aggregations) {
            if (this.metricParserMap.containsKey(aggregation.getName())) {
                resultMap.putAll(this.metricParserMap.get(aggregation.getName()).parse(aggregation));
                continue;
            }
            throw new RuntimeException(StringUtils.format("couldn't parse field %s in aggregation response", aggregation.getName()));
        }
        return resultMap;
    }

    @Generated
    public Map<String, MetricParser> getMetricParserMap() {
        return this.metricParserMap;
    }

    @Generated
    public List<String> getCountAggNameList() {
        return this.countAggNameList;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MetricParserHelper)) {
            return false;
        }
        MetricParserHelper other = (MetricParserHelper)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, MetricParser> this$metricParserMap = this.getMetricParserMap();
        Map<String, MetricParser> other$metricParserMap = other.getMetricParserMap();
        if (this$metricParserMap == null ? other$metricParserMap != null : !((Object)this$metricParserMap).equals(other$metricParserMap)) {
            return false;
        }
        List<String> this$countAggNameList = this.getCountAggNameList();
        List<String> other$countAggNameList = other.getCountAggNameList();
        return !(this$countAggNameList == null ? other$countAggNameList != null : !((Object)this$countAggNameList).equals(other$countAggNameList));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MetricParserHelper;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, MetricParser> $metricParserMap = this.getMetricParserMap();
        result = result * 59 + ($metricParserMap == null ? 43 : ((Object)$metricParserMap).hashCode());
        List<String> $countAggNameList = this.getCountAggNameList();
        result = result * 59 + ($countAggNameList == null ? 43 : ((Object)$countAggNameList).hashCode());
        return result;
    }

    @Generated
    public MetricParserHelper(Map<String, MetricParser> metricParserMap, List<String> countAggNameList) {
        this.metricParserMap = metricParserMap;
        this.countAggNameList = countAggNameList;
    }
}

