/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.planner.physical;

import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollationTraitDef;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rel.logical.LogicalSort;
import org.apache.calcite.rex.RexNode;
import org.apache.commons.lang3.tuple.Pair;
import org.immutables.value.Value;
import org.opensearch.sql.opensearch.planner.physical.ImmutableSortProjectExprTransposeRule;
import org.opensearch.sql.opensearch.planner.physical.OpenSearchIndexScanRule;
import org.opensearch.sql.opensearch.util.OpenSearchRelOptUtil;
import shaded.com.google.common.collect.ImmutableMap;

@Value.Enclosing
public class SortProjectExprTransposeRule
extends RelRule<Config> {
    protected SortProjectExprTransposeRule(Config config) {
        super((RelRule.Config)config);
    }

    public void onMatch(RelOptRuleCall call) {
        Project result;
        Sort sort = (Sort)call.rel(0);
        Project project = (Project)call.rel(1);
        ArrayList<RelFieldCollation> pushable = new ArrayList<RelFieldCollation>();
        boolean allPushable = true;
        for (RelFieldCollation fieldCollation : sort.getCollation().getFieldCollations()) {
            RexNode expr = (RexNode)project.getProjects().get(fieldCollation.getFieldIndex());
            Optional<Pair<Integer, Boolean>> pushableExprInputInfo = OpenSearchRelOptUtil.getOrderEquivalentInputInfo(expr);
            if (pushableExprInputInfo.isEmpty()) {
                allPushable = false;
                break;
            }
            int inputIndex = (Integer)pushableExprInputInfo.get().getLeft();
            boolean flipped = (Boolean)pushableExprInputInfo.get().getRight();
            RelFieldCollation.Direction dir = flipped ? fieldCollation.getDirection().reverse() : fieldCollation.getDirection();
            pushable.add(new RelFieldCollation(inputIndex, dir, fieldCollation.nullDirection));
        }
        if (!allPushable || pushable.isEmpty()) {
            return;
        }
        RelCollation inputCollation = RelCollations.of(pushable);
        Sort lowerSort = sort.copy(sort.getTraitSet().replace((RelTrait)inputCollation), project.getInput(), inputCollation, null, null);
        if (sort.fetch == null && sort.offset == null) {
            result = project.copy(sort.getTraitSet(), (RelNode)lowerSort, project.getProjects(), project.getRowType());
        } else {
            Sort limitSort = sort.copy(sort.getTraitSet().replace((RelTrait)RelCollations.EMPTY), (RelNode)lowerSort, RelCollations.EMPTY, sort.offset, sort.fetch);
            result = project.copy(sort.getTraitSet(), (RelNode)limitSort, project.getProjects(), project.getRowType());
        }
        ImmutableMap equiv = sort.offset == null && sort.fetch == null && project.getCluster().getPlanner().getRelTraitDefs().contains(RelCollationTraitDef.INSTANCE) ? ImmutableMap.of((Object)lowerSort, (Object)project.getInput()) : ImmutableMap.of();
        call.transformTo((RelNode)result, (Map)equiv);
    }

    @Value.Immutable
    public static interface Config
    extends RelRule.Config {
        public static final Config DEFAULT = ImmutableSortProjectExprTransposeRule.Config.builder().build().withOperandSupplier(b0 -> b0.operand(LogicalSort.class).oneInput(b1 -> b1.operand(LogicalProject.class).predicate(Predicate.not(Project::containsOver).and(OpenSearchIndexScanRule::projectContainsExpr)).anyInputs()));

        default public SortProjectExprTransposeRule toRule() {
            return new SortProjectExprTransposeRule(this);
        }
    }
}

