/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.planner.physical;

import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.rel.AbstractRelNode;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.logical.LogicalFilter;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.calcite.sql.SqlOperator;
import org.immutables.value.Value;
import org.opensearch.sql.calcite.utils.UserDefinedFunctionUtils;
import org.opensearch.sql.opensearch.planner.physical.ImmutableOpenSearchRelevanceFunctionPushdownRule;
import org.opensearch.sql.opensearch.storage.scan.CalciteLogicalIndexScan;

@Value.Enclosing
public class OpenSearchRelevanceFunctionPushdownRule
extends RelRule<Config> {
    protected OpenSearchRelevanceFunctionPushdownRule(Config config) {
        super((RelRule.Config)config);
    }

    public void onMatch(RelOptRuleCall call) {
        if (call.rels.length == 2) {
            LogicalFilter filter = (LogicalFilter)call.rel(0);
            CalciteLogicalIndexScan scan = (CalciteLogicalIndexScan)call.rel(1);
            if (this.containsRelevanceFunction(filter.getCondition())) {
                this.apply(call, (Filter)filter, scan);
            }
        } else {
            throw new AssertionError((Object)String.format("The length of rels should be 2 but got %s", call.rels.length));
        }
    }

    protected void apply(RelOptRuleCall call, Filter filter, CalciteLogicalIndexScan scan) {
        AbstractRelNode newRel = scan.pushDownFilter(filter);
        if (newRel != null) {
            call.transformTo((RelNode)newRel);
        }
    }

    private boolean containsRelevanceFunction(RexNode node) {
        RelevanceFunctionVisitor visitor = new RelevanceFunctionVisitor();
        node.accept((RexVisitor)visitor);
        return visitor.hasRelevanceFunction();
    }

    private static class RelevanceFunctionVisitor
    extends RexVisitorImpl<Void> {
        private boolean foundRelevanceFunction = false;

        RelevanceFunctionVisitor() {
            super(true);
        }

        public Void visitCall(RexCall call) {
            SqlOperator operator = call.getOperator();
            String operatorName = operator.getName().toLowerCase();
            if (UserDefinedFunctionUtils.SINGLE_FIELD_RELEVANCE_FUNCTION_SET.contains(operatorName) || UserDefinedFunctionUtils.MULTI_FIELDS_RELEVANCE_FUNCTION_SET.contains(operatorName)) {
                this.foundRelevanceFunction = true;
                return null;
            }
            return (Void)super.visitCall(call);
        }

        boolean hasRelevanceFunction() {
            return this.foundRelevanceFunction;
        }
    }

    @Value.Immutable
    public static interface Config
    extends RelRule.Config {
        public static final Config DEFAULT = ImmutableOpenSearchRelevanceFunctionPushdownRule.Config.builder().build().withOperandSupplier(b0 -> b0.operand(LogicalFilter.class).oneInput(b1 -> b1.operand(CalciteLogicalIndexScan.class).noInputs()));

        default public OpenSearchRelevanceFunctionPushdownRule toRule() {
            return new OpenSearchRelevanceFunctionPushdownRule(this);
        }
    }
}

