/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.executor;

import java.security.AccessController;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelRoot;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.runtime.Hook;
import org.apache.calcite.sql.SqlExplainLevel;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.validate.SqlUserDefinedAggFunction;
import org.apache.calcite.sql.validate.SqlUserDefinedFunction;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.sql.ast.statement.Explain;
import org.opensearch.sql.calcite.CalcitePlanContext;
import org.opensearch.sql.calcite.utils.CalciteToolsHelper;
import org.opensearch.sql.calcite.utils.OpenSearchTypeFactory;
import org.opensearch.sql.calcite.utils.UserDefinedFunctionUtils;
import org.opensearch.sql.common.response.ResponseListener;
import org.opensearch.sql.data.model.ExprTupleValue;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.data.type.ExprCoreType;
import org.opensearch.sql.data.type.ExprType;
import org.opensearch.sql.executor.ExecutionContext;
import org.opensearch.sql.executor.ExecutionEngine;
import org.opensearch.sql.executor.Explain;
import org.opensearch.sql.executor.pagination.PlanSerializer;
import org.opensearch.sql.expression.function.BuiltinFunctionName;
import org.opensearch.sql.expression.function.PPLFuncImpTable;
import org.opensearch.sql.opensearch.client.OpenSearchClient;
import org.opensearch.sql.opensearch.client.OpenSearchNodeClient;
import org.opensearch.sql.opensearch.executor.protector.ExecutionProtector;
import org.opensearch.sql.opensearch.functions.DistinctCountApproxAggFunction;
import org.opensearch.sql.opensearch.functions.GeoIpFunction;
import org.opensearch.sql.opensearch.util.JdbcOpenSearchDataTypeConvertor;
import org.opensearch.sql.planner.physical.PhysicalPlan;
import org.opensearch.sql.storage.TableScanOperator;

public class OpenSearchExecutionEngine
implements ExecutionEngine {
    private static final Logger logger = LogManager.getLogger(OpenSearchExecutionEngine.class);
    private final OpenSearchClient client;
    private final ExecutionProtector executionProtector;
    private final PlanSerializer planSerializer;

    public OpenSearchExecutionEngine(OpenSearchClient client, ExecutionProtector executionProtector, PlanSerializer planSerializer) {
        this.client = client;
        this.executionProtector = executionProtector;
        this.planSerializer = planSerializer;
        this.registerOpenSearchFunctions();
    }

    @Override
    public void execute(PhysicalPlan physicalPlan, ResponseListener<ExecutionEngine.QueryResponse> listener) {
        this.execute(physicalPlan, ExecutionContext.emptyExecutionContext(), listener);
    }

    @Override
    public void execute(PhysicalPlan physicalPlan, ExecutionContext context, ResponseListener<ExecutionEngine.QueryResponse> listener) {
        PhysicalPlan plan = this.executionProtector.protect(physicalPlan);
        this.client.schedule(() -> {
            try {
                ArrayList<ExprValue> result = new ArrayList<ExprValue>();
                context.getSplit().ifPresent(plan::add);
                plan.open();
                Integer querySizeLimit = context.getQuerySizeLimit();
                while (plan.hasNext() && (querySizeLimit == null || result.size() < querySizeLimit)) {
                    result.add((ExprValue)plan.next());
                }
                ExecutionEngine.QueryResponse response = new ExecutionEngine.QueryResponse(physicalPlan.schema(), result, this.planSerializer.convertToCursor(plan));
                listener.onResponse(response);
            }
            catch (Exception e) {
                listener.onFailure(e);
            }
            finally {
                plan.close();
            }
        });
    }

    @Override
    public void explain(PhysicalPlan plan, ResponseListener<ExecutionEngine.ExplainResponse> listener) {
        this.client.schedule(() -> {
            try {
                Explain openSearchExplain = new Explain(this){

                    @Override
                    public ExecutionEngine.ExplainResponseNode visitTableScan(TableScanOperator node, Object context) {
                        return this.explain(node, context, explainNode -> explainNode.setDescription(Map.of("request", node.explain())));
                    }
                };
                listener.onResponse(openSearchExplain.apply(plan));
            }
            catch (Exception e) {
                listener.onFailure(e);
            }
        });
    }

    private Hook.Closeable getPhysicalPlanInHook(AtomicReference<String> physical, SqlExplainLevel level) {
        return Hook.PLAN_BEFORE_IMPLEMENTATION.addThread(obj -> {
            RelRoot relRoot = (RelRoot)obj;
            physical.set(RelOptUtil.toString((RelNode)relRoot.rel, (SqlExplainLevel)level));
        });
    }

    private Hook.Closeable getCodegenInHook(AtomicReference<String> codegen) {
        return Hook.JAVA_PLAN.addThread(obj -> codegen.set((String)obj));
    }

    @Override
    public void explain(RelNode rel, Explain.ExplainFormat format, CalcitePlanContext context, ResponseListener<ExecutionEngine.ExplainResponse> listener) {
        this.client.schedule(() -> {
            block13: {
                try {
                    if (format == Explain.ExplainFormat.SIMPLE) {
                        String logical = RelOptUtil.toString((RelNode)rel, (SqlExplainLevel)SqlExplainLevel.NO_ATTRIBUTES);
                        listener.onResponse(new ExecutionEngine.ExplainResponse(new ExecutionEngine.ExplainResponseNodeV2(logical, null, null)));
                        break block13;
                    }
                    SqlExplainLevel level = format == Explain.ExplainFormat.COST ? SqlExplainLevel.ALL_ATTRIBUTES : SqlExplainLevel.EXPPLAN_ATTRIBUTES;
                    String logical = RelOptUtil.toString((RelNode)rel, (SqlExplainLevel)level);
                    AtomicReference<String> physical = new AtomicReference<String>();
                    AtomicReference<String> javaCode = new AtomicReference<String>();
                    try (Hook.Closeable closeable = this.getPhysicalPlanInHook(physical, level);){
                        if (format == Explain.ExplainFormat.EXTENDED) {
                            this.getCodegenInHook(javaCode);
                            CalcitePlanContext.skipEncoding.set(true);
                        }
                        AccessController.doPrivileged(() -> CalciteToolsHelper.OpenSearchRelRunners.run(context, rel));
                    }
                    listener.onResponse(new ExecutionEngine.ExplainResponse(new ExecutionEngine.ExplainResponseNodeV2(logical, physical.get(), javaCode.get())));
                }
                catch (Exception e) {
                    listener.onFailure(e);
                }
                finally {
                    CalcitePlanContext.skipEncoding.remove();
                }
            }
        });
    }

    @Override
    public void execute(RelNode rel, CalcitePlanContext context, ResponseListener<ExecutionEngine.QueryResponse> listener) {
        this.client.schedule(() -> AccessController.doPrivileged(() -> {
            try (PreparedStatement statement = CalciteToolsHelper.OpenSearchRelRunners.run(context, rel);){
                ResultSet result = statement.executeQuery();
                this.buildResultSet(result, rel.getRowType(), context.querySizeLimit, listener);
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
            return null;
        }));
    }

    private void buildResultSet(ResultSet resultSet, RelDataType rowTypes, Integer querySizeLimit, ResponseListener<ExecutionEngine.QueryResponse> listener) throws SQLException {
        String columnName;
        int i;
        ResultSetMetaData metaData = resultSet.getMetaData();
        int columnCount = metaData.getColumnCount();
        List<RelDataType> fieldTypes = rowTypes.getFieldList().stream().map(RelDataTypeField::getType).toList();
        ArrayList<ExprValue> values = new ArrayList<ExprValue>();
        while (resultSet.next() && (querySizeLimit == null || values.size() < querySizeLimit)) {
            LinkedHashMap<String, ExprValue> row = new LinkedHashMap<String, ExprValue>();
            for (i = 1; i <= columnCount; ++i) {
                columnName = metaData.getColumnName(i);
                int sqlType = metaData.getColumnType(i);
                RelDataType fieldType = fieldTypes.get(i - 1);
                ExprValue exprValue = JdbcOpenSearchDataTypeConvertor.getExprValueFromSqlType(resultSet, i, sqlType, fieldType, columnName);
                row.put(columnName, exprValue);
            }
            values.add(ExprTupleValue.fromExprValueMap(row));
        }
        ArrayList<ExecutionEngine.Schema.Column> columns = new ArrayList<ExecutionEngine.Schema.Column>(metaData.getColumnCount());
        for (i = 1; i <= columnCount; ++i) {
            columnName = metaData.getColumnName(i);
            RelDataType fieldType = fieldTypes.get(i - 1);
            ExprType exprType = fieldType.getSqlTypeName() == SqlTypeName.ANY ? (!values.isEmpty() ? ((ExprValue)values.getFirst()).tupleValue().get(columnName).type() : ExprCoreType.UNDEFINED) : OpenSearchTypeFactory.convertRelDataTypeToExprType(fieldType);
            columns.add(new ExecutionEngine.Schema.Column(columnName, null, exprType));
        }
        ExecutionEngine.Schema schema = new ExecutionEngine.Schema(columns);
        ExecutionEngine.QueryResponse response = new ExecutionEngine.QueryResponse(schema, values, null);
        listener.onResponse(response);
    }

    private void registerOpenSearchFunctions() {
        if (this.client instanceof OpenSearchNodeClient) {
            SqlUserDefinedFunction geoIpFunction = new GeoIpFunction(this.client.getNodeClient()).toUDF("GEOIP");
            PPLFuncImpTable.INSTANCE.registerExternalOperator(BuiltinFunctionName.GEOIP, (SqlOperator)geoIpFunction);
        } else {
            logger.info("Function [GEOIP] not registered: incompatible client type {}", (Object)this.client.getClass().getName());
        }
        SqlUserDefinedAggFunction approxDistinctCountFunction = UserDefinedFunctionUtils.createUserDefinedAggFunction(DistinctCountApproxAggFunction.class, "APPROX_DISTINCT_COUNT", ReturnTypes.BIGINT_FORCE_NULLABLE, null);
        PPLFuncImpTable.INSTANCE.registerExternalAggOperator(BuiltinFunctionName.DISTINCT_COUNT_APPROX, approxDistinctCountFunction);
    }
}

