/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.expression.function.udf.datetime;

import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.apache.calcite.adapter.enumerable.NotNullImplementor;
import org.apache.calcite.adapter.enumerable.NullPolicy;
import org.apache.calcite.adapter.enumerable.RexToLixTranslator;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.MethodCallExpression;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.opensearch.sql.calcite.utils.OpenSearchTypeFactory;
import org.opensearch.sql.calcite.utils.PPLOperandTypes;
import org.opensearch.sql.calcite.utils.PPLReturnTypes;
import org.opensearch.sql.calcite.utils.UserDefinedFunctionUtils;
import org.opensearch.sql.calcite.utils.datetime.DateTimeConversionUtils;
import org.opensearch.sql.data.model.ExprValueUtils;
import org.opensearch.sql.expression.function.ImplementorUDF;
import org.opensearch.sql.expression.function.UDFOperandMetadata;
import org.opensearch.sql.expression.function.udf.datetime.AddSubDateFunction;

public class DateAddSubFunction
extends ImplementorUDF {
    public DateAddSubFunction(boolean isAdd) {
        super(new DateAddSubImplementor(isAdd), NullPolicy.ANY);
    }

    @Override
    public SqlReturnTypeInference getReturnTypeInference() {
        return PPLReturnTypes.TIMESTAMP_FORCE_NULLABLE;
    }

    @Override
    public UDFOperandMetadata getOperandMetadata() {
        return PPLOperandTypes.DATETIME_INTERVAL;
    }

    public static class DateAddSubImplementor
    implements NotNullImplementor {
        private final boolean isAdd;

        public Expression implement(RexToLixTranslator translator, RexCall call, List<Expression> translatedOperands) {
            Expression temporal = translatedOperands.get(0);
            Expression temporalDelta = translatedOperands.get(1);
            RelDataType temporalType = ((RexNode)call.getOperands().get(0)).getType();
            RelDataType temporalDeltaType = ((RexNode)call.getOperands().get(1)).getType();
            MethodCallExpression interval = Expressions.call(DateTimeConversionUtils.class, (String)"convertToTemporalAmount", (Expression[])new Expression[]{Expressions.convert_((Expression)temporalDelta, Long.TYPE), Expressions.constant((Object)Objects.requireNonNull(temporalDeltaType.getIntervalQualifier()).getUnit())});
            MethodCallExpression base = Expressions.call(ExprValueUtils.class, (String)"fromObjectValue", (Expression[])new Expression[]{temporal, Expressions.constant((Object)OpenSearchTypeFactory.convertRelDataTypeToExprType(temporalType))});
            MethodCallExpression properties = Expressions.call(UserDefinedFunctionUtils.class, (String)"restoreFunctionProperties", (Expression[])new Expression[]{translator.getRoot()});
            String funcName = this.isAdd ? "dateAddInterval" : "dateSubInterval";
            return Expressions.call(AddSubDateFunction.AddSubDateImplementor.class, (String)funcName, (Expression[])new Expression[]{properties, base, interval});
        }

        @Generated
        public DateAddSubImplementor(boolean isAdd) {
            this.isAdd = isAdd;
        }
    }
}

