/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.executor;

import java.security.AccessController;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.logical.LogicalSort;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.calcite.tools.FrameworkConfig;
import org.apache.calcite.tools.Frameworks;
import org.apache.calcite.tools.Program;
import org.apache.calcite.tools.Programs;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.sql.analysis.AnalysisContext;
import org.opensearch.sql.analysis.Analyzer;
import org.opensearch.sql.ast.statement.Explain;
import org.opensearch.sql.ast.tree.UnresolvedPlan;
import org.opensearch.sql.calcite.CalcitePlanContext;
import org.opensearch.sql.calcite.CalciteRelNodeVisitor;
import org.opensearch.sql.calcite.OpenSearchSchema;
import org.opensearch.sql.calcite.plan.LogicalSystemLimit;
import org.opensearch.sql.common.response.ResponseListener;
import org.opensearch.sql.common.setting.Settings;
import org.opensearch.sql.datasource.DataSourceService;
import org.opensearch.sql.exception.CalciteUnsupportedException;
import org.opensearch.sql.exception.NonFallbackCalciteException;
import org.opensearch.sql.executor.ExecutionContext;
import org.opensearch.sql.executor.ExecutionEngine;
import org.opensearch.sql.executor.OpenSearchTypeSystem;
import org.opensearch.sql.executor.QueryType;
import org.opensearch.sql.planner.PlanContext;
import org.opensearch.sql.planner.Planner;
import org.opensearch.sql.planner.logical.LogicalPaginate;
import org.opensearch.sql.planner.logical.LogicalPlan;
import org.opensearch.sql.planner.physical.PhysicalPlan;
import org.opensearch.sql.storage.split.Split;

public class QueryService {
    @Generated
    private static final Logger log = LogManager.getLogger(QueryService.class);
    private final Analyzer analyzer;
    private final ExecutionEngine executionEngine;
    private final Planner planner;
    private DataSourceService dataSourceService;
    private Settings settings;
    private final AtomicReference<Object> relNodeVisitor = new AtomicReference();

    public void execute(UnresolvedPlan plan, QueryType queryType, ResponseListener<ExecutionEngine.QueryResponse> listener) {
        if (this.shouldUseCalcite(queryType)) {
            this.executeWithCalcite(plan, queryType, listener);
        } else {
            this.executeWithLegacy(plan, queryType, listener, Optional.empty());
        }
    }

    public void explain(UnresolvedPlan plan, QueryType queryType, ResponseListener<ExecutionEngine.ExplainResponse> listener, Explain.ExplainFormat format) {
        if (this.shouldUseCalcite(queryType)) {
            this.explainWithCalcite(plan, queryType, listener, format);
        } else {
            this.explainWithLegacy(plan, queryType, listener, format, Optional.empty());
        }
    }

    public void executeWithCalcite(UnresolvedPlan plan, QueryType queryType, ResponseListener<ExecutionEngine.QueryResponse> listener) {
        try {
            AccessController.doPrivileged(() -> {
                CalcitePlanContext context = CalcitePlanContext.create(this.buildFrameworkConfig(), this.getQuerySizeLimit(), queryType);
                RelNode relNode = this.analyze(plan, context);
                RelNode optimized = this.optimize(relNode, context);
                RelNode calcitePlan = QueryService.convertToCalcitePlan(optimized);
                this.executionEngine.execute(calcitePlan, context, listener);
                return null;
            });
        }
        catch (Throwable t) {
            if (this.isCalciteFallbackAllowed(t) && !(t instanceof NonFallbackCalciteException)) {
                log.warn("Fallback to V2 query engine since got exception", t);
                this.executeWithLegacy(plan, queryType, listener, Optional.of(t));
            }
            if (t instanceof Exception) {
                listener.onFailure((Exception)t);
            }
            if (t instanceof VirtualMachineError) {
                throw t;
            }
            listener.onFailure(new CalciteUnsupportedException(t.getMessage(), t));
        }
    }

    public void explainWithCalcite(UnresolvedPlan plan, QueryType queryType, ResponseListener<ExecutionEngine.ExplainResponse> listener, Explain.ExplainFormat format) {
        try {
            AccessController.doPrivileged(() -> {
                CalcitePlanContext context = CalcitePlanContext.create(this.buildFrameworkConfig(), this.getQuerySizeLimit(), queryType);
                RelNode relNode = this.analyze(plan, context);
                RelNode optimized = this.optimize(relNode, context);
                RelNode calcitePlan = QueryService.convertToCalcitePlan(optimized);
                this.executionEngine.explain(calcitePlan, format, context, listener);
                return null;
            });
        }
        catch (Throwable t) {
            if (this.isCalciteFallbackAllowed(t)) {
                log.warn("Fallback to V2 query engine since got exception", t);
                this.explainWithLegacy(plan, queryType, listener, format, Optional.of(t));
            }
            if (t instanceof Error) {
                listener.onFailure(new CalciteUnsupportedException(t.getMessage()));
            }
            listener.onFailure((Exception)t);
        }
    }

    public void executeWithLegacy(UnresolvedPlan plan, QueryType queryType, ResponseListener<ExecutionEngine.QueryResponse> listener, Optional<Throwable> calciteFailure) {
        try {
            this.executePlan(this.analyze(plan, queryType), PlanContext.emptyPlanContext(), listener);
        }
        catch (Exception e) {
            if (this.shouldUseCalcite(queryType) && this.isCalciteFallbackAllowed(null)) {
                calciteFailure.ifPresentOrElse(t -> listener.onFailure(new RuntimeException((Throwable)t)), () -> listener.onFailure(e));
            }
            listener.onFailure(e);
        }
    }

    public void explainWithLegacy(UnresolvedPlan plan, QueryType queryType, ResponseListener<ExecutionEngine.ExplainResponse> listener, Explain.ExplainFormat format, Optional<Throwable> calciteFailure) {
        try {
            if (format != null && format != Explain.ExplainFormat.STANDARD) {
                throw new UnsupportedOperationException("Explain mode " + format.name() + " is not supported in v2 engine");
            }
            this.executionEngine.explain(this.plan(this.analyze(plan, queryType)), listener);
        }
        catch (Exception e) {
            if (this.shouldUseCalcite(queryType) && this.isCalciteFallbackAllowed(null)) {
                calciteFailure.ifPresentOrElse(t -> listener.onFailure(new RuntimeException((Throwable)t)), () -> listener.onFailure(e));
            }
            listener.onFailure(e);
        }
    }

    public void executePlan(LogicalPlan plan, PlanContext planContext, ResponseListener<ExecutionEngine.QueryResponse> listener) {
        try {
            planContext.getSplit().ifPresentOrElse(split -> this.executionEngine.execute(this.plan(plan), new ExecutionContext((Split)split), listener), () -> this.executionEngine.execute(this.plan(plan), ExecutionContext.querySizeLimit(plan instanceof LogicalPaginate ? null : this.getQuerySizeLimit()), listener));
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    public RelNode analyze(UnresolvedPlan plan, CalcitePlanContext context) {
        return this.getRelNodeVisitor().analyze(plan, context);
    }

    public LogicalPlan analyze(UnresolvedPlan plan, QueryType queryType) {
        return this.analyzer.analyze(plan, new AnalysisContext(queryType));
    }

    public PhysicalPlan plan(LogicalPlan plan) {
        return this.planner.plan(plan);
    }

    public RelNode optimize(RelNode plan, CalcitePlanContext context) {
        return LogicalSystemLimit.create(LogicalSystemLimit.SystemLimitType.QUERY_SIZE_LIMIT, plan, (RexNode)context.relBuilder.literal((Object)context.querySizeLimit));
    }

    private boolean isCalciteFallbackAllowed(@Nullable Throwable t) {
        if (t instanceof CalciteUnsupportedException) {
            return true;
        }
        if (this.settings != null) {
            Boolean fallback_allowed = (Boolean)this.settings.getSettingValue(Settings.Key.CALCITE_FALLBACK_ALLOWED);
            if (fallback_allowed == null) {
                return false;
            }
            return fallback_allowed;
        }
        return true;
    }

    private boolean isCalciteEnabled(Settings settings) {
        if (settings != null) {
            return (Boolean)settings.getSettingValue(Settings.Key.CALCITE_ENGINE_ENABLED);
        }
        return false;
    }

    private Integer getQuerySizeLimit() {
        return this.settings == null ? null : (Integer)this.settings.getSettingValue(Settings.Key.QUERY_SIZE_LIMIT);
    }

    private boolean shouldUseCalcite(QueryType queryType) {
        return this.isCalciteEnabled(this.settings) && queryType == QueryType.PPL;
    }

    private FrameworkConfig buildFrameworkConfig() {
        SchemaPlus rootSchema = CalciteSchema.createRootSchema((boolean)true, (boolean)false).plus();
        SchemaPlus opensearchSchema = rootSchema.add("OpenSearch", (Schema)new OpenSearchSchema(this.dataSourceService));
        Frameworks.ConfigBuilder configBuilder = Frameworks.newConfigBuilder().parserConfig(SqlParser.Config.DEFAULT).defaultSchema(opensearchSchema).traitDefs((List)null).programs(new Program[]{Programs.standard()}).typeSystem(OpenSearchTypeSystem.INSTANCE);
        return configBuilder.build();
    }

    private static RelNode convertToCalcitePlan(RelNode osPlan) {
        RelNode calcitePlan = osPlan;
        RelCollation collation = osPlan.getTraitSet().getCollation();
        if (!(osPlan instanceof Sort) && collation != RelCollations.EMPTY) {
            calcitePlan = LogicalSort.create((RelNode)osPlan, (RelCollation)collation, null, null);
        }
        return calcitePlan;
    }

    @Generated
    public QueryService(Analyzer analyzer, ExecutionEngine executionEngine, Planner planner) {
        this.analyzer = analyzer;
        this.executionEngine = executionEngine;
        this.planner = planner;
    }

    @Generated
    public QueryService(Analyzer analyzer, ExecutionEngine executionEngine, Planner planner, DataSourceService dataSourceService, Settings settings) {
        this.analyzer = analyzer;
        this.executionEngine = executionEngine;
        this.planner = planner;
        this.dataSourceService = dataSourceService;
        this.settings = settings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public CalciteRelNodeVisitor getRelNodeVisitor() {
        Object $value = this.relNodeVisitor.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = this.relNodeVisitor;
            synchronized (atomicReference) {
                $value = this.relNodeVisitor.get();
                if ($value == null) {
                    CalciteRelNodeVisitor actualValue = new CalciteRelNodeVisitor(this.dataSourceService);
                    $value = actualValue == null ? this.relNodeVisitor : actualValue;
                    this.relNodeVisitor.set($value);
                }
            }
        }
        return (CalciteRelNodeVisitor)($value == this.relNodeVisitor ? null : $value);
    }
}

