/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.calcite.utils.binning.handlers;

import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.util.NlsString;
import org.opensearch.sql.ast.expression.Literal;
import org.opensearch.sql.ast.tree.Bin;
import org.opensearch.sql.ast.tree.SpanBin;
import org.opensearch.sql.calcite.CalcitePlanContext;
import org.opensearch.sql.calcite.CalciteRexNodeVisitor;
import org.opensearch.sql.calcite.utils.binning.BinFieldValidator;
import org.opensearch.sql.calcite.utils.binning.BinHandler;
import org.opensearch.sql.calcite.utils.binning.SpanInfo;
import org.opensearch.sql.calcite.utils.binning.SpanParser;
import org.opensearch.sql.calcite.utils.binning.SpanType;
import org.opensearch.sql.calcite.utils.binning.handlers.LogSpanHelper;
import org.opensearch.sql.calcite.utils.binning.handlers.NumericSpanHelper;
import org.opensearch.sql.calcite.utils.binning.handlers.TimeSpanHelper;

public class SpanBinHandler
implements BinHandler {
    private final NumericSpanHelper numericHelper = new NumericSpanHelper();
    private final LogSpanHelper logHelper = new LogSpanHelper();
    private final TimeSpanHelper timeHelper = new TimeSpanHelper();

    @Override
    public RexNode createExpression(Bin node, RexNode fieldExpr, CalcitePlanContext context, CalciteRexNodeVisitor visitor) {
        SpanBin spanBin = (SpanBin)node;
        if (BinFieldValidator.isTimeBasedField(fieldExpr.getType())) {
            return this.handleTimeBasedSpan(spanBin, fieldExpr, context, visitor);
        }
        return this.handleNumericOrLogSpan(spanBin, fieldExpr, context, visitor);
    }

    private RexNode handleTimeBasedSpan(SpanBin node, RexNode fieldExpr, CalcitePlanContext context, CalciteRexNodeVisitor visitor) {
        if (node.getSpan() instanceof Literal) {
            Literal spanLiteral = (Literal)node.getSpan();
            String spanStr = spanLiteral.getValue().toString();
            RexNode alignTimeValue = this.processAligntime(node, fieldExpr, context, visitor);
            return this.timeHelper.createTimeSpanExpression(spanStr, fieldExpr, alignTimeValue, context);
        }
        RexNode spanValue = visitor.analyze(node.getSpan(), context);
        if (!spanValue.isA(SqlKind.LITERAL)) {
            throw new IllegalArgumentException("Span must be a literal value for time binning");
        }
        String spanStr = ((RexLiteral)spanValue).getValue().toString();
        RexNode alignTimeValue = this.processAligntime(node, fieldExpr, context, visitor);
        return this.timeHelper.createTimeSpanExpression(spanStr, fieldExpr, alignTimeValue, context);
    }

    private RexNode handleNumericOrLogSpan(SpanBin node, RexNode fieldExpr, CalcitePlanContext context, CalciteRexNodeVisitor visitor) {
        RexNode spanValue = visitor.analyze(node.getSpan(), context);
        if (!spanValue.isA(SqlKind.LITERAL)) {
            throw new IllegalArgumentException("Span must be a literal value");
        }
        Comparable spanRawValue = ((RexLiteral)spanValue).getValue();
        if (spanRawValue instanceof NlsString) {
            String spanStr = ((NlsString)spanRawValue).getValue();
            SpanInfo spanInfo = SpanParser.parse(spanStr);
            if (spanInfo.getType() == SpanType.LOG) {
                return this.logHelper.createLogSpanExpression(fieldExpr, spanInfo, context);
            }
            return this.numericHelper.createNumericSpanExpression(fieldExpr, (int)spanInfo.getValue(), context);
        }
        if (spanRawValue instanceof Number) {
            Number spanNumber = (Number)((Object)spanRawValue);
            if (spanNumber.doubleValue() == Math.floor(spanNumber.doubleValue())) {
                return this.numericHelper.createNumericSpanExpression(fieldExpr, spanNumber.intValue(), context);
            }
            return this.numericHelper.createNumericSpanExpression(fieldExpr, spanNumber.doubleValue(), context);
        }
        throw new IllegalArgumentException("Span must be either a number or a string, got: " + spanRawValue.getClass().getSimpleName());
    }

    private RexNode processAligntime(SpanBin node, RexNode fieldExpr, CalcitePlanContext context, CalciteRexNodeVisitor visitor) {
        if (node.getAligntime() == null) {
            return null;
        }
        if (node.getAligntime() instanceof Literal) {
            Literal aligntimeLiteral = (Literal)node.getAligntime();
            String aligntimeStr = aligntimeLiteral.getValue().toString().replace("\"", "").replace("'", "").trim();
            if ("earliest".equals(aligntimeStr)) {
                return context.relBuilder.min(fieldExpr).over().toRex();
            }
            if ("latest".equals(aligntimeStr)) {
                return context.relBuilder.max(fieldExpr).over().toRex();
            }
            if (aligntimeStr.startsWith("@d")) {
                return context.relBuilder.literal((Object)("ALIGNTIME_TIME_MODIFIER:" + aligntimeStr));
            }
            try {
                long epochValue = Long.parseLong(aligntimeStr);
                return context.relBuilder.literal((Object)("ALIGNTIME_EPOCH:" + epochValue));
            }
            catch (NumberFormatException e) {
                return visitor.analyze(node.getAligntime(), context);
            }
        }
        return visitor.analyze(node.getAligntime(), context);
    }
}

