/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.calcite.utils.binning.handlers;

import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.opensearch.sql.ast.expression.Literal;
import org.opensearch.sql.ast.expression.UnresolvedExpression;
import org.opensearch.sql.ast.tree.Bin;
import org.opensearch.sql.ast.tree.CountBin;
import org.opensearch.sql.calcite.CalcitePlanContext;
import org.opensearch.sql.calcite.CalciteRexNodeVisitor;
import org.opensearch.sql.calcite.utils.binning.BinHandler;
import org.opensearch.sql.expression.function.PPLBuiltinOperators;

public class CountBinHandler
implements BinHandler {
    @Override
    public RexNode createExpression(Bin node, RexNode fieldExpr, CalcitePlanContext context, CalciteRexNodeVisitor visitor) {
        CountBin countBin = (CountBin)node;
        Integer requestedBins = countBin.getBins();
        if (requestedBins == null) {
            requestedBins = 100;
        }
        RexNode minValue = context.relBuilder.min(fieldExpr).over().toRex();
        RexNode maxValue = context.relBuilder.max(fieldExpr).over().toRex();
        RexNode dataRange = context.relBuilder.call((SqlOperator)SqlStdOperatorTable.MINUS, new RexNode[]{maxValue, minValue});
        RexNode startValue = this.convertParameter(countBin.getStart(), context);
        RexNode endValue = this.convertParameter(countBin.getEnd(), context);
        RexLiteral numBins = context.relBuilder.literal((Object)requestedBins);
        return context.rexBuilder.makeCall(PPLBuiltinOperators.WIDTH_BUCKET, new RexNode[]{fieldExpr, numBins, dataRange, maxValue});
    }

    private RexNode convertParameter(UnresolvedExpression expr, CalcitePlanContext context) {
        if (expr == null) {
            return context.relBuilder.literal((Object)-1);
        }
        if (expr instanceof Literal) {
            Literal literal = (Literal)expr;
            Object value = literal.getValue();
            if (value instanceof Number) {
                return context.relBuilder.literal((Object)((Number)value).doubleValue());
            }
            return context.relBuilder.literal(value);
        }
        throw new IllegalArgumentException("Expected literal expression, got: " + String.valueOf(expr.getClass()));
    }
}

