/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.lucene;

import java.io.IOException;
import java.util.Map;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.codecs.lucene90.IndexedDISI;
import org.apache.lucene.index.FloatVectorValues;
import org.apache.lucene.index.KnnVectorValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.KnnCollector;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.VectorScorer;
import org.apache.lucene.search.knn.KnnCollectorManager;
import org.apache.lucene.search.knn.KnnSearchStrategy;
import org.opensearch.lucene.SeededMappedDISI;
import org.opensearch.lucene.SeededTopDocsDISI;

public class ReentrantKnnCollectorManager
implements KnnCollectorManager {
    @Generated
    private static final Logger log = LogManager.getLogger(ReentrantKnnCollectorManager.class);
    private final KnnCollectorManager knnCollectorManager;
    private final Map<Integer, TopDocs> segmentOrdToResults;
    private final float[] query;
    private final String field;

    public KnnCollector newCollector(int visitLimit, KnnSearchStrategy searchStrategy, LeafReaderContext ctx) throws IOException {
        KnnCollector delegateCollector = this.knnCollectorManager.newCollector(visitLimit, searchStrategy, ctx);
        TopDocs seedTopDocs = this.segmentOrdToResults.get(ctx.ord);
        if (seedTopDocs == null || seedTopDocs.totalHits.value() == 0L) {
            log.warn("Seed top docs was empty, expected non-empty top results to be given.");
            assert (false);
            return delegateCollector;
        }
        LeafReader reader = ctx.reader();
        FloatVectorValues vectorValues = reader.getFloatVectorValues(this.field);
        if (vectorValues == null) {
            log.error("Acquired null {} for field [{}]", (Object)FloatVectorValues.class.getSimpleName(), (Object)this.field);
            FloatVectorValues.checkField((LeafReader)reader, (String)this.field);
            return null;
        }
        VectorScorer scorer = vectorValues.scorer(this.query);
        if (scorer == null) {
            log.error("Acquired null {} for field [{}]", (Object)VectorScorer.class.getSimpleName(), (Object)this.field);
            assert (false);
            return delegateCollector;
        }
        DocIdSetIterator vectorIterator = scorer.iterator();
        if (vectorIterator instanceof IndexedDISI) {
            IndexedDISI indexedDISI = (IndexedDISI)vectorIterator;
            vectorIterator = IndexedDISI.asDocIndexIterator((IndexedDISI)indexedDISI);
        }
        if (vectorIterator instanceof KnnVectorValues.DocIndexIterator) {
            KnnVectorValues.DocIndexIterator indexIterator = (KnnVectorValues.DocIndexIterator)vectorIterator;
            SeededMappedDISI seedDocs = new SeededMappedDISI(indexIterator, new SeededTopDocsDISI(seedTopDocs));
            return this.knnCollectorManager.newCollector(visitLimit, (KnnSearchStrategy)new KnnSearchStrategy.Seeded((DocIdSetIterator)seedDocs, seedTopDocs.scoreDocs.length, searchStrategy), ctx);
        }
        log.error("`vectorIterator` was not one of [{}, {}] and was {}", (Object)IndexedDISI.class.getSimpleName(), (Object)KnnVectorValues.DocIndexIterator.class.getSimpleName(), (Object)(vectorIterator == null ? "null" : vectorIterator.getClass().getSimpleName()));
        assert (false);
        return delegateCollector;
    }

    @Generated
    public ReentrantKnnCollectorManager(KnnCollectorManager knnCollectorManager, Map<Integer, TopDocs> segmentOrdToResults, float[] query, String field) {
        this.knnCollectorManager = knnCollectorManager;
        this.segmentOrdToResults = segmentOrdToResults;
        this.query = query;
        this.field = field;
    }
}

