/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.agent.tools;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.agent.tools.utils.PPLExecuteHelper;
import org.opensearch.agent.tools.utils.clustering.ClusteringHelper;
import org.opensearch.agent.tools.utils.clustering.HierarchicalAgglomerativeClustering;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.Strings;
import org.opensearch.ml.common.spi.tools.Tool;
import org.opensearch.ml.common.spi.tools.ToolAnnotation;
import org.opensearch.ml.common.utils.StringUtils;
import org.opensearch.ml.common.utils.ToolUtils;
import org.opensearch.transport.client.Client;

@ToolAnnotation(value="LogPatternAnalysisTool")
public class LogPatternAnalysisTool
implements Tool {
    @Generated
    private static final Logger log = LogManager.getLogger(LogPatternAnalysisTool.class);
    public static final String TYPE = "LogPatternAnalysisTool";
    public static final String STRICT_FIELD = "strict";
    private static final String DEFAULT_DESCRIPTION = "This is a tool used to detect selection log patterns by the patterns command in PPL or to detect selection log sequences by the log clustering algorithm.";
    private static final double LOG_VECTORS_CLUSTERING_THRESHOLD = 0.5;
    private static final double LOG_PATTERN_THRESHOLD = 0.75;
    private static final double LOG_PATTERN_LIFT = 3.0;
    private static final String DEFAULT_TIME_FIELD = "@timestamp";
    public static final String DEFAULT_INPUT_SCHEMA = "{\n    \"type\": \"object\",\n    \"properties\": {\n        \"index\": {\n            \"type\": \"string\",\n            \"description\": \"Target OpenSearch index name containing log data (e.g., 'ss4o_logs-otel-2025.06.24')\"\n        },\n        \"timeField\": {\n            \"type\": \"string\",\n            \"description\": \"Date/time field in the index mapping used for time-based filtering\"\n        },\n        \"logFieldName\": {\n            \"type\": \"string\",\n            \"description\": \"Field containing raw log messages to analyze (e.g., 'body', 'message', 'log')\"\n        },\n        \"traceFieldName\": {\n            \"type\": \"string\",\n            \"description\": \"[OPTIONAL] Field for trace/correlation ID to enable sequence analysis (e.g., 'traceId', 'correlationId'). Leave empty for pattern-only analysis.\"\n        },\n        \"baseTimeRangeStart\": {\n            \"type\": \"string\",\n            \"description\": \"Start time for baseline comparison period (date string in utc timezone, e.g., '2025-06-24 07:33:05')\"\n        },\n        \"baseTimeRangeEnd\": {\n            \"type\": \"string\",\n            \"description\": \"End time for baseline comparison period (date string in utc timezone, e.g., '2025-06-24 07:51:27')\"\n        },\n        \"selectionTimeRangeStart\": {\n            \"type\": \"string\",\n            \"description\": \"Start time for analysis target period (date string in utc timezone, e.g., '2025-06-24 07:50:26')\"\n        },\n        \"selectionTimeRangeEnd\": {\n            \"type\": \"string\",\n            \"description\": \"End time for analysis target period (date string in utc timezone, e.g., '2025-06-24 07:55:56')\"\n        }\n    },\n    \"required\": [\n        \"index\",\n        \"timeField\",\n        \"logFieldName\",\n        \"selectionTimeRangeStart\",\n        \"selectionTimeRangeEnd\"\n    ],\n    \"additionalProperties\": false\n}\n";
    public static final Map<String, Object> DEFAULT_ATTRIBUTES = Map.of("input_schema", "{\n    \"type\": \"object\",\n    \"properties\": {\n        \"index\": {\n            \"type\": \"string\",\n            \"description\": \"Target OpenSearch index name containing log data (e.g., 'ss4o_logs-otel-2025.06.24')\"\n        },\n        \"timeField\": {\n            \"type\": \"string\",\n            \"description\": \"Date/time field in the index mapping used for time-based filtering\"\n        },\n        \"logFieldName\": {\n            \"type\": \"string\",\n            \"description\": \"Field containing raw log messages to analyze (e.g., 'body', 'message', 'log')\"\n        },\n        \"traceFieldName\": {\n            \"type\": \"string\",\n            \"description\": \"[OPTIONAL] Field for trace/correlation ID to enable sequence analysis (e.g., 'traceId', 'correlationId'). Leave empty for pattern-only analysis.\"\n        },\n        \"baseTimeRangeStart\": {\n            \"type\": \"string\",\n            \"description\": \"Start time for baseline comparison period (date string in utc timezone, e.g., '2025-06-24 07:33:05')\"\n        },\n        \"baseTimeRangeEnd\": {\n            \"type\": \"string\",\n            \"description\": \"End time for baseline comparison period (date string in utc timezone, e.g., '2025-06-24 07:51:27')\"\n        },\n        \"selectionTimeRangeStart\": {\n            \"type\": \"string\",\n            \"description\": \"Start time for analysis target period (date string in utc timezone, e.g., '2025-06-24 07:50:26')\"\n        },\n        \"selectionTimeRangeEnd\": {\n            \"type\": \"string\",\n            \"description\": \"End time for analysis target period (date string in utc timezone, e.g., '2025-06-24 07:55:56')\"\n        }\n    },\n    \"required\": [\n        \"index\",\n        \"timeField\",\n        \"logFieldName\",\n        \"selectionTimeRangeStart\",\n        \"selectionTimeRangeEnd\"\n    ],\n    \"additionalProperties\": false\n}\n", "strict", false);
    private static final Pattern REPEATED_WILDCARDS_PATTERN = Pattern.compile("(<\\*>)(\\s+<\\*>)+");
    Comparator<PatternDiffResult> comparator = (d1, d2) -> {
        Double lift2;
        Double lift1 = Optional.ofNullable(d1.lift).orElse((Double)Double.MIN_VALUE);
        if (lift1.compareTo(lift2 = Optional.ofNullable(d2.lift).orElse((Double)Double.MIN_VALUE)) == 0) {
            return Optional.ofNullable(d2.selection).orElse((Double)Double.MIN_VALUE).compareTo(Optional.ofNullable(d1.selection).orElse((Double)Double.MIN_VALUE));
        }
        return lift2.compareTo(lift1);
    };
    private String name = "LogPatternAnalysisTool";
    private String description = "This is a tool used to detect selection log patterns by the patterns command in PPL or to detect selection log sequences by the log clustering algorithm.";
    private String version;
    private Client client;
    private ClusteringHelper clusteringHelper;

    public LogPatternAnalysisTool(Client client) {
        this.client = client;
        this.clusteringHelper = new ClusteringHelper(0.5);
    }

    public String getType() {
        return TYPE;
    }

    public Map<String, Object> getAttributes() {
        return Map.of();
    }

    public void setAttributes(Map<String, Object> map) {
    }

    public boolean validate(Map<String, String> map) {
        try {
            new AnalysisParameters(map).validate();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public <T> void run(Map<String, String> originalParameters, ActionListener<T> listener) {
        try {
            Map parameters = ToolUtils.extractInputParameters(originalParameters, DEFAULT_ATTRIBUTES);
            log.debug("Starting log pattern analysis with parameters: {}", parameters.keySet());
            AnalysisParameters params = new AnalysisParameters(parameters);
            params.validate();
            if (params.hasTraceField() && params.hasBaseTime()) {
                log.debug("Performing log sequence analysis for index: {}", (Object)params.index);
                this.logSequenceAnalysis(params, listener);
            } else if (params.hasBaseTime()) {
                log.debug("Performing log pattern analysis for index: {}", (Object)params.index);
                this.logPatternDiffAnalysis(params, listener);
            } else {
                this.logInsight(params, listener);
            }
        }
        catch (IllegalArgumentException e) {
            log.error("Invalid parameters for LogPatternAnalysisTool: {}", (Object)e.getMessage());
            listener.onFailure((Exception)new IllegalArgumentException("Invalid parameters: " + e.getMessage(), e));
        }
        catch (Exception e) {
            log.error("Unexpected error in LogPatternAnalysisTool", (Throwable)e);
            listener.onFailure((Exception)new RuntimeException("Failed to execute log pattern analysis", e));
        }
    }

    private <T> void logSequenceAnalysis(AnalysisParameters params, ActionListener<T> listener) {
        this.analyzeSelectionTimeRange(params, (ActionListener<PatternAnalysisResult>)ActionListener.wrap(selectionResult -> {
            log.debug("Base time range analysis completed, found {} traces", (Object)selectionResult.tracePatternMap.size());
            if (selectionResult.tracePatternMap.isEmpty()) {
                Map<String, Map<String, String>> emptyResult = this.buildFinalResult(List.of(), List.of(), Collections.emptyMap(), Collections.emptyMap());
                listener.onResponse((Object)StringUtils.gson.toJson(emptyResult));
                return;
            }
            this.analyzeBaseTimeRange(params, (ActionListener<PatternAnalysisResult>)ActionListener.wrap(baseResult -> {
                log.debug("Selection time range analysis completed, found {} traces", (Object)baseResult.tracePatternMap.size());
                this.generateSequenceComparisonResult((PatternAnalysisResult)baseResult, (PatternAnalysisResult)selectionResult, listener);
            }, arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
        }, error -> {
            log.error("Failed to execute analysis", (Throwable)error);
            listener.onFailure((Exception)new RuntimeException("Analysis failed: " + error.getMessage(), (Throwable)error));
        }));
    }

    private void analyzeBaseTimeRange(AnalysisParameters params, ActionListener<PatternAnalysisResult> listener) {
        String baseTimeRangeLogPatternPPL = this.buildLogPatternPPL(params.index, params.timeField, params.logFieldName, params.traceFieldName, params.baseTimeRangeStart, params.baseTimeRangeEnd);
        this.executePPL(baseTimeRangeLogPatternPPL, listener);
    }

    private void analyzeSelectionTimeRange(AnalysisParameters params, ActionListener<PatternAnalysisResult> listener) {
        String selectionTimeRangeLogPatternPPL = this.buildLogPatternPPL(params.index, params.timeField, params.logFieldName, params.traceFieldName, params.selectionTimeRangeStart, params.selectionTimeRangeEnd);
        this.executePPL(selectionTimeRangeLogPatternPPL, listener);
    }

    private void executePPL(String ppl, ActionListener<PatternAnalysisResult> listener) {
        Function<List, PatternAnalysisResult> rowParser = dataRows -> {
            HashMap<String, Set<String>> tracePatternMap = new HashMap<String, Set<String>>();
            HashMap<String, Set<String>> patternCountMap = new HashMap<String, Set<String>>();
            HashMap<String, String> rawPatternCache = new HashMap<String, String>();
            for (List row : dataRows) {
                if (row.size() < 2) continue;
                String traceId = (String)row.get(0);
                String rawPattern = (String)row.get(1);
                String simplifiedPattern = rawPatternCache.computeIfAbsent(rawPattern, this::postProcessPattern);
                tracePatternMap.computeIfAbsent(traceId, k -> new LinkedHashSet()).add(simplifiedPattern);
                patternCountMap.computeIfAbsent(simplifiedPattern, k -> new HashSet()).add(traceId);
            }
            Map<String, Double> patternVectors = this.vectorizePattern(patternCountMap, tracePatternMap.size());
            return new PatternAnalysisResult(tracePatternMap, patternCountMap, patternVectors);
        };
        PPLExecuteHelper.executePPLAndParseResult(this.client, ppl, PPLExecuteHelper.dataRowsParser(rowParser), listener);
    }

    private String buildLogPatternPPL(String index, String timeField, String logFieldName, String traceFieldName, String startTime, String endTime) {
        return String.format(Locale.ROOT, "source=%s | where %s!='' | where %s>'%s' and %s<'%s' | patterns %s method=brain variable_count_threshold=3 | fields %s, patterns_field, %s | sort %s", index, traceFieldName, timeField, startTime, timeField, endTime, logFieldName, traceFieldName, timeField, timeField);
    }

    private Map<String, Double> vectorizePattern(Map<String, Set<String>> patternCountMap, int totalTraceCount) {
        HashMap<String, Double> patternValues = new HashMap<String, Double>();
        for (Map.Entry<String, Set<String>> entry : patternCountMap.entrySet()) {
            String pattern = entry.getKey();
            Set<String> traceIds = entry.getValue();
            if (traceIds != null && !traceIds.isEmpty()) {
                double idf = Math.log((double)totalTraceCount / (double)traceIds.size());
                double value = 1.0 / (1.0 + Math.exp(-idf));
                patternValues.put(pattern, value);
                continue;
            }
            patternValues.put(pattern, 0.0);
        }
        return patternValues;
    }

    private <T> void generateSequenceComparisonResult(PatternAnalysisResult baseResult, PatternAnalysisResult selectionResult, ActionListener<T> listener) {
        try {
            Map<String, Integer> patternIndexMap = this.buildPatternIndex(baseResult, selectionResult);
            Map<String, double[]> baseVectorMap = this.buildVectorMap(baseResult.tracePatternMap, baseResult.patternWeightsMap, patternIndexMap, false, new Map[0]);
            List<String> baseRepresentative = this.clusteringHelper.clusterLogVectorsAndGetRepresentative(baseVectorMap);
            Map<String, double[]> selectionVectorMap = this.buildVectorMap(selectionResult.tracePatternMap, selectionResult.patternWeightsMap, patternIndexMap, true, baseResult.patternCountMap, selectionResult.patternCountMap);
            List<String> selectionRepresentative = this.clusteringHelper.clusterLogVectorsAndGetRepresentative(selectionVectorMap);
            List<String> traceNeedToExamine = this.filterSelectionCentroids(baseRepresentative, selectionRepresentative, baseVectorMap, selectionVectorMap);
            log.info("Identified {} traceNeedToExamine centroids from {} candidates", (Object)traceNeedToExamine.size(), (Object)selectionRepresentative.size());
            Map<String, Map<String, String>> result = this.buildFinalResult(baseRepresentative, traceNeedToExamine, baseResult.tracePatternMap, selectionResult.tracePatternMap);
            listener.onResponse((Object)StringUtils.gson.toJson(result));
        }
        catch (Exception e) {
            log.error("Failed to generate sequence comparison result", (Throwable)e);
            listener.onFailure((Exception)new RuntimeException("Failed to generate comparison result: " + e.getMessage(), e));
        }
    }

    private Map<String, Integer> buildPatternIndex(PatternAnalysisResult baseResult, PatternAnalysisResult selectionResult) {
        HashSet<String> allPatterns = new HashSet<String>(baseResult.patternCountMap.keySet());
        allPatterns.addAll(selectionResult.patternCountMap.keySet());
        ArrayList<String> sortedPatterns = new ArrayList<String>(allPatterns);
        Collections.sort(sortedPatterns);
        log.debug("vector dimension is {}", (Object)sortedPatterns.size());
        HashMap<String, Integer> patternIndexMap = new HashMap<String, Integer>();
        for (int i = 0; i < sortedPatterns.size(); ++i) {
            patternIndexMap.put((String)sortedPatterns.get(i), i);
        }
        return patternIndexMap;
    }

    @SafeVarargs
    private Map<String, double[]> buildVectorMap(Map<String, Set<String>> tracePatternMap, Map<String, Double> patternWeightsMap, Map<String, Integer> patternIndexMap, boolean isSelection, Map<String, Set<String>> ... additionalPatternMaps) {
        HashMap<String, double[]> vectorMap = new HashMap<String, double[]>();
        int dimension = patternIndexMap.size();
        for (Map.Entry<String, Set<String>> entry : tracePatternMap.entrySet()) {
            String traceId = entry.getKey();
            Set<String> patterns = entry.getValue();
            double[] vector = new double[dimension];
            for (String pattern : patterns) {
                Integer index = patternIndexMap.get(pattern);
                if (index == null) continue;
                double baseValue = 0.5 * patternWeightsMap.getOrDefault(pattern, 0.0);
                if (isSelection && additionalPatternMaps.length >= 2) {
                    Map<String, Set<String>> basePatterns = additionalPatternMaps[0];
                    boolean existenceWeight = !basePatterns.containsKey(pattern);
                    vector[index.intValue()] = baseValue + 0.5 * (double)existenceWeight;
                    continue;
                }
                vector[index.intValue()] = baseValue;
            }
            vectorMap.put(traceId, vector);
        }
        return vectorMap;
    }

    private List<String> filterSelectionCentroids(List<String> baseCentroids, List<String> selectionCandidates, Map<String, double[]> baseVectorMap, Map<String, double[]> selectionVectorMap) {
        ArrayList<String> selectionCentroids = new ArrayList<String>();
        for (String candidate : selectionCandidates) {
            boolean isSelection = true;
            double[] candidateVector = selectionVectorMap.get(candidate);
            if (candidateVector == null) {
                log.warn("No vector found for selection candidate: {}", (Object)candidate);
                continue;
            }
            for (String baseCentroid : baseCentroids) {
                double[] baseVector = baseVectorMap.get(baseCentroid);
                if (baseVector == null || !(HierarchicalAgglomerativeClustering.calculateCosineSimilarity(baseVector, candidateVector) > 0.5)) continue;
                isSelection = false;
                break;
            }
            if (!isSelection) continue;
            selectionCentroids.add(candidate);
        }
        return selectionCentroids;
    }

    private Map<String, Map<String, String>> buildFinalResult(List<String> baseCentroids, List<String> selectionCentroids, Map<String, Set<String>> baseTracePatternMap, Map<String, Set<String>> selectionTracePatternMap) {
        HashMap<String, String> baseSequences = new HashMap<String, String>();
        for (String string : baseCentroids) {
            Set<String> patterns = baseTracePatternMap.get(string);
            if (patterns == null) continue;
            baseSequences.put(string, String.join((CharSequence)" -> ", patterns));
        }
        HashMap<String, String> selectionSequences = new HashMap<String, String>();
        for (String centroid : selectionCentroids) {
            Set<String> patterns = selectionTracePatternMap.get(centroid);
            if (patterns == null) continue;
            selectionSequences.put(centroid, String.join((CharSequence)" -> ", patterns));
        }
        HashMap<String, Map<String, String>> hashMap = new HashMap<String, Map<String, String>>();
        hashMap.put("BASE", baseSequences);
        hashMap.put("EXCEPTIONAL", selectionSequences);
        return hashMap;
    }

    private <T> void logPatternDiffAnalysis(AnalysisParameters params, ActionListener<T> listener) {
        String baseTimeRangeLogPatternPPL = this.buildLogPatternPPL(params.index, params.timeField, params.logFieldName, params.baseTimeRangeStart, params.baseTimeRangeEnd);
        Function<List, Map> dataRowsParser = dataRows -> {
            HashMap<String, Double> patternMap = new HashMap<String, Double>();
            for (List row : dataRows) {
                if (row.size() != 2) continue;
                String pattern = (String)row.get(1);
                double count = ((Number)row.get(0)).doubleValue();
                patternMap.put(pattern, count);
            }
            return patternMap;
        };
        log.debug("Executing base time range pattern PPL: {}", (Object)baseTimeRangeLogPatternPPL);
        PPLExecuteHelper.executePPLAndParseResult(this.client, baseTimeRangeLogPatternPPL, PPLExecuteHelper.dataRowsParser(dataRowsParser), ActionListener.wrap(basePatterns -> {
            try {
                this.mergeSimilarPatterns((Map<String, Double>)basePatterns);
                log.debug("Base patterns processed: {} patterns", (Object)basePatterns.size());
                String selectionTimeRangeLogPatternPPL = this.buildLogPatternPPL(params.index, params.timeField, params.logFieldName, params.selectionTimeRangeStart, params.selectionTimeRangeEnd);
                log.debug("Executing selection time range pattern PPL: {}", (Object)selectionTimeRangeLogPatternPPL);
                PPLExecuteHelper.executePPLAndParseResult(this.client, selectionTimeRangeLogPatternPPL, PPLExecuteHelper.dataRowsParser(dataRowsParser), ActionListener.wrap(selectionPatterns -> {
                    this.mergeSimilarPatterns((Map<String, Double>)selectionPatterns);
                    log.debug("Selection patterns processed: {} patterns", (Object)selectionPatterns.size());
                    List<PatternDiffResult> patternDifferences = this.calculatePatternDifferences((Map<String, Double>)basePatterns, (Map<String, Double>)selectionPatterns);
                    List topDiffs = Stream.concat(patternDifferences.stream().filter(diff -> !Objects.isNull(diff.lift)).sorted(this.comparator).limit(10L), patternDifferences.stream().filter(diff -> Objects.isNull(diff.lift)).sorted(this.comparator).limit(10L)).collect(Collectors.toList());
                    HashMap finalResult = new HashMap();
                    finalResult.put("patternMapDifference", topDiffs);
                    log.debug("Pattern analysis completed: {} differences found", (Object)patternDifferences.size());
                    listener.onResponse((Object)StringUtils.gson.toJson(finalResult));
                }, arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
            }
            catch (Exception e) {
                log.error("Failed to process base pattern response", (Throwable)e);
                listener.onFailure((Exception)new RuntimeException("Failed to process base patterns: " + e.getMessage(), e));
            }
        }, error -> {
            log.error("Failed to execute pattern analysis", (Throwable)error);
            listener.onFailure((Exception)new RuntimeException("Analysis failed: " + error.getMessage(), (Throwable)error));
        }));
    }

    private <T> void logInsight(AnalysisParameters params, ActionListener<T> listener) {
        Set<String> errorKeywords = Set.of("error", "err", "exception", "failed", "failure", "timeout", "panic", "fatal", "critical", "severe", "abort", "aborted", "aborting", "crash", "crashed", "broken", "corrupt", "corrupted", "invalid", "malformed", "unprocessable", "denied", "forbidden", "unauthorized", "conflict", "deadlock", "overflow", "underflow", "throttled", "disk_full", "insufficient", "retrying", "backpressure", "degraded", "unexpected", "unusual", "missing", "stale", "expired", "mismatch", "violation");
        String selectionTimeRangeLogPatternPPL = String.format(Locale.ROOT, "source=%s | where %s>'%s' and %s<'%s' | where match(%s, '%s') | patterns %s method=brain mode=aggregation max_sample_count=2 variable_count_threshold=3 | fields patterns_field, pattern_count, sample_logs | sort -pattern_count | head 5", params.index, params.timeField, params.selectionTimeRangeStart, params.timeField, params.selectionTimeRangeEnd, params.logFieldName, String.join((CharSequence)" ", errorKeywords), params.logFieldName);
        Function<List, List> dataRowsParser = dataRows -> {
            ArrayList<PatternWithSamples> patternWithSamplesList = new ArrayList<PatternWithSamples>();
            for (List row : dataRows) {
                if (row.size() != 3) continue;
                String pattern = (String)row.get(0);
                double count = ((Number)row.get(1)).doubleValue();
                List samples = (List)row.get(2);
                patternWithSamplesList.add(new PatternWithSamples(pattern, count, samples));
            }
            return patternWithSamplesList;
        };
        PPLExecuteHelper.executePPLAndParseResult(this.client, selectionTimeRangeLogPatternPPL, PPLExecuteHelper.dataRowsParser(dataRowsParser), ActionListener.wrap(logInsights -> {
            try {
                HashMap<String, List> finalResult = new HashMap<String, List>();
                finalResult.put("logInsights", (List)logInsights);
                listener.onResponse((Object)StringUtils.gson.toJson(finalResult));
            }
            catch (Exception e) {
                log.error("Failed to process base pattern response", (Throwable)e);
                listener.onFailure((Exception)new RuntimeException("Failed to process base patterns: " + e.getMessage(), e));
            }
        }, error -> {
            log.error("Failed to execute log insights analysis", (Throwable)error);
            listener.onFailure((Exception)new RuntimeException("Log insights analysis failed: " + error.getMessage(), (Throwable)error));
        }));
    }

    private String buildLogPatternPPL(String index, String timeField, String logFieldName, String startTime, String endTime) {
        return String.format(Locale.ROOT, "source=%s | where %s>'%s' and %s<'%s' | patterns %s method=brain mode=aggregation variable_count_threshold=3 | fields pattern_count, patterns_field", index, timeField, startTime, timeField, endTime, logFieldName);
    }

    private List<PatternDiffResult> calculatePatternDifferences(Map<String, Double> basePatterns, Map<String, Double> selectionPatterns) {
        ArrayList<PatternDiffResult> differences = new ArrayList<PatternDiffResult>();
        double selectionTotal = selectionPatterns.values().stream().mapToDouble(Double::doubleValue).sum();
        double baseTotal = basePatterns.values().stream().mapToDouble(Double::doubleValue).sum();
        for (Map.Entry<String, Double> entry : selectionPatterns.entrySet()) {
            String pattern = entry.getKey();
            double selectionCount = entry.getValue();
            if (basePatterns.containsKey(pattern)) {
                double baseCount = basePatterns.get(pattern);
                double lift = selectionCount / selectionTotal / (baseCount / baseTotal);
                if (lift < 1.0) {
                    lift = 1.0 / lift;
                }
                if (!(lift > 3.0)) continue;
                differences.add(new PatternDiffResult(pattern, baseCount / baseTotal, selectionCount / selectionTotal, lift));
                continue;
            }
            differences.add(new PatternDiffResult(pattern, 0.0, selectionCount / selectionTotal, null));
            log.debug("New selection pattern detected: {} (count: {})", (Object)pattern, (Object)selectionCount);
        }
        return differences;
    }

    private double jaccardSimilarity(String pattern1, String pattern2) {
        if (Strings.isEmpty((CharSequence)pattern1) && Strings.isEmpty((CharSequence)pattern2)) {
            return 1.0;
        }
        if (Strings.isEmpty((CharSequence)pattern1) || Strings.isEmpty((CharSequence)pattern2)) {
            return 0.0;
        }
        HashSet<String> set1 = new HashSet<String>(Arrays.asList(pattern1.split("\\s+")));
        HashSet<String> set2 = new HashSet<String>(Arrays.asList(pattern2.split("\\s+")));
        HashSet<String> union = new HashSet<String>(set1);
        union.addAll(set2);
        int intersectionSize = set1.size() + set2.size() - union.size();
        return (double)intersectionSize / (double)union.size();
    }

    private void mergeSimilarPatterns(Map<String, Double> patternMap) {
        if (patternMap.isEmpty()) {
            return;
        }
        ArrayList<String> patterns = new ArrayList<String>(patternMap.keySet());
        patterns.sort(String::compareTo);
        HashSet<String> removed = new HashSet<String>();
        for (int i = 0; i < patterns.size(); ++i) {
            String pattern1 = (String)patterns.get(i);
            if (removed.contains(pattern1)) continue;
            for (int j = i + 1; j < patterns.size(); ++j) {
                String pattern2 = (String)patterns.get(j);
                if (removed.contains(pattern2) || !(this.jaccardSimilarity(pattern1, pattern2) > 0.75)) continue;
                double count1 = patternMap.getOrDefault(pattern1, 0.0);
                double count2 = patternMap.getOrDefault(pattern2, 0.0);
                patternMap.put(pattern1, count1 + count2);
                patternMap.remove(pattern2);
                removed.add(pattern2);
                log.debug("Merged similar patterns: '{}' + '{}' -> '{}'", (Object)pattern1, (Object)pattern2, (Object)pattern1);
            }
        }
        HashMap<String, String> toReplace = new HashMap<String, String>();
        for (String string : patternMap.keySet()) {
            String processedPattern = this.postProcessPattern(string);
            if (processedPattern.equals(string)) continue;
            toReplace.put(string, processedPattern);
        }
        for (Map.Entry entry : toReplace.entrySet()) {
            String originalPattern = (String)entry.getKey();
            String processedPattern = (String)entry.getValue();
            double count = patternMap.remove(originalPattern);
            patternMap.merge(processedPattern, count, Double::sum);
        }
        log.debug("Pattern merging completed: {} patterns remaining", (Object)patternMap.size());
    }

    private String postProcessPattern(String pattern) {
        if (Strings.isEmpty((CharSequence)pattern)) {
            return pattern;
        }
        pattern = REPEATED_WILDCARDS_PATTERN.matcher(pattern).replaceAll("<*>");
        return pattern;
    }

    @Generated
    public void setComparator(Comparator<PatternDiffResult> comparator) {
        this.comparator = comparator;
    }

    @Generated
    public void setVersion(String version) {
        this.version = version;
    }

    @Generated
    public void setClient(Client client) {
        this.client = client;
    }

    @Generated
    public void setClusteringHelper(ClusteringHelper clusteringHelper) {
        this.clusteringHelper = clusteringHelper;
    }

    @Generated
    public Comparator<PatternDiffResult> getComparator() {
        return this.comparator;
    }

    @Generated
    public Client getClient() {
        return this.client;
    }

    @Generated
    public ClusteringHelper getClusteringHelper() {
        return this.clusteringHelper;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    private static class AnalysisParameters {
        final String index;
        final String timeField;
        final String logFieldName;
        final String traceFieldName;
        final String baseTimeRangeStart;
        final String baseTimeRangeEnd;
        final String selectionTimeRangeStart;
        final String selectionTimeRangeEnd;

        AnalysisParameters(Map<String, String> parameters) {
            this.index = parameters.getOrDefault("index", "");
            this.timeField = parameters.getOrDefault("timeField", LogPatternAnalysisTool.DEFAULT_TIME_FIELD);
            this.logFieldName = parameters.getOrDefault("logFieldName", "message");
            this.traceFieldName = parameters.getOrDefault("traceFieldName", "");
            this.baseTimeRangeStart = parameters.getOrDefault("baseTimeRangeStart", "");
            this.baseTimeRangeEnd = parameters.getOrDefault("baseTimeRangeEnd", "");
            this.selectionTimeRangeStart = parameters.getOrDefault("selectionTimeRangeStart", "");
            this.selectionTimeRangeEnd = parameters.getOrDefault("selectionTimeRangeEnd", "");
        }

        private void validate() {
            ArrayList<String> missingParams = new ArrayList<String>();
            if (Strings.isEmpty((CharSequence)this.index)) {
                missingParams.add("index");
            }
            if (Strings.isEmpty((CharSequence)this.timeField)) {
                missingParams.add("timeField");
            }
            if (Strings.isEmpty((CharSequence)this.logFieldName)) {
                missingParams.add("logFieldName");
            }
            if (Strings.isEmpty((CharSequence)this.selectionTimeRangeStart)) {
                missingParams.add("selectionTimeRangeStart");
            }
            if (Strings.isEmpty((CharSequence)this.selectionTimeRangeEnd)) {
                missingParams.add("selectionTimeRangeEnd");
            }
            if (!missingParams.isEmpty()) {
                throw new IllegalArgumentException("Missing required parameters: " + String.join((CharSequence)", ", missingParams));
            }
        }

        boolean hasBaseTime() {
            return !Strings.isEmpty((CharSequence)this.baseTimeRangeStart) && !Strings.isEmpty((CharSequence)this.baseTimeRangeEnd);
        }

        boolean hasTraceField() {
            return !Strings.isEmpty((CharSequence)this.traceFieldName);
        }
    }

    private record PatternAnalysisResult(Map<String, Set<String>> tracePatternMap, Map<String, Set<String>> patternCountMap, Map<String, Double> patternWeightsMap) {
    }

    private record PatternDiffResult(String pattern, Double base, Double selection, Double lift) {
    }

    private record PatternWithSamples(String pattern, double count, List<?> sampleLogs) {
    }

    public static class Factory
    implements Tool.Factory<LogPatternAnalysisTool> {
        private Client client;
        private static Factory INSTANCE;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static Factory getInstance() {
            if (INSTANCE != null) {
                return INSTANCE;
            }
            Class<LogPatternAnalysisTool> clazz = LogPatternAnalysisTool.class;
            synchronized (LogPatternAnalysisTool.class) {
                if (INSTANCE != null) {
                    // ** MonitorExit[var0] (shouldn't be in output)
                    return INSTANCE;
                }
                INSTANCE = new Factory();
                // ** MonitorExit[var0] (shouldn't be in output)
                return INSTANCE;
            }
        }

        public void init(Client client) {
            this.client = client;
        }

        public LogPatternAnalysisTool create(Map<String, Object> map) {
            return new LogPatternAnalysisTool(this.client);
        }

        public String getDefaultDescription() {
            return LogPatternAnalysisTool.DEFAULT_DESCRIPTION;
        }

        public String getDefaultType() {
            return LogPatternAnalysisTool.TYPE;
        }

        public Map<String, Object> getDefaultAttributes() {
            return DEFAULT_ATTRIBUTES;
        }

        public String getDefaultVersion() {
            return null;
        }
    }
}

